﻿/**
*/
module nemuxi.file.items.itemif;

debug import std.stdio: wl = writefln, pl = printf;
debug(itemif) void main() {}

import std.conv;

import nemuxi.negui.system.base;
import nemuxi.system.exception;
import nemuxi.negui.input.keyboard.keyboard;
import nemuxi.negui.file.file;
import nemuxi.file.data;

///
class ItemException: DataException {
	mixin MixInNemuxiException;
}

enum ITEM_TYPE {
	NORMAL, /// 通常アイテム。
	URI,    /// アイテムはURI(なんでもあり)。
	MULTI,  /// 複数アイテム。
	LINK,   /// アイテムへのリンク。
}

/**
*/
class ItemDateTime: DateTime {
	invariant() {
		assert(Mask == MASK.DATE+MASK.TIME);
		assert(0 <= SystemTime.wYear && SystemTime.wYear <= 9999);
		assert(Format    == FORMAT);
		assert(MonthList == MONTHLIST);
	}

	invariant FORMAT    = "[YYYY]/[M]/[DD] [hh]:[mm]:[ss]";
	invariant MONTHLIST = ["01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"];
	invariant OUTSTRING = "YYYY/MM/DD HH:MM:SS";
	
	/**
	*/
	this() {
		super();
		Format    = FORMAT;
		MonthList = MONTHLIST;
	}
	/**
	*/
	this(WORD Year, WORD Month, WORD Day, WORD Hour, WORD Minute, WORD Second, WORD MilliSecond) {
		this();
		
		year   = Year;
		month  = Month;
		day    = Day;
		hour   = Hour;
		minute = Minute;
		second = Second;
		ms     = MilliSecond;
		ChangeWeek();
	}
	/**
	History:
		1.00β19:
			[P] 日時情報のチェックを二重に行っていた部分を一本化。
	*/
	this(Text date, lazy Text ItemInfo=Text.emptyText) {
		this();
		

		try {
			if(date.length != OUTSTRING.length) {
				throw new ItemException(Text("内部保持用日時情報長が不正, [%s = %s](%s)", date.text8, date.length, ItemInfo.text8), EC.ITEM_DATE_LENGTH);
			}
			
			/+
			auto time=split(date);
			auto ymd=split(time[0], "/");
			auto hms=split(time[1], ":");
			+/
			auto time=date.split(' ');
			auto ymd=time[0].split('/');
			auto hms=time[1].split(':');
			
			if(ymd.length + hms.length != 6)
				throw new ItemException("日時情報分割数が不正。", EC.ITEM_DATE_SPLIT);
			
			year   = to!(WORD)(ymd[0].text);
			month  = to!(WORD)(ymd[1].text);
			day    = to!(WORD)(ymd[2].text);
			hour   = to!(WORD)(hms[0].text);
			minute = to!(WORD)(hms[1].text);
			second = to!(WORD)(hms[2].text);

			/+
			bool check=true;
			check &= year > 0 && year < 10000;
			check &= month >= 1 && month <= 12;
			check &= day >= 1 && day <= 31;
			check &= hour >= 0 && hour <= 23;
			check &= minute >= 0 && minute <= 59;
			check &= second >= 0 && second <= 59;
			if(!check)
				throw new ItemException("日時情報がへんてこりん", EC.ITEM_DATE_INFO);
			+/
			ChangeWeek();

		} catch(Exception e) {
			throw new ItemException("日時情報変換時に例外", EC.ITEM_DATE, e);
		}
	}
	
	override void year(in WORD Year) {
		if(0 <= Year && Year <= 9999) {
			super.year(Year);
		} else {
			throw new ItemException("年情報が不正", EC.ITEM_DATE);
		}
	}
	override const WORD year()
	out(r) {
		assert(0 <= r && r <= 9999);
	}
	body {
		return super.year();
	}
}

/**
History:
	1.051:
		新規作成。
*/
immutable KEYS=[
	KEY.NONE,
	KEY.A, KEY.B, KEY.C, KEY.D, KEY.E, KEY.F, KEY.G, KEY.H, KEY.I, KEY.J, KEY.K, KEY.L, KEY.M,
	KEY.N, KEY.O, KEY.P, KEY.Q, KEY.R, KEY.S, KEY.T, KEY.U, KEY.V, KEY.W, KEY.X, KEY.Y, KEY.Z,
	KEY.KEY_0, KEY.KEY_1, KEY.KEY_2, KEY.KEY_3, KEY.KEY_4, KEY.KEY_5, KEY.KEY_6, KEY.KEY_7, KEY.KEY_8, KEY.KEY_9,

];


