﻿/**
アイテム関数。
*/
module nemuxi.file.items.itemfunc;

debug import std.stdio: wl = writefln, pl = printf;

debug(itemfunc) void main() {}

//import std.string;
//import std.conv;
//import std.file;
//import std.path;

//import win32.windef;

import etc.kareki.kareki;

import nemuxi.file.items.linkitem;
import nemuxi.file.items.item;
//import nemuxi.file.items.itemif;

import nemuxi.negui.system.base;
import nemuxi.negui.file.file;
import nemuxi.negui.draw.icon;
//import nemuxi.base;
//public import nemuxi.negui.system.timer;
import nemuxi.image.icon;
import nemuxi.negui.environ.variable;
;

/+
Text GetName(Item item)
in {
	assert(item);
}
body {
	return item.name;
}
+/

/**
親フォルダの取得。

Params:
	item = 親フォルダを取得するアイテム。
	       <table>
	         <thead>
	           <tr>
	             <th>Item.TYPE</th>
	             <th>フォルダ</th>
	           </tr>
	         </thead>
	         <tbody>
	           <tr>
	             <th>NORMAL</th>
	             <td>親フォルダ</td>
	           </tr>
	           <tr>
	             <th>URI</th>
	             <td>
	               iten.uriが有効なローカルアドレスならその親フォルダ。
	               無効な場合はスペース分割("が存在する場合は括弧として扱う)した第一要素をローカルアドレスとする。
	               分割要素が無効であれば作業フォルダを使用、それも無理ならnullを返す。
	             </td>
	           </tr>
	           <tr>
	             <th>MULTI</th>
	             <td>
	               作業フォルダを使用。
	               作業フォルダが有効でなければnull。
	             </td>
	           </tr>
	           <tr>
	             <th>LINK</th>
	             <td></td>
	           </tr>
	         </tbody>
	       </table>

History:
	1.061:
		[P] 環境変数を考慮。
*/
Text GetFolder(Item item, lazy Kareha ItemBase=null)
in {
	assert(item);
}
out(r) {
	if(r.length)
	assert(r[r.length-1]=='\\', r.toString);
}
body {
	
	with(Item.TYPE) switch(item.type()) {
		case NORMAL: {
			//return PATH.ownerFolder(item.address);
			return PATH.ownerFolder(toPlain(item.address));
		}
		case URI: {
			try {
				//auto Folder = item.workFolder;
				auto Folder = toPlain(item.workFolder);
				
				if(FILE.isFolder(Folder)) {
					return PATH.addFolderSep(Folder);
				} else {
					return PATH.ownerFolder(Folder);
				}
			} catch(NeGuiFileException e) {
				/+
				if(FILE.isExistence(item.uri)) {
					return PATH.ownerFolder(item.uri);
				} else if(item.uri.length) {
					char   SplitChar;
					size_t StartIndex;
					if(item.uri[0] == '"') {
						SplitChar  = '"';
						StartIndex = 1;
					} else {
						SplitChar  = ' ';
						StartIndex = 0;
					}
					for(auto i=StartIndex; i < item.uri.length; i++) {
						if(item.uri[i] == SplitChar) {
							auto Folder=PATH.ownerFolder(item.uri[StartIndex..i]);
							if(FILE.isFolder(Folder)) {
								return PATH.addFolderSep(Folder);
							}
							break;
						}
					}
				}
				+/
				const Uri=toPlain(item.uri);
				if(FILE.isExistence(Uri)) {
					return PATH.ownerFolder(Uri);
				} else if(Uri.length) {
					char   SplitChar;
					size_t StartIndex;
					if(Uri[0] == '"') {
						SplitChar  = '"';
						StartIndex = 1;
					} else {
						SplitChar  = ' ';
						StartIndex = 0;
					}
					for(auto i=StartIndex; i < Uri.length; i++) {
						if(Uri[i] == SplitChar) {
							auto Folder=PATH.ownerFolder(Uri[StartIndex..i]);
							if(FILE.isFolder(Folder)) {
								return PATH.addFolderSep(Folder);
							}
							break;
						}
					}
				}
			}
			
			return Text.emptyText;
		}
		case MULTI: {
			/+
			if(!item.workFolder.length) {
				return Text.emptyText;
			}
			auto Folder = PATH.addFolderSep(item.workFolder());
			
			try {
				return FILE.isFolder(Folder)
					? Folder
					: Text.emptyText
				;
			} catch(NeGuiFileException e) {
				Text.emptyText;
			}
			+/
			const WorkFolder=item.workFolder;
			if(!WorkFolder.length) {
				return Text.emptyText;
			}
			auto Folder = PATH.addFolderSep(WorkFolder);
			
			try {
				return FILE.isFolder(Folder)
					? Folder
					: Text.emptyText
				;
			} catch(NeGuiFileException e) {
				Text.emptyText;
			}
		}
		case LINK: {
			auto link=new LinkItem(item, ItemBase);
			return GetFolder(link, ItemBase);
		}
		default:
			assert(false);
	}
}
debug(itemfunc) unittest {
	auto aki=newItem();
	auto item=new Item(Text("ie"), aki[`Items`]);
}

/**
History:
	1.061:
		[P] 環境変数を考慮。
*/
Text GetWorkFolder(Item item, lazy Kareha ItemBase=null)
in {
	assert(item);
}
out(r) {
	if(r.length)
	assert(r[r.length-1]=='\\', r.toString);
}
body {
	with(Item.TYPE) switch(item.type()) {
		case NORMAL:
			/+
			if(item.workFolder.length) {
				return PATH.addFolderSep(item.workFolder);
			} else {
				auto Folder=PATH.ownerFolder(item.address);
				if(Folder.length) {
					return PATH.addFolderSep(Folder);
				}
				
				return Text.emptyText;
			}
			+/
			const WorkFolder=toPlain(item.workFolder);
			if(WorkFolder.length) {
				return PATH.addFolderSep(WorkFolder);
			} else {
				const Address=toPlain(item.address);
				auto Folder=PATH.ownerFolder(Address);
				if(Folder.length) {
					return PATH.addFolderSep(Folder);
				}
				
				return Text.emptyText;
			}
			
		case URI, MULTI:
			/*
			if(item.workFolder.length) {
				return PATH.addFolderSep(item.workFolder);
			} else {
				return Text.emptyText;
			}
			*/
			const WorkFolder=toPlain(item.workFolder);
			if(WorkFolder.length) {
				return PATH.addFolderSep(WorkFolder);
			} else {
				return Text.emptyText;
			}
		case LINK:
			return GetWorkFolder(new LinkItem(item, ItemBase), ItemBase);
		default:
			assert(false);
	}
}

/**
History:
	1.00β16:
		[B] 環境変数の処理が甘かった部分を修正。
	
	1.00β15:
		[P] 無効アイコン表示をSYSICON.ASTERISKからSYSICON.EXCLAMATIONに変更。まぁこの列挙体は何の考慮もしてないからあてにならないけど。
		[B] 環境変数を含んでいた場合に起こる不具合の修正。
*/
Icon GetIcon(Item item, Icon.FIXED IconFixed, lazy Kareha ItemBase=null)
in {
	assert(item);
}
body {
	Text IconAddress=void;
	if(item.type() != Item.TYPE.LINK)
	IconAddress=toPlain(item.iconAddress());
	
	switch(item.type()) {
		case Item.TYPE.LINK:
			return GetIcon(new LinkItem(item, ItemBase), IconFixed, ItemBase);
		case Item.TYPE.NORMAL:
			if(!FILE.isExistence(IconAddress)) {
				Text FileAddress=toPlain(item.address());
				if(FILE.isExistence(FileAddress)) {
					IconAddress = FileAddress;
				} else {
					IconAddress = Text.emptyText();
				}
			}
			break;
		case Item.TYPE.URI, Item.TYPE.MULTI:
			if(!FILE.isExistence(IconAddress)) {
				IconAddress = Text.emptyText();
			}
			break;
		default:
			assert(false);
	}
	if(IconAddress.length) {
		return GetFileIcon(IconAddress, item.iconIndex(), IconFixed);
	} else {
		SYSICON SysIcon;
		if(item.type() == Item.TYPE.NORMAL) {
			return new Icon(Icon.STOCK.EXCLAMATION, IconFixed);
		} else {
			assert(item.type() != Item.TYPE.LINK);
			SysIcon = item.type() == Item.TYPE.URI ? SYSICON.URI:SYSICON.MULTI;
		}
		return GetSystemIcon(SysIcon, IconFixed);
	}
}

