﻿/**
ランチャ的なアイテム。

時期を見てからmixinの予定。
*/
module nemuxi.file.items.item;

debug import std.stdio: wl = writefln, pl = printf;

debug(item) void main() {}

//import std.file;
import std.string;
import std.conv;
import std.contracts;
//version(unittest) static import std.regexp;

import etc.kareki.kareki;

import nemuxi.file.items.itemif;

import nemuxi.negui.system.base;
import nemuxi.negui.system.type.enumerated;
import nemuxi.negui.input.keyboard.keyboard;
//import nemuxi.negui.negui;
//import nemuxi.negui.draw.icon;
//public import nemuxi.negui.system.timer;
import nemuxi.system.exception;
import nemuxi.system.type;
import nemuxi.system.log;
//import nemuxi.base;
import nemuxi.negui.file.file;
import nemuxi.file.data;


//import nemuxi.file.items.timer;
//import nemuxi.file.setting;
//import nemuxi.system.language;
//import nemuxi.image.icon;
//import nemuxi.negui.environ.variable;
;
/+
///
class ItemException: DataException {
	mixin MixInNemuxiException;
}
+/
/**
とりあえず登録アイテムにアクセスするにはこいつを使う。

TYPE.LINKはいろいろ存在しない可能性あり。

Bugs:
	Textを設定したい。

History:
	1.051:
		[P] keyの持ち方を変更。
*/
class Item: Data {
	invariant() {
		assert(ItemID.length);
		assert(isID(ItemID), ItemID.toString);
		//assert(ItemIdType(ItemID) == ITEM_ID_TYPE.ITEM);
		
		assert(ks[ITEM.NAME]);
		assert(ks[ITEM.TYPE].have());
		auto Type=cast(TYPE)ks[ITEM.TYPE].get!(Integer);
		if(cast(TYPE)ks[ITEM.TYPE].get!(Integer) != TYPE.MULTI) {
			assert(ks[ITEM.ADDRESS].type() == HAGATA.String);
		} else {
			assert(ks[ITEM.ADDRESS].type() == HAGATA.TSV_String, ItemID.toString);
		}
		if(Type != TYPE.LINK) {
			assert(ks[ITEM.WORKFOLDER].type() == HAGATA.String);
			assert(ks[ITEM.OPTION].type() == HAGATA.String);
			assert(ks[ITEM.ICON_ADDRESS].type() == HAGATA.String);
			//assert(ks[ITEM.ICON_INDEX].type() == HAGATA.Integer);
			assert(ks[ITEM.ICON_INDEX].get!(Integer) >= 0);
			assert(ks[ITEM.SHOW].type() == HAGATA.Integer);
			assert(SHOW.min <= ks[ITEM.SHOW].get!(Integer) && ks[ITEM.SHOW].get!(Integer) <= SHOW.max);
			assert(ks[ITEM.TAGS].type() == HAGATA.TSV_String);
			assert(ks[ITEM.KEY].type() == HAGATA.Integer);
			assert(ks[ITEM.HISTORY_WORKFOLDERS].type() == HAGATA.TSV_String);
			assert(ks[ITEM.HISTORY_OPTIONS].type() == HAGATA.TSV_String);
			//assert(KEY.A <= ks[ITEM.KEY].unSafe!(Integer) && ks[ITEM.KEY].unSafe!(Integer) <= KEY.Z);
			assert(KEYS.indexOf(ks[ITEM.KEY].unSafe!(Integer)) != -1);
		}
		assert(ks[ITEM.HISTORY_REGIST].type() == HAGATA.String);
		assert(ks[ITEM.HISTORY_LAST].type() == HAGATA.String);
		assert(ks[ITEM.HISTORY_USE].type() == HAGATA.Integer);
	}

	private static enum ITEM {
		NAME,
		TYPE,
		ADDRESS,
		WORKFOLDER,
		OPTION,
		ICON_ADDRESS,
		ICON_INDEX,
		SHOW,
		TAGS,
		KEY,
		HISTORY_WORKFOLDERS,
		HISTORY_OPTIONS,
		HISTORY_REGIST,
		HISTORY_LAST,
		HISTORY_USE,
	}

	static immutable struct TREE {
		immutable string
		
		TYPE                = "Type",
		ADDRESS             = "Address",
		WORKFOLDER          = "WorkFolder",
		OPTION              = "Option",
		ICON                = "Icon",
		ICON_ADDRESS        = "Address",
		ICON_INDEX          = "Index",
		SHOW                = "Show",
		TAGS                = "Tags",
		KEY                 = "Key",
		HISTORY             = "History",
		HISTORY_WORKFOLDERS = "WorkFolders",
		HISTORY_OPTIONS     = "Options",
		HISTORY_REGIST      = "Regist",
		HISTORY_LAST        = "Last",
		HISTORY_USE         = "Use",

		_NONE_ ="";
	}
	/+
	/// アイテムの種類。
	static enum TYPE {
		NORMAL, /// 通常アイテム。
		URI,    /// アイテムはURI(なんでもあり)。
		MULTI,  /// 複数アイテム。
		LINK,   /// アイテムへのリンク。
	}
	+/
	alias ITEM_TYPE TYPE;
	/**
	タイプに関連する文字列の取得。

	History:
		1.00β18:
			[S] typeToStringからtypeToTextに名称変更。
			[P] 戻り値の型変更。
	*/
	/*
	static const(Text) typeToText(TYPE Type) {
		/+
		final switch(Type) {
			case TYPE.NORMAL: return Text("通常");
			case TYPE.URI:    return Text("URI");
			case TYPE.MULTI:  return Text("マルチ");
			case TYPE.LINK:   return Text("リンク");
		}
		+/
		return LanguageData.itemType(Type);
	}
	*/
	
	static {
		/**
		History:
			1.00β17:
				[P] 使用禁止文字追加。
		*/
		private immutable NOID = " .,\t[]^{}";
		/**
		History:
			1.00β17:
				[P] 判定方法変更。
				[P] 属性変更。
		*/
		pure nothrow bool isID(dchar c) {
			bool OK=true;
			if(OK &= Convert.isNameChar(c))
			foreach(NoId; NOID) {
				if(!(OK &= c != NoId)) {
					return false;
				}
			}
			return OK;
			/+
			return !Convert.isNameChar(c)
			&& c != NOID[0]//' '
			&& c != NOID[1]//'.'
			&& c != NOID[2]//','
			&& c != NOID[3];//'\t';
			+/
		}
		debug(item) unittest {
			assert(isID('a'));
			assert(isID('あ'));
			assert(!isID('/'));
			assert(!isID('.'));
		}

		/**
		History:
			1.00β17:
				[P] 判定方法変更。
				[P] 属性変更。
		*/
		nothrow bool isID(in Text Id) {
			if(Id.length) {
				foreach(c; Id.text)
				if(!isID(c)) return false;
				return true;
			} else {
				return false;
			}
			/+
			return Id.length
			&& Id.find(NOID[0]) == -1  //indexOf(Id, ' ') == -1
			&& Id.find(NOID[1]) == -1  //indexOf(Id, '.') == -1
			&& Id.find(NOID[2]) == -1  //indexOf(Id, ',') == -1
			&& Id.find(NOID[3]) == -1 //indexOf(Id, '\t') == -1
			&& Convert.isTree(Id.toString);
			+/
		}
	}
	private Text ItemID;
	/**
	コンストラクタ。
	
	ツリーは完全構築される。
	
	Params:
		ItemID = アイテム自体の識別名。
		         Items/[ItemID]

		ItemBase = 基底ツリー。
	*/
	this(in Text ItemID, in Kareha ItemBase)
	in {
		assert(ItemID.length);
		assert(ItemBase);
	}
	body {
		enforce(isID(ItemID), new ItemException(ItemID));
		this.ItemID = ItemID;
		
		ks.length = ITEM.max + 1;

		auto item=ItemBase[ItemID.text8];
		super(item);

		// そのまんま
		ks[ITEM.NAME] = item;

		// アイテム形式
		RegistEx!(TYPE.NORMAL)(
			item,
			TREE.TYPE,
			ITEM.TYPE,
			ks[ITEM.TYPE].have()
			&& ks[ITEM.TYPE].type() == HAGATA.Integer
			&& (TYPE.min <= ks[ITEM.TYPE].get!(Integer) && ks[ITEM.TYPE].unSafe!(Integer) <= TYPE.max)
		);
		invariant auto Type=cast(TYPE)ks[ITEM.TYPE].unSafe!(Integer);
		invariant auto NotLink = Type != TYPE.LINK;

		// アドレス
		if(!(TREE.ADDRESS in item)) {
			item.plus(TREE.ADDRESS, Type != TYPE.MULTI ? super.EmptyString(): super.EmptyTsvString());
			if(item[TREE.ADDRESS].type() == HAGATA.String) {
				item[TREE.ADDRESS] = string.init;
			} else {
				item[TREE.ADDRESS] = (string[]).init;
			}
		}
		ks[ITEM.ADDRESS] = item[TREE.ADDRESS];
		if(
			!ks[ITEM.ADDRESS].have()
			|| !(ks[ITEM.ADDRESS].type() == HAGATA.String || ks[ITEM.ADDRESS].type() == HAGATA.TSV_String)
		) {
			ks[ITEM.ADDRESS] = string.init;
		}

		// アイコン＠履歴＠ブロック外でも使うので先にやっておく
		if(!(TREE.ICON in item)) {
			item.plus(TREE.ICON, super.Empty());
		}
		if(item[TREE.ICON].have()) {
			item[TREE.ICON].fileKill();
		}
		auto icon=item[TREE.ICON];
		
		if(!(TREE.HISTORY in item)) {
			item.plus(TREE.HISTORY, super.Empty());
		}
		if(item[TREE.HISTORY].have()) {
			item[TREE.HISTORY].fileKill();
		}
		auto history=item[TREE.HISTORY];

		//-------------------------------------------------------------

		// 作業フォルダ
		RegistEx!(string.init)(
			item,
			TREE.WORKFOLDER,
			ITEM.WORKFOLDER,
			ks[ITEM.WORKFOLDER].have()
			&& ks[ITEM.WORKFOLDER].type() == HAGATA.String,
			NotLink
		);
	
		// オプション
		RegistEx!(string.init)(
			item,
			TREE.OPTION,
			ITEM.OPTION,
			ks[ITEM.OPTION].have()
			&& ks[ITEM.OPTION].type() == HAGATA.String,
			NotLink
		);
	

		// アドレス
		RegistEx!(string.init)(
			icon,
			TREE.ICON_ADDRESS,
			ITEM.ICON_ADDRESS,
			ks[ITEM.ICON_ADDRESS].have()
			&& ks[ITEM.ICON_ADDRESS].type() == HAGATA.String,
			NotLink
		);
		// インデックス
		RegistEx!(0)(
			icon,
			TREE.ICON_INDEX,
			ITEM.ICON_INDEX,
			ks[ITEM.ICON_INDEX].have()
			&& ks[ITEM.ICON_INDEX].get!(Integer) >= 0,
			NotLink
		);

		// 表示方法
		RegistEx!(cast(Integer)SHOW.SHOWNORMAL)(
			item,
			TREE.SHOW,
			ITEM.SHOW,
			ks[ITEM.SHOW].have()
			&& SHOW.min <= ks[ITEM.SHOW].get!(Integer) && ks[ITEM.SHOW].get!(Integer) <= SHOW.max,
			NotLink
		);

		// タグ
		RegistEx!((string[]).init)(
			item,
			TREE.TAGS,
			ITEM.TAGS,
			ks[ITEM.TAGS].have()
			&& ks[ITEM.TAGS].type() == HAGATA.TSV_String,
			true//NotLink
		);

		// 試験＠キー
		RegistEx!(KEY.NONE)(
			item,
			TREE.KEY,
			ITEM.KEY,
			ks[ITEM.KEY].have()
			&& ks[ITEM.KEY].type() == HAGATA.Integer
			//&& KEY.A <= ks[ITEM.KEY].unSafe!(Integer) && ks[ITEM.KEY].unSafe!(Integer) <= KEY.Z,
			&& KEYS.indexOf(ks[ITEM.KEY].unSafe!(Integer)) != -1,
			true//NotLink
		);


		// 作業フォルダ
		RegistEx!((string[]).init)(
			history,
			TREE.HISTORY_WORKFOLDERS,
			ITEM.HISTORY_WORKFOLDERS,
			ks[ITEM.HISTORY_WORKFOLDERS].have()
			&& ks[ITEM.HISTORY_WORKFOLDERS].type() == HAGATA.TSV_String
		);
		
		// オプション
		RegistEx!((string[]).init)(
			history,
			TREE.HISTORY_OPTIONS,
			ITEM.HISTORY_OPTIONS,
			ks[ITEM.HISTORY_OPTIONS].have()
			&& ks[ITEM.HISTORY_OPTIONS].type() == HAGATA.TSV_String
		);
		
		//-------------------------------------------------------------
		
		// 登録日時
		RegistEx!(string.init)(
			history,
			TREE.HISTORY_REGIST,
			ITEM.HISTORY_REGIST,
			ks[ITEM.HISTORY_REGIST].have()
			&& ks[ITEM.HISTORY_REGIST].type() == HAGATA.String
		);
		// 最終使用日
		RegistEx!(string.init)(
			history,
			TREE.HISTORY_LAST,
			ITEM.HISTORY_LAST,
			ks[ITEM.HISTORY_LAST].have()
			&& ks[ITEM.HISTORY_LAST].type() == HAGATA.String
		);
		// 使用回数
		RegistEx!(0)(
			history,
			TREE.HISTORY_USE,
			ITEM.HISTORY_USE,
			ks[ITEM.HISTORY_USE].have()
			&& ks[ITEM.HISTORY_USE].type() == HAGATA.Integer
			&& ks[ITEM.HISTORY_USE].unSafe!(Integer) >= 0
		);
	}

	/**
	アイテムの種類を取得。

	Return:
		現在のアイテムの種類を返す。
	*/
	const TYPE type() {
		return cast(TYPE)ks[ITEM.TYPE].unSafe!(Integer);
	}

	/+
	/**
	*/
	const string itemID() {
		return ItemID;
	}
	+/
	const Text itemID() {
		return cast(Text)ItemID;
	}

	/**
	History:
		1.00β15:
			Text.toTextLineをそのまま。
	*/
	override string toString() {
		return toTextLine.toString;
	}
	/**
	History:
		1.00β15:
			新規作成。
	*/
	const Text toTextLine() {
		if(name.length) {
			if(name == itemID) {
				//return Text("%s[%s]", name.text, typeToText(type).text);
				return Text("%s", name.text);
			} else {
				return Text("%s(%s)", name.text, ItemID.text);
			}
		} else {
			return Text("(%s)", ItemID.text);
		}
	}
	/**
	History:
		1.022:
			[F] informationを表示。
	*/
	const Text toTextInfo() {
		return name ~ (information.length ? Text.newline~information: Text.emptyText);
	}

	/**
	*/
	const Text name() {
		return GetText(ITEM.NAME);
	}
	/**
	History:
		1.022:
			[P] 処理変更。
	*/
	void name(in Text Name) {
		ks[ITEM.NAME] = Name.text8;
	}

	/**
	アイテムのコメントを取得。

	Return:
		アイテムに設定されているコメント。
	*/
	const Text information() {
		return ks[ITEM.NAME].comment.toText;
	}
	void information(in Text Information) {
		ks[ITEM.NAME].comment = Information.text8;
	}

	/**
	ファイルアドレスを取得。

	TYPE.NORMALであることが強制される。

	Return:
		ファイルアドレス。
	*/
	const Text address() {
		assert(this.type() == TYPE.NORMAL);

		return GetText(ITEM.ADDRESS);
	}
	void address(in Text Address) {
		ks[ITEM.TYPE]    = TYPE.NORMAL;
		ks[ITEM.ADDRESS] = Address.toString;
	}
	/**
	登録アイテムがURIの場合にURIを取得。

	TYPE.URIであることが強制される。
	
	Return:
		URI。
	*/
	const Text uri() {
		assert(this.type() == TYPE.URI);
		
		return GetText(ITEM.ADDRESS);
	}
	void uri(in Text URI) {
		ks[ITEM.TYPE]    = TYPE.URI;
		ks[ITEM.ADDRESS] = URI.toString;
	}
	/**
	*/
	const Text[] multi() {
		assert(this.type() == TYPE.MULTI);

		//return ks[ITEM.ADDRESS].get!(string[]);
		return Texts(ks[ITEM.ADDRESS].get!(string[]));
	}
	void multi(in Text[] Multi) {
		ks[ITEM.TYPE]    = TYPE.MULTI;
		//ks[ITEM.ADDRESS] = Multi;
		ks[ITEM.ADDRESS] = Strings(Multi);
	}

	/**
	*/
	const Text link() {
		assert(this.type() == TYPE.LINK, ItemID.toString);
		
		return GetText(ITEM.ADDRESS);
	}
	void link(in Text Link) {
		ks[ITEM.TYPE]    = TYPE.LINK;
		ks[ITEM.ADDRESS] = Link.toString;
	}

	/**
	作業フォルダ取得。

	Return:
		作業フォルダ。
	*/
	const Text workFolder() {
		return GetText(ITEM.WORKFOLDER);
	}
	void workFolder(in Text Path) {
		if(ks[ITEM.WORKFOLDER]) {
			ks[ITEM.WORKFOLDER] = Path.toString;
		} else {
			ks[ITEM.NAME].plus(TREE.WORKFOLDER, new Kareha(Path.toString));
			ks[ITEM.WORKFOLDER] = ks[ITEM.NAME][TREE.WORKFOLDER];
		}
	}
	const bool haveWorkFolder() {
		return ks[ITEM.WORKFOLDER] !is null;
	}

	/**
	オプション取得。

	Return:
		オプション。
	*/
	const Text option() {
		return GetText(ITEM.OPTION);
	}
	void option(in Text Option) {
		if(ks[ITEM.OPTION]) {
			ks[ITEM.OPTION] = Option.toString;
		} else {
			ks[ITEM.NAME].plus(TREE.OPTION, new Kareha(Option.toString));
			ks[ITEM.OPTION] = ks[ITEM.NAME][TREE.OPTION];
		}
	}
	const bool haveOption() {
		return ks[ITEM.OPTION] !is null;
	}

	/**
	アイコンアドレス取得。

	Return:
		アイコンアドレス。
	*/
	const Text iconAddress() {
		return GetText(ITEM.ICON_ADDRESS);
	}
	void iconAddress(in Text Path) {
		if(ks[ITEM.ICON_ADDRESS]) {
			ks[ITEM.ICON_ADDRESS] = Path.toString;
		} else {
			ks[ITEM.NAME].plus(TREE.ICON, Empty);
			ks[ITEM.NAME][TREE.ICON].plus(TREE.ICON_ADDRESS, new Kareha(Path.toString));
			ks[ITEM.ICON_ADDRESS] = ks[ITEM.NAME][TREE.ICON][TREE.ICON_ADDRESS];
		}
	}
	const bool haveIconAddress() {
		return ks[ITEM.ICON_ADDRESS] !is null;
	}
	
	/**
	アイコンインデックス取得。

	Return:
		アイコンインデックス。
	*/
	const Integer iconIndex() {
		return ks[ITEM.ICON_INDEX].unSafe!(Integer);
	}
	void iconIndex(Integer Index) {
		if(ks[ITEM.ICON_INDEX]) {
			ks[ITEM.ICON_INDEX] = Index;
		} else {
			ks[ITEM.NAME].plus(TREE.ICON, Empty);
			ks[ITEM.NAME][TREE.ICON].plus(TREE.ICON_INDEX, new Kareha(Index));
			ks[ITEM.ICON_INDEX] = ks[ITEM.NAME][TREE.ICON][TREE.ICON_INDEX];
		}
	}
	const bool haveIconIndex() {
		return ks[ITEM.ICON_INDEX] !is null;
	}

	/**
	表示方法取得。

	Return:
		表示方法。
	*/
	const SHOW show() {
		return cast(SHOW)ks[ITEM.SHOW].unSafe!(Integer);
	}
	void show(SHOW Show) {
		if(ks[ITEM.SHOW]) {
			ks[ITEM.SHOW] = Show;
		} else {
			ks[ITEM.NAME].plus(TREE.SHOW, new Kareha(Show));
			ks[ITEM.SHOW] = ks[ITEM.NAME][TREE.SHOW];
		}
	}
	const bool haveShow() {
		return ks[ITEM.SHOW] !is null;
	}
	
	/**
	タグ取得。

	Return:
		タグ。
	*/
	const Text[] tags() {
		return Texts(ks[ITEM.TAGS].unSafe!(string[]));
	}
	void tags(in Text[] Tags) {
		ks[ITEM.TAGS] = Strings(Tags);
	}

	/**
	*/
	const KEY key() {
		return cast(KEY)ks[ITEM.KEY].unSafe!(Integer);
	}
	void key(KEY Key) {
		ks[ITEM.KEY] = cast(Integer)Key;
	}

	/**
	作業フォルダ履歴取得。

	Return:
		作業フォルダ履歴。
	*/
	const Text[] historyWorkFolders() {
		return Texts(ks[ITEM.HISTORY_WORKFOLDERS].unSafe!(string[]));
	}
	void historyWorkFolders(Text[] Paths) {
		ks[ITEM.HISTORY_WORKFOLDERS] = Strings(Paths);
	}
	const bool haveHistoryWorkFolders() {
		return ks[ITEM.HISTORY_WORKFOLDERS] !is null;
	}

	/**
	オプション履歴取得。

	Return:
		オプション履歴。
	*/
	const Text[] historyOptions() {
		// assert(this.type() != TYPE.MULTI);
		return Texts(ks[ITEM.HISTORY_OPTIONS].unSafe!(string[]));//.unSafe!(string[]);
	}
	void historyOptions(Text[] Options) {
		return ks[ITEM.HISTORY_OPTIONS] = Strings(Options);
	}
	const bool haveHistoryOptions() {
		return ks[ITEM.HISTORY_OPTIONS] !is null;
	}
	
	/**
	登録日時取得。

	Return:
		登録日時。
	*/
	const DateTime historyResist() {
		try {
			return new ItemDateTime(GetText(ITEM.HISTORY_REGIST), toTextLine);
		} catch(ItemException e) {
			Logger.write(e);
			return null;
		}
	}
	void historyResist(DateTime date) {
		ks[ITEM.HISTORY_REGIST] = date.toString();
	}
	
	/**
	最終使用日時取得。

	Return:
		最終使用日時。
	*/
	const DateTime historyLast() {
		try {
			return new ItemDateTime(GetText(ITEM.HISTORY_LAST), toTextLine);
		} catch(ItemException e) {
			Logger.write(e);
			return null;
		}
	}
	void historyLast(DateTime date) {
		ks[ITEM.HISTORY_LAST] = date.toString();
	}

	/**
	使用回数取得。

	Return:
		使用回数。
	*/
	const Integer historyUse() {
		return ks[ITEM.HISTORY_USE].unSafe!(Integer);
	}
	/**
	使用回数設定。

	Params:
		value = 設定値。
		        0未満ならInteger.initに設定される。
	*/
	void historyUse(Integer value) {
		if(value < 0)
			value = Integer.init;
		ks[ITEM.HISTORY_USE] = value;
	}
	
	override bool opEquals(Object obj) {
		auto item=cast(Item)obj;
		return ItemID == item.ItemID;
	}

	/**
	History:
		1.021:
			新規作成。
	*/
	override int opCmp(Object obj) {
		auto item=cast(Item)obj;

		// 名前
		if(auto cmp=name.cmpi(item.name)) {
			return cmp;
		}
		// ID
		return ItemID.cmpi(item.ItemID);
	}

	debug const Text toDebug() {
		string[] s;
		s ~= format("%20s > %s", "ItemID", ItemID.toString);
		for(auto i=ITEM.min; i <= ITEM.max; i++) {
			s ~= format("%20s > %s", to!(string)(cast(ITEM)i), ks[i]);
		}
		return join(s, "\n").toText;
	}

}

debug(item) unittest {
	Item item;

	auto aki=newItem();
	
	item=new Item(Text("ie"), aki[`Items`]);
	item=new Item(Text("test"), aki[`Items`]);
	//assert(cast(SHOW)aki[`Items/test`]["Show"].unSafe!(Integer) == SHOW.SHOW);
	assert(aki[`Items/test`]["Address"].unSafe!(string) == "");
	assert(aki[`Items/test`]["Tags"].unSafe!(string[]) == null);
	item=new Item(Text("link"), aki[`Items`]);
	//wl("%s",(new Item("ie", aki[`Items`])).toDebug);
}
debug AkiDocument newItem() {
	return new AkiDocument(`
;The
;Internet
;Explorer
Items/ie\Internet Explorer
Items/ie/Type:0
Items/ie/Address\C:\\Program Files\\Internet Explorer\\iexplore.exe
Items/ie/WorkFolder\C:\\Program Files\\Internet Explorer\\
Items/ie/Option\\e
Items/ie/Icon/Address\C:\\Program Files\\Internet Explorer\\iexplore.exe
Items/ie/Icon/Index:0
Items/ie/Show:5
Items/ie/Tags$\e
Items/ie/History/WorkFolders$\e
Items/ie/History/Options$\e
Items/ie/History/Regist\2007/01/01
Items/ie/History/Last\2008/01/01
Items/ie/History/Use:0

;Baka!
Items/test\Test!!
Items/test/Address/DUMMY\あああ
Items/test/Tags/DUMMY\あああ

;uri
Items/URI\ゆーあーるあい
Items/URI/Type:1
Items/URI/Address\\"C:\\Program Files\\Internet Explorer\\iexplore.exe" -test

		
;まるち
Items/MULTI\MULTI
Items/MULTI/Type:2
Items/MULTI/Address$ie	test	ie	link	link

;リンク
Items/link\LINKKK!
Items/link/Type:3
Items/link/Address\ie
Items/link/WorkFolder\aaa
		
;リンク
Items/eeee\eeee
Items/eeee/Type:3
Items/eeee/Address\eeee
Items/eeee/WorkFolder\aaa
;リンク
Items/ffff\ffff
Items/ffff/Type:3
Items/ffff/Address\eeee
Items/ffff/WorkFolder\aaa
		
;まるち
Items/333\３
Items/333/Type:2
Items/333/Address$test	URI	MULTI	link	333

	`.splitlines);
}


