﻿/**

*/
module nemuxi.file.folder;

debug import std.stdio: wl = writefln, pl = printf;

debug(folder) void main() {}

import std.contracts;

import win32.shlobj;
//import win32.shellapi;
//import win32.winerror;
//import win32.shlwapi;
//import win32.objbase;
//import win32.objidl;

//import win32.core;

//import nemuxi.base;
import nemuxi.negui.system.base;
import nemuxi.system.exception;
import nemuxi.negui.file.file;
//import nemuxi.file.exec;

import nemuxi.negui.com.imalloc;

class FolderException: NemuxiException {
	mixin MixInNemuxiException;
}



enum {
	CSIDL_DESKTOP                 = 0x0000, /// 「デスクトップ」（ネームスペースのルートを表す仮想フォルダ）
	CSIDL_INTERNET                = 0x0001, /// 「Internet Explorer」（仮想フォルダ）
	CSIDL_PROGRAMS                = 0x0002, /// 「プログラム」（ファイルシステムディレクトリ）
	CSIDL_CONTROLS                = 0x0003, /// 「コントロール パネル」（仮想フォルダ）
	CSIDL_PRINTERS                = 0x0004, /// 「プリンタ」（仮想フォルダ）
	CSIDL_PERSONAL                = 0x0005, /// 「マイ ドキュメント」（ファイルシステムディレクトリ）
	CSIDL_FAVORITES               = 0x0006, /// 「お気に入り」（ファイルシステムディレクトリ）
	CSIDL_STARTUP                 = 0x0007, /// 「スタートアップ」（ファイルシステムディレクトリ）
	CSIDL_RECENT                  = 0x0008, /// 「最近使ったファイル」（ファイルシステムディレクトリ）
	CSIDL_SENDTO                  = 0x0009, /// 「SendTo」（ファイルシステムディレクトリ）
	CSIDL_BITBUCKET               = 0x000a, /// 「ごみ箱」（仮想フォルダ）
	CSIDL_STARTMENU               = 0x000b, /// 「スタートメニュー」（ファイルシステムディレクトリ）
	CSIDL_MYMUSIC                 = 0x000d, /// 「マイ ミュージック」（ファイルシステムディレクトリ）
	CSIDL_MYVIDEO                 = 0x000e, /// 
	CSIDL_DESKTOPDIRECTORY        = 0x0010, /// 「デスクトップ」上のファイルオブジェクトを格納するフォルダ（ファイルシステムディレクトリ）
	CSIDL_DRIVES                  = 0x0011, /// 「マイ コンピュータ」（仮想フォルダ）
	CSIDL_NETWORK                 = 0x0012, /// 「ネットワークコンピュータ」（仮想フォルダ）
	CSIDL_NETHOOD                 = 0x0013, /// 「NetHood」（ファイルシステムディレクトリ）
	CSIDL_FONTS                   = 0x0014, /// 「Fonts」（フォントを含む仮想フォルダ）
	CSIDL_TEMPLATES               = 0x0015, /// ドキュメントテンプレートが格納されるフォルダ（ファイルシステムディレクトリ）
	CSIDL_COMMON_STARTMENU        = 0x0016, /// AllUsers の「スタートメニュー」（ファイルシステムディレクトリ）
	CSIDL_COMMON_PROGRAMS         = 0x0017, /// AllUsers の「プログラム」（ファイルシステムディレクトリ）
	CSIDL_COMMON_STARTUP          = 0x0018, /// AllUsers の「スタートアップ」（ファイルシステムディレクトリ）
	CSIDL_COMMON_DESKTOPDIRECTORY = 0x0019, /// AllUsers の「デスクトップ」（ファイルシステムディレクトリ）
	CSIDL_APPDATA                 = 0x001a, /// Version 4.71 以降： 「Application Data」（ファイルシステムディレクトリ）
	CSIDL_PRINTHOOD               = 0x001b, /// 「プリンタ」仮想フォルダにおかれるリンクオブジェクトを格納するフォルダ（ファイルシステムディレクトリ）
	CSIDL_LOCAL_APPDATA           = 0x001c, /// Version 5.0 以降： 「Application Data」（ファイルシステムディレクトリ）
	CSIDL_ALTSTARTUP              = 0x001d, /// 非ローカル版の「スタートアップ」（ファイルシステムディレクトリ）
	CSIDL_COMMON_ALTSTARTUP       = 0x001e, /// 非ローカル版の AllUsers の「スタートアップ」（ファイルシステムディレクトリ）
	CSIDL_COMMON_FAVORITES        = 0x001f, /// AllUsers の「お気に入り」（NT系のみ）（ファイルシステムディレクトリ）
	CSIDL_INTERNET_CACHE          = 0x0020, /// Version 4.72 以降： インターネット一時ファイルを格納するフォルダ（ファイルシステムディレクトリ）
	CSIDL_COOKIES                 = 0x0021, /// 「Cookies」（ファイルシステムディレクトリ）
	CSIDL_HISTORY                 = 0x0022, /// 「履歴」（ファイルシステムディレクトリ）
	CSIDL_COMMON_APPDATA          = 0x0023, /// Version 5.0 以降： AllUsers の「Application Data」（ファイルシステムディレクトリ）
	CSIDL_WINDOWS                 = 0x0024, /// Version 5.0 以降： Windows ディレクトリ
	CSIDL_SYSTEM                  = 0x0025, /// Version 5.0 以降： Windows System ディレクトリ
	CSIDL_PROGRAM_FILES           = 0x0026, /// Version 5.0 以降： Program Files フォルダ
	CSIDL_MYPICTURES              = 0x0027, /// Version 5.0 以降： My Pictures フォルダ（ファイルシステムディレクトリ）
	CSIDL_PROFILE                 = 0x0028, /// Version 5.0 以降： profile フォルダ
	CSIDL_PROGRAM_FILES_COMMON    = 0x002b, /// Version 5.0 以降；Windows 2000/XP： Program Files\Common
	CSIDL_COMMON_TEMPLATES        = 0x002d, /// Windows NT/2000/XP： AllUsers のドキュメントテンプレートが格納されるディレクトリ
	CSIDL_COMMON_DOCUMENTS        = 0x002e, /// Shfolder.dll： AllUsers のドキュメントテンプレートが格納されるディレクトリ（Windows NT 系および Shfolder.dll がインストールされた Windows 9x）
	CSIDL_COMMON_ADMINTOOLS       = 0x002f, /// Version 5.0 以降： AllUsers の管理ツールディレクトリ
	CSIDL_ADMINTOOLS              = 0x0030, /// Version 5.0 以降： 管理ツールディレクトリ

	CSIDL_COMMON_MUSIC    = 0x35,
	CSIDL_COMMON_PICTURES = 0x36,
	CSIDL_COMMON_VIDEO    = 0x37,

	
}

enum SYSTEM_FOLDER {
	COMPUTER = int.min,
	CONTROLPANEL,
	TRASH,
	NETWORK,
	NETWORK_CONNECT,
	CAMERA_SCANNER,
	PRINTER_FAX,
	TASK,
	FONTS,
	ADMINTOOLS,

	_PADDING_VIRTUAL_,

	STARTMENU                = CSIDL_STARTMENU,               /// 「スタートメニュー」（ファイルシステムディレクトリ）
	PROGRAMS                 = CSIDL_PROGRAMS,                /// 「プログラム」（ファイルシステムディレクトリ）
	STARTUP                  = CSIDL_STARTUP,                 /// 「スタートアップ」（ファイルシステムディレクトリ）
	DESKTOPDIRECTORY         = CSIDL_DESKTOPDIRECTORY,        /// 「デスクトップ」上のファイルオブジェクトを格納するフォルダ（ファイルシステムディレクトリ）
	FAVORITES                = CSIDL_FAVORITES,               /// 「お気に入り」（ファイルシステムディレクトリ）
	RECENT                   = CSIDL_RECENT,                  /// 「最近使ったファイル」（ファイルシステムディレクトリ）
	SENDTO                   = CSIDL_SENDTO,                  /// 「SendTo」（ファイルシステムディレクトリ）
	
	PROFILE                  = CSIDL_PROFILE,                 /// Version 5.0 以降： profile フォルダ
	DOCUMENTS                = CSIDL_PERSONAL,                /// 「マイ ドキュメント」（ファイルシステムディレクトリ）
	PICTURES                 = CSIDL_MYPICTURES,              /// Version 5.0 以降： My Pictures フォルダ（ファイルシステムディレクトリ）
	MUSIC                    = CSIDL_MYMUSIC,                 /// 「マイ ミュージック」（ファイルシステムディレクトリ）
	VIDEO                    = CSIDL_MYVIDEO,                 /// 「マイミュージック」
	
	APPDATA                  = CSIDL_APPDATA,                 /// Version 4.71 以降： 「Application Data」（ファイルシステムディレクトリ）
	APPDATA_LOCAL            = CSIDL_LOCAL_APPDATA,           /// Version 5.0 以降： 「Application Data」（ファイルシステムディレクトリ）
	TEMPLATES                = CSIDL_TEMPLATES,               /// ドキュメントテンプレートが格納されるフォルダ（ファイルシステムディレクトリ）
	
	INTERNET_CACHE           = CSIDL_INTERNET_CACHE,          /// Version 4.72 以降： インターネット一時ファイルを格納するフォルダ（ファイルシステムディレクトリ）
	INTERNET_COOKIES         = CSIDL_COOKIES,                 /// 「Cookies」（ファイルシステムディレクトリ）
	INTERNET_HISTORY         = CSIDL_HISTORY,                 /// 「履歴」（ファイルシステムディレクトリ）
	
	WINDOWS                  = CSIDL_WINDOWS,                 /// Version 5.0 以降： Windows ディレクトリ
	SYSTEM                   = CSIDL_SYSTEM,                  /// Version 5.0 以降： Windows System ディレクトリ
	PROGRAM_FILES            = CSIDL_PROGRAM_FILES,           /// Version 5.0 以降： Program Files フォルダ
	PROGRAM_FILES_COMMON     = CSIDL_PROGRAM_FILES_COMMON,    /// Version 5.0 以降；Windows 2000/XP： Program Files\Common
	
	ALLUSER_STARTMENU        = CSIDL_COMMON_STARTMENU,        /// AllUsers の「スタートメニュー」（ファイルシステムディレクトリ）
	ALLUSER_PROGRAMS         = CSIDL_COMMON_PROGRAMS,         /// AllUsers の「プログラム」（ファイルシステムディレクトリ）
	ALLUSER_STARTUP          = CSIDL_COMMON_STARTUP,          /// AllUsers の「スタートアップ」（ファイルシステムディレクトリ）
	ALLUSER_DESKTOPDIRECTORY = CSIDL_COMMON_DESKTOPDIRECTORY, /// AllUsers の「デスクトップ」（ファイルシステムディレクトリ）
	ALLUSER_FAVORITES        = CSIDL_COMMON_FAVORITES,        /// AllUsers の「お気に入り」（NT系のみ）（ファイルシステムディレクトリ）
	ALLUSER_APPDATA          = CSIDL_COMMON_APPDATA,          /// Version 5.0 以降： AllUsers の「Application Data」（ファイルシステムディレクトリ）
	ALLUSER_TEMPLATES        = CSIDL_COMMON_TEMPLATES,        /// Windows NT/2000/XP： AllUsers のドキュメントテンプレートが格納されるディレクトリ
	ALLUSER_DOCUMENTS        = CSIDL_COMMON_DOCUMENTS,        /// Shfolder.dll： AllUsers のドキュメントテンプレートが格納されるディレクトリ（Windows NT 系および Shfolder.dll がインストールされた Windows 9x）
	ALLUSER_PICTURES         = CSIDL_COMMON_PICTURES,         /// 
	ALLUSER_MUSIC            = CSIDL_COMMON_MUSIC,            /// 
	ALLUSER_VIDEO            = CSIDL_COMMON_VIDEO,            /// 
}

private static struct SYSTEMFOLDER {
	static immutable wstring

	/// マイコンピュータ
	COMPUTER = `::{20D04FE0-3AEA-1069-A2D8-08002B30309D}`,
	/// コントロールパネル
	CONTROLPANEL = `::{20D04FE0-3AEA-1069-A2D8-08002B30309D}\::{21EC2020-3AEA-1069-A2DD-08002B30309D}`,
	/// ゴミ箱
	TRASH = `::{645FF040-5081-101B-9F08-00AA002F954E}`,
	/// マイネットワーク
	NETWORK = `::{208D2C60-3AEA-1069-A2D7-08002B30309D}`,
	/// ネットワーク接続
	NETWORK_CONNECT = `::{20D04FE0-3AEA-1069-A2D8-08002B30309D}\::{21EC2020-3AEA-1069-A2DD-08002B30309D}\::{7007ACC7-3202-11D1-AAD2-00805FC1270E}`,
	/// カメラとスキャナ
	CAMERA_SCANNER = `::{20D04FE0-3AEA-1069-A2D8-08002B30309D}\::{21EC2020-3AEA-1069-A2DD-08002B30309D}\::{E211B736-43FD-11D1-9EFB-0000F8757FCD}`,
	/// プリンタとFAX
	PRINTER_FAX = `::{20D04FE0-3AEA-1069-A2D8-08002B30309D}\::{21EC2020-3AEA-1069-A2DD-08002B30309D}\::{2227A280-3AEA-1069-A2DE-08002B30309D}`,
	/// タスク
	TASK = `::{20D04FE0-3AEA-1069-A2D8-08002B30309D}\::{21EC2020-3AEA-1069-A2DD-08002B30309D}\::{D6277990-4C6A-11CF-8D87-00AA0060F5BF}`,
	/// フォント
	FONTS = `::{20D04FE0-3AEA-1069-A2D8-08002B30309D}\::{21EC2020-3AEA-1069-A2DD-08002B30309D}\::{D20EA4E1-3957-11d2-A40B-0C5020524152}`,
	/// 管理ツール
	ADMINTOOLS = `::{20D04FE0-3AEA-1069-A2D8-08002B30309D}\::{21EC2020-3AEA-1069-A2DD-08002B30309D}\::{D20EA4E1-3957-11d2-A40B-0C5020524153}`,

	
	_NONE_="";

	static Text toText(SYSTEM_FOLDER SystemFolder)
	in {
		assert(SystemFolder < SYSTEM_FOLDER._PADDING_VIRTUAL_);
	}
	body {
		switch(SystemFolder) {
			case SYSTEM_FOLDER.COMPUTER:
				return Text(COMPUTER);
			case SYSTEM_FOLDER.CONTROLPANEL:
				return Text(CONTROLPANEL);
			case SYSTEM_FOLDER.TRASH:
				return Text(TRASH);
			case SYSTEM_FOLDER.NETWORK:
				return Text(NETWORK);
			case SYSTEM_FOLDER.NETWORK_CONNECT:
				return Text(NETWORK_CONNECT);
			case SYSTEM_FOLDER.CAMERA_SCANNER:
				return Text(CAMERA_SCANNER);
			case SYSTEM_FOLDER.PRINTER_FAX:
				return Text(PRINTER_FAX);
			case SYSTEM_FOLDER.TASK:
				return Text(TASK);
			case SYSTEM_FOLDER.FONTS:
				return Text(FONTS);
			case SYSTEM_FOLDER.ADMINTOOLS:
				return Text(ADMINTOOLS);

			default:
				assert(false);
		}
	}
}

Text GetSystemFolder(SYSTEM_FOLDER SystemFolder, size_t PathSize=PATH.MAX_PATH)
in {
	assert(SystemFolder != SYSTEM_FOLDER._PADDING_VIRTUAL_);
	assert(PathSize);
}
body {
	if(SystemFolder < SYSTEM_FOLDER._PADDING_VIRTUAL_) {
		return SYSTEMFOLDER.toText(SystemFolder);
	} else {
		scope malloc=new Malloc();
		LPITEMIDLIST pidl;
		scope(exit) malloc.free(pidl);
		
		enforce(S_OK == SHGetSpecialFolderLocation(null, SystemFolder, &pidl), new FolderException(ERR.toText));
		auto RawPath=new wchar[PathSize];
		enforce(SHGetPathFromIDList(pidl, RawPath.ptr), new FolderException(ERR.toText));
		
		return Text(RawPath.ptr);
	}
	
}

debug(folder) unittest {
	wl("%s", GetSystemFolder(SYSTEM_FOLDER.NETWORK_CONNECT));
}

