﻿/**
ちょっとしたデータ。
*/
module nemuxi.file.data;

debug import std.stdio: wl = writefln, pl = printf;
debug(data) void main() {}

//import std.file;
import std.string;
import std.stream;
//import core.thread;
import std.contracts;

import etc.kareki.kareki;

//import nemuxi.base;
import nemuxi.negui.system.base;
//import nemuxi.negui.system.meta.memberproperty;

import nemuxi.negui.file.file;
import nemuxi.system.exception;
import nemuxi.system.log;
//import nemuxi.utility.meta.memberproperty;

///
class DataException: NemuxiException {
	mixin MixInNemuxiException;
}

/**
Kareha集合体。

少しでも早くアクセスしたい、そんな思いを配列に。

History:
	1.081:
		[P] ルートを保持する。
*/
class Data {
	protected Kareha Root;
	/**
	History:
		1.081:
			新規作成。
	*/
	this(Kareha Root) {
		this.Root = Root;
	}
	protected {
		/// アクセス用配列。わけわからん修飾子だなぁ。
		package Kareha[] ks;
		/// 文字列取得。
		const Text GetText(size_t n) {
			if(auto s=ks[n].unSafe!(string)) {
				return s.toText;
			} else {
				return Text.emptyText;
			}
		}
		/**
		History:
			1.090:
				新規作成。
		*/
		const Text[] GetTexts(size_t n) {
			if(auto s=ks[n].unSafe!(string[])) {
				return Texts(s);
			} else {
				return null;
			}
		}
		/**
		真偽値取得。
		
		History:
			1.081:
				[P] 間違えること無いだろうしunSafe。
		*/
		const bool GetBool(size_t n) {
			return ks[n].unSafe!(Integer) == 0 ? false: true;
		}

		/**
		History:
			1.081:
				新規作成。
		*/
		const T[] GetDefaultTSV(T: T[])(size_t n, in T[] DefaultTSV) {
			auto DataTsv=ks[n].unSafe!(T[]);
			auto Result=new T[DefaultTSV.length];

			for(auto i=0; i < DefaultTSV.length; i++) {
				Result[i] = cast(T)(DataTsv[i] == DefaultTSV[i] ? DefaultTSV[i]: DataTsv[i]);
			}

			return Result;
		}
		/**
		History:
			1.081:
				新規作成。
		*/
		void SetDefaultTSV(T: T[])(size_t n, in T[] DefaultTSV, in T[] SetTSV) {
			auto Result=new T[DefaultTSV.length];

			bool FullEqual=true;
			for(auto i=0; i < DefaultTSV.length; i++) {
				auto Equal=SetTSV[i] == DefaultTSV[i];
				Result[i] = cast(T)(SetTSV[i] == DefaultTSV[i] ? T.init: SetTSV[i]);
				
				if(!FullEqual && !Equal) {
					FullEqual = false;
				}
			}
			if(FullEqual) {
				ks[n] = (T[]).init;
			} else {
				ks[n] = Result;
			}
		}
		/**
		History:
			1.081:
				新規作成。
		*/
		Kareha DefaultParent(Kareha Parent, size_t ChildIndex, string ChildTree, lazy Kareha ChildKareha) {
			if(!(ChildTree in Parent)) {
				Parent.plus(ChildTree, ChildKareha);
			}
			auto item=Parent[ChildTree];
			if(ChildIndex != -1) {
				return ks[ChildIndex] = item;
			} else {
				return item;
			}
		}
		Kareha DefaultParent(size_t ParentIndex, size_t ChildIndex, string ChildTree, lazy Kareha ChildKareha) {
			return DefaultParent(ks[ParentIndex], ChildIndex, ChildTree, ChildKareha);
		}
	}
	/// 空Kareha生成。
	static protected Kareha Empty() {
		return new Kareha();
	}
	/// ditto
	static protected Kareha EmptyString() {
		return new Kareha(string.init);
	}
	/// ditto
	static protected Kareha EmptyInteger(Integer ini=Integer.init) {
		return new Kareha(ini);
	}
	/// ditto
	static protected Kareha EmptyTsvInteger() {
		return new Kareha((Integer[]).init);
	}
	/// ditto
	static protected Kareha EmptyTsvString() {
		return new Kareha((string[]).init);
	}

	/**
	登録簡易化。
	
	------------------------------------------
	// Before
	if(!ks[ITEM.XXX](TREE.XXX_YYY)) {
		ks[ITEM.XXX].plus(TREE.XXX_YYY, super.EmptyTsvString());
	}
	ks[ITEM.XXX_YYY] = ks[ITEM.XXX][TREE.XXX_YYY];
	if(
		!ks[ITEM.XXX_YYY].have()
		|| ks[ITEM.XXX_YYY].type() != HAGATA.TSV_String
		|| (ks[ITEM.XXX_YYY].tsvLength() < 2)
	) {
		ks[ITEM.XXX_YYY] = (string[]).init;
	}
	
	//After
	Regist!((string[]).init)(
		ks[ITEM.XXX],
		TREE.XXX_YYY,
		ITEM.XXX_YYY,
		!ks[ITEM.XXX_YYY].have()
		|| ks[ITEM.XXX_YYY].type() != HAGATA.TSV_String
		|| (ks[ITEM.XXX_YYY].tsvLength() < 2)
	);
	------------------------------------------
	#あんましかわんねー…。

	Params:
		Value = Expが真の場合に設定される値。

		BaseData = 基底ツリー。

		TreeData = 対象のツリー。

		TargetIndex = 設定すべきksの添え字。

		Exp = 対象ksの無効値。

		ArraySubstitution = BaseData[TreeData]が無効な場合に生成して代入を行うか。
	*/
	deprecated protected void Regist(alias Value)(Kareha BaseData, string TreeData, size_t TargetIndex, lazy bool Exp, bool ArraySubstitution=true) {
		if(ArraySubstitution) {
			if(!(TreeData in BaseData)) {
				BaseData.plus(TreeData, this.Empty());
			}
			ks[TargetIndex] = BaseData[TreeData];
			//auto Exps=ks[TargetIndex];
			if(Exp) {
				ks[TargetIndex] = Value;
			}
		} else {
			if((TreeData in BaseData)) {
				ks[TargetIndex] = BaseData[TreeData];
				//auto Exps=ks[TargetIndex];
				if(Exp) {
					ks[TargetIndex] = Value;
				}
			}
		}
	}
	/**
	invariant()にそのまま使えるようにassertとかenforceに合わせてExpが偽の場合に処理を行う。
	*/
	final protected void RegistEx(alias Value)(Kareha BaseData, string TreeData, size_t TargetIndex, lazy bool Exp, bool ArraySubstitution=true) {
		if(ArraySubstitution) {
			if(!(TreeData in BaseData)) {
				BaseData.plus(TreeData, this.Empty());
			}
			ks[TargetIndex] = BaseData[TreeData];
			
			if(!Exp) {
				ks[TargetIndex] = Value;
			}
		} else {
			if(TreeData in BaseData) {
				ks[TargetIndex] = BaseData[TreeData];
				
				if(!Exp) {
					ks[TargetIndex] = Value;
				}
			}
		}
	}
	
	const Kareha opIndex(size_t n) {
		return cast(Kareha)ks[n];
	}
	/**
	History:
		1.00β15:
			新規作成。
	*/
	const size_t length() {
		return ks.length;
	}

	override string toString() {
		return Root.toString;
	}
}


class AkiStream: EndianStream {
	
	/**
	*/
	this(in Text path, FileMode mode = (FileMode).In, uint bufferSize = BufferedStream.DefaultBufferSize) {
		super(new BufferedFile(path.text8(), mode, bufferSize));
		
		if((mode & FileMode.In) == FileMode.In && size > 0) {
			Bom = readBOM == -1 ? false: true;
		}
	}

	///
	private bool Bom;
	mixin(SMixInStructGetSet!(bool)("bom", q{Bom}));

	void writeBOM() {
		if(Bom) {
			super.writeBOM(BOM.UTF8);
		}
	}

	/**
	History:
		1.070:
			新規作成。
	*/
	string[] allData(size_t InitialValue=BUFFER.INITIAL, size_t Increment=BUFFER.INCREMENT) {
		auto Datas=new string[InitialValue];
		
		size_t i=0;
		foreach(char[] line; this) {
			Datas.autoIncrement(i, Increment);
			Datas[i++] = line.idup;
		}

		return Datas[0 .. i];
	}
	/**
	History:
		1.070:
			新規作成。
	*/
	bool allData(in string[] Datas) {
		try {
			writeBOM();

			foreach(line; Datas) {
				writeLine(line);
			}

			return true;
		} catch(Exception e) {
			return false;
		}
	}
}

/**
History:
	1.070:
		新規作成。
*/
string[] ReadTextData(in Text file, size_t InitialValue=BUFFER.INITIAL, size_t Increment=BUFFER.INCREMENT)
in {
	assert(FILE.isExistence(file));
}
body {
	mixin(SMixInLog("ReadTextData"));
	log.write("file - [%s]%sInitialValue - [%s]%sIncrement - [%s]", file, Text.newline, InitialValue, Text.newline, Increment);

	scope aki=new AkiStream(file);
	scope(exit) {
		log.write("file close.");
		aki.close;
	}
	return aki.allData(InitialValue, Increment);
}
/**
History:
	1.081:
		[P] 処理内容変更。

	1.070:
		新規作成。
*/
bool WriteTextData(in Text Path, in string[] Datas, bool Bom=true) {
	mixin(SMixInLog("WriteTextData"));
	log.write("Path - [%s]", Path);
	
	auto aki=new AkiStream(Path, FileMode.OutNew);
	scope(exit) {
		log.write("file flush.");
		aki.flush;
		log.write("file close.");
		aki.close;
		delete aki;
	}
	aki.bom = Bom;
	return aki.allData(Datas);
}

/**
History:
	1.081:
		[F] エラー出力機能。

	1.070:
		[S] ファイル操作を委譲。
*/
AkiDocument ReadAkiDocument(in Text file, size_t InitialValue=BUFFER.INITIAL, size_t Increment=BUFFER.INCREMENT) {
	mixin(SMixInLog("ReadAkiDocument"));
	log.write("file - [%s]%sInitialValue - [%s]%sIncrement - [%s]", file, Text.newline, InitialValue, Text.newline, Increment);
	
	enforce(FILE.isExistence(file), new DataException(Text("not found - [%s]", file)));
	AKIERRDATA[] ErrDatas;
	auto aki=new AkiDocument(ReadTextData(file, InitialValue, Increment), ErrDatas);
	if(ErrDatas.length) {
		auto errs=new Text[ErrDatas.length];
		foreach(i, ErrData; ErrDatas) {
			errs[i] = Text("data = %s[%s]", ErrData.data, ErrData.e);
		}
		log.write("Error!%s%s", Text.newline, errs.join(Text.newline));
	}
	return aki;
}
/**
History:
	1.070:
		[S] ファイル操作を委譲。
*/
bool WriteAkiDocument(in Text file, AkiDocument AkiData) {
	mixin(SMixInLog("WriteAkiDocument"));
	log.write("file - [%s]", file);

	auto data=AkiData.toString().splitlines();

	return WriteTextData(file, data);
}


