﻿/**
DLLインターフェイス。

序数1-9は予約されたものとして処理。

<dl>
	<dt>DLL_Information</dt>
	<dd>
		Index: 1
		extern(C) int DLL_Information(DLLINFORMATION* pDllInformation);

		Params:
			pDllInformation = DLL情報を格納する領域。
			                  wchar*メンバがnullの場合はその情報を格納せずに対応size_tメンバのみに値を格納する。
			                  size_tメンバにはwchar*メンバに必要なサイズ(番兵不要)が格納される。

		Return:
			成功すれば0以外、失敗すれば0を返す。
	</dd>

	<dt>DLL_SettingDialog__TYPE</dt>
	<dd>
		Index: 2
		extern(C) int DLL_HaveSettingDialog();

		Return:
			DLLが設定ダイアログを持っていれば0以外、もっていなければ0を返す。
	</dd>
	
</dl>
*/
module dllinterface;

version(build) {
	pragma(build_def, `

EXPORTS

		DLL_Information             @1
		DLL_HaveSettingDialog       @2

	`);
}

immutable {
	wstring TOOLNAME       = "Hooker";
	wstring TOOLVER        = "1.100";

	wstring VENDORNAME     = "sk";
	wstring VENDORSITENAME = "ヲコノモノ";
	wstring VENDORSITEURI  = "http://www.usamimi.info/~wokonomono/";
	wstring VENDORMAIL     = "wokonomono@gmail.com";
	wstring VENDORCOMMENT  = "TLS死ね";
	
	wstring LICENSENAME    = "NYSL";
	wstring LICENSEDOC     = `NYSL Version 0.9982

A. 本ソフトウェアは Everyone'sWare です。このソフトを手にした一人一人が、
   ご自分の作ったものを扱うのと同じように、自由に利用することが出来ます。

  A-1. フリーウェアです。作者からは使用料等を要求しません。
  A-2. 有料無料や媒体の如何を問わず、自由に転載・再配布できます。
  A-3. いかなる種類の 改変・他プログラムでの利用 を行っても構いません。
  A-4. 変更したものや部分的に使用したものは、あなたのものになります。
       公開する場合は、あなたの名前の下で行って下さい。

B. このソフトを利用することによって生じた損害等について、作者は
   責任を負わないものとします。各自の責任においてご利用下さい。

C. 著作者人格権は ○○○○ に帰属します。著作権は放棄します。

D. 以上の３項は、ソース・実行バイナリの双方に適用されます。
`;
	//'
}

// DLL_Information -----------------------------------------
extern(C) int DLL_Information(DLLINFORMATION* pDllInformation) {
	// 長さ設定
	pDllInformation.ToolNameLength        = TOOLNAME       .length;
	pDllInformation.ToolVerLength         = TOOLVER        .length;
	pDllInformation.VendorNameLength      = VENDORNAME     .length;
	pDllInformation.VendorSiteNameLength  = VENDORSITENAME .length;
	pDllInformation.VendorSiteUriLength   = VENDORSITEURI  .length;
	pDllInformation.VendorMailLength      = VENDORMAIL     .length;
	pDllInformation.VendorCommentLength   = VENDORCOMMENT  .length;
	pDllInformation.LicenseNameLength     = LICENSENAME    .length;
	pDllInformation.LicenseDocLength      = LICENSEDOC     .length;

	void SetValue(wchar* Copy, in wstring Src) {
		if(Copy) {
			for(auto i=0; i < Src.length; i++) {
				Copy[i] = Src[i];
			}
		}
	}

	try {
		SetValue(pDllInformation.ToolName        , TOOLNAME       );
		SetValue(pDllInformation.ToolVer         , TOOLVER        );
		SetValue(pDllInformation.VendorName      , VENDORNAME     );
		SetValue(pDllInformation.VendorSiteName  , VENDORSITENAME );
		SetValue(pDllInformation.VendorSiteUri   , VENDORSITEURI  );
		SetValue(pDllInformation.VendorMail      , VENDORMAIL     );
		SetValue(pDllInformation.VendorComment   , VENDORCOMMENT  );
		SetValue(pDllInformation.LicenseName     , LICENSENAME    );
		SetValue(pDllInformation.LicenseDoc      , LICENSEDOC     );
	} catch(Object o) {
		// 隠蔽
		return 0;
	}
	
	return 1;
}

/**
DLL情報。
*/
struct DLLINFORMATION {
	wchar* ToolName;             /// DLL名。
	size_t ToolNameLength;       /// ditto
	wchar* ToolVer;              /// DLLバージョン。
	size_t ToolVerLength;        /// ditto
	wchar* VendorName;           /// 製作者名。
	size_t VendorNameLength;     /// ditto
	wchar* VendorSiteName;       /// 製作者サイト名。
	size_t VendorSiteNameLength; /// ditto
	wchar* VendorSiteUri;        /// 製作者サイトURI。
	size_t VendorSiteUriLength;  /// ditto
	wchar* VendorMail;           /// 製作者メールアドレス。
	size_t VendorMailLength;     /// ditto
	wchar* VendorComment;        /// 製作者コメント。
	size_t VendorCommentLength;  /// ditto
	wchar* LicenseName;          /// ライセンス名。
	size_t LicenseNameLength;    /// ditto
	wchar* LicenseDoc;           /// ライセンス内容。
	size_t LicenseDocLength;     /// ditto
}


// DLL_SettingDialog ---------------------------------------
extern(C) int DLL_HaveSettingDialog()  {
	return 0;
}



