//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <iomanip>
#include "CommPort.h"
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------

//RXgN^
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
	CommPort = new TCommPort;
	CommPort->OnRecvEvent = RecvEvent;
}
//---------------------------------------------------------------------------

//fXgN^
__fastcall TMainForm::~TMainForm()
{
    delete CommPort;
}
//---------------------------------------------------------------------------

//|[gJ܂
void __fastcall TMainForm::OpenButtonClick(TObject *Sender)
{
	if ( !CommPort->Enabled ) {

		CommPort->ChPort = PortEdit->Text.ToIntDef(1);
		if ( !CommPort->Open() )
        	Application->MessageBoxA("|[gJ܂B", "Error", MB_OK | MB_ICONQUESTION);
    }
}
//---------------------------------------------------------------------------

//|[g܂
void __fastcall TMainForm::CloseButtonClick(TObject *Sender)
{
	CommPort->Close();
}
//---------------------------------------------------------------------------

//f[^M
void __fastcall TMainForm::WriteButtonClick(TObject *Sender)
{
	CommPort->write(WriteEdit->Text.c_str());	
}
//---------------------------------------------------------------------------

//f[^MCxg
void __fastcall TMainForm::RecvEvent(char *RxData, int size)
{
	for ( int i=0; i<size; i++ ) {

    	switch ( RxData[i] ) {

			case '\r':
            	CommBuff << "\\r";
				break;

			case '\n':
			    CommBuff << "\\n";
				break;

			case '\0':
				CommBuff << "\\0";
				break;

			default:
				if ( 32<=RxData[i] && RxData[i]<=126 )
					CommBuff << RxData[i];
				else {
                	CommBuff.setf(ios::hex, ios::basefield);
					CommBuff << "0x" << (unsigned int)((BYTE)RxData[i]) << "h";
				}
				break;
		}
	}

	ReadEdit->Text = CommBuff.str().c_str();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ClearButtonClick(TObject *Sender)
{
	CommBuff.str("");
	ReadEdit->Text = "";	
}
//---------------------------------------------------------------------------
