//---------------------------------------------------------------------------

#ifndef CommPortH
#define CommPortH
//---------------------------------------------------------------------------

#include <Classes.hpp>
#include <vector.h>
//---------------------------------------------------------------------------
//
//  VA|[g񓯊ʐMNX
//
//---------------------------------------------------------------------------
#define WAIT_COMM		WAIT_OBJECT_0
#define WAIT_ESC		(WAIT_OBJECT_0+1)

const int COMM_EVENT = 0;
const int ESC_FUNC = 1;

typedef void __fastcall (__closure *TRecvEvent)(char *RxData, int size);
typedef void __fastcall (__closure *TErrorEvent)(DWORD fEvent);

class TCommPort : public TThread
{
private:

    //CxgIuWFNg
    HANDLE      hEventObjects[2];
    OVERLAPPED  fOverLapped;
    OVERLAPPED  fReadDummy;
    OVERLAPPED  fWriteDummy;
    DWORD       fEventMask;
    DWORD       fEvent;

    //ʐM|[g
    HANDLE      hCom;
    DCB         comDcb;
    COMSTAT     comStat;
    DWORD       comError;

    //ʐMobt@
    vector<char>    RxBuff;
    vector<char>    TxBuff;
    vector<char>    TxData;


    //vpeB
    int             FEnabled;
    int             FChPort;
    DWORD           FEscFunc;
    DWORD           FBaudRate;
    TRecvEvent      FOnRecvEvent;
    TErrorEvent     FOnErrorEvent;


    //\bh
    void __fastcall comm_event();
    void __fastcall esc_func();

    void create_dcb();

protected:

    void __fastcall Execute();

public:

    //RXgN^ƃfXgN^
    __fastcall TCommPort(bool CreateSuspended=false);
    virtual __fastcall ~TCommPort();


    //I[vN[Y
    bool Open();
    void Close();
    void EscapeFunction(DWORD dwFunc);
    void SetEventMask(DWORD mask);
    void ResetEventMask(DWORD mask);


    //M\bh
    void write(const char* data, int size);
    void write(const char* buff);


    //vpeB
    __property int Enabled
        = { read=FEnabled };
    __property int ChPort
        = { read=FChPort, write=writeChPort };
    __property DWORD BaudRate
        = { read=FBaudRate, write=writeBaudRate };
    __property TRecvEvent OnRecvEvent
        = { read=FOnRecvEvent, write=FOnRecvEvent };
    __property TErrorEvent OnErrorEvent
        = { read=FOnErrorEvent, write=FOnErrorEvent };

private:

    //vpeBpANZX\bh
    void writeChPort(int port);
    void writeBaudRate(DWORD baud);

};
//---------------------------------------------------------------------------
#endif
