//---------------------------------------------------------------------------

#define STRICT
#include <vcl.h>
#pragma hdrstop

#include <windows.h>
#include <algorithm>
#include <iterator>
#include <sstream>
#include "CommPort.h"

#pragma package(smart_init)
//---------------------------------------------------------------------------

// ӁFقȂXbhL VCL ̃\bh/֐/vpeB
//       ʂ̃Xbh̒爵ꍇCr̖肪܂B
//
//       CXbh̏LIuWFNgɑ΂Ă Synchronize
//       \bhgł܂B̃IuWFNgQƂ邽
//       ̃\bhXbhNXɒǉCSynchronize \bh
//       Ƃēn܂B
//
//       Ƃ UpdateCaption ȉ̂悤ɒ`A
//
//      void __fastcall TCommPort::UpdateCaption()
//      {
//        Form1->Caption = "Xbh珑܂";
//      }
//
//       Execute \bh̒ Synchronize \bhɓnƂŃC
//       XbhL Form1  Caption vpeBSɕ
//       Xł܂B
//
//      Synchronize(UpdateCaption);
//
//---------------------------------------------------------------------------


//[
void __fastcall TCommPort::Execute()
{
    DWORD Result;

    // TODO : XbhƂĎsR[hȉɋLq */
    while ( !Terminated ) {

        //ŃCxg҂ubN
        Result = WaitForMultipleObjects(2, hEventObjects, FALSE, 500);


        //Cxg
        switch ( Result ) {

			//ʐMCxg
			case WAIT_COMM:
				Synchronize((TThreadMethod)&comm_event);
				break;

			//RTSNGXg
			case WAIT_ESC:
                Synchronize((TThreadMethod)&esc_func);
                break;
        }
    }
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//  VA|[gʐM\bh
//---------------------------------------------------------------------------

//ʐM|[gCxgM
void __fastcall TCommPort::comm_event()
{
    DWORD rwSize;
    ResetEvent(hEventObjects[COMM_EVENT]);
    ClearCommError(hCom, &comError, &comStat);


    //f[^MCxg
    if ( fEvent & EV_RXCHAR ) {

        if ( comStat.cbInQue ) {
        
            RxBuff.clear();
            RxBuff.resize(comStat.cbInQue);
            ReadFile(hCom, RxBuff.begin()._Myptr, RxBuff.size(), NULL, &fReadDummy);
            GetOverlappedResult(hCom, &fReadDummy, &rwSize, TRUE);

            if ( FOnRecvEvent!=NULL ) FOnRecvEvent(RxBuff.begin()._Myptr, RxBuff.size());
        }
    }

    //Mobt@Cxg
    if ( fEvent & EV_TXEMPTY ) {

        TxBuff.clear();
        if ( !TxData.empty() ) {

        	copy(TxData.begin(), TxData.end(), back_inserter(TxBuff));
			TxData.clear();
            WriteFile(hCom, TxBuff.begin()._Myptr, TxBuff.size(), NULL, &fWriteDummy);
        }
    }

    //CTSoCxg
    if ( fEvent & ~(EV_RXCHAR | EV_TXEMPTY) ) {

        if ( FOnErrorEvent!=NULL ) FOnErrorEvent(fEvent);
    }

    WaitCommEvent(hCom, &fEvent, &fOverLapped);
}
//---------------------------------------------------------------------------

//RTSNGXg
void __fastcall TCommPort::esc_func()
{
	ResetEvent(hEventObjects[ESC_FUNC]);

	if ( hCom!=INVALID_HANDLE_VALUE ) EscapeCommFunction(hCom, FEscFunc);
}
//---------------------------------------------------------------------------

//DCB\̂𐶐܂
void TCommPort::create_dcb()
{
    //{ݒ
    comDcb.DCBlength = sizeof(DCB);
    comDcb.BaudRate = FBaudRate;
    comDcb.ByteSize = 8;
    comDcb.fAbortOnError = FALSE;
    comDcb.fNull = FALSE;
    comDcb.fBinary = TRUE;
    comDcb.fParity = FALSE;
    comDcb.Parity = NOPARITY;
    comDcb.StopBits = ONESTOPBIT;


    //t[Ƃ
    comDcb.fOutxCtsFlow = FALSE;
    comDcb.fOutxDsrFlow = FALSE;
    comDcb.fDtrControl = DTR_CONTROL_DISABLE;
    comDcb.fRtsControl = RTS_CONTROL_DISABLE;
    comDcb.fDsrSensitivity = FALSE;


    //Xon-XoffRg[
    comDcb.fTXContinueOnXoff = TRUE;
    comDcb.fOutX = FALSE;
    comDcb.fInX = FALSE;
    comDcb.XonLim = 1024;
    comDcb.XoffLim = 1024;
//    comDcb.XonChar;
//    comDcb.XoffChar;


    //uƂCxg
    comDcb.fErrorChar = FALSE;
//    comDcb.ErrorChar = 0x00;
//    comDcb.EofChar;
//    comDcb.EvtChar;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//  J\bh
//---------------------------------------------------------------------------

//VA|[gI[v܂
bool TCommPort::Open()
{
    //ʐM|[gĂƂ
    if ( hCom==NULL ) {

        //pX̍쐬
        stringstream path;
        if ( FChPort>9 ) {
            path << "\\\\.\\COM" << FChPort;
        }
        else {
            path << "COM" << FChPort;
        }


        //|[g̃I[v
        hCom = CreateFile(
            path.str().c_str(),
            GENERIC_READ | GENERIC_WRITE,
            0,
            NULL,
            OPEN_EXISTING,
            FILE_FLAG_OVERLAPPED,
            NULL
        );
        if ( hCom==INVALID_HANDLE_VALUE ) return false;


        //|[gƃCxg̐ݒ
        create_dcb();
        SetCommState(hCom, &comDcb);
        SetCommMask(hCom, EV_TXEMPTY | EV_RXCHAR | fEventMask);
        WaitCommEvent(hCom, &fEvent, &fOverLapped);


        //obt@̃NA
        FEnabled = true;
        RxBuff.clear();
        TxBuff.clear();
        TxData.clear();
	}

	return true;
}
//---------------------------------------------------------------------------

//VA|[gN[Y܂
void TCommPort::Close()
{
    //ʐM|[gJĂƂ
    if ( hCom!=NULL ) {

        SetCommMask(hCom, 0);
        CloseHandle(hCom);
        hCom = NULL;
        FEnabled = false;
    }
}
//---------------------------------------------------------------------------

//RTSM̐
void TCommPort::EscapeFunction(DWORD dwFunc)
{
    FEscFunc = dwFunc;
    SetEvent(hEventObjects[ESC_FUNC]);
}
//---------------------------------------------------------------------------

//M\bh
void TCommPort::write(const char* data, int size)
{
    //Mobt@̎͂ɑM
    if ( TxBuff.empty() ) {

        copy(data, data + size, back_inserter(TxBuff));
        WriteFile(hCom, TxBuff.begin()._Myptr, size, NULL, &fWriteDummy);
    }

    //M̏ꍇTxDataɃvbV
    else {

		copy(data, data + size, back_inserter(TxData));
	}
}
//---------------------------------------------------------------------------

//M\bh
void TCommPort::write(const char* buff)
{
	int size;

	//Mobt@̎͂ɑM
	if ( TxBuff.empty() ) {

		for ( size=0; buff[size]!=NULL; size++ ) TxBuff.push_back(buff[size]);
		WriteFile(hCom, TxBuff.begin()._Myptr, size, NULL, &fWriteDummy);
	}

	//M̏ꍇTxDataɃvbV
	else {

		for ( size=0; buff[size]!=NULL; size++ ) TxData.push_back(buff[size]);
    }
}
//---------------------------------------------------------------------------

//Cxg}XNZbg
void TCommPort::SetEventMask(DWORD mask)
{
    fEventMask |= mask;
}
//---------------------------------------------------------------------------

//Cxg}XNZbg
void TCommPort::ResetEventMask(DWORD mask)
{
    fEventMask &= ~mask;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//  RXgN^ƃfXgN^
//---------------------------------------------------------------------------

//RXgN^
__fastcall TCommPort::TCommPort(bool CreateSuspended)
    : TThread(CreateSuspended)
{
    //ȍ
    hCom = NULL;
    FEnabled = false;
    FChPort = 1;
    FBaudRate = 9600; 

    //CxgIuWFNg̍쐬
	hEventObjects[0] = CreateEvent(NULL, TRUE, FALSE, NULL);
	hEventObjects[1] = CreateEvent(NULL, TRUE, FALSE, NULL);


    //nhNULL̎͗O𓊂B
    if ( hEventObjects[0]==NULL || hEventObjects[1]==NULL ) {

        //nh̃N[Y
		CloseHandle(hEventObjects[0]);
		CloseHandle(hEventObjects[1]);

		throw "event object is null";
    }
    else {

        //OVERLAPPED\̂̏
        ZeroMemory(&fOverLapped, sizeof(OVERLAPPED));
        ZeroMemory(&fReadDummy, sizeof(OVERLAPPED));
        ZeroMemory(&fWriteDummy, sizeof(OVERLAPPED));
        
        fOverLapped.Offset = 0;
        fOverLapped.OffsetHigh = 0;
        fOverLapped.hEvent = hEventObjects[COMM_EVENT];
    }
}
//---------------------------------------------------------------------------

//fXgN^
__fastcall TCommPort::~TCommPort()
{
    //Xbh̏I
	OnRecvEvent = NULL;
	OnErrorEvent = NULL;
	Close();

    //nh̃N[Y
	CloseHandle(hEventObjects[0]);
	CloseHandle(hEventObjects[1]);
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//  ANZX\bh
//---------------------------------------------------------------------------

//COM|[gANZX
void TCommPort::writeChPort(int port)
{
    if ( port>0 ) FChPort = port;
}
//---------------------------------------------------------------------------

//{[[gANZX
void TCommPort::writeBaudRate(DWORD baud)
{
    switch ( baud ) {
        case 110:
            FBaudRate = baud;
            break;
        case 300:
            FBaudRate = baud;
            break;
        case 1200:
            FBaudRate = baud;
            break;
        case 2400:
            FBaudRate = baud;
            break;
        case 4800:
            FBaudRate = baud;
            break;
        case 9600:
            FBaudRate = baud;
            break;
        case 19200:
            FBaudRate = baud;
            break;
        case 38400:
            FBaudRate = baud;
            break;
        case 57600:
            FBaudRate = baud;
            break;
        case 115200:
            FBaudRate = baud;
            break;
        case 230400:
            FBaudRate = baud;
            break;
        case 460800:
            FBaudRate = baud;
            break;
        case 921600:
            FBaudRate = baud;
            break;
        default:
            FBaudRate = 9600;
            break;
    }
}
//---------------------------------------------------------------------------

