#include <stdio.h>
#include <string.h>
#include <stdlib.h>

//XNvg͍ő1000s܂œǂݍ
#define SCRIPT_MAX_LINE 1000
//XNvgő啶
#define SCRIPT_MAX_STRING_LENGTH 300

typedef struct ScriptInformation_tag {
	int maxLineNumber;			//XNvgs
	int currentLine;			//݉sڂsĂ邩
	const char* filename;		//t@C
	char script[SCRIPT_MAX_LINE][SCRIPT_MAX_STRING_LENGTH];
} ScriptInformation;


//vg^Cv錾
int loadScript(const char* filename, ScriptInformation* scriptInfo);
void splitString(const char* src, char* dest[], const char* delim, int splitNum);
void printElements(char* elem[]);
int searchScriptLabel(const char* label, ScriptInformation* scriptInfo);

//XNvgt@Cǂݍ
//߂l -1 : s  0 : 
int loadScript(const char* filename, ScriptInformation* scriptInfo)
{
	int pos;
	char c;
	//XNvgt@C
	FILE* fp;

	//XNvg
	memset( scriptInfo , 0, sizeof(ScriptInformation) );

	//XNvgt@CJ
	fp = fopen(filename, "r");
	if( fp == NULL ) {
		//t@Cǂݍ݂Ɏs
		printf("XNvg %s ǂݍ߂܂ł\n", filename);
		return -1;
	}

	//scriptݎɎgp
	pos = 0;

	for( ;; ) {
		//ꕶǂݍ
		c = fgetc( fp );
		//t@C̏I肩ǂ
		if( feof( fp ) ) {
			break;
		}
		//͐擪̋󔒕ǂݔ΂
		while( (c == ' ' || c == '\t') && pos == 0 && !feof( fp ) ) {
			c = fgetc( fp );
		}

		if( pos >= SCRIPT_MAX_STRING_LENGTH - 1 ) {
			//1s̕
			printf("error: ܂ (%ds)", scriptInfo->currentLine );
			return -1;
		}

		//soĂꍇC̍sֈړ
		if( c == '\n' ) {
			//s͓ǂݔ΂
			if( pos == 0 ) {
				continue;
			}
			//\0𕶎̍Ōɕt
			scriptInfo->script[ scriptInfo->currentLine ][ pos ] = '\0';
			//̍sɈړ
			scriptInfo->currentLine++;
			//݈ʒu0ɂ
			pos = 0;
		}else {
			//
			scriptInfo->script[ scriptInfo->currentLine ][ pos ] = c;
			//݈ʒu炷
			pos++;
		}
	}
	//ős
	scriptInfo->maxLineNumber = scriptInfo->currentLine;
	//ǂݍݒ̍s0ɂ
	scriptInfo->currentLine = 0;
	//XNvgt@Cݒ
	scriptInfo->filename = filename;

	return 0;
}

//񕪊(1s̍ő啶 SCRIPT_MAX_STRING_LENGTH)
//src : 
//dest: ꂽ
//delim: ؂蕶
//splitNum : ő啪
void splitString(const char* src, char* dest[], const char* delim, int splitNum)
{
	int i;
	char* cp;
	char* copySrc;

	//͂̕Rs[
	copySrc = (char*)malloc( sizeof(int) * SCRIPT_MAX_STRING_LENGTH + 1);
	strncpy( copySrc, src, SCRIPT_MAX_STRING_LENGTH );
	cp = copySrc;

	//strtokg copySrc delim؂ŕ
	for( i = 0; i < splitNum ; i++ ) {
		//Ώە񂪖Ȃ܂ŕ
		if( (dest[i] = strtok(cp, delim)) == NULL ) {
			break;
		}
		//2ڂstrtokĂяóCcpNULLɂ
		cp = NULL;
	}
	//ꂽ̍Ō̗vfNULLƂĂ
	dest[i] = NULL;
}

//fobOp
//elem̗vf\
void printElements(char* elem[])
{
	int i;
	for( i = 0; elem[i] != NULL; i++ ) {
		printf("%d : %s\n", i + 1, elem[i] );
	}
}

//w肵xsT
//߂l ̐: w肵x̍sԍ -1: G[
int searchScriptLabel(const char* label, ScriptInformation* scriptInfo)
{
	//ꂽXNvg
	char* message[100];
	//񕪊̋؂蕶
	const char* delim = " ";
	int i, line = -1;

	for( i = 0; i < scriptInfo->maxLineNumber; i++ ) { 
		//XNvg
		splitString( scriptInfo->script[i] , message, delim, 100 );

		//Ɏsꍇ
		if( message[0] == NULL ) {
			return -1;
		}

		//w肵xT
		if( strncmp(message[0], "@@label", SCRIPT_MAX_STRING_LENGTH) == 0 ) {
			if( strncmp(message[1], label, SCRIPT_MAX_STRING_LENGTH) == 0 ) {
				//w肵x
				line = i;
				break;
			}
		}
	}

	return line;
}

int main()
{
	int i;
	int line;
	ScriptInformation script;

	loadScript( "./script.txt", &script );

	for( i = 0; i < script.maxLineNumber ; i++ ) {
		printf("%d : %s\n", i + 1, script.script[i] );
	}

	line = searchScriptLabel("LABEL1", &script );
	printf("LABEL1 %d sڂɂ܂\n", line + 1);
	
	line = searchScriptLabel("NEXT", &script );
	printf("NEXT %d sڂɂ܂\n", line + 1);

	line = searchScriptLabel("HELLO", &script );
	printf("HELLO %d sڂɂ܂\n", line + 1);

	return 0;
}