#include "DxLib.h"

#define GRAPHIC_BACKGROUND_FILENAME "./pic/back.png"
#define GRAPHIC_SELECTBOX_FILENAME  "./pic/select.png"

#define SELECT_BOX_X 50
#define SELECT_BOX_Y 200

#define SELECT_BOX_WIDTH 700
#define SELECT_BOX_HEIGHT 50

#define SELECT_BOX_MESSAGE_Y 20

#define FONT_SIZE 16

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
						 LPSTR lpCmdLine, int nCmdShow )
{
	//EBhE[hŋN
	ChangeWindowMode( TRUE );
	//ʂ̑傫800 * 600
	SetGraphMode( 800, 600 , 16 ) ;
	//DxLib
	if( DxLib_Init() == -1 ) {
		 return -1;
	}

	// `𗠉ʂɃZbg
	SetDrawScreen( DX_SCREEN_BACK );

	//tHg̑傫Zbg
	SetFontSize( FONT_SIZE );

	//
	int whiteColor = GetColor(255, 255, 255);
	//wi̓ǂݍ
	int backgroundGraphic = LoadGraph( GRAPHIC_BACKGROUND_FILENAME );
	//I{bNX̓ǂݍ
	int selectBoxGraphicHandle = LoadGraph( GRAPHIC_SELECTBOX_FILENAME ); 

	//C[v
	while( ProcessMessage() == 0 && CheckHitKey( KEY_INPUT_ESCAPE ) == 0 ) {

		//ʃNA
		ClearDrawScreen();

		//wi`
		DrawGraph( 0, 0, backgroundGraphic, FALSE );		
		//x50Ƃ
		SetDrawBlendMode( DX_BLENDMODE_ALPHA , 128 );
		//I{bNX̕`(I2̏ꍇ)
		DrawGraph( SELECT_BOX_X, SELECT_BOX_Y, selectBoxGraphicHandle, TRUE );
		DrawGraph( SELECT_BOX_X, SELECT_BOX_Y + SELECT_BOX_HEIGHT,
			selectBoxGraphicHandle, TRUE);
		//At@uhɖ߂
		SetDrawBlendMode( DX_BLENDMODE_NOBLEND , 0 );

		//Kɕ\
		DrawString(SELECT_BOX_X + 20, SELECT_BOX_Y + SELECT_BOX_MESSAGE_Y,
			"I1 ", whiteColor);
		DrawString(SELECT_BOX_X + 20, SELECT_BOX_Y + SELECT_BOX_HEIGHT + SELECT_BOX_MESSAGE_Y,
			"I2 Ă", whiteColor);

		ScreenFlip();
	}

	DxLib_End();
	return 0;
}
