package value;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedHashSet;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import main_panel.MainPanel;
import main_panel.Starter;
import main_panel.Starter.HeaderInfo;
import action.ActionManager;
import action.ChangeShosetsu;
import action.Delete;

public class Values implements ActionListener, ChangeListener, KeyListener {
	public static JButton[] bs, bs2;
	public static int[] combo_boxes = { 1, 2, 4 };
	public static String[] combo_boxes_ = { "x1.0", "x2.0", "x4.0" };
	public static int DIRECTION = 8;

	public static int haku_4_numbers = 400;

	public static JSpinner haku_jspinner;

	public static HeaderInfo header;

	public static JLabel Label_E_N_S, Label_E_N_N;
	public static final Values ME = new Values();
	/**
	 * x/yのy部音符の長さ
	 * 
	 */
	public static final int NODE_H = 12;
	public static final int NODE_W = 40;
	public static final int LINE_X[] = { 0, NODE_W, NODE_W + 6, NODE_W * 2 + 6,
			NODE_W * 3 + 6, NODE_W * 4 + 6, NODE_W * 5 + 6 };
	public static MainPanel main_panel;
	public static int raitio = 1;
	public static JScrollBar scroll;
	public static JViewport view;
	public static Dimension viewport_d = new Dimension(
			LINE_X[LINE_X.length - 1] + 1, NODE_H * 40);

	public static int getArrow(char c) {
		switch (c) {
		case '↓':
			return 2;
		case '←':
			return 4;
		case '→':
			return 6;
		case '↑':
			return 8;
		default:
			return 1;
		}
	}

	public static String getArrow(int VALUE) {
		switch (VALUE) {
		case 2:
			return "↓";
		case 4:
			return "←";
		case 6:
			return "→";
		case 8:
			return "↑";
		default:
			return "";
		}
	}

	public static int getCompressNumber() {
		if (Values.ME.three_combination) {
			if (Values.ME.six_combination) {
				return 2;
			} else {
				return 4;
			}
		} else
			return 12 / Values.raitio;
	}

	public static int getMainH() {
		return NODE_H * haku_4_numbers;
	}

	public static int getMinNode() {
		if (raitio == 1)
			return 4;
		else if (raitio == 2)
			return 8;
		else if (raitio == 4)
			return 16;
		else
			return 32;
	}

	public static int getNode16H() {
		return NODE_H * raitio / 4;
	}

	public static int getNodeH() {
		return getNode16H() * 16 / getMinNode();
	}

	public static int getRows(int rows) {
		if (rows > 0)
			rows++;
		return LINE_X[rows];
	}

	public static int getShoSetsuHeight() {
		return NODE_H * 4 * raitio;
	}

	public static void setSize_MainPanel() {
		// Values.scroll.setVisible(false);
		// Values.scroll.setEnabled(false);
		// Values.view.setVisible(false);
		// Values.view.setEnabled(false);
		if (Starter.ME == null) {
			main_panel.setPreferredSize(getMainH(), raitio);
			return;
		}
		Starter.ME.setVisible(false);
		main_panel.setPreferredSize(getMainH(), raitio);
		Starter.ME.setVisible(true);
		// Values.scroll.setVisible(true);
		// Values.scroll.setEnabled(true);
		// Values.view.setVisible(true);
		// Values.view.setEnabled(true);
	}

	public JSpinner BMP;

	public LinkedHashSet<Integer> KeyPressingList = new LinkedHashSet<Integer>(
			3);

	public boolean three_combination, six_combination;
	public boolean flag_Long_Node;
	public static boolean flag_changing_shosetsu;
	public static JRadioButton select_normal, select_long;

	@Override
	public void actionPerformed(ActionEvent e) {
		Object o = e.getSource();
		if (o instanceof JComboBox) {
			JComboBox c = (JComboBox) o;
			if (c.getName().matches("RATIO")) {
				raitio = combo_boxes[c.getSelectedIndex()];
				setSize_MainPanel();
			}
		} else if (o instanceof JButton) {
			JButton b = (JButton) o;
			if (b.getActionCommand().matches("DIRECT")) {
				for (JButton bb : bs) {
					bb.setEnabled(true);
				}
				b.setEnabled(false);
				DIRECTION = getArrow(b.getText().charAt(0));
			} else if (b.getText().matches("\\+"))
				main_panel.changeShoSetsu(1);
			else if (b.getText().matches("\\-"))
				main_panel.changeShoSetsu(-1);
			else if (b.getText().matches("コピー"))
				main_panel.copy();
			else if (b.getText().matches("切り取り"))
				main_panel.cut();
			else if (b.getText().matches("解除"))
				main_panel.copyRelease();
		} else if (o instanceof JRadioButton) {
			JRadioButton b = (JRadioButton) o;
			nodeLength(b);
		}
		Values.main_panel.requestUpDate();
	}

	private void nodeLength(JRadioButton b) {
		Values.ME.flag_Long_Node = false;
		three_combination = false;
		six_combination = false;
		if (b.getText().matches("３連")) {
			three_combination = true;
		} else if (b.getText().matches("６連")) {
			three_combination = true;
			six_combination = true;
		} else if (b.getText().matches("長押")) {
			Values.ME.flag_Long_Node = true;
		}
	}

	@Override
	public void keyPressed(KeyEvent e) {
		int code = e.getKeyCode();
		switch (code) {
		case KeyEvent.VK_N:
			select_normal.setSelected(true);
			nodeLength(select_normal);
			break;
		case KeyEvent.VK_L:
			System.out.println(select_long);
			select_long.setSelected(true);
			nodeLength(select_long);
			break;
		case KeyEvent.VK_S:
			if (KeyPressingList.contains(KeyEvent.VK_CONTROL)) {
				SaveLoad.save();
				break;
			}
		case KeyEvent.VK_DOWN:
			DIRECTION = 2;
			break;
		case KeyEvent.VK_LEFT:
		case KeyEvent.VK_A:
			DIRECTION = 4;
			break;
		case KeyEvent.VK_RIGHT:
		case KeyEvent.VK_D:
			DIRECTION = 6;
			break;
		case KeyEvent.VK_UP:
		case KeyEvent.VK_W:
			DIRECTION = 8;
			break;
		case KeyEvent.VK_DELETE:
			if (!main_panel.selected_nodes.isEmpty())
				ActionManager.exe(new Delete(main_panel.selected_nodes));
			break;
		case KeyEvent.VK_X:
			if (KeyPressingList.contains(KeyEvent.VK_CONTROL))
				main_panel.cut();
			else
				main_panel.delete(main_panel.getMousePosition());
			break;
		case KeyEvent.VK_Z:
			if (KeyPressingList.contains(KeyEvent.VK_CONTROL))
				if (KeyPressingList.contains(KeyEvent.VK_SHIFT))
					ActionManager.redo();
				else
					ActionManager.undo();
			else
				main_panel.add(main_panel.getMousePosition());
			break;
		case KeyEvent.VK_C:
			if (KeyPressingList.contains(KeyEvent.VK_CONTROL))
				if (KeyPressingList.contains(KeyEvent.VK_SHIFT))
					main_panel.copyRelease();
				else
					main_panel.copy();
			break;
		case KeyEvent.VK_Y:
			if (KeyPressingList.contains(KeyEvent.VK_CONTROL))
				ActionManager.redo();
			break;
		}
		for (JButton b : bs)
			b.setEnabled(!getArrow(DIRECTION).matches(b.getText()));
		KeyPressingList.add(code);
		main_panel.upDate();
		Values.main_panel.requestUpDate();
	}

	@Override
	public void keyReleased(KeyEvent e) {
		KeyPressingList.remove(e.getKeyCode());
		Values.main_panel.requestUpDate();
	}

	@Override
	public void keyTyped(KeyEvent e) {
	}

	@Override
	public void stateChanged(ChangeEvent e) {
		Object o = e.getSource();
		if (o instanceof JSpinner) {
			JSpinner c = (JSpinner) o;
			if (c.getName().matches("BPM")) {
				main_panel.BPM_MAP.put(0, (Integer) c.getValue());
			} else if (c.getName().matches("haku_4_numbers")) {
				if (!flag_changing_shosetsu)
					ActionManager
							.exe(new ChangeShosetsu((Integer) c.getValue()));
			} else if (c.getName().matches("WHO")) {
				scroll.setUnitIncrement((Integer) c.getValue());
			}
		}
		Values.main_panel.requestUpDate();
	}
}
