package value;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

import main_panel.Starter;
import main_panel.node.Node;
import action.ActionManager;

public class SaveLoad {
	public static final String SAVE = "Save as_", Load = "Load",
			OVERWRITE = "Save";
	public static File f = null;

	public static boolean actionPerformed(String s) {
		JFileChooser filechooser = new JFileChooser("./otog/csv/");
		FileNameExtensionFilter ff = new FileNameExtensionFilter(
				"csvファイル(*.csv)", "csv");
		filechooser.setFileFilter(ff);
		SwingUtilities.updateComponentTreeUI(Starter.ME);
		if (s.matches(SAVE)) {
			int selected = filechooser.showSaveDialog(Starter.ME);
			if (selected == JFileChooser.APPROVE_OPTION) {
				File file = filechooser.getSelectedFile();
				if (!file.getName().contains(".")) {
					file = new File(file.getPath().concat(".csv"));
				}
				return write(file);
			} else if (selected == JFileChooser.CANCEL_OPTION) {
			} else if (selected == JFileChooser.ERROR_OPTION) {
			}
		} else if (s.matches(Load)) {
			int selected = filechooser.showOpenDialog(Starter.ME);
			if (selected == JFileChooser.APPROVE_OPTION) {
				File file = filechooser.getSelectedFile();
				return load(file);
			} else if (selected == JFileChooser.CANCEL_OPTION) {
			} else if (selected == JFileChooser.ERROR_OPTION) {
			}
		} else if (s.matches(OVERWRITE)) {
			save();
		}
		return false;
	}

	private static boolean load(File file) {
		f = file;
		FileReader filereader;
		BufferedReader br = null;
		try {
			Values.main_panel.init();
			filereader = new FileReader(file);
			br = new BufferedReader(filereader);
			String line;
			int cols = -1;
			int pre_bpm = -1;
			int shosetsu_count = 0;
			while ((line = br.readLine()) != null) {
				StringTokenizer st = new StringTokenizer(line, ",", false);
				if (st.hasMoreTokens()) {
					if (cols == -1) {
						// HEAD 読み込み
						cols = 0;
						Values.header.text.setText(st.nextToken());
						Values.header.spinner.setValue(Integer.valueOf(st
								.nextToken()));
						Values.header.spinner2.setValue(Integer.valueOf(st
								.nextToken()));
						Values.header.spinner3.setValue(Integer.valueOf(st
								.nextToken()));
						Values.header.combo.setSelectedItem(st.nextToken());
					} else {
						String bpm = st.nextToken();
						if (!bpm.matches("_")) {
							int b = Integer.valueOf(bpm);
							if (pre_bpm == -1) {
								Values.ME.BMP.setValue(b);
							}
							if (b != pre_bpm)
								Values.main_panel.BPM_MAP
										.put(shosetsu_count, b);
							shosetsu_count++;
							Values.main_panel.add(cols);
						} else {
							int row = 0;
							while (st.hasMoreTokens()) {
								Values.main_panel.load(cols, row++,
										st.nextToken());
							}
							cols++;
						}
					}
				}
			}
			JOptionPane.showMessageDialog(null, "ロードしました");

			Values.haku_jspinner.setValue((cols + 11) / 12);
			setTitle(file);
			Values.main_panel.upDate();
			if (br != null)
				try {
					br.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(null, "ロードに失敗ました");
			JOptionPane.showMessageDialog(null, e.getMessage());
			if (br != null)
				try {
					br.close();
				} catch (IOException e2) {
					e2.printStackTrace();
				}
			return false;
		}
	}

	private static void setTitle(File file) {
		Starter.ME.setTitle(file.getName());
		ActionManager.flag_unsaved = false;
	}

	public static boolean save() {
		if (f != null) {
			return write(f);
		}
		return actionPerformed(SAVE);
	}

	private static boolean write(File file) {
		f = file;
		PrintWriter pw;
		try {
			pw = new PrintWriter(new FileWriter(file, false));
			// 内容を指定する
			int max = Values.haku_4_numbers * 12;
			int sum = 0;
			int empties = 0;
			int bpm = -1;
			int shosetsu_count = 0;
			write(pw, Values.header.text.getText(),
					Values.header.spinner.getValue(),
					Values.header.spinner2.getValue(),
					Values.header.spinner3.getValue(), Values.header.combo
							.getSelectedItem().toString());
			for (int cols = 0; cols < max; cols++) {
				for (int shosetsu : Values.main_panel.SHO_SETSU_LINE) {
					if (cols == shosetsu * 12) {
						if (Values.main_panel.BPM_MAP
								.containsKey(shosetsu_count)) {
							bpm = Values.main_panel.BPM_MAP.get(shosetsu_count);
						}
						write(pw, bpm, "_", "_", "_", "_", "_");
						shosetsu_count++;
						break;
					}
				}
				empties++;
				Node n[] = new Node[5];
				for (Node node : Values.main_panel.target_list) {
					if (node.COLS == cols) {
						sum++;
						n[node.ROW] = node;
						empties = 0;
					}
				}
				write(pw, "_", n[0], n[1], n[2], n[3], n[4]);
			}
			// ファイルに書き出す
			pw.close();
			// 終了メッセージを画面に出力する
			JOptionPane.showMessageDialog(null, "セーブしました\n" + shosetsu_count
					+ "小節\n" + max / 12 + "コ分の四分音符\n" + sum + "ノード");
			if (empties > 1)
				JOptionPane.showMessageDialog(null, "最後に" + empties / 12
						+ "コの四分音符分の空白があります\n忘れずに削除してください");
			setTitle(file);
			Values.main_panel.upDate();
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(null, "セーブに失敗ました");
			return false;
		}

	}

	private static void write(PrintWriter pw, Object... objs) {
		for (int i = 0; i < objs.length; i++) {
			Object obj = objs[i];
			if (obj == null || obj.toString().isEmpty())
				pw.print("x");
			else
				pw.print(obj.toString());
			if (i != objs.length - 1)
				pw.print(",");
		}
		pw.println();
	}

	private static void write(PrintWriter pw, Object r0, Object r1, Object r2,
			Object r3, Object r4, Object r5) {
		Object rs[] = { r0, r1, r2, r3, r4, r5 };
		for (int i = 0; i < rs.length; i++) {
			if (rs[i] == null)
				pw.print("0");
			else
				pw.print(rs[i]);
			if (i != rs.length - 1)
				pw.print(",");
		}
		pw.println();
	}

}
