package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertySupporter {
	public static PropertySupporter ME = new PropertySupporter();
	private final Properties PROP = new Properties();
	public final String PASS;

	private PropertySupporter() {
		String root = "./otog/";
		PASS = root.concat("editor/config.properties");
		try {
			File f = new File(PASS);
			if (!f.exists()) {
				new File(root).createNewFile();
				new File(root.concat("csv")).createNewFile();
				new File(root.concat("editor")).createNewFile();
				f.createNewFile();
			}
			InputStream inputStream = new FileInputStream(f);
			PROP.load(inputStream);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public int getProperty(String key) {
		try {
			return Integer.valueOf(PROP.getProperty(key));
		} catch (Exception e) {
			return -1;
		}
	}

	/**
	 * 
	 * @param key
	 * @return Object（キャストなし）
	 */
	public Object getProperty_Nature(String key) {
		try {
			return PROP.getProperty(key);
		} catch (Exception e) {
			return null;
		}
	}

	public boolean isGotPropertyTrue(String key) {
		try {
			return Boolean.parseBoolean(PROP.getProperty(key));
		} catch (Exception e) {
			return false;
		}
	}

	public void saveProperty(String key, String value) {
		PROP.setProperty(key, value);
		try {
			PROP.store(new FileOutputStream(PASS), null);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void saveProperty(String key, Object value) {
		saveProperty(key, value.toString());
	}

	public void saveProperty_add(String key, long l) {
		long val = getProperty(key) + l;
		saveProperty(key, val);
	}

	public String getProperty() {
		return getProperty_Nature("author").toString();
	}

	public void saveProperty(String s) {
		saveProperty("author", s);
	}
}
