package main_panel.node;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;

import javax.swing.JOptionPane;

import main_panel.Starter;
import util.BeautifulView;
import value.Values;

public class Node {
	public int COLS, ROW;

	public final boolean CLEARY;
	public int VALUE;

	@Override
	public String toString() {
		return String.valueOf(VALUE);
	}

	public void drawArrow(Graphics2D g, int x, int y, int w, int h) {
		if (ROW != 0)
			return;
		g.setFont(g.getFont().deriveFont(20f));
		String s = Values.getArrow(CLEARY ? Values.DIRECTION : VALUE);
		drawString(g, s, x, y, w, h);
		g.setFont(g.getFont().deriveFont(15f));
	}

	private void drawString(Graphics2D g, String s, int x, int y, int w, int h) {
		x += w / 2 - g.getFontMetrics().stringWidth(s) / 2;
		y += h / 2 + g.getFontMetrics().getHeight() / 4;
		g.setColor(Color.BLACK);
		for (int i = 0; i < 5; i++) {
			for (int j = 0; j < 5; j++) {
				int dx = i - 2;
				int dy = j - 2;
				if (i != 0 || j != 0)
					g.drawString(s, x + dx, y + dy);
			}
		}
		g.setColor(Color.RED);
		for (int i = 0; i < 3; i++) {
			for (int j = 0; j < 3; j++) {
				int dx = i - 1;
				int dy = j - 1;
				g.drawString(s, x + dx, y + dy);
			}
		}
	}

	public Node(int cols, int rows, boolean b) {
		this(cols, rows, rows == 0 ? Values.DIRECTION : 1, b);
	}

	public Node(int cols, int rows, int value, boolean b) {
		COLS = Values.main_panel.convertCompressedCols(cols);
		ROW = rows;
		CLEARY = b;
		VALUE = value;
	}

	public void setValue(int v) {
		if (ROW == 0) {
			JOptionPane.showMessageDialog(Starter.ME, "チルノダンスに長押しは設定出来ません");
		} else {
			VALUE = v;
		}
	}

	public Node(int cols, int row, int value) {
		COLS = cols;
		ROW = row;
		VALUE = value;
		CLEARY = false;
	}

	public int getCOLS() {
		return Values.main_panel.getCOLS(COLS);
	}

	public void draw(Graphics2D g, int dy) {
		int w = Values.NODE_W;
		int x = Values.getRows(ROW);
		int h = Values.main_panel.getH(COLS);
		int y = Values.main_panel.getY(COLS, dy, h);
		if (ROW != 0 && VALUE > 1) {
			int p_h = VALUE * Values.raitio;
			y = y - p_h + h;
			h = p_h;
		}
		// int h = Values.main_panel.getH(COLS);
		// int y = Values.main_panel.getY(COLS, dy, h);
		if (y > 0 || y + h * 4 < -Values.viewport_d.height)
			return;
		draw(g, dy, x, y, w, h);
	}

	public void draw(Graphics2D g, int dy, int x, int y, int w, int h) {
		if (CLEARY) {
			if (check_same())
				return;
			setRectColor(g);
			g.drawRect(x, y, w, h);
		} else if (isSelected()) {
			drawSelected(g, x, y, w, h);
		}
		x += 1;
		y += 1;
		w -= 2;
		h -= 2;
		if (CLEARY)
			BeautifulView.setAlphaOnImg(g, 0.5f);
		if (!CLEARY && check_same())
			setColor(g, Color.RED, Color.ORANGE, x, w);
		else {
			if (COLS % 12 == 0)
				setColor(g, Color.BLUE, Color.CYAN, x, w);
			else if (COLS % 6 == 0)
				setColor(g, Color.GREEN, Color.WHITE, x, w);
			else if (COLS % 3 == 0)
				setColor(g, Color.MAGENTA, Color.WHITE, x, w);
			else if (COLS % 4 == 0)
				setColor(g, Color.BLACK, Color.LIGHT_GRAY, x, w);
			else
				setColor(g, Color.GRAY, Color.WHITE, x, w);
		}
		g.fillRect(x, y, w, h);
		g.setPaint(null);
		g.setColor(Color.BLACK);
		g.drawRect(x, y, w, h);
		drawArrow(g, x, y, w, h);
		if (ROW != 0 && (Values.ME.three_combination || COLS % 3 != 0)) {
			if (Values.ME.six_combination && COLS % 2 == 0) {
				drawString(g, "6", x, y, w, h);
			} else if (COLS % 4 == 0
					|| (COLS % 12 == 0 && Values.ME.three_combination))
				drawString(g, "3", x, y, w, h);
			else if (COLS % 2 == 0)
				drawString(g, "6", x, y, w, h);
		}
		if (CLEARY)
			BeautifulView.setAlphaOnImg(g, 1f);

	}

	public boolean isSelected() {
		if (Values.main_panel.pressed_p == null)
			return false;
		Point st = Values.main_panel.selectStartPoint();
		Point ed = Values.main_panel.selectEndPoint();
		int st_row = st.x;
		if (st_row > 0)
			st_row--;
		int ed_row = ed.x;
		if (ed_row > 1)
			ed_row--;
		if (st_row <= ROW && ROW < ed_row)
			if (ed.y < COLS && COLS <= st.y)
				return true;
		return false;
	}

	protected void setRectColor(Graphics2D g) {
		if (Values.main_panel.is_pressing)
			g.setColor(Color.ORANGE);
		else
			g.setColor(Color.YELLOW);
	}

	protected void setColor(Graphics2D g, Color c1, Color c2, int x, int w) {
		g.setPaint(new GradientPaint(x - w / 2, 0, c1, x + w / 2, 0, c2, true));
	}

	public boolean check_same() {
		for (Node n : CLEARY ? Values.main_panel.target_list
				: Values.main_panel.opaque_list) {
			if (check_same(n)) {
				return true;
			}
		}
		return false;
	}

	public boolean check_same_compered_with_targets() {
		for (Node n : Values.main_panel.target_list) {
			if (check_same(n)) {
				return true;
			}
		}
		return false;
	}

	public int check_same_count() {
		int count = 0;
		for (Node n : Values.main_panel.target_list) {
			if (check_same(n)) {
				count++;
			}
		}
		return count;
	}

	public boolean check_same(Node n) {
		if (Values.ME.three_combination) {
			int num = Values.ME.six_combination ? 6 : 3;
			if (COLS % num == 0 && n.COLS % num != 0) {
				return false;
			}
			if (n.COLS % num == 0 && COLS % num != 0) {
				return false;
			}
		}
		return n.ROW == ROW && n.getCOLS() == getCOLS();
	}

	public void drawSelected(Graphics2D g, int dy) {
		int w = Values.NODE_W;
		int x = Values.getRows(ROW);
		int h = Values.main_panel.getH(COLS);
		int y = Values.main_panel.getY(COLS, dy, h);
		if (y > 0 || y + h * 4 < -Values.viewport_d.height)
			return;
		drawSelected(g, x, y, w, h);
	}

	public void drawSelected(Graphics2D g, int x, int y, int w, int h) {
		g.setColor(Color.RED);
		g.drawRect(x, y, w, h);
	}
}
