package main_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import util.PropertySupporter;
import value.Values;
import action.ActionManager;
import action.ChangeBPM;

public class Starter extends JFrame implements MouseListener {

	private static final long serialVersionUID = 1L;
	public static final Starter ME = new Starter();
	public static int w, h;

	/**
	 * @param args
	 */
	public static void main(String[] args) {
	}

	public HeaderInfo header;

	public Starter() {
		setTitle("Loading...");
		setVisible(true);
		setLocationRelativeTo(null);
		setUI();
		initConfig();
		initContents();
		initFinal();
		setTitle("ダンシング・チルノ　エディタ　v 1.00");
	}

	private void setUI() {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (ClassNotFoundException e) {
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		} catch (UnsupportedLookAndFeelException e) {
		}
	}

	private void initFinal() {
		Values.main_panel.setViewPosition(0);
		addKeyListener(Values.ME);
		pack();
		setLocationRelativeTo(null);
		setFocusable(true);
		addMouseListener(this);
		requestFocus();
	}

	@Override
	public Component add(Component comp) {
		comp.addKeyListener(Values.ME);
		return super.add(comp);
	}

	@Override
	public Component add(Component comp, int index) {
		comp.addKeyListener(Values.ME);
		return super.add(comp, index);
	}

	private void initConfig() {
		setResizable(false);
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		addWindowListener(ActionManager.ME);
		repaint();
	}

	private void initContents() {
		MenuItem.ME.init(this);
		initScrollPane();
		initNorth();
		initEast();
	}

	private class MyPanel extends JPanel {
		private static final long serialVersionUID = 1L;

		@Override
		public Component add(Component comp) {
			comp.addKeyListener(Values.ME);
			return super.add(comp);
		}

		@Override
		public Component add(Component comp, int index) {
			comp.addKeyListener(Values.ME);
			return super.add(comp, index);
		}
	}

	private void initNorth() {
		JPanel PARENT = new MyPanel();
		PARENT.setLayout(new BorderLayout());

		JPanel panel = new MyPanel();
		panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		initNorth_SAVE(panel);
		initNorth_UNDO(panel);
		initNorth_WHO(panel);
		JPanel panel2 = new MyPanel();
		panel2.setLayout(new FlowLayout(FlowLayout.RIGHT));
		initNorth_RATIO(panel2);
		PARENT.add(panel, BorderLayout.WEST);
		PARENT.add(panel2, BorderLayout.EAST);
		getContentPane().add(PARENT, BorderLayout.NORTH);
	}

	private void initNorth_SAVE(JPanel panel) {
	}

	private void initNorth_UNDO(JPanel panel) {
		for (JButton b : ActionManager.ME.bs) {
			panel.add(b);
		}
	}

	private void initNorth_RATIO(JPanel panel) {
		JRadioButton check = new JRadioButton("通常");
		JRadioButton checks = new JRadioButton("長押");
		JRadioButton check1 = new JRadioButton("３連");
		JRadioButton check2 = new JRadioButton("６連");
		Values.select_normal = check;
		Values.select_long = checks;
		check.setSelected(true);
		check.setToolTipText("N");
		checks.setToolTipText("L");
		check.addActionListener(Values.ME);
		checks.addActionListener(Values.ME);
		check1.addActionListener(Values.ME);
		check2.addActionListener(Values.ME);
		ButtonGroup group = new ButtonGroup();
		group.add(check);
		group.add(checks);
		group.add(check1);
		group.add(check2);
		panel.add(check, BorderLayout.EAST);
		panel.add(checks, BorderLayout.EAST);
		panel.add(check1, BorderLayout.EAST);
		panel.add(check2, BorderLayout.EAST);
		JComboBox combo = new JComboBox(Values.combo_boxes_);
		combo.addActionListener(Values.ME);
		combo.setPreferredSize(new Dimension(50, 20));
		combo.setName("RATIO");
		panel.add(combo, BorderLayout.EAST);
	}

	private void initNorth_WHO(JPanel panel) {
		int def = 25;
		JSpinner spinner = new JSpinner(new SpinnerNumberModel(def, 1, null, 1));
		spinner.setName("WHO");
		spinner.setPreferredSize(new Dimension(40, 20));
		spinner.addChangeListener(Values.ME);
		panel.add(new JLabel("ホイール"), BorderLayout.WEST);
		panel.add(spinner, BorderLayout.WEST);
		Values.scroll.setUnitIncrement(def);
		// panel.add(new JLabel("全四分音符"), BorderLayout.WEST);
		panel.add(spinner, BorderLayout.EAST);
	}

	private void initEast() {
		JPanel panel_parent = new MyPanel();
		panel_parent.setLayout(new FlowLayout(FlowLayout.LEFT));
		initEast_North0(panel_parent);
		initEast_North1(panel_parent);
		initEast_North2(panel_parent);
		initEast_North2_2(panel_parent);
		initEast_North3(panel_parent);
		panel_parent.setPreferredSize(new Dimension(250, 0));
		getContentPane().add(panel_parent, BorderLayout.CENTER);
	}

	private void initEast_North2(JPanel panel_parent) {
		JPanel panel = new MyPanel();
		panel.setBorder(new TitledBorder("チルノダンス"));
		int[] is = { 8, 4, 6, 2 };
		// String[] bors = { BorderLayout.SOUTH, BorderLayout.WEST,
		// BorderLayout.EAST, BorderLayout.NORTH };
		String[] text = { "W", "A", "D", "S" };
		JButton bs[] = new JButton[4];
		panel.setLayout(new GridLayout(3, 3));
		for (int i = 0; i < bs.length; i++) {
			JButton b = new JButton(Values.getArrow(is[i]));
			b.setToolTipText(text[i].concat(",").concat(Values.getArrow(is[i])));
			b.setActionCommand("DIRECT");
			b.addActionListener(Values.ME);
			panel.add(Box.createGlue());
			panel.add(b);
			bs[i] = b;
			bs[i].setEnabled(is[i] != 8);
		}
		Values.bs = bs;
		panel_parent.add(panel, BorderLayout.NORTH);
	}

	private void initEast_North2_2(JPanel panel_parent) {
		JPanel panel = new MyPanel();
		panel.setBorder(new TitledBorder("コピー"));
		String[] titles = { "コピー", "切り取り", "解除" };
		String[] text = { "Ctrl+C", "Ctrl+X", "Ctrl+Shift+C" };
		JButton bs[] = new JButton[titles.length];
		panel.setLayout(new GridLayout(titles.length, 1));
		for (int i = 0; i < bs.length; i++) {
			JButton b = new JButton(titles[i]);
			b.setToolTipText(text[i]);
			b.addActionListener(Values.ME);
			panel.add(b);
			b.setEnabled(false);
			bs[i] = b;
		}
		Values.bs2 = bs;
		panel_parent.add(panel, BorderLayout.NORTH);
	}

	public class HeaderInfo extends JPanel {
		private static final long serialVersionUID = 1L;
		public final JSpinner spinner;
		public final JTextField text;
		public final JComboBox combo;
		public final JSpinner spinner3;
		public final JSpinner spinner2;

		public HeaderInfo() {
			JPanel panel = this;
			panel.setPreferredSize(new Dimension(230, 200));
			panel.setLayout(new FlowLayout(FlowLayout.RIGHT));
			panel.setBorder(new TitledBorder("ヘッダ情報"));
			{
				text = new JTextField(18);
				text.setEditable(false);
				text.setText(PropertySupporter.ME.getProperty());
				// text.setPreferredSize(new Dimension(200, 20));
				panel.add(new JLabel("HN :"));
				panel.add(text);
			}
			{
				spinner = new JSpinner(new SpinnerNumberModel(1, 1, 20, 1));
				spinner.setPreferredSize(new Dimension(40, 20));
				panel.add(new JLabel("Level :"));
				panel.add(spinner);
			}
			panel.add(Box.createHorizontalStrut(10));
			{
				spinner2 = new JSpinner(new SpinnerNumberModel(1, 1, 4, 1));
				spinner2.setPreferredSize(new Dimension(40, 20));
				panel.add(new JLabel("何の譜 :"));
				panel.add(spinner2);
			}
			{
				spinner3 = new JSpinner(new SpinnerNumberModel(0, null, null,
						10));
				spinner3.setPreferredSize(new Dimension(80, 20));
				panel.add(new JLabel("オフセット(milli_sec) :"));
				panel.add(spinner3);
			}
			{
				int first = 240;
				JSpinner spinner = new JSpinner(new SpinnerNumberModel(first,
						1, null, 1));
				spinner.setName("BPM");
				spinner.addChangeListener(Values.ME);
				spinner.setPreferredSize(new Dimension(50, 20));
				Values.ME.BMP = spinner;
				Values.main_panel.BPM_MAP.put(0, first);
				panel.add(new JLabel("開始時BPM :"));
				panel.add(spinner);
			}
			{
				JPanel panel2 = new JPanel();
				panel2.setLayout(new GridLayout(2, 1));
				File f = new File("./res/bgm");
				if (!f.exists()) {
					f = new File("./res/bgm_raw");
				}
				String[] items = f.list();
				for (int i = 0; i < items.length; i++) {
					items[i] = items[i].replaceFirst("\\.mp3", "");
				}
				String[] items2 = new String[items.length + 1];
				items2[0] = "";
				for (int i = 0; i < items.length; i++) {
					items2[i + 1] = items[i].replaceFirst("\\.mp3", "")
							.replaceFirst("\\.dat", "");
				}
				combo = new JComboBox(items2);
				{
					JPanel p = new JPanel();
					p.setLayout(new FlowLayout(FlowLayout.CENTER));
					p.add(new JLabel("▼音楽ファイル名▼"));
					panel2.add(p);
				}
				{
					JPanel p = new JPanel();
					p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
					p.add(Box.createHorizontalStrut(5));
					p.add(combo);
					panel2.add(p);
				}

				panel.add(panel2);
			}
			Values.header = this;
		}
	}

	private void initEast_North3(JPanel p) {
		p.add(header = new HeaderInfo(), BorderLayout.NORTH);
	}

	private void initEast_North0(JPanel p) {
		JPanel p_1 = new MyPanel();
		p_1.setBorder(new TitledBorder("BPM"));
		p_1.setLayout(new BoxLayout(p_1, BoxLayout.Y_AXIS));
		//
		JPanel p0 = new MyPanel();
		p0.setLayout(new FlowLayout(FlowLayout.LEFT));
		final JCheckBox box0 = new JCheckBox("可変");
		final JCheckBox box1 = new JCheckBox("可視");
		box1.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				Values.main_panel.flag_bpm_visible = box1.isSelected();
				Values.main_panel.upDate();
			}
		});
		p0.add(box0);
		p0.add(box1);
		p_1.add(p0);
		//
		JPanel p1 = new MyPanel();
		p1.setLayout(new BoxLayout(p1, BoxLayout.X_AXIS));
		final JLabel l = new JLabel(" 001小節目以降のBPM");
		l.setEnabled(false);
		Values.Label_E_N_N = l;
		p1.add(l);
		p1.add(Box.createHorizontalStrut(5));
		int first = 240;
		final JSpinner spinner = new JSpinner(new SpinnerNumberModel(first, 1,
				null, 1));
		spinner.setName("change_BPM");
		spinner.setPreferredSize(new Dimension(50, 20));
		spinner.setEnabled(false);

		p1.add(spinner);
		p1.add(Box.createHorizontalStrut(5));
		final JButton b = new JButton("決定");
		spinner.addChangeListener(new ChangeListener() {

			@Override
			public void stateChanged(ChangeEvent e) {
				if (box0.isSelected())
					b.setEnabled(true);
			}
		});
		b.setMargin(new Insets(3, 8, 3, 6));
		b.setEnabled(false);
		p1.add(b);
		p_1.add(p1);
		box0.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				l.setEnabled(box0.isSelected());
				spinner.setEnabled(box0.isSelected());
				if (!box0.isSelected())
					b.setEnabled(false);
			}
		});
		b.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				ActionManager.exe(new ChangeBPM((Integer) spinner.getValue()));
				b.setEnabled(false);
				Values.main_panel.upDate();
			}
		});
		p.add(p_1, BorderLayout.NORTH);
	}

	private void initEast_North1(JPanel parent) {
		JPanel panel = new MyPanel();
		panel.setBorder(new TitledBorder("小節"));
		panel.setLayout(new BorderLayout());
		initEast_North_North(panel);
		initEast_North_SOUTH(panel);
		parent.add(panel, BorderLayout.NORTH);
	}

	private void initEast_North_SOUTH(JPanel p) {
		JPanel panel = new MyPanel();
		JLabel l = new JLabel(" 001小節目以降の拍子");
		Values.Label_E_N_S = l;
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
		panel.add(l);
		panel.add(Box.createHorizontalStrut(5));
		JButton b = new JButton("+");
		// b.setPreferredSize(new Dimension(25, 25));
		b.setMargin(new Insets(3, 8, 3, 6));
		b.addActionListener(Values.ME);
		panel.add(b);
		JButton b2 = new JButton("-");
		// b2.setPreferredSize(new Dimension(25, 25));
		b2.setMargin(new Insets(3, 8, 3, 6));
		b2.addActionListener(Values.ME);
		panel.add(b2);
		p.add(panel, BorderLayout.CENTER);
	}

	private void initEast_North_North(JPanel p) {
		JPanel panel = new MyPanel();
		JSpinner spinner = new JSpinner(new SpinnerNumberModel(
				Values.haku_4_numbers, 1, null, 1));
		spinner.setName("haku_4_numbers");
		spinner.setPreferredSize(new Dimension(50, 20));
		spinner.addChangeListener(Values.ME);
		Values.haku_jspinner = spinner;
		panel.add(new JLabel("全四分音符"), BorderLayout.WEST);
		panel.add(spinner, BorderLayout.EAST);
		p.add(panel, BorderLayout.NORTH);
	}

	private void initScrollPane() {
		JScrollPane scrollpane = new JScrollPane();
		Values.scroll = scrollpane.getVerticalScrollBar();
		JViewport view = scrollpane.getViewport();
		Values.view = view;
		view.setPreferredSize(Values.viewport_d);
		new MainPanel(view, Values.viewport_d);
		JPanel panel = new MyPanel();
		panel.add(scrollpane);
		getContentPane().add(panel, BorderLayout.WEST);
	}

	@Override
	public void mouseClicked(MouseEvent e) {

	}

	@Override
	public void mousePressed(MouseEvent e) {
		requestFocus();
	}

	@Override
	public void mouseReleased(MouseEvent e) {

	}

	@Override
	public void mouseEntered(MouseEvent e) {

	}

	@Override
	public void mouseExited(MouseEvent e) {

	}
}
