package main_panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import util.PropertySupporter;
import value.SaveLoad;

public class MenuItem implements ActionListener {
	public static final MenuItem ME = new MenuItem();
	public static JMenuBar menubar = new JMenuBar();

	private class MyMenu extends JMenuItem {
		private static final long serialVersionUID = 1L;

		public MyMenu(String title) {
			super(title);
			addActionListener(ME);
		}
	}

	public void init(JFrame f) {
		JMenu menu1 = new JMenu("File");
		JMenu menu2 = new JMenu("Header");
		// JMenu menu3 = new JMenu("Tool");
		// JMenu menu4 = new JMenu("Help");

		menubar.add(menu1);
		menubar.add(menu2);
		// menubar.add(menu3);
		// menubar.add(menu4);

		// MyMenu menuitem1_1 = new MyMenu("New");
		MyMenu menuitem1_1 = new MyMenu(SaveLoad.SAVE);
		MyMenu menuitem1_2 = new MyMenu(SaveLoad.OVERWRITE);
		menuitem1_2.setToolTipText("Ctrl+S");
		MyMenu menuitem1_3 = new MyMenu(SaveLoad.Load);
		menu1.add(menuitem1_1);
		menu1.add(menuitem1_2);
		menu1.add(menuitem1_3);

		MyMenu menuitem2_1 = new MyMenu("HN");
		//
		menu2.add(menuitem2_1);
		// menu2.add(menuitem2_3);
		// menu2.insert(menuitem2_2, 1);

		f.setJMenuBar(menubar);

	}

	@Override
	public void actionPerformed(ActionEvent e) {
		String s = e.getActionCommand();
		if (s.matches(SaveLoad.Load) || s.matches(SaveLoad.SAVE)
				|| s.matches(SaveLoad.OVERWRITE))
			SaveLoad.actionPerformed(s);
		else if (s.matches("HN")) {
			// JOptionPane.showInputDialog(Starter.ME, "HNを入力して下さい");
			s = JOptionPane.showInputDialog(Starter.ME, "HNを入力して下さい",
					PropertySupporter.ME.getProperty());
			if (s != null) {
				PropertySupporter.ME.saveProperty(s);
				Starter.ME.header.text.setText(s);
			}
		}
	}
}
