package main_panel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import main_panel.node.D_D_Node;
import main_panel.node.Node;
import value.Values;
import action.ActionManager;
import action.Add;
import action.ChangeShosetsuLine;
import action.Delete;
import action.Drag;
import action.LetItLong;

public class MainPanel extends JPanel implements ChangeListener,
		MouseMotionListener, MouseListener {
	private static final long serialVersionUID = 1L;
	public int cols;
	public MyList<D_D_Node> d_d_node = new MyList<D_D_Node>();

	public boolean is_pressing = false;

	public class MyList<E> extends ArrayList<E> {
		private static final long serialVersionUID = 1L;

		@Override
		public synchronized boolean add(E e) {
			return super.add(e);
		};

		@Override
		public final synchronized boolean remove(Object o) {
			return super.remove(o);
		};
	}

	public MyList<Node> opaque_list = new MyList<Node>(),
			target_list = new MyList<Node>();

	public Point pressed_p, d_d_p;

	public MyList<Node> selected_nodes = new MyList<Node>() {
		private static final long serialVersionUID = 1L;

		@Override
		public void add(int index, Node element) {
			enable(true);
			super.add(index, element);
		}

		private void enable(boolean f) {
			Values.bs2[0].setEnabled(f);
			Values.bs2[1].setEnabled(f);
		}

		public synchronized boolean add(Node e) {
			enable(true);
			return super.add(e);
		};

		@Override
		public void clear() {
			super.clear();
			enable(false);
		};
	}, copied_nodes = new MyList<Node>();
	/**
	 * cols numbers
	 */
	public MyList<Integer> SHO_SETSU_LINE = new MyList<Integer>();
	/**
	 * key : 小節番号<br/>
	 * value:bpm
	 */
	public HashMap<Integer, Integer> BPM_MAP = new HashMap<Integer, Integer>();

	public final JViewport view;

	public final Dimension VIew_Port_D;
	protected boolean flag_bpm_visible;

	public MainPanel(JViewport view, Dimension d) {
		VIew_Port_D = d;
		this.view = view;
		setIgnoreRepaint(true);
		requestUpDate();
		view.addChangeListener(this);
		Values.main_panel = this;
		Values.setSize_MainPanel();
		addMouseMotionListener(this);
		addMouseListener(this);
		for (int i = 0; i < Values.haku_4_numbers + 1; i++) {
			if (i % 4 == 0)
				SHO_SETSU_LINE.add(i);
		}
		addKeyListener(Values.ME);
		setFocusable(true);
	}

	public void add(int cols) {
		SHO_SETSU_LINE.add(cols / 12);
	}

	public void add(int x, int y) {
		for (Node n : target_list)
			if (n.check_same())
				return;
		int row = getRows(x);
		int cols = getCols(y);
		if (copied_nodes.isEmpty())
			add(cols, row, target_list, false);
		else {
			ArrayList<Node> list = new ArrayList<Node>() {
				private static final long serialVersionUID = 1L;

				@Override
				public boolean add(Node e) {
					if (e != null)
						return super.add(e);
					return false;
				}
			};
			Node f = copied_nodes.get(0);
			int fr = f.ROW;
			int fc = f.COLS;
			for (Node n : copied_nodes)
				list.add(getTarget(cols + n.COLS - fc, row + n.ROW - fr,
						n.VALUE));
			ActionManager.exe(new Add(list));
			upDate();
		}
	}

	private Node getTarget(int cols, int row, int value) {
		if (col_row_Checker(cols, row))
			return new Node(cols, row, value, false);
		return null;
	}

	private void add(int cols, int row, MyList<Node> list, boolean opaque) {
		if (!col_row_Checker(cols, row))
			return;
		if (list == opaque_list) {
			list.add(new Node(cols, row, opaque));
		} else {
			ActionManager.exe(new Add(new Node(cols, row, opaque)));
		}
		upDate();
	}

	public void add(Point p) {
		add(p.x, p.y);
	}

	public void changeShoSetsu(int i) {
		int count = 0;
		int index = getHaku(cols) + 1;
		ArrayList<Integer> s = new ArrayList<Integer>(SHO_SETSU_LINE.size());
		for (int j = 0; j < SHO_SETSU_LINE.size(); j++) {
			s.add(SHO_SETSU_LINE.get(j));
		}
		ArrayList<Integer> list = new ArrayList<Integer>(s.size());
		for (Iterator<Integer> iterator = s.iterator(); iterator.hasNext();) {
			Integer j = iterator.next();
			if (index <= j) {
				int next = j + (++count) * i;
				list.add(next);
				iterator.remove();
			}
		}
		for (Integer j : list) {
			s.add(j);
		}
		int delt = s.get(s.size() - 1) - s.get(s.size() - 2);
		if (delt < 1)
			delt = 1;
		while (s.get(s.size() - 1) < Values.haku_4_numbers) {
			s.add(s.get(s.size() - 1) + delt);
		}
		ActionManager.exe(new ChangeShosetsuLine(s.toArray(new Integer[0])));
		upDate();
	}

	private boolean col_row_Checker(int cols, int row) {
		if (cols <= -1 || row <= -1 || cols / 12 > Values.haku_4_numbers) {
			upDate();
			return false;
		}
		setCols(cols);
		return true;
	}

	/**
	 * 
	 * @param cols
	 * @return
	 * @see Values.getCompressNumber()
	 */
	public int convertCompressedCols(int cols) {
		int COLS;
		if (Values.ME.three_combination) {
			if (Values.ME.six_combination) {
				COLS = (cols) / 2 * 2;
			} else {
				COLS = cols * 3 / 12 * 12 / 3;
			}
		} else
			COLS = cols * Values.raitio / 12 * 12 / Values.raitio;
		return COLS;
	}

	public boolean delete(Point p) {

		MyList<Node> list = new MyList<Node>();
		for (Iterator<Node> iterator = target_list.iterator(); iterator
				.hasNext();) {
			Node n = iterator.next();
			if (n.check_same()) {
				list.add(n);
				break;
			}
		}
		if (list.isEmpty())
			return false;
		// 何かアレば削除
		boolean flag = true;
		for (Node node : list) {
			if (!selected_nodes.contains(node)) {
				flag = false;
			}
		}
		if (flag)
			for (Node node : selected_nodes) {
				if (!list.contains(node))
					list.add(node);
			}
		ActionManager.exe(new Delete(list));
		return true;
	}

	public boolean draw(Graphics2D g) {
		if (g == null)
			return false;
		init(g);
		Image back = createImage(VIew_Port_D.width,
				VIew_Port_D.height + Values.getShoSetsuHeight() + 10);
		int h = back.getHeight(null);
		drawBuffer((Graphics2D) back.getGraphics(), h);
		g.drawImage(back, 0, -h, null);
		g.dispose();
		return true;
	}

	public void drawBuffer(Graphics2D g, int h) {
		g.setFont(g.getFont().deriveFont(15f));
		g.translate(0, h + getDiff() - 1);
		if (Values.ME.flag_Long_Node)
			g.setColor(Color.BLUE.darker().darker());
		else
			g.setColor(Color.DARK_GRAY);
		g.fillRect(0, -h, VIew_Port_D.width, h);
		drawHLine(g);
		drawVLine(g);
		g.setColor(Color.YELLOW);
		String s = String.valueOf(getSelectedShosetsu());
		g.drawString(s,
				VIew_Port_D.width - 2 - g.getFontMetrics().stringWidth(s),
				-VIew_Port_D.height + 12 - getDiff());
		drawTarget(g);
		g.dispose();
	}

	private void drawHLine(Graphics2D g) {
		int dy = Values.NODE_H * Values.raitio;
		int lines_4 = VIew_Port_D.height / dy + 5;
		int lines_3s = 0;
		int lines_6s = 0;
		int lines_8 = Values.raitio >= 2 ? lines_4 * 2 : 0;
		int lines_16 = Values.raitio >= 4 ? lines_4 * 2 : 0;
		if (Values.ME.three_combination) {
			lines_3s = lines_4 * 3;
			if (Values.ME.six_combination)
				lines_6s = lines_3s;
			lines_8 = lines_16 = 0;
		}
		int passed_shosetsu_count = getShosetsuCount(0);
		int bpm = -1;
		for (int i = 0; i < passed_shosetsu_count; i++) {
			if (BPM_MAP.containsKey(i))
				bpm = BPM_MAP.get(i);
		}
		for (int i = 0; i < lines_4; i++) {
			if (isShosetsu(-dy * i)) {
				if (isShosetsuP(-dy * i)) {
					g.setColor(Color.YELLOW);
				} else {
					g.setColor(Color.WHITE);
				}
				if (flag_bpm_visible) {
					int count = getShosetsuCount(-dy * i);
					if (BPM_MAP.containsKey(count))
						bpm = BPM_MAP.get(count);
					g.drawString(String.valueOf(bpm), 0, -dy * i);
				}
			} else
				g.setColor(Color.GRAY);
			drawHLine(g, -dy * i);
		}
		g.setColor(Color.PINK.darker().darker());
		float dash[] = { 5.0f };
		BasicStroke dashStroke = new BasicStroke(1.0f, BasicStroke.CAP_BUTT,
				BasicStroke.JOIN_MITER, 10.0f, dash, 0.0f);
		g.setStroke(dashStroke);
		for (int i = 0; i < lines_8; i++) {
			drawHLine(g, -dy / 2 - dy * i);
		}
		g.setColor(Color.GRAY);
		for (int i = 0; i < lines_3s; i++) {
			if (i % 3 != 0)
				drawHLine(g, -dy * i / 3);
		}
		for (int i = 0; i < lines_6s; i++) {
			drawHLine(g, -dy * i / 3 + dy / 2);
		}
		dy /= 2;
		g.setColor(Color.CYAN.darker().darker());
		for (int i = 0; i < lines_16; i++) {
			drawHLine(g, -dy / 2 - dy * i);
		}
		g.setStroke(new BasicStroke());
	}

	private int getShosetsuCount(int dy) {
		int count = 0;
		int passed = getPassed(dy);
		for (int l : SHO_SETSU_LINE) {
			if (passed <= l) {
				break;
			}
			count++;
		}
		return count;
	}

	private void drawHLine(Graphics2D g, int y) {
		g.drawLine(0, y, VIew_Port_D.width, y);
	}

	private void drawRect(Graphics2D g, int dy) {
		if (pressed_p != null) {
			Point p = selectStartPoint();
			int x = Values.LINE_X[p.x];
			int base_h = getBaseColH();
			int y = Values.main_panel.getY(p.y, dy, base_h);
			p = selectEndPoint();
			int w = Values.LINE_X[p.x] - x;
			int h = Values.main_panel.getY(p.y, dy, base_h) - y;
			g.setColor(new Color(255, 255, 0, 20));
			g.fillRect(x, y, w, h);
			g.setColor(Color.ORANGE);
			g.drawRect(x, y, w, h);
		}
	}

	private synchronized void drawTarget(Graphics2D g) {
		try {
			Point p = view.getViewPosition();
			int dy = getHeight_View() - p.y - getDiff();
			drawRect(g, dy);
			for (Node n : selected_nodes)
				n.drawSelected(g, dy);
			for (Node n : opaque_list)
				n.draw(g, dy);
			for (Node n : target_list)
				n.draw(g, dy);
			for (D_D_Node n : d_d_node)
				n.draw(g, dy);
		} catch (java.util.ConcurrentModificationException e) {
			drawTarget(g);
		}
	}

	private void drawVLine(Graphics2D g) {
		g.setColor(Color.LIGHT_GRAY);
		for (int x : Values.LINE_X) {
			g.drawLine(x, 0, x,
					-VIew_Port_D.height - Values.getShoSetsuHeight());
		}
		g.setColor(Color.BLACK);
		g.fillRect(Values.LINE_X[1] + 1, 0, Values.LINE_X[2] - Values.LINE_X[1]
				- 1, VIew_Port_D.height);
	}

	public int getBaseColH() {
		int h;
		if (Values.ME.six_combination) {
			// 6連符
			h = Values.getNode16H() * 16 / 4 / 6;
		} else if (Values.ME.three_combination) {
			// 3連符
			h = Values.getNode16H() * 16 / 4 / 3;
		} else {
			h = Values.getNodeH();
		}
		return h;
	}

	public int getCols(int y) {
		y = getPreferredSize().height - y;
		int cols = y * Values.NODE_H / 12 / Values.raitio;
		return cols;
	}

	public int getCOLS(int cols) {
		return cols * Values.getMinNode() / 3 / 16;
	}

	public synchronized Point getDDPoint() {
		return d_d_p;
	}

	public int getDiff() {
		return getY()
				% (Values.NODE_H * 4 * Values.raitio * 4 / Values.getMinNode());
	}

	public int getH(int COLS) {
		int h;
		if (Values.ME.six_combination && (COLS % 2 == 0)) {
			// 6連符
			h = Values.getNode16H() * 16 / 4 / 6;
		} else if (Values.ME.three_combination
				&& (COLS % 12 == 0 || COLS % 3 != 0)) {
			// 3連符
			h = Values.getNode16H() * 16 / 4 / 3;
		} else {
			h = Values.getNodeH();
		}
		return h;
	}

	private int getHaku(int cols) {
		return cols / 12;
	}

	public int getHeight_View() {
		return getPreferredSize().height - VIew_Port_D.height;
	}

	private int getPassed(int dy) {
		int passed = (getY() - dy) - getDiff();
		passed /= (Values.NODE_H * Values.raitio);
		return passed;
	}

	public int getRow_PressedP(boolean true_pressed____false_dd) {
		int x = (true_pressed____false_dd ? pressed_p.x : d_d_p.x);
		if (x < 0)
			return 1;
		for (int i = 0; i < Values.LINE_X.length; i++) {
			if (x < Values.LINE_X[i]) {
				return i;
			}
		}
		return Values.LINE_X.length - 1;
	}

	public int getRows(int x) {
		for (int i = 0; i < Values.LINE_X.length; i++) {
			if (x < Values.LINE_X[i]) {
				if (i > 1) {
					if (i == 1)
						return -1;
					i--;
				}
				return --i;
			}
		}
		return -1;
	}

	public int getSelectedShosetsu() {
		return getShosetsu(cols);
	}

	private int getShosetsu(int cols) {
		int c = 0;
		for (Integer i : SHO_SETSU_LINE) {
			if (getHaku(cols) >= i)
				c++;
			else
				break;
		}
		return c;
	}

	public int getViewPosition() {
		return 100 - view.getViewPosition().y * 100 / getHeight_View();
	}

	public int getY() {
		return getHeight_View() - view.getViewPosition().y;
	}

	public int getY(int COLS, int dy, int h) {
		int y;
		if (Values.ME.six_combination && (COLS % 2 == 0)) {
			// 6連符
			y = COLS / 2;
			y = -y * h;
			y += -h;
			y += dy;
			// Values.ME.six_combination ? 6 : 3;
		} else if (Values.ME.three_combination
				&& (COLS % 12 == 0 || COLS % 3 != 0)) {
			// 3連符
			y = COLS / 4;
			y = -y * h;
			y += -h;
			y += dy;
		} else {
			y = getCOLS(COLS);
			y = -y * h;
			y += -h;
			y += dy;
		}
		return y;
	}

	public void init() {
		target_list.clear();
		SHO_SETSU_LINE.clear();
	}

	private void init(Graphics2D g) {
		Point p = view.getViewPosition();
		g.setClip(0, p.y, VIew_Port_D.width, VIew_Port_D.height);
		g.translate(p.x, p.y + VIew_Port_D.height);
		// g.setColor(Color.DARK_GRAY);
		// g.fillRect(0, -D.height, D.width, D.height);
	}

	private boolean isShosetsu(int dy) {
		return SHO_SETSU_LINE.contains(getPassed(dy));
	}

	private boolean isShosetsuP(int dy) {
		return getShosetsuCount(dy) == getSelectedShosetsu();
	}

	private void leftPressed(MouseEvent e) {
		if (Values.ME.flag_Long_Node) {
			leftPressed_long_node(e);
		} else {
			leftPressed_normal(e);
		}
	}

	private void leftPressed_long_node(MouseEvent e) {
		d_d_node.clear();
		Node n = null;
		selected_nodes.clear();
		for (Iterator<Node> iterator = target_list.iterator(); iterator
				.hasNext();) {
			n = iterator.next();
			if (n.check_same()) {
				// 位置移動
				iterator.remove();
				D_D_Node d = new D_D_Node(n);
				d_d_node.add(d);
				selected_nodes.add(n);
				return;
			}
		}
		add(e.getX(), e.getY());
		is_pressing = true;
	}

	private void leftPressed_normal(MouseEvent e) {
		d_d_node.clear();
		Node n = null;
		boolean flag = false;
		for (Iterator<Node> iterator = target_list.iterator(); iterator
				.hasNext();) {
			n = iterator.next();
			if (n.check_same()) {
				// 位置移動
				iterator.remove();
				D_D_Node d = new D_D_Node(n);
				d_d_node.add(d);
				flag = true;
				break;
			}
		}
		if (flag) {
			if (selected_nodes.isEmpty())
				selected_nodes.add(n);
			else if (selected_nodes.contains(n)) {
				for (Node sel : selected_nodes) {
					if (sel != n) {
						d_d_node.add(new D_D_Node(sel));
						target_list.remove(sel);
					}
				}
			}
			return;
		}
		// 左クリック時の処理→何もないなら追加
		add(e.getX(), e.getY());
		is_pressing = true;
	}

	public boolean load(int cols, int row, String value) {
		int v = Integer.valueOf(value);
		if (v != 0) {
			target_list.add(new Node(cols, row, v));
			return true;
		}
		return false;
	}

	@Override
	public void mouseClicked(MouseEvent e) {
	}

	@Override
	public void mouseDragged(MouseEvent e) {
		if (!d_d_node.isEmpty()) {
			int row = getRows(e.getX());
			int cols = getCols(e.getY());
			if (cols <= -1 || row <= -1)
				return;
			if (cols / 12 > Values.haku_4_numbers)
				return;
			D_D_Node first = d_d_node.get(0);
			int f_c = first.COLS, f_r = first.ROW;
			for (D_D_Node d : d_d_node) {
				int c = cols + d.COLS - f_c;
				int r = row + d.ROW - f_r;
				d.set(c, r);
			}
		} else {
			if (pressed_p != null) {
				setDDPoint(e.getPoint());
				opaque_list.clear();
				upDate();
				return;
			}
		}
		moved(e);
	}

	@Override
	public void mouseEntered(MouseEvent e) {
		upDate();
	}

	@Override
	public void mouseExited(MouseEvent e) {
		opaque_list.clear();
		upDate();
	}

	@Override
	public void mouseMoved(MouseEvent e) {
		moved(e);
	}

	@Override
	public void mousePressed(MouseEvent e) {
		requestFocus();
		if (javax.swing.SwingUtilities.isRightMouseButton(e)) {
			rightPressed(e);
		} else if (javax.swing.SwingUtilities.isMiddleMouseButton(e)) {
			// 中ボタンクリック時の処理
		} else if (javax.swing.SwingUtilities.isLeftMouseButton(e)) {
			leftPressed(e);
		}
	}

	@Override
	public void mouseReleased(MouseEvent e) {
		is_pressing = false;
		if (javax.swing.SwingUtilities.isRightMouseButton(e)) {
			// 右クリック時の処理→何かあれば削除
			selectNodes();
		} else if (javax.swing.SwingUtilities.isMiddleMouseButton(e)) {
			// 中ボタンクリック時の処理
		} else if (javax.swing.SwingUtilities.isLeftMouseButton(e)) {
			leftReleased(e);
		}
		upDate();
	}

	private void leftReleased(MouseEvent e) {
		if (Values.ME.flag_Long_Node)
			leftReleased_LongNode(e);
		else
			leftReleased_Nomal(e);
	}

	private void leftReleased_LongNode(MouseEvent e) {
		int row = getRows(e.getX());
		int cols = getCols(e.getY());
		if (!d_d_node.isEmpty()) {
			// 左ドロップ時の処理→何もないならそこまで延ばす
			D_D_Node n = d_d_node.get(0);
			if (!col_row_Checker(cols, row)
					|| n.check_same_compered_with_targets())
				target_list.add(n.PRE_NODE);
			else
				ActionManager.exe(new LetItLong(n, cols));
			d_d_node.clear();
		}
	}

	private void leftReleased_Nomal(MouseEvent e) {
		int row = getRows(e.getX());
		int cols = getCols(e.getY());
		if (!d_d_node.isEmpty()) {
			// 左ドロップ時の処理→何もないなら追加
			boolean isFailed = false;
			if (!col_row_Checker(cols, row))
				isFailed = true;
			if (!isFailed)
				for (D_D_Node n : d_d_node)
					if (n.check_same_compered_with_targets()) {
						isFailed = true;
						break;
					}
			if (isFailed)
				for (D_D_Node n : d_d_node)
					target_list.add(n.PRE_NODE);
			else
				ActionManager.exe(new Drag(d_d_node));
			d_d_node.clear();
		} else {
			// 何も無いところをpressしてreleaseした
		}
	}

	private synchronized void moved(MouseEvent e) {
		moved(e.getX(), e.getY());
	}

	private synchronized void moved(int x, int y) {
		opaque_list.clear();
		if (d_d_node.isEmpty() && !is_pressing) {
			int row = getRows(x);
			int cols = getCols(y);
			if (copied_nodes.isEmpty())
				add(cols, row, opaque_list, true);
			else {
				Node f = copied_nodes.get(0);
				int fr = f.ROW;
				int fc = f.COLS;
				for (Node n : copied_nodes) {
					add(cols + n.COLS - fc, row + n.ROW - fr, opaque_list, true);
				}
			}
		} else {
			upDate();
		}
	}

	public void requestUpDate() {
		new Thread() {
			public void run() {
				try {
					sleep(100);
					while (!upDate()) {
						sleep(100);
					}
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}.start();
	}

	private void rightPressed(MouseEvent e) {
		if (!delete(e.getPoint())) {
			selected_nodes.clear();
			pressed_p = e.getPoint();
			setDDPoint(pressed_p);
			is_pressing = true;
		}
	}

	public Point selectEndPoint() {
		Point p = new Point();
		p.x = getRow_PressedP(pressed_p.x >= d_d_p.x);
		if (pressed_p.y >= d_d_p.y) {
			p.y = convertCompressedCols(getCols(pressed_p.y));
		} else {
			p.y = convertCompressedCols(getCols(d_d_p.y));
		}
		p.y -= Values.getCompressNumber();
		return p;
	}

	private void selectNodes() {
		for (Node n : target_list) {
			if (n.isSelected())
				selected_nodes.add(n);
		}
		pressed_p = null;
		setDDPoint(null);
	}

	public Point selectStartPoint() {
		Point p = new Point();
		p.x = getRow_PressedP(pressed_p.x < d_d_p.x) - 1;
		if (pressed_p.y < d_d_p.y) {
			p.y = convertCompressedCols(getCols(pressed_p.y));
		} else {
			p.y = convertCompressedCols(getCols(d_d_p.y));
		}
		return p;
	}

	private void setCols(int cols) {
		this.cols = cols;
		String s = "";
		int i = getShosetsu(cols);
		if (i < 1000)
			s = " ";
		if (i < 100)
			s = " 0";
		if (i < 10)
			s = " 00";
		Values.Label_E_N_S.setText(s + i + "小節目以降の拍子");
		Values.Label_E_N_N.setText(s + i + "小節目以降のBPM");
	}

	public synchronized void setDDPoint(Point p) {
		d_d_p = p;
	}

	public void setPreferredSize(int h, int raitio) {
		int r = getViewPosition();
		super.setPreferredSize(new Dimension(getWidth(), h * raitio));
		view.setView(this);
		setViewPosition(r);
	}

	public void setViewPosition(int ratio) {
		view.setViewPosition(new Point(0, getHeight_View() * (100 - ratio)
				/ 100));
	}

	@Override
	public void stateChanged(ChangeEvent e) {
		upDate();
	}

	public synchronized boolean upDate() {
		return draw((Graphics2D) getGraphics());
	}

	public void copy() {
		Node max_n = null;
		copied_nodes.clear();
		for (Node n : selected_nodes) {
			if (max_n == null)
				max_n = n;
			else {
				if (max_n.COLS > n.COLS)
					max_n = n;
				else if (max_n.COLS == n.COLS && max_n.ROW < n.ROW)
					max_n = n;
			}
			copied_nodes.add(n);
		}
		if (max_n != null) {
			copied_nodes.remove(max_n);
			copied_nodes.add(0, max_n);
			Point p = getMousePosition();
			if (p != null)
				moved(p.x, p.y);
			else
				upDate();
		}
		Values.bs2[2].setEnabled(!copied_nodes.isEmpty());
	}

	public void cut() {
		if (!selected_nodes.isEmpty()) {
			copy();
			ActionManager.exe(new Delete(selected_nodes));
		}
	}

	public void copyRelease() {
		copied_nodes.clear();
		Values.bs2[2].setEnabled(false);
		Point p = getMousePosition();
		if (p != null)
			moved(p.x, p.y);
		else
			upDate();
	}
}
