package action;

import java.util.ArrayList;

import main_panel.node.D_D_Node;
import main_panel.node.Node;
import value.Values;

public class Drag extends Base_Action {
	public final Node PRE_N[], NEW_N[];

	public Drag(D_D_Node... ns) {
		NEW_N = new Node[ns.length];
		PRE_N = new Node[ns.length];
		for (int i = 0; i < NEW_N.length; i++) {
			PRE_N[i] = ns[i].PRE_NODE;
			NEW_N[i] = new Node(ns[i].COLS, ns[i].ROW, ns[i].VALUE, false);
		}
	}

	public Drag(ArrayList<D_D_Node> list) {
		this(list.toArray(new D_D_Node[0]));
	}

	@Override
	public void execute() {
		for (int i = 0; i < NEW_N.length; i++) {
			Values.main_panel.target_list.remove(PRE_N[i]);
			Values.main_panel.target_list.add(NEW_N[i]);
			Values.main_panel.selected_nodes.add(NEW_N[i]);
		}
	}

	@Override
	public void undo() {
		for (int i = 0; i < NEW_N.length; i++) {
			Values.main_panel.target_list.remove(NEW_N[i]);
			Values.main_panel.target_list.add(PRE_N[i]);
			Values.main_panel.selected_nodes.add(PRE_N[i]);
		}
	}

}
