package action;

import java.util.ArrayList;

import main_panel.node.Node;
import value.Values;

public class Delete extends Base_Action {
	public final Node[] N;

	public Delete(Node... ns) {
		N = ns;
	}

	public Delete(ArrayList<Node> list) {
		this(list.toArray(new Node[0]));
		list.clear();
	}

	@Override
	public void execute() {
		for (Node n : N) {
			Values.main_panel.target_list.remove(n);
			Values.main_panel.selected_nodes.add(n);
		}
	}

	@Override
	public void undo() {
		for (Node n : N) {
			Values.main_panel.target_list.add(n);
			Values.main_panel.selected_nodes.add(n);
		}
	}

}
