package action;

import java.util.ArrayList;

import value.Values;

public class ChangeShosetsu extends Base_Action {
	public final int DELT;
	public final ArrayList<Integer> PRE;

	public ChangeShosetsu(int value) {
		DELT = value - Values.haku_4_numbers;
		PRE = new ArrayList<Integer>();
		for (int i = 0; i < Values.main_panel.SHO_SETSU_LINE.size(); i++) {
			PRE.add(Values.main_panel.SHO_SETSU_LINE.get(i));
		}
	}

	@Override
	public void execute() {
		changeShosetsu(Values.haku_4_numbers + DELT);
		changeLine();
		Values.setSize_MainPanel();
	}

	private void changeLine() {
		ArrayList<Integer> s = Values.main_panel.SHO_SETSU_LINE;
		int delt = s.get(s.size() - 1) - s.get(s.size() - 2);
		if (s.size() > 1) {
			while (s.get(s.size() - 2) > Values.haku_4_numbers) {
				s.remove(s.size() - 1);
			}
		}
		while (s.get(s.size() - 1) < Values.haku_4_numbers) {
			s.add(s.get(s.size() - 1) + delt);
		}
	}

	public void changeShosetsu(int value) {
		Values.haku_4_numbers = value;
		Values.flag_changing_shosetsu = true;
		Values.haku_jspinner.setValue(value);
		Values.flag_changing_shosetsu = false;
	}

	@Override
	public void undo() {
		changeShosetsu(Values.haku_4_numbers - DELT);
		for (int i = 0; i < PRE.size(); i++) {
			Values.main_panel.SHO_SETSU_LINE.add(PRE.get(i));
		}
		Values.setSize_MainPanel();
	}

}
