package action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

import main_panel.Starter;
import value.SaveLoad;
import value.Values;

public class ActionManager implements ActionListener, WindowListener {
	public final static ActionManager ME = new ActionManager();
	public final int MAX = 200;
	public final ArrayList<Base_Action> undo_list = new ArrayList<Base_Action>(
			MAX), redo_list = new ArrayList<Base_Action>(MAX);
	public final JButton bs[] = { new JButton("←"), new JButton("→") };
	public static Base_Action unsaved_a = null;
	public static boolean flag_unsaved = false;

	public static boolean isUnsaved() {
		return flag_unsaved;
	}

	public ActionManager() {
		String text[] = { "Ctrl+Z", "Ctrl+Shift+Z,Ctrl+Y" };
		for (int i = 0; i < bs.length; i++) {
			JButton b = bs[i];
			b.setToolTipText(text[i]);
			b.addActionListener(this);
			b.setEnabled(false);
		}

	}

	public static void exe(Base_Action a) {
		if (ME.undo_list.size() == ME.MAX) {
			ME.undo_list.remove(0);
		}
		Values.main_panel.selected_nodes.clear();
		ME.redo_list.clear();
		ME.undo_list.add(a);
		a.execute();
		button();
		if (!isUnsaved()) {
			unsaved_a = a;
			setFlagSaved(false);
		}
	}

	private static void button() {
		ME.bs[0].setEnabled(isAbleToUndo());
		ME.bs[1].setEnabled(isAbleToRedo());
	}

	/**
	 * Ctrl+Y
	 */
	public static void redo() {
		if (!isAbleToRedo())
			return;
		Values.main_panel.selected_nodes.clear();
		Base_Action a = ME.redo_list.remove(ME.redo_list.size() - 1);
		a.execute();
		if (ME.undo_list.size() == ME.MAX) {
			ME.undo_list.remove(0);
		}
		ME.undo_list.add(a);
		if (a == unsaved_a) {
			setFlagSaved(false);
		}
		button();
	}

	/**
	 * Ctrl+Z
	 */
	public static boolean isAbleToUndo() {
		return !ME.undo_list.isEmpty();
	}

	/**
	 * Ctrl+Y
	 */
	public static boolean isAbleToRedo() {
		return !ME.redo_list.isEmpty();
	}

	/**
	 * Ctrl+Z
	 */
	public static void undo() {
		if (!isAbleToUndo())
			return;
		Values.main_panel.selected_nodes.clear();
		Base_Action a = ME.undo_list.remove(ME.undo_list.size() - 1);
		a.undo();
		if (ME.redo_list.size() == ME.MAX) {
			ME.redo_list.remove(0);
		}
		ME.redo_list.add(a);
		if (a == unsaved_a) {
			setFlagSaved(true);
		}
		button();
	}

	private static void setFlagSaved(boolean b) {
		flag_unsaved = !b;
		if (flag_unsaved) {
			Starter.ME.setTitle("*".concat(Starter.ME.getTitle()));
		} else {
			Starter.ME.setTitle(Starter.ME.getTitle().replaceFirst("\\*", ""));
		}
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		Object o = e.getSource();
		if (o instanceof JButton) {
			SwingUtilities.updateComponentTreeUI(Starter.ME);
			JButton b = (JButton) o;
			if (b.getText().matches("Redo")) {
				ActionManager.redo();
			} else if (b.getText().matches("Undo")) {
				ActionManager.undo();
			}
		}
		Values.main_panel.requestUpDate();
	}

	@Override
	public void windowOpened(WindowEvent e) {
	}

	@Override
	public void windowClosing(WindowEvent e) {
		System.out.println("windowClosing");
		maybeExit();
	}

	private void maybeExit() {
		Starter frame = Starter.ME;
		if (!isUnsaved()) {
			System.out.println("The document has already been saved,"
					+ " exit without doing anything.");
			frame.dispose();
			return;
		}
		java.awt.Toolkit.getDefaultToolkit().beep();
		Object[] options = { "名前を付けて保存", "上書き保存", "破棄", "キャンセル" };
		int retValue = JOptionPane.showOptionDialog(frame,
				"<html>ファイルは変更されています<br />閉じる前に保存しますか？</html>", "Exit Options",
				JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.WARNING_MESSAGE,
				null, options, options[0]);
		if (retValue == 0) {
			if (SaveLoad.actionPerformed(SaveLoad.SAVE)) {
				System.out.println("exit");
				frame.dispose();
			}
		} else if (retValue == 1) {
			if (SaveLoad.save()) {
				System.out.println("exit");
				frame.dispose();
			}
		} else if (retValue == 2) {
			System.out.println("Exit without save");
			frame.dispose();
		} else {
			System.out.println("Cancel exit");
		}
	}

	@Override
	public void windowClosed(WindowEvent e) {
		System.out.println("windowClosed");
		System.exit(0); // webstart
	}

	@Override
	public void windowIconified(WindowEvent e) {
	}

	@Override
	public void windowDeiconified(WindowEvent e) {
	}

	@Override
	public void windowActivated(WindowEvent e) {
	}

	@Override
	public void windowDeactivated(WindowEvent e) {
	}
}
