/*
 * Decompiled with CFR 0.152.
 */
package main.util;

import dangeon.model.map.PresentField;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import main.util.Show;

public class FileReadSupporter {
    private static String base() {
        return "res/";
    }

    private static String imageBase() {
        return FileReadSupporter.base().concat("image/");
    }

    public static String mapBase() {
        return FileReadSupporter.base().concat("map/");
    }

    public static BufferedImage readImage(String path) {
        try {
            return ImageIO.read(FileReadSupporter.readURL(path));
        }
        catch (IOException e) {
            Show.showCriticalErrorMessageDialog(path, "\u306f\u958b\u3051\u307e\u305b\u3093");
            return null;
        }
    }

    public static BufferedImage readImage(String name, String code) {
        try {
            return ImageIO.read(FileReadSupporter.readImageURL(name, code));
        }
        catch (IOException e) {
            Show.showCriticalErrorMessageDialog(FileReadSupporter.readImageURL(name, code).toString(), "\u306f\u958b\u3051\u307e\u305b\u3093");
            return null;
        }
    }

    public static File readImageURL(String name, String code) {
        if (!code.contains(".")) {
            return FileReadSupporter.readURL(FileReadSupporter.imageBase(), name, ".", code);
        }
        return FileReadSupporter.readURL(FileReadSupporter.imageBase(), name, code);
    }

    public static BufferedImage readPNGImage(String path) {
        try {
            return ImageIO.read(new File(path));
        }
        catch (IOException e) {
            Show.showCriticalErrorMessageDialog(path, "\u306f\u958b\u3051\u307e\u305b\u3093");
            return null;
        }
    }

    private static File readURL(String ... url) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = url;
        int n = url.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            sb.append(str);
            ++n2;
        }
        return FileReadSupporter.readURL(sb.toString());
    }

    public static File readURL(String name) {
        name = name.replace(".png", ".dat");
        return new File(name);
    }

    public static InputStreamReader readUTF8(String url) throws UnsupportedEncodingException, FileNotFoundException {
        return FileReadSupporter.readUTF8File(url);
    }

    public static InputStreamReader readUTF8(String url, String code) throws UnsupportedEncodingException, FileNotFoundException {
        if (!code.contains(".")) {
            return FileReadSupporter.readUTF8File(url, ".", code);
        }
        return FileReadSupporter.readUTF8File(url, code);
    }

    private static InputStreamReader readUTF8File(String ... url) throws UnsupportedEncodingException, FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = url;
        int n = url.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            sb.append(str);
            ++n2;
        }
        try {
            return new InputStreamReader((InputStream)new FileInputStream(sb.toString()), "UTF-8");
        }
        catch (IOException e) {
            Show.showCriticalErrorMessageDialog(e);
            return null;
        }
    }

    public static Reader readUTF8Map() throws UnsupportedEncodingException, FileNotFoundException {
        return FileReadSupporter.readUTF8File(PresentField.get().getFileName());
    }
}

