/*
 * Decompiled with CFR 0.152.
 */
package main.res;

import dangeon.controller.TurnSystemController;
import dangeon.model.condition.CONDITION;
import dangeon.model.object.creature.Base_Creature;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import load.Loading;
import main.thread.MainThread;
import main.util.BeautifulView;
import main.util.FileReadSupporter;

public enum Image_Condition {
    strange_piyo(5, true),
    strange_dodo(3, true, false, 20, -3),
    strange_sibi(3, false, false, 0, -5),
    strange_zzz(3, true, false, 15, 0),
    strange_seal(2, true, false, 0, 0),
    strange_slow(3, true, true, 0, 5, 2),
    strange_death(4, true),
    strange_death_num(10, true),
    strange_kagenui(3, false, true, -4, 13),
    strange_fire(3, false, true, 0, -19),
    strange_dark(1, false, false, 0, -16),
    strange_ejanaika(3, true, false, 0, 15),
    strange_amjk(3, true, true, 0, 0, 2);

    private final Image[] image;
    private final boolean HEAD;
    private final boolean ROTATE;
    private final int X_DIF;
    private final int Y_DIF;
    private final int DELAY;

    public static Image_Condition get(String string) {
        if (string == null) {
            return null;
        }
        Image_Condition[] image_ConditionArray = Image_Condition.values();
        int n = image_ConditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Image_Condition c = image_ConditionArray[n2];
            if (c.name().matches(string)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    private Image_Condition(int length, boolean head) {
        this(length, head, false, 0, 0);
    }

    private Image_Condition(int length, boolean head, boolean rotate, int x_diff, int y_diff) {
        this(length, head, rotate, x_diff, y_diff, 1);
    }

    private Image_Condition(int length, boolean head, boolean rotate, int x_diff, int y_diff, int delay) {
        this.HEAD = head;
        this.ROTATE = rotate;
        this.DELAY = delay;
        this.X_DIF = x_diff;
        this.Y_DIF = y_diff;
        Loading.setStr((Object)this);
        this.image = new Image[length];
        StringBuilder sb = new StringBuilder();
        sb.delete(0, sb.length());
        sb.append("res/image/anime/");
        sb.append("strange");
        sb.append("/");
        sb.append(this.name());
        sb.append(".png");
        BufferedImage bi = this.loadImage(sb.toString());
        int h = bi.getHeight() / length;
        int j = 0;
        while (j < this.image.length) {
            this.image[j] = bi.getSubimage(0, h * j, bi.getWidth(), h);
            ++j;
        }
        System.out.println("load : " + this.name());
    }

    public void draw(Graphics2D g, int x, int y, Base_Creature c) {
        if (this.HEAD) {
            y += c.getHeadY();
        }
        x += this.X_DIF;
        y += this.Y_DIF;
        if (this == strange_fire) {
            BeautifulView.setAlphaOnImg(g, Float.valueOf(0.2f));
            g.drawImage(this.getImage(), x, y, null);
            BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
        } else if (this == strange_dark) {
            BeautifulView.setAlphaOnImg(g, Float.valueOf((float)(MainThread.getFrame() / 3 / this.DELAY % 2) * 0.3f + 0.5f));
            g.drawImage(this.getImage(), x, y, null);
            BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
        } else if (this == strange_ejanaika) {
            int del = MainThread.getFrame() / 12 % 2 == 0 ? 5 : -31;
            g.drawImage(this.getImage(), x + del, y, null);
        } else {
            g.drawImage(this.getImage(), x, y, null);
        }
        if (this == strange_death) {
            int t = c.getConditionTurn(CONDITION.\u6b7b);
            if (t < 10) {
                g.drawImage(Image_Condition.strange_death_num.image[t], x, y, null);
            } else {
                int tenth = t / 10;
                int ones = t - tenth * 10;
                g.drawImage(Image_Condition.strange_death_num.image[tenth], x - 4, y, null);
                g.drawImage(Image_Condition.strange_death_num.image[ones], x + 4, y, null);
            }
        }
    }

    public Image getImage() {
        if (TurnSystemController.time_stop_count > 0) {
            return this.image[0];
        }
        if (this.ROTATE) {
            int len = this.image.length * 2 - 2;
            int i = MainThread.getFrame() / 3 / this.DELAY % len;
            if (i >= this.image.length) {
                i = len - i;
            }
            return this.image[i];
        }
        return this.image[MainThread.getFrame() / 3 / this.DELAY % this.image.length];
    }

    public int getLength() {
        return this.image.length;
    }

    private BufferedImage loadImage(String filename) {
        try {
            return ImageIO.read(FileReadSupporter.readURL(filename));
        }
        catch (IOException e) {
            try {
                return ImageIO.read(FileReadSupporter.readURL("res/image/floor.png"));
            }
            catch (IOException e1) {
                return null;
            }
        }
    }
}

