/*
 * Decompiled with CFR 0.152.
 */
package main.pad;

import java.util.ArrayList;
import java.util.List;
import main.util.Show;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;

public class JInputWrapper {
    private static Controller[] con;
    private static List<Integer> gamepadID;
    private static Integer useID;
    public static boolean[] flgButton;
    public static int arrowX;
    public static int arrowY;
    public static int lastButton;
    public static int lastPad;
    public static Component.Identifier[] buttonID;
    private static Float[] polle_base;

    static {
        gamepadID = new ArrayList<Integer>();
        useID = null;
        flgButton = new boolean[16];
        buttonID = new Component.Identifier[16];
        JInputWrapper.buttonID[0] = Component.Identifier.Button._0;
        JInputWrapper.buttonID[1] = Component.Identifier.Button._1;
        JInputWrapper.buttonID[2] = Component.Identifier.Button._2;
        JInputWrapper.buttonID[3] = Component.Identifier.Button._3;
        JInputWrapper.buttonID[4] = Component.Identifier.Button._4;
        JInputWrapper.buttonID[5] = Component.Identifier.Button._5;
        JInputWrapper.buttonID[6] = Component.Identifier.Button._6;
        JInputWrapper.buttonID[7] = Component.Identifier.Button._7;
        JInputWrapper.buttonID[8] = Component.Identifier.Button._8;
        JInputWrapper.buttonID[9] = Component.Identifier.Button._9;
        JInputWrapper.buttonID[10] = Component.Identifier.Button._10;
        JInputWrapper.buttonID[11] = Component.Identifier.Button._11;
        JInputWrapper.buttonID[12] = Component.Identifier.Button._12;
        JInputWrapper.buttonID[13] = Component.Identifier.Button._13;
        JInputWrapper.buttonID[14] = Component.Identifier.Button._14;
        JInputWrapper.buttonID[15] = Component.Identifier.Button._15;
        polle_base = null;
    }

    private static Component[] con_init(int ID) {
        con[ID].poll();
        Component[] com = con[ID].getComponents();
        if (polle_base == null) {
            polle_base = new Float[com.length];
            int c = 0;
            while (c < com.length) {
                float p = com[c].getPollData();
                if (com[c].getIdentifier() == Component.Identifier.Axis.X) {
                    JInputWrapper.polle_base[c] = Float.valueOf(p);
                }
                if (com[c].getIdentifier() == Component.Identifier.Axis.Y) {
                    JInputWrapper.polle_base[c] = Float.valueOf(p);
                }
                ++c;
            }
        }
        return com;
    }

    public static int getArrowX() {
        return arrowX;
    }

    public static int getArrowY() {
        return arrowY;
    }

    public static boolean[] getButton() {
        return flgButton;
    }

    public static int getLastButton() {
        return lastButton;
    }

    public static int getLastGamepad() {
        return lastPad;
    }

    public static void init() {
        con = ControllerEnvironment.getDefaultEnvironment().getControllers();
        int c = 0;
        while (c < con.length) {
            Controller.Type ct = con[c].getType();
            if (ct == Controller.Type.STICK || ct == Controller.Type.GAMEPAD) {
                gamepadID.add(c);
            }
            ++c;
        }
    }

    public static void resetLastButton() {
        lastButton = -1;
    }

    public static void setUseGamepadID(int i) {
        useID = i;
    }

    public static void upDate() {
        try {
            if (useID != null) {
                JInputWrapper.upDateOne(useID);
            } else {
                for (int ID : gamepadID) {
                    JInputWrapper.upDateOne(ID);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Show.showErrorMessageDialog("\u30b2\u30fc\u30e0\u30d1\u30c3\u30c9\u304c\u8907\u6570\u691c\u51fa\u3055\u308c\u305f\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3000\uff12\u3064\u4ee5\u4e0a\u5dee\u3057\u3066\u3044\u308b\u5834\u5408\u306f\uff11\u3064\u306b\u3057\u3066\u304f\u3060\u3055\u3044");
            Show.showCriticalErrorMessageDialog(e);
            e.printStackTrace();
        }
    }

    private static void upDateOne(int ID) {
        Component[] com = JInputWrapper.con_init(ID);
        float arrow_x = 0.0f;
        float arrow_y = 0.0f;
        int c = 0;
        while (c < com.length) {
            float p = com[c].getPollData();
            int b = 0;
            while (b < 16) {
                if (com[c].getIdentifier() == buttonID[b]) {
                    if (p != 0.0f) {
                        JInputWrapper.flgButton[b] = true;
                        lastButton = b;
                        lastPad = ID;
                    } else {
                        JInputWrapper.flgButton[b] = false;
                    }
                }
                ++b;
            }
            if (com[c].getIdentifier() == Component.Identifier.Axis.X) {
                arrow_x += p - polle_base[c].floatValue();
            }
            if (com[c].getIdentifier() == Component.Identifier.Axis.Y) {
                arrow_y += p - polle_base[c].floatValue();
            }
            ++c;
        }
        arrowX = arrow_x < -0.5f ? -1 : (arrow_x > 0.5f ? 1 : 0);
        arrowY = arrow_y < -0.5f ? -1 : (arrow_y > 0.5f ? 1 : 0);
    }
}

