/*
 * Decompiled with CFR 0.152.
 */
package main;

import dangeon.latest.scene.action.message.Message;
import dangeon.model.config.Config;
import dangeon.util.Switch;
import debugMode.WindowDebug;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import main.Listener;
import main.constant.PropertySupporter;
import main.pad.ListenerAdapter;
import main.res.BGM;
import main.thread.MainThread;

public class Second_Firster
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static Second_Firster ME;
    public final Insets insets;
    private GraphicsDevice device;
    private boolean fullscreen;
    private int width;
    private int height;
    private float scale_w = 1.0f;
    private float scale_h = 1.0f;
    private boolean flag_screen_doubled;
    private final PropertySupporter PR = Config.PR;
    private boolean flag_supportedfullscreen;
    private float x_offset;
    private float y_offset;

    private static void BGMwriter() {
        BGM b;
        BGM[] bs;
        int i = 0;
        BGM[] bGMArray = bs = new BGM[]{BGM.kagerou, BGM.iku, BGM.Mermaidia, BGM.kanpyo_ch2_hexa, BGM.Dingy_rip};
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            b = bGMArray[n2];
            if (b != BGM.UTIL) {
                b.play();
                BGM.waitUntilFadeOut();
                System.out.println(++i);
            }
            ++n2;
        }
        System.out.print("name");
        System.out.print("\t");
        System.out.print("AUTHOR");
        System.out.print("\t");
        System.out.print("Hz_44100");
        System.out.print("\t");
        System.out.print("NAME");
        System.out.print("\t");
        System.out.print("seek");
        System.out.print("\t");
        System.out.print("TITLE");
        System.out.print("\t");
        System.out.print("end_frame");
        System.out.println();
        bGMArray = bs;
        n = bs.length;
        n2 = 0;
        while (n2 < n) {
            b = bGMArray[n2];
            if (b != BGM.UTIL) {
                System.out.print(b.name());
                System.out.print("\t");
                System.out.println();
            }
            ++n2;
        }
    }

    public static void start() {
        ME = new Second_Firster();
        new WindowDebug();
        MainThread.ME.start();
        ME.requestFocus();
    }

    private Second_Firster() {
        this.setIconImage(new ImageIcon("./res/image/artifact/stairs.dat").getImage());
        this.getContentPane().setBackground(Color.BLACK);
        this.setBackground(Color.BLACK);
        this.setTitle(Switch.getMainTitle());
        this.setSize(400, 340);
        this.setResizable(MainThread.ME.test);
        this.setLocationRelativeTo(null);
        this.initFullScreen();
        this.setVisible(true);
        this.insets = this.getInsets();
        this.width = 400 + this.insets.left + this.insets.right;
        this.height = 340 + this.insets.top + this.insets.bottom;
        MainThread.ME.getClass();
        this.setSize(this.width, this.height);
        this.setIgnoreRepaint(true);
        this.flag_screen_doubled = !this.PR.isGotPropertyTrue("flag_screen_doubled");
        this.switchSize();
        this.setLocationRelativeTo(null);
        this.addKeyListener(Listener.ME);
        ListenerAdapter.setListener(Listener.ME);
        this.setDefaultCloseOperation(3);
        this.fullscreen = this.PR.isGotPropertyTrue("fullscreen");
        if (this.fullscreen) {
            this.setFullScreen();
        }
    }

    public void drawBlack(Graphics2D g) {
        g.scale(1.0, 1.0);
        g.setColor(Color.GREEN);
        g.fillRect(0, 0, this.getX_offset(), this.getBounds().height);
        g.fillRect(this.getBounds().width - this.getX_offset(), 0, this.getX_offset(), this.getBounds().height);
    }

    public float getRateH() {
        return this.scale_h;
    }

    public float getRateW() {
        return this.scale_w;
    }

    public int getX_offset() {
        return Math.round(this.x_offset);
    }

    public int getY_offset() {
        return Math.round(this.y_offset);
    }

    private void initFullScreen() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.device = ge.getDefaultScreenDevice();
        this.flag_supportedfullscreen = this.device.isFullScreenSupported();
    }

    public boolean isDoubledScreen() {
        return this.flag_screen_doubled;
    }

    public boolean isFullScreen() {
        return this.fullscreen;
    }

    public int PCScreenH() {
        return this.getBounds().height;
    }

    public int PCScreenW() {
        return this.getBounds().width;
    }

    private void restoreFullScreen() {
        this.dispose();
        this.setCursor(null);
        this.setUndecorated(false);
        this.fullscreen = false;
        this.device.setFullScreenWindow(null);
        if (this.flag_screen_doubled) {
            this.scale_w = 2.0f;
            this.scale_h = 2.0f;
        } else {
            this.scale_w = 1.0f;
            this.scale_h = 1.0f;
        }
        this.PR.saveProperty("fullscreen", this.fullscreen);
        this.setVisible(true);
    }

    private void setDisplayMode(int width, int height, int bitDepth) {
        if (!this.device.isDisplayChangeSupported()) {
            System.out.println("\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4\u30e2\u30fc\u30c9\u306e\u5909\u66f4\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        DisplayMode dm = new DisplayMode(width, height, bitDepth, 0);
        this.device.setDisplayMode(dm);
    }

    private void setFullScreen() {
        this.dispose();
        this.setUndecorated(true);
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(1, 1, 3), new Point(), "");
        this.setCursor(cursor);
        if (!this.flag_supportedfullscreen) {
            Message.set("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u30e2\u30fc\u30c9\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            this.fullscreen = false;
            this.PR.saveProperty("fullscreen", this.fullscreen);
            return;
        }
        this.fullscreen = true;
        this.PR.saveProperty("fullscreen", this.fullscreen);
        this.device.setFullScreenWindow(this);
        this.scale_h = this.scale_w = Math.min((float)this.getBounds().width / 400.0f, (float)this.getBounds().height / 340.0f);
        this.y_offset = 0.0f;
        this.x_offset = 0.0f;
        if (this.getBounds().width > this.getBounds().height) {
            this.x_offset = (float)this.getBounds().width - 400.0f * this.scale_w;
            this.x_offset /= 2.0f;
        } else {
            this.y_offset = this.getBounds().height - this.getBounds().width;
            this.y_offset /= 2.0f;
        }
        this.setVisible(true);
    }

    private void showCurrentMode() {
        DisplayMode dm = this.device.getDisplayMode();
        System.out.println("\u73fe\u5728\u306e\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4\u30e2\u30fc\u30c9");
        System.out.println("Width: " + dm.getWidth());
        System.out.println("Height: " + dm.getHeight());
        System.out.println("Bit Depth: " + dm.getBitDepth());
        System.out.println("Refresh Rate: " + dm.getRefreshRate());
    }

    public void switchFullScreen() {
        if (this.fullscreen) {
            this.restoreFullScreen();
        } else {
            this.setFullScreen();
        }
    }

    public void switchSize() {
        if (this.fullscreen) {
            this.restoreFullScreen();
        }
        this.flag_screen_doubled = !this.flag_screen_doubled;
        this.width = 400 + this.insets.left + this.insets.right;
        this.height = 340 + this.insets.top + this.insets.bottom;
        this.scale_w = 1.0f;
        this.scale_h = 1.0f;
        if (this.flag_screen_doubled) {
            this.width += 400;
            this.height += 340;
            this.scale_w = 2.0f;
            this.scale_h = 2.0f;
        }
        this.PR.saveProperty("flag_screen_doubled", this.flag_screen_doubled);
        this.setSize(this.width, this.height);
    }
}

