/*
 * Decompiled with CFR 0.152.
 */
package dungeon_creater.second_ver;

import dangeon.model.config.table.EnemyTable;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dungeon_creater.second_ver.DungeonLevelControl;
import dungeon_creater.second_ver.FileControl;
import dungeon_creater.second_ver.SetObject;
import dungeon_creater.second_ver.SubBaseCreature;
import dungeon_creater.second_ver.TableMainFrame;
import dungeon_creater.second_ver.readGraphics.SortImage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JPanel;
import main.res.CHARA_IMAGE;

public class EnemyTableGraphicsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static EnemyTableGraphicsPanel ME = new EnemyTableGraphicsPanel();
    static TableMainFrame FRAME = TableMainFrame.MAIN;
    public boolean repainter = false;
    private int chara_max_x = 12;
    int main_chara_size = 50;
    int reduction_chara = 42;
    int set_chara_space = 2;
    int one_character_space = this.reduction_chara + this.set_chara_space;
    int table_x = this.chara_max_x * (this.reduction_chara + this.set_chara_space) + 30;
    int table_start_y = this.one_character_space * 4;
    int explain_start_y = 10;
    int explain_height = this.one_character_space * 3;
    int dungeon_level_control_y = this.explain_height + this.explain_start_y + 15;
    int dungeon_level_control_y_line = this.dungeon_level_control_y + 5;
    int table_y = 30;
    int table_width = 430;
    int enemy_max = 10;
    int draw_dungeon_level_start_x;
    public HashMap<Point, SubBaseCreature> image_map;
    int control_tab_width_and_height;
    boolean flag_sort;

    public EnemyTableGraphicsPanel() {
        this.draw_dungeon_level_start_x = TableMainFrame.MAIN.main_panel_x - 150;
        this.image_map = new HashMap();
        this.control_tab_width_and_height = 10;
        this.flag_sort = false;
        this.setBackground(Color.WHITE);
    }

    public BufferedImage cutImageMainCharaSize(BufferedImage _img) {
        int current_x = _img.getWidth();
        int current_y = _img.getHeight();
        int cut_source_x1 = (current_x - this.main_chara_size) / 2;
        int cut_source_y1 = (current_y - this.main_chara_size) / 2;
        if (current_x > this.main_chara_size || current_y > this.main_chara_size) {
            _img = _img.getSubimage(cut_source_x1, cut_source_y1, this.main_chara_size, this.main_chara_size);
            current_x = _img.getWidth();
            current_y = _img.getHeight();
        }
        return _img;
    }

    public void drawDungeonLevel(Graphics2D g) {
        g.drawString(String.valueOf(DungeonLevelControl.getDungeonLevel()).concat("F"), this.draw_dungeon_level_start_x + 10, 20 + this.table_start_y);
        g.drawLine(this.draw_dungeon_level_start_x, this.table_y + this.table_start_y, this.draw_dungeon_level_start_x + 110, this.table_y + this.table_start_y);
        g.drawLine(this.draw_dungeon_level_start_x, this.table_start_y, this.draw_dungeon_level_start_x, this.table_y + this.table_start_y);
    }

    public void drawDungeonLevelControl(Graphics2D g) {
        g.drawLine(this.table_x, this.dungeon_level_control_y_line, this.table_x + this.table_width, this.dungeon_level_control_y_line);
    }

    public void drawObjectExplain(Graphics2D g) {
        g.drawRect(this.table_x, this.explain_start_y, this.table_width, this.explain_height);
    }

    public void drawTableCreater(Graphics2D g) {
        g.drawString(FileControl.getFileName(), this.table_x + 10, 20 + this.table_start_y);
        g.drawLine(this.table_x, this.table_y + this.table_start_y, this.table_x + 150, this.table_y + this.table_start_y);
        g.drawLine(this.table_x, this.table_start_y, this.table_x, this.table_y + this.table_start_y);
        int i = 1;
        while (i <= this.enemy_max) {
            g.drawRect(this.table_x, this.one_character_space * i + this.table_start_y, this.one_character_space, this.one_character_space);
            g.drawRect(this.table_x + this.one_character_space, this.one_character_space * i + this.table_start_y, this.table_width - this.one_character_space, this.one_character_space);
            ++i;
        }
    }

    public SubBaseCreature getImageOfPoint(Point p) {
        int x = p.x / this.one_character_space;
        int y = p.y / this.one_character_space;
        SubBaseCreature sb = this.image_map.get(new Point(x, y));
        if (sb == null) {
            return null;
        }
        return new SubBaseCreature(sb);
    }

    public Point getPointEnemyTable(int y) {
        return new Point(this.table_x, this.one_character_space * y + this.table_start_y);
    }

    public Point getPointObjectExplainBox() {
        return new Point(this.table_x, this.explain_start_y);
    }

    public int getYEnemyTableFromPoint(Point p) {
        int x = p.x;
        int y = p.y - this.one_character_space - this.table_start_y;
        if (y < 0) {
            return -1;
        }
        y /= this.one_character_space;
        if (x < this.table_x || x > this.table_x + this.one_character_space) {
            return -1;
        }
        if (y >= this.enemy_max) {
            return -1;
        }
        return y;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.setImages(g2);
        SetObject.draw(g2);
        this.drawTableCreater(g2);
        this.drawDungeonLevel(g2);
        this.drawObjectExplain(g2);
        DungeonLevelControl.drawControler(g2);
        this.drawDungeonLevelControl(g2);
    }

    public BufferedImage reduction(BufferedImage inputImage) {
        int currentWidth = inputImage.getWidth();
        int currentHeight = inputImage.getHeight();
        int endWidth = this.reduction_chara;
        int endHeight = this.reduction_chara;
        BufferedImage currentImage = inputImage;
        int delta = currentWidth - endWidth;
        int nextPow2 = currentWidth >> 1;
        while (currentWidth > 1) {
            Graphics2D g;
            BufferedImage tmpImage;
            if (delta <= nextPow2) {
                if (currentWidth != endWidth) {
                    tmpImage = new BufferedImage(endWidth, endHeight, 2);
                    g = (Graphics2D)tmpImage.getGraphics();
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.drawImage(currentImage, 0, 0, tmpImage.getWidth(), tmpImage.getHeight(), null);
                    g.dispose();
                    currentImage = tmpImage;
                }
                return currentImage;
            }
            tmpImage = new BufferedImage(currentWidth >> 1, currentHeight >> 1, 2);
            g = (Graphics2D)tmpImage.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(currentImage, 0, 0, tmpImage.getWidth(), tmpImage.getHeight(), null);
            g.dispose();
            currentImage = tmpImage;
            currentWidth = currentImage.getWidth();
            currentHeight = currentImage.getHeight();
            delta = currentWidth - endWidth;
            nextPow2 = currentWidth >> 1;
        }
        return currentImage;
    }

    public void set() {
        this.setBackground(Color.WHITE);
    }

    public void setBaseCreature(Point p) {
        int i = this.getYEnemyTableFromPoint(p);
        if (i == -1) {
            return;
        }
        SetObject.setEnemyList(i);
    }

    public void setImages(Graphics2D g) {
        int put_x = 0;
        int put_y = 0;
        int count = 0;
        g.setColor(Color.GRAY);
        if (this.repainter) {
            SortImage.sort();
            this.image_map.clear();
            for (SubBaseCreature c : SetObject.enemy_list) {
                this.image_map.put(new Point(put_x, put_y), c);
                BufferedImage _img = c.C.getWalkDot();
                ++count;
                _img = this.cutImageMainCharaSize(_img);
                _img = this.reduction(_img);
                g.drawImage((Image)_img, put_x * (this.reduction_chara + this.set_chara_space), put_y * (this.reduction_chara + this.set_chara_space), this);
                int draw_line = this.reduction_chara + this.set_chara_space;
                g.drawLine((put_x + 1) * draw_line, (put_y + 1) * draw_line, draw_line * put_x, (put_y + 1) * draw_line);
                g.drawLine((put_x + 1) * draw_line, (put_y + 1) * draw_line, draw_line * (put_x + 1), draw_line * put_y);
                if (++put_x < 12) continue;
                ++put_y;
                put_x = 0;
            }
            return;
        }
        CHARA_IMAGE[] cHARA_IMAGEArray = CHARA_IMAGE.values();
        int n = cHARA_IMAGEArray.length;
        int n2 = 0;
        while (n2 < n) {
            CHARA_IMAGE _img = cHARA_IMAGEArray[n2];
            if (!(_img.name().matches("\u30ad\u30b9\u30e1") || _img.name().matches("arrow") || _img.name().matches("\u8239") || _img.name().matches("Ex\u30eb\u30fc\u30df\u30a2"))) {
                _img.load();
                int i = 0;
                while (i <= 2) {
                    BufferedImage img = _img.getWalkDot(i);
                    ++count;
                    img = this.cutImageMainCharaSize(img);
                    img = this.reduction(img);
                    g.drawImage((Image)img, put_x * (this.reduction_chara + this.set_chara_space), put_y * (this.reduction_chara + this.set_chara_space), this);
                    Base_Enemy _c = EnemyTable.returnBaseEnemy(_img.name(), i + 1);
                    SubBaseCreature c = new SubBaseCreature(_c, 1);
                    SetObject.enemy_list.add(c);
                    SetObject.base_enemy_list.add(c);
                    this.image_map.put(new Point(put_x, put_y), c);
                    int draw_line = this.reduction_chara + this.set_chara_space;
                    g.drawLine((put_x + 1) * draw_line, (put_y + 1) * draw_line, draw_line * put_x, (put_y + 1) * draw_line);
                    g.drawLine((put_x + 1) * draw_line, (put_y + 1) * draw_line, draw_line * (put_x + 1), draw_line * put_y);
                    if (++put_x >= this.chara_max_x) {
                        ++put_y;
                        put_x = 0;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        this.repainter = true;
    }
}

