/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.detail;

import dangeon.controller.DangeonScene;
import dangeon.model.config.Config;
import dangeon.model.map.MapList;
import dangeon.model.map.PresentField;
import dangeon.model.map.StairScene;
import dangeon.model.object.creature.player.Player;
import dangeon.view.constant.BGMFONT;
import dangeon.view.constant.NormalFont;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import main.util.BeautifulView;

public class View_StairScene {
    public static void draw(Graphics2D g) {
        StairScene ss = (StairScene)DangeonScene.STAIRS.getTask();
        if (ss != null) {
            ss.work();
            double rate = Math.sin(Math.PI * ss.getFrame() / (double)ss.FRAME);
            BeautifulView.setAlphaOnImg(g, Float.valueOf((float)(1.0 * rate)));
            g.setColor(Color.BLACK);
            int s = 30;
            g.fillRect(-s, -s, 400 + s * 2, 340 + s * 2);
            View_StairScene.drawFloor(g);
            g.setColor(Color.WHITE);
        }
    }

    private static void drawDangeonMap(Graphics2D g) {
        g.setFont(BGMFONT.FONT);
        StringBuilder s = new StringBuilder();
        s.append(PresentField.get().getMapName());
        View_StairScene.drawMap(g, s.toString());
        s = new StringBuilder();
        s.append(" -");
        s.append(PresentField.get().getRandomMap().getDIFFICULTY().name());
        s.append("- ");
        s.append(MapList.getFloor());
        s.append("\uff26");
        g.drawString(s.toString(), 100, 170);
        g.setFont(NormalFont.NORMALFONT);
        if (Config.isLapON()) {
            StringBuilder sb = new StringBuilder();
            long t = Player.me.getPlayingMilliTime();
            boolean h = false;
            if ((t /= 1000L) > 3600L) {
                sb.append(Color.ORANGE);
                sb.append(t / 3600L);
                t -= t / 3600L * 3600L;
                sb.append("\u6642 ");
                h = true;
            }
            sb.append(Color.RED);
            if (t > 60L) {
                if (h && t / 60L < 10L) {
                    sb.append("0");
                }
                sb.append(t / 60L);
                t -= t / 60L * 60L;
                sb.append("\u5206 ");
            }
            sb.append(Color.YELLOW);
            if (t < 10L) {
                sb.append("0");
            }
            sb.append(t);
            sb.append("\u79d2 ");
            if (!h) {
                sb.append(Color.lightGray);
                t = Player.me.getPlayingMilliTime();
                t -= t / 1000L * 1000L;
                if (t < 10L) {
                    sb.append("00");
                } else if (t < 100L) {
                    sb.append("0");
                }
                sb.append(t);
            }
            StringFilter.drawString(g, sb.toString(), 200, 220);
        }
    }

    private static void drawFloor(Graphics2D g) {
        g.setColor(Color.WHITE);
        if (PresentField.get().isHaraheru()) {
            View_StairScene.drawDangeonMap(g);
        } else {
            View_StairScene.drawTwonMap(g);
        }
    }

    private static void drawMap(Graphics2D g, String s) {
        g.drawString(s, 200 - g.getFontMetrics().stringWidth(s) / 2, 120);
    }

    private static void drawTwonMap(Graphics2D g) {
        g.setFont(NormalFont.NORMALFONT);
        View_StairScene.drawMap(g, PresentField.get().getMapName());
    }
}

