/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.detail;

import dangeon.view.constant.BGMFONT;
import dangeon.view.constant.NormalFont;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import main.util.BeautifulView;

public class View_Sider_Info {
    private static final int INFO_INTER = 1000;
    private static final int MAX = 10;
    private static final LinkedHashSet<View_Sider_Info> info_list = new LinkedHashSet(10);
    private static final ArrayList<String> record = new ArrayList(100);
    final String name;
    private int time;

    private static void add(View_Sider_Info type) {
        type.time = 0;
    }

    static void draw(Graphics2D g) {
        Font font = g.getFont();
        g.setFont(NormalFont.NORMALFONT.deriveFont(10.0f));
        int index = 0;
        Iterator i = info_list.iterator();
        while (i.hasNext()) {
            View_Sider_Info type = (View_Sider_Info)i.next();
            if (type.draw_div(g, index)) {
                View_Sider_Info.add(type);
                i.remove();
            }
            ++index;
        }
        g.setFont(font);
    }

    private static void end(View_Sider_Info type) {
        record.add(type.name);
        while (record.size() >= 100) {
            record.remove(0);
        }
    }

    public static String[] getRecord() {
        return record.toArray(new String[0]);
    }

    public static int getRecordSize() {
        return record.size();
    }

    public static void reset() {
        Iterator i = info_list.iterator();
        while (i.hasNext()) {
            View_Sider_Info.add((View_Sider_Info)i.next());
            i.remove();
        }
    }

    static void setInformation(String ... msg) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = msg;
        int n = msg.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            sb.append(string);
            ++n2;
        }
        View_Sider_Info type = new View_Sider_Info(sb.toString());
        info_list.add(type);
        View_Sider_Info.end(type);
    }

    View_Sider_Info(String s) {
        this.name = s;
        this.time = 1000;
    }

    boolean draw_div(Graphics2D g, int index) {
        int x = 0;
        int w = g.getFontMetrics().stringWidth(StringFilter.getPlainString(this.name));
        int h = g.getFontMetrics().getHeight();
        int height = h * (index + 2) + BGMFONT.DECENT;
        if (this.time > 0) {
            BeautifulView.setAlphaOnImg(g, Float.valueOf((float)Math.sin(1.5707963267948966 * (double)this.time / 1000.0)));
            x = 400 - w - 10;
            if (this.time > 990) {
                x -= 990 - this.time;
            } else if (this.time < 125) {
                x += (125 - this.time) * 2;
            }
            --this.time;
        }
        int y = 25 + height;
        g.setPaint(new GradientPaint(x, y - h, new Color(0, 0, 255, 50), x, y, new Color(0, 0, 100, 50)));
        g.fillRect(x, y - h + 2, w, h);
        g.setColor(Color.WHITE);
        g.drawRect(x, y - h + 2, w, h);
        g.setColor(Color.WHITE);
        StringFilter.drawString(g, this.name, x, y);
        if (this.time > 0) {
            --this.time;
            if (this.time <= 0) {
                return true;
            }
            BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
        }
        return false;
    }

    int getTime() {
        return this.time;
    }
}

