/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.detail;

import dangeon.controller.DangeonScene;
import dangeon.controller.MainSystem;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.model.condition.CONDITION;
import dangeon.model.config.Config;
import dangeon.model.map.InitialPlacement;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.Base_Device;
import dangeon.model.object.artifact.device.Stairs;
import dangeon.model.object.artifact.device.\u6249;
import dangeon.model.object.artifact.device.\u795e\u968e\u6bb5;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u7f60\u5e2b;
import dangeon.model.object.artifact.trap.Base_Trap;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.npc.Base_NPC;
import dangeon.model.object.creature.npc.\u5b88\u77e2\u8cfd\u92ad\u7bb1;
import dangeon.model.object.creature.player.Player;
import dangeon.view.constant.NormalFont;
import dangeon.view.detail.MainMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import main.Second_Firster;
import main.thread.MainThread;
import main.util.DIRECTION;

public class MiniMap {
    private static int x_min;
    private static int x_max;
    private static int y_min;
    private static int y_max;
    public static final Color C_MAP;
    public static final Color C_MAP_WARNING;
    public static final Color C_MAP_CHECKED;
    public static final Color C_MAP_PATH;
    public static final Color C_HOLY;
    public static final Color C_ARTIFACT;
    public static final Color C_ARTIFACT_CHECKED;
    public static final Color C_PLAYER;
    public static final Color C_TRAP;
    public static final Color C_DEVICE;
    public static final Color C_GOLDSTAIR;
    public static final Color C_ENEMY;
    private static final int MINI_MAP_SIZE = 5;
    private static BufferedImage IMAGE;
    private static final int FONT_HEIGHT;
    private static final int WIDTH = 200;
    private static final int HEIGHT = 150;

    static {
        C_MAP = new Color(17, 17, 255, 150);
        C_MAP_WARNING = new Color(17, 17, 255, 20);
        C_MAP_CHECKED = new Color(0, 0, 136, 150);
        C_MAP_PATH = new Color(153, 153, 221, 100);
        C_HOLY = new Color(255, 255, 17, 100);
        C_ARTIFACT = new Color(255, 200, 0);
        C_ARTIFACT_CHECKED = new Color(100, 255, 100);
        C_PLAYER = new Color(255, 255, 255);
        C_TRAP = new Color(255, 255, 0);
        C_DEVICE = new Color(0, 255, 255);
        C_GOLDSTAIR = new Color(255, 255, 100);
        C_ENEMY = new Color(255, 0, 0);
        FontMetrics fm = Second_Firster.ME.getFontMetrics(NormalFont.NORMALFONT.deriveFont(5.0f));
        FONT_HEIGHT = fm.getHeight() - fm.getDescent();
        MiniMap.reset();
    }

    public static void addPicture(Mass m) {
        if (m.isVisible() || !m.WALKABLE) {
            return;
        }
        MiniMap.forceToAddPicture(m);
    }

    public static void draw(Graphics2D g) {
        boolean flag_map;
        if (DangeonScene.isPresentSceneLikeMenu()) {
            return;
        }
        boolean bl = flag_map = Scene_Action.getMe().isMap() && MainSystem.isKeyAccept();
        if (!Config.isMini_map_on() && !flag_map) {
            return;
        }
        g.setFont(NormalFont.NORMALFONT.deriveFont(5.0f).deriveFont(1));
        g.drawImage((Image)IMAGE, MiniMap.getOrigineX(), MiniMap.getOrigineY(), null);
        MiniMap.drawMainMap_Minimap(g);
        if (flag_map) {
            MiniMap.drawDirection(g);
        }
        g.setFont(NormalFont.NORMALFONT);
    }

    private static void drawDirection(Graphics2D g) {
        DIRECTION d = Player.me.getDirection();
        int x = Player.me.getMassPoint().x;
        int y = Player.me.getMassPoint().y;
        Color color = new Color(255, 255, 255, 100);
        g.setColor(color);
        int i = 0;
        int max = Math.max(40, 30);
        boolean flag_fall = false;
        while (i++ < max) {
            if (!flag_fall) {
                boolean flag_creature;
                boolean flag = false;
                if (!MassCreater.getMass((int)(x + d.X), (int)(y + d.Y)).WALKABLE) {
                    flag = true;
                }
                boolean bl = flag_creature = !MainMap.isOutofPlayerSight(MapList.getEnemy(x, y));
                if (flag || flag_creature || i == 11 || !MassCreater.getMass(x, y).isVisible()) {
                    flag_fall = true;
                    if (!MassCreater.getMass(x, y).isVisible()) {
                        g.setColor(new Color(255, 255, 255, 50));
                        int s = 5;
                        int h = s * 3 / 4;
                        g.fillOval(MiniMap.getOrigineX() + x * s + h / 4, MiniMap.getOrigineY() + y * s + h / 4, h, h);
                    } else if (MainThread.getFrame() % 20 < 10) {
                        g.setColor(new Color(255, 255, 255, 200));
                        g.drawRect(MiniMap.getOrigineX() + x * 5, MiniMap.getOrigineY() + y * 5, 5, 5);
                    }
                    g.setColor(new Color(255, 255, 255, 50));
                    x += d.X;
                    y += d.Y;
                    continue;
                }
            }
            if (i != 1) {
                int s = 5;
                int h = s * 3 / 4;
                g.drawString("\uff0a", MiniMap.getOrigineX() + x * s + h / 4, MiniMap.getOrigineY() + y * s + h + 2);
            }
            x += d.X;
            y += d.Y;
        }
    }

    private static void drawFrozenWaterLines(Graphics2D g, Mass m, int x_l, int y_t, int x_r, int y_b) {
        if (!m.WATER_FROZEN) {
            return;
        }
        int[][][] ints = new int[][][]{new int[][]{{x_r, y_t + 1, x_r, y_b - 1}, {x_r, y_b, x_r, y_b}, {x_r, y_t, x_r, y_t}}, new int[][]{{x_l + 1, y_b, x_r - 1, y_b}, {x_l, y_b, x_l, y_b}, {x_r, y_b, x_r, y_b}}, new int[][]{{x_l, y_t + 1, x_l, y_b - 1}, {x_l, y_t, x_l, y_t}, {x_l, y_b, x_l, y_b}}, new int[][]{{x_l + 1, y_t, x_r - 1, y_t}, {x_r, y_t, x_r, y_t}, {x_l, y_t, x_l, y_t}}};
        int i = -1;
        boolean[] flag_drawn = new boolean[4];
        DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyBasic4();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            ++i;
            if (!m.get((DIRECTION)d).WATER_FROZEN) {
                MiniMap.setFrozenWaterLinesColor(g);
                MiniMap.drawLine(g, ints[i][0][0], ints[i][0][1], ints[i][0][2], ints[i][0][3]);
                int j = 0;
                while (j < 2) {
                    DIRECTION d2 = d.getNeiboringDirection(-2 * (j * 2 - 1));
                    int num = DIRECTION.getDirection((int)(d.X + d2.X), (int)(d.Y + d2.Y)).ROTATE / 2;
                    if (!flag_drawn[num]) {
                        flag_drawn[num] = true;
                        if (!m.get((DIRECTION)d2).WATER_FROZEN && m.isRoom()) {
                            g.setColor(MiniMap.getC_MAP(m));
                        } else {
                            MiniMap.setFrozenWaterLinesColor(g);
                        }
                        int k = j + 1;
                        MiniMap.drawLine(g, ints[i][k][0], ints[i][k][1], ints[i][k][2], ints[i][k][3]);
                    }
                    ++j;
                }
            }
            ++n2;
        }
    }

    public static void drawHolyRect(InitialPlacement.Room r) {
        Graphics2D g = (Graphics2D)IMAGE.getGraphics();
        g.setColor(C_GOLDSTAIR);
        int x = r.X * 5;
        int y = r.Y * 5;
        g.drawRect(x, y, r.W * 5 - 1, r.H * 5 - 1);
        g.dispose();
    }

    private static void drawLine(Graphics2D g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
        g.setStroke(new BasicStroke());
    }

    private static void drawMainMap_Minimap(Graphics2D g) {
        for (Base_Artifact a : MapList.getListArtifact()) {
            String artifact;
            if (a.isHidden() || a.isAnimating() || !MassCreater.getMass(a.getMassPoint()).isVisible() && !EnchantSpecial.toushi() || !a.isVisible() && (a instanceof Base_Device || !Player.me.conditionCheck(CONDITION.\u76ee\u85ac) && !\u5370\u7f60\u5e2b.effect() || EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u63a2\u77e5))) continue;
            if (a instanceof \u795e\u968e\u6bb5) {
                if (!MassCreater.getMass(a.getMassPoint()).isVisible()) continue;
                g.setColor(C_GOLDSTAIR);
                artifact = "\u25a1";
            } else if (a instanceof Stairs) {
                if (!MassCreater.getMass(a.getMassPoint()).isVisible()) continue;
                g.setColor(C_DEVICE);
                artifact = "\u25a1";
            } else if (a instanceof \u6249) {
                if (!MassCreater.getMass(a.getMassPoint()).isVisible()) continue;
                g.setColor(C_DEVICE);
                artifact = "\u25ce";
            } else if (a instanceof Base_Trap) {
                g.setColor(C_TRAP);
                artifact = "\u00d7";
            } else if (a instanceof Base_Device) {
                g.setColor(C_DEVICE);
                artifact = "\u25a0";
            } else {
                Color c = a.isPunishment() || a.isMerchant() ? C_GOLDSTAIR : (a instanceof Base_Item && ((Base_Item)a).isPickCheked() ? C_ARTIFACT_CHECKED : C_ARTIFACT);
                if (MassCreater.getMass((Point)a.getMassPoint()).WATER) {
                    c = c.darker().darker();
                }
                g.setColor(c);
                artifact = "\u25a0";
            }
            MiniMap.drawMap(g, artifact, a.getMassPoint().x, a.getMassPoint().y);
        }
        boolean flag_toushi = EnchantSpecial.toushi();
        for (Base_Creature c : MapList.getListCreature()) {
            if (c.isPlayerSide() && (flag_toushi || c.isShownOnMiniMap())) {
                g.setColor(C_PLAYER);
                MiniMap.drawMap(g, "\u25cf", c.getMassPoint().x, c.getMassPoint().y);
                continue;
            }
            if (c.isFlagWarning()) {
                if (!CONDITION.isMovable(c) && !flag_toushi && !c.isShownOnMiniMap()) continue;
                boolean flag_swith = MainThread.getFrame() % 20 < 10;
                g.setColor(C_ENEMY);
                if (flag_swith) {
                    g.setColor(C_ENEMY);
                } else {
                    g.setColor(C_ARTIFACT);
                }
                Font f = g.getFont();
                int size = 9;
                g.setFont(f.deriveFont((float)size));
                MiniMap.drawMap(g, flag_swith ? "\u2605" : "\u2606", c.getMassPoint().x, c.getMassPoint().y, -size / 4);
                g.setFont(f);
                continue;
            }
            if (!flag_toushi && !c.isShownOnMiniMap()) continue;
            if (c instanceof Base_NPC) {
                if (c instanceof \u5b88\u77e2\u8cfd\u92ad\u7bb1) {
                    g.setColor(C_GOLDSTAIR);
                } else {
                    g.setColor(C_PLAYER);
                }
            } else {
                g.setColor(C_ENEMY);
            }
            MiniMap.drawMap(g, "\u25c6", c.getMassPoint().x, c.getMassPoint().y);
        }
        g.setColor(C_PLAYER);
        MiniMap.drawMap(g, MainThread.getFrame() % 20 < 10 ? "\u2468" : "\u25cf", Player.me.getMassPoint().x, Player.me.getMassPoint().y);
    }

    private static void drawMap(Graphics2D g, String symbol, int x, int y) {
        MiniMap.drawMap(g, symbol, x, y, 0);
    }

    private static void drawMap(Graphics2D g, String symbol, int x, int y, int delt) {
        g.drawString(symbol, MiniMap.getOrigineX() + x * 5 + delt, MiniMap.getOrigineY() + y * 5 + FONT_HEIGHT);
    }

    private static void drawWallLines(Graphics2D g, Mass m, int x_l, int y_t, int x_r, int y_b) {
        Mass m2 = m.get(DIRECTION.LEFT);
        if (!m2.WALKABLE) {
            MiniMap.setColor_Gird(g, m, m2);
            MiniMap.drawLine(g, x_l, y_t, x_l, y_b);
        }
        m2 = m.get(DIRECTION.RIGHT);
        if (!m2.WALKABLE) {
            MiniMap.setColor_Gird(g, m, m2);
            MiniMap.drawLine(g, x_r, y_t, x_r, y_b);
        }
        m2 = m.get(DIRECTION.UP);
        if (!m2.WALKABLE) {
            MiniMap.setColor_Gird(g, m, m2);
            MiniMap.drawLine(g, x_l, y_t, x_r, y_t);
        }
        m2 = m.get(DIRECTION.DOWN);
        if (!m2.WALKABLE) {
            MiniMap.setColor_Gird(g, m, m2);
            MiniMap.drawLine(g, x_l, y_b, x_r, y_b);
        }
        m2 = m.get(DIRECTION.UP_LEFT);
        if (!m2.WALKABLE && m.get((DIRECTION)DIRECTION.LEFT).WALKABLE && m.get((DIRECTION)DIRECTION.UP).WALKABLE) {
            MiniMap.setColor_Gird(g, m, m2);
            MiniMap.drawLine(g, x_l, y_t, x_l, y_t);
        }
        m2 = m.get(DIRECTION.UP_RIGHT);
        if (!m2.WALKABLE && m.get((DIRECTION)DIRECTION.RIGHT).WALKABLE && m.get((DIRECTION)DIRECTION.UP).WALKABLE) {
            MiniMap.setColor_Gird(g, m, m2);
            MiniMap.drawLine(g, x_r, y_t, x_r, y_t);
        }
        m2 = m.get(DIRECTION.DOWN_LEFT);
        if (!m2.WALKABLE && m.get((DIRECTION)DIRECTION.LEFT).WALKABLE && m.get((DIRECTION)DIRECTION.DOWN).WALKABLE) {
            MiniMap.setColor_Gird(g, m, m2);
            MiniMap.drawLine(g, x_l, y_b, x_l, y_b);
        }
        m2 = m.get(DIRECTION.DOWN_RIGHT);
        if (!m2.WALKABLE && m.get((DIRECTION)DIRECTION.RIGHT).WALKABLE && m.get((DIRECTION)DIRECTION.DOWN).WALKABLE) {
            MiniMap.setColor_Gird(g, m, m2);
            MiniMap.drawLine(g, x_r, y_b, x_r, y_b);
        }
    }

    private static void drawWarnings(Graphics2D g, Mass m, int x, int y) {
        Color c;
        boolean red;
        if (m.isTrapChecked()) {
            return;
        }
        boolean yellow = m.isWarningLarge(false) && !m.isWarningLarge(true);
        boolean bl = red = m.isWarningSmall(false) && !m.isWarningSmall(true);
        if (yellow && red) {
            c = Color.MAGENTA;
        } else if (yellow) {
            c = Color.YELLOW;
        } else if (red) {
            c = Color.RED;
        } else {
            return;
        }
        int w = 2;
        g.setColor(c.darker().darker());
        g.drawRect(x + 1, y + 1, w, w);
    }

    private static void drawWaterLines(Graphics2D g, Mass m, int x_l, int y_t, int x_r, int y_b) {
        if (!m.isWater_or_WaterLeef()) {
            return;
        }
        int[][][] ints = new int[][][]{new int[][]{{x_r, y_t + 1, x_r, y_b - 1}, {x_r, y_b, x_r, y_b}, {x_r, y_t, x_r, y_t}}, new int[][]{{x_l + 1, y_b, x_r - 1, y_b}, {x_l, y_b, x_l, y_b}, {x_r, y_b, x_r, y_b}}, new int[][]{{x_l, y_t + 1, x_l, y_b - 1}, {x_l, y_t, x_l, y_t}, {x_l, y_b, x_l, y_b}}, new int[][]{{x_l + 1, y_t, x_r - 1, y_t}, {x_r, y_t, x_r, y_t}, {x_l, y_t, x_l, y_t}}};
        int i = -1;
        boolean[] flag_drawn = new boolean[4];
        DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyBasic4();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            ++i;
            if (!m.get(d).isWater_or_WaterLeef()) {
                MiniMap.setWaterLinesColor(g, m);
                MiniMap.drawLine(g, ints[i][0][0], ints[i][0][1], ints[i][0][2], ints[i][0][3]);
                int j = 0;
                while (j < 2) {
                    DIRECTION d2 = d.getNeiboringDirection(-2 * (j * 2 - 1));
                    int num = DIRECTION.getDirection((int)(d.X + d2.X), (int)(d.Y + d2.Y)).ROTATE / 2;
                    if (!flag_drawn[num]) {
                        flag_drawn[num] = true;
                        if (!m.get(d2).isWater_or_WaterLeef() && m.isRoom()) {
                            g.setColor(MiniMap.getC_MAP(m));
                        } else {
                            MiniMap.setWaterLinesColor(g, m);
                        }
                        int k = j + 1;
                        MiniMap.drawLine(g, ints[i][k][0], ints[i][k][1], ints[i][k][2], ints[i][k][3]);
                    }
                    ++j;
                }
            }
            ++n2;
        }
    }

    private static void forceToAddPicture(Mass m) {
        m.setVisible(true);
        int x = m.X * 5;
        int y = m.Y * 5;
        Graphics2D g = (Graphics2D)IMAGE.getGraphics();
        MiniMap.setColor(g, m);
        g.fillRect(x, y, 5, 5);
        MiniMap.drawWarnings(g, m, x, y);
        int x_l = x;
        int x_r = x + 5 - 1;
        int y_t = y;
        int y_b = y + 5 - 1;
        MiniMap.drawWaterLines(g, m, x_l, y_t, x_r, y_b);
        MiniMap.drawFrozenWaterLines(g, m, x_l, y_t, x_r, y_b);
        MiniMap.drawWallLines(g, m, x_l, y_t, x_r, y_b);
        g.dispose();
        if (m.X < x_min) {
            x_min = m.X;
        }
        if (m.Y < y_min) {
            y_min = m.Y;
        }
        if (m.X > x_max) {
            x_max = m.X;
        }
        if (m.Y > y_max) {
            y_max = m.Y;
        }
    }

    private static Color getC_MAP(Mass m) {
        if (m.isTrapChecked()) {
            return C_MAP_CHECKED;
        }
        return C_MAP;
    }

    private static int getOrigineX() {
        int w = (x_max - x_min + 1) * 5;
        return 95 - w / 2 - x_min * 5;
    }

    private static int getOrigineY() {
        int h = (y_max - y_min + 1) * 5;
        return 150 - h / 2 - y_min * 5;
    }

    private static void openAroundTile(int x, int y) {
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                Mass m = MassCreater.getMass(x + i, y + j);
                if (m.isWalkable()) {
                    MiniMap.addPicture(m);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void openRoom(int x, int y) {
        MassCreater.getRoom(x, y).draw();
    }

    private static void openRoom_concated_path(int x, int y, ArrayList<Mass> list) {
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                Mass m = MassCreater.getMass(x + i, y + j);
                if (!list.contains(m) && m.isWalkable()) {
                    if (m.isRoom()) {
                        list.add(m);
                        MiniMap.openRoom_concated_path(x + i, y + j, list);
                    } else {
                        MiniMap.addPicture(m);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void openTiles() {
        Point p = Player.me.getMassPoint();
        MiniMap.openTiles(p.x, p.y);
        if (!MassCreater.isSpotValid()) {
            for (Mass m : MassCreater.getMasses_NotSpotValid(p.x, p.y)) {
                if (!m.isWalkable()) continue;
                MiniMap.addPicture(m);
            }
        }
    }

    private static void openTiles(int x, int y) {
        if (MassCreater.getMass(x, y).isRoom()) {
            if (MassCreater.getRoom(x, y).isDrawed()) {
                return;
            }
            MiniMap.openRoom_concated_path(x, y, new ArrayList<Mass>());
            MiniMap.openRoom(x, y);
        } else {
            MiniMap.openAroundTile(x, y);
        }
    }

    public static void reset() {
        x_max = -1;
        x_min = 40;
        y_max = -1;
        y_min = 30;
        IMAGE = new BufferedImage(200, 150, 3);
        Mass[][] massArray = MassCreater.getMass();
        int n = massArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mass[] m2;
            Mass[] massArray2 = m2 = massArray[n2];
            int n3 = m2.length;
            int n4 = 0;
            while (n4 < n3) {
                Mass m = massArray2[n4];
                if (m.isVisible()) {
                    MiniMap.forceToAddPicture(m);
                }
                ++n4;
            }
            ++n2;
        }
        MiniMap.openTiles();
    }

    private static void setColor(Graphics2D g, Mass m) {
        if (MassCreater.getRoom(m.X, m.Y) == null) {
            g.setColor(C_MAP_PATH);
        } else {
            DIRECTION d;
            int n;
            int n2;
            DIRECTION[] dIRECTIONArray;
            boolean flag;
            g.setColor(MiniMap.getC_MAP(m));
            if (m.isHoly()) {
                flag = false;
                dIRECTIONArray = DIRECTION.values_exceptNeatral();
                n2 = dIRECTIONArray.length;
                n = 0;
                while (n < n2) {
                    d = dIRECTIONArray[n];
                    if (!MassCreater.getMass(m.X + d.X, m.Y + d.Y).isHoly()) {
                        flag = true;
                        break;
                    }
                    ++n;
                }
                if (flag) {
                    g.setColor(C_HOLY);
                    return;
                }
            }
            if (m.isShop()) {
                flag = false;
                dIRECTIONArray = DIRECTION.values_exceptNeatral();
                n2 = dIRECTIONArray.length;
                n = 0;
                while (n < n2) {
                    d = dIRECTIONArray[n];
                    if (!MassCreater.getMass(m.X + d.X, m.Y + d.Y).isShop()) {
                        flag = true;
                        break;
                    }
                    ++n;
                }
                if (flag) {
                    g.setColor(new Color(17, 255, 17, 100));
                    return;
                }
            }
        }
    }

    private static void setColor_Gird(Graphics2D g, Mass m, Mass m2) {
        if (!m2.isDiggable()) {
            g.setStroke(new BasicStroke(1.0f, 0, 0, 2.0f));
        }
        if (m.ROOM) {
            g.setColor(new Color(120, 200, 200));
        } else {
            g.setColor(new Color(180, 180, 180));
        }
    }

    private static void setFrozenWaterLinesColor(Graphics2D g) {
        g.setColor(new Color(255, 255, 255));
    }

    private static void setWaterLinesColor(Graphics2D g, Mass m) {
        if (m.WATER) {
            g.setColor(new Color(20, 20, 255));
        } else {
            g.setColor(Color.GREEN);
        }
    }
}

