/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.anime;

import dangeon.view.anime.Base_Effect;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import main.util.BeautifulView;

public class ThunderEffect
extends Base_Effect {
    private final boolean flag_room;
    private Point delt_p;

    public ThunderEffect(boolean room) {
        this(room, new Point());
    }

    public ThunderEffect(boolean room, Point delt_p) {
        this.frame_image = new ArrayList(1);
        this.frame_image.add(this.loadImage("anime/biriri.png"));
        this.flag_room = room;
        this.delt_p = delt_p;
    }

    @Override
    protected boolean draw(Graphics2D g) {
        int max = 20;
        if (this.getFrame() == max) {
            return false;
        }
        int size_max = this.flag_room ? 600 : 100;
        int size = this.getFrame() > max / 3 ? size_max : size_max * this.getFrame() * 3 / max;
        double theta = this.getFrame() > max * 2 / 3 ? max * 2 / 3 : this.getFrame();
        theta *= 0.1;
        AffineTransform firts_at = g.getTransform();
        AffineTransform at = new AffineTransform(firts_at);
        at.translate(200 + this.delt_p.x, 170 + this.delt_p.y);
        g.setTransform(at);
        BeautifulView.setAlphaOnImg(g, new Float(0.2 * Math.sin(Math.PI * (double)this.getFrame() / (double)max)));
        g.setColor(Color.YELLOW);
        if (!this.flag_room) {
            g.fillOval(-size_max / 2, -size_max / 2, size_max, size_max);
            BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
            g.setTransform(firts_at);
            return true;
        }
        g.fillRect(-size_max / 2, -size_max / 2, size_max, size_max);
        BeautifulView.setAlphaOnImg(g, Float.valueOf(0.6f));
        g.drawImage((Image)this.frame_image.get(0), -size / 2, -size / 2, size, size, null);
        at.rotate(theta);
        g.setTransform(at);
        BeautifulView.setAlphaOnImg(g, Float.valueOf(0.1f));
        g.drawImage((Image)this.frame_image.get(0), -size / 2, -size / 2, size, size, null);
        BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
        g.setTransform(firts_at);
        return true;
    }
}

