/*
 * Decompiled with CFR 0.152.
 */
package dangeon.util;

import dangeon.model.object.Base_MapObject;
import dangeon.model.object.creature.player.Player;
import java.awt.Point;

public class ObjectPoint {
    public static Point getDangeonScreenPoint(int x, int y) {
        return new Point(50 * x, 50 * y);
    }

    public static Point getDangeonScreenPoint(Point mass_point) {
        int x = 50 * mass_point.x;
        int y = 50 * mass_point.y;
        return new Point(x, y);
    }

    public static Point getDifferenceBetweenMass_Screen(Base_MapObject o) {
        int x = o.getMassPoint().x * 50 - o.getScreenPoint().x;
        int y = o.getMassPoint().y * 50 - o.getScreenPoint().y;
        return new Point(x, y);
    }

    public static Point getDifferenceBetweenPlayer(int x, int y) {
        int dx = x - Player.me.getPureScreenPoint().x;
        int dy = y - Player.me.getPureScreenPoint().y;
        return new Point(dx, dy);
    }

    public static int getLengthBetweenPlayer(int x, int y) {
        int _x = Player.me.getMassPoint().x - x;
        int _y = Player.me.getMassPoint().y - y;
        return Math.max(Math.abs(_x), Math.abs(_y));
    }

    public static int getLengthBetweenPlayer(Point p) {
        int _x = Player.me.getMassPoint().x - p.x;
        int _y = Player.me.getMassPoint().y - p.y;
        return Math.max(Math.abs(_x), Math.abs(_y));
    }

    public static Point getMassPoint(Point screen_point) {
        int x = screen_point.x / 50;
        int y = screen_point.y / 50;
        return new Point(x, y);
    }

    public static Point getScreenPointRelPlayer(Base_MapObject o) {
        int x = 175;
        int y = 150;
        if (o.isJumping()) {
            y += o.getJumpDY();
        }
        if (o.equals(Player.me)) {
            return new Point(x + Player.me.getDeltX(), y + Player.me.getDeltY());
        }
        return new Point(x += o.getScreenPoint().x - Player.me.getPureScreenPoint().x, y += o.getScreenPoint().y - Player.me.getPureScreenPoint().y);
    }

    public static Point getScreenPointRelPlayer(int screen_x, int screen_y) {
        int dx = screen_x - Player.me.getPureScreenPoint().x;
        int dy = screen_y - Player.me.getPureScreenPoint().y;
        screen_x = 175 + dx;
        screen_y = 150 + dy;
        return new Point(screen_x, screen_y);
    }

    public static Point getScreenPointRelPlayer(Point screen_point) {
        int dx = screen_point.x - Player.me.getPureScreenPoint().x;
        int dy = screen_point.y - Player.me.getPureScreenPoint().y;
        int x = 175 + dx;
        int y = 150 + dy;
        return new Point(x, y);
    }

    public static boolean isNoDifferenceBetweenMass_Screen(Base_MapObject o) {
        int x = o.getMassPoint().x * 50 - o.getScreenPoint().x;
        int y = o.getMassPoint().y * 50 - o.getScreenPoint().y;
        return x == 0 && y == 0;
    }
}

