/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.player.save;

import dangeon.latest.scene.action.message.Message;
import dangeon.model.config.Config;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.map.field.random.Base_Map_Random;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.save.SaveLoad;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import main.constant.PropertySupporter;
import main.util.Show;

public class ResultSaveLoad
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int ATK;
    public final int DEF;
    public final int DIFFICULTY;
    public final Player PLAYER = Player.me;
    public final ArrayList<Base_Artifact> ITEMS;
    public final Base_Artifact[] ENCHANT_ARTIFACT;
    public final String FIELD_NAME;
    public final int FLOOR;
    public final String[] RECORD;
    public final int SCORE;
    public final int RANK;
    public final int LEFT_LIFE = Config.getRetryNumber() - 1;
    public final int SAVE_INDEX;
    public static final int MAX_RECORD = 30;
    private static PropertySupporter ps;

    public static String getNameDifficulty(Base_Map_Random.Difficulty difficulty) {
        return "_".concat(difficulty.name());
    }

    public static String getNameDifficulty(int difficulty) {
        return ResultSaveLoad.getNameDifficulty(Base_Map_Random.Difficulty.getFromIndex(difficulty));
    }

    public static String getRoot(String fileld_name, int difficulty) {
        StringBuilder sb = new StringBuilder();
        sb.append("save/");
        sb.append(fileld_name);
        if (difficulty >= 0) {
            sb.append(ResultSaveLoad.getNameDifficulty(difficulty));
        }
        return sb.toString();
    }

    public static String getURL(String fileld_name, int index, int difficulty) {
        StringBuilder sb = new StringBuilder();
        sb.append(ResultSaveLoad.getRoot(fileld_name, difficulty));
        sb.append("/");
        sb.append(index);
        sb.append(".save");
        return sb.toString();
    }

    public static ResultSaveLoad staticLoad(String fileld_name, int index, int difficulty) {
        String url = ResultSaveLoad.getURL(fileld_name, index, difficulty);
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(url));
            ResultSaveLoad me = (ResultSaveLoad)ois.readObject();
            ois.close();
            if (me.PLAYER.hash_restriction == null) {
                me.PLAYER.hash_restriction = new HashMap();
            }
            return me;
        }
        catch (Exception e) {
            System.out.println(fileld_name);
            System.out.println(index);
            System.out.println(difficulty);
            System.out.println(url);
            e.printStackTrace();
            Show.showInformationMessageDialog("\u30bb\u30fc\u30d6\u30d5\u30a1\u30a4\u30eb\u306e\u30c7\u30fc\u30bf\u304c\u58ca\u308c\u3066\u3044\u307e\u3059\u3002");
            return null;
        }
    }

    public static PropertySupporter getPropertySupporter(String name, int difficulty) {
        return new PropertySupporter(new File(ResultSaveLoad.getRoot(name, difficulty)));
    }

    public ResultSaveLoad(Base_Map_Random bmr) {
        this(bmr, true);
    }

    public ResultSaveLoad(Base_Map_Random bmr, boolean save) {
        if (bmr == null) {
            this.FIELD_NAME = null;
            this.DIFFICULTY = -1;
        } else if (Config.isHack_playing()) {
            String name = MassCreater.getHackName();
            this.FIELD_NAME = "[".concat(name.substring(0, 1)).concat("] ").concat(name.substring(1));
            this.DIFFICULTY = bmr.getDIFFICULTY().index;
        } else {
            this.FIELD_NAME = bmr.getMapName();
            this.DIFFICULTY = bmr.getDIFFICULTY().index;
        }
        this.FLOOR = MapList.getFloor();
        this.ITEMS = Belongings.getListItems();
        for (Base_Artifact a : this.ITEMS) {
            a.check();
        }
        this.ENCHANT_ARTIFACT = Enchant.savePresentEnchant();
        this.RECORD = Message.ME.getRecordToArray();
        if (this.RECORD.length > 0) {
            this.RECORD[this.RECORD.length - 1] = "";
        }
        this.ATK = Enchant.getSumSTR();
        this.DEF = Enchant.getSumDEF();
        int i = 1;
        if (!Config.isHack_playing()) {
            try {
                ps = new PropertySupporter(new File(ResultSaveLoad.getRoot(this.FIELD_NAME, this.DIFFICULTY)));
                Rank rank = new Rank();
                while (i < 31) {
                    if (!this.compare(ps.getProperty_Nature(this.getKey(i)), rank)) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.RANK = i;
        this.SAVE_INDEX = Config.getSaveIndex();
        this.SCORE = this.RANK * 1000;
        if (save) {
            this.save();
        }
    }

    private boolean compare(Object object, Rank rank) {
        if (object == null) {
            return true;
        }
        String[] arr = object.toString().split(",");
        if (arr.length == 1) {
            return true;
        }
        int[] arr_i = new int[arr.length - 1];
        int i = 0;
        while (i < arr_i.length) {
            arr_i[i] = Integer.valueOf(arr[i]);
            ++i;
        }
        i = rank.compareTo(arr_i[0], arr_i[1], arr_i[2], arr_i[3], arr_i[4], Long.valueOf(arr[arr.length - 1]));
        return i <= 0;
    }

    private void createConfig(File root) throws IOException {
        File newfile = new File(root + "/config.properties");
        newfile.createNewFile();
        ps = new PropertySupporter(root);
        int i = 1;
        while (i < 31) {
            ps.saveProperty(this.getKey(i), -1);
            ++i;
        }
    }

    private File getFile(int i) {
        return new File(ResultSaveLoad.getURL(this.FIELD_NAME, i, this.DIFFICULTY));
    }

    private String getKey(int i) {
        return "r".concat(String.valueOf(i));
    }

    private File getTemporaryFile(int i) {
        return new File(ResultSaveLoad.getURL(".", i, -1));
    }

    private void save() {
        SaveLoad.delete();
        if (this.FIELD_NAME == null) {
            return;
        }
        try {
            if (Config.isHack_playing()) {
                int max = 10;
                File file = this.getTemporaryFile(max);
                file.createNewFile();
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(this);
                oos.close();
                File f = this.getTemporaryFile(max - 1);
                if (f.exists()) {
                    f.delete();
                }
                int i = max - 2;
                while (i >= 0) {
                    f = this.getTemporaryFile(i);
                    if (f.exists()) {
                        f.renameTo(this.getTemporaryFile(i + 1));
                    }
                    --i;
                }
                file.renameTo(this.getTemporaryFile(0));
            } else {
                File root = new File(ResultSaveLoad.getRoot(this.FIELD_NAME, this.DIFFICULTY));
                if (!root.exists() && !root.mkdir()) {
                    Show.showErrorMessageDialog("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\n\u30ea\u30b6\u30eb\u30c8\u30c7\u30fc\u30bf\u306f\u7834\u68c4\u3055\u308c\u307e\u3059");
                    return;
                }
                if (!new File(root + "/config.properties").exists()) {
                    this.createConfig(root);
                }
                if (this.RANK <= 30) {
                    File file = this.getFile(0);
                    file.createNewFile();
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
                    oos.writeObject(this);
                    oos.close();
                    File f = this.getFile(30);
                    if (f.exists()) {
                        f.delete();
                    }
                    int i = 30;
                    while (i > this.RANK) {
                        f = this.getFile(i - 1);
                        if (f.exists()) {
                            f.renameTo(this.getFile(i));
                        }
                        System.out.println(i);
                        ps.saveProperty(this.getKey(i), ps.getProperty_Nature(this.getKey(i - 1)));
                        --i;
                    }
                    file.renameTo(this.getFile(this.RANK));
                    StringBuilder sb = new StringBuilder();
                    Rank rank = new Rank();
                    sb.append(rank.floor);
                    sb.append(",");
                    sb.append(rank.flag_clear);
                    sb.append(",");
                    sb.append(rank.flag_item);
                    sb.append(",");
                    sb.append(rank.flag_item_daichan);
                    sb.append(",");
                    sb.append(rank.life);
                    sb.append(",");
                    sb.append(rank.time);
                    ps.saveProperty(this.getKey(this.RANK), sb.toString());
                }
            }
        }
        catch (Exception e) {
            Show.showErrorMessageDialog(e);
        }
    }

    public class Rank {
        final int floor;
        final int life;
        final int flag_clear;
        final int flag_item;
        final int flag_item_daichan;
        final long time;

        public Rank() {
            this.floor = ResultSaveLoad.this.FLOOR;
            String result = ResultSaveLoad.this.PLAYER.cause_of_death;
            this.flag_clear = Player.flag_clear ? 1 : -1;
            this.flag_item = ResultSaveLoad.this.PLAYER.flag_no_item ? 1 : -1;
            this.flag_item_daichan = ResultSaveLoad.this.PLAYER.flag_no_item_daichan ? 1 : -1;
            this.time = ResultSaveLoad.this.PLAYER.getPlayingMilliTime();
            this.life = ResultSaveLoad.this.LEFT_LIFE;
        }

        public int compareTo(int floor, int flag_clear, int flag_item, int flag_item_daichan, int life, long time) {
            long dt = this.time - time;
            int t = dt > 0L ? -1 : (dt < 0L ? 1 : 0);
            int[] c = new int[]{this.floor - floor, this.flag_clear - flag_clear, this.flag_item - flag_item, this.flag_item_daichan - flag_item_daichan, this.life - life, t};
            int i = 0;
            while (i < c.length) {
                if (c[i] != 0) {
                    return c[i] * -1;
                }
                ++i;
            }
            return 0;
        }
    }
}

