/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.player.hold_enemy;

import dangeon.controller.TurnSystemController;
import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.EnemyFall;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.npc.\u8cfd\u92ad\u7bb1;
import dangeon.model.object.creature.player.Player;
import dangeon.util.MapInSelect;
import dangeon.view.constant.NormalFont;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.util.ArrayList;
import main.res.SE;
import main.util.BeautifulView;
import main.util.DIRECTION;

public class HoldEnemy {
    public static HoldEnemy ME = new HoldEnemy();
    private Base_Enemy E = null;
    private int throw_max = 5;
    private int timer = 0;
    private int INTERVAL = 100;

    private static void draw(Graphics2D g, String s1, String s2, int x, int y) {
        String name = s1.concat(s2);
        int w = g.getFontMetrics().stringWidth(StringFilter.getPlainString(name));
        int h = g.getFontMetrics().getHeight();
        g.setPaint(new GradientPaint(x, (y += g.getFontMetrics().getHeight() + 11) - h, new Color(0, 0, 255, 100), x, y, new Color(0, 0, 100, 100)));
        g.fillRect(x, y - h + 2, w, h);
        g.setColor(Color.WHITE);
        g.drawRect(x, y - h + 2, w, h);
        StringFilter.drawString(g, name, x, y);
    }

    public int draw(Graphics2D g, int x, int y) {
        if (this.E != null) {
            Image im = this.E.getCharacterImage().getWalkImage(this.E.getLV(), DIRECTION.DOWN, 0.0f);
            int rect_size = 33;
            int percent = im.getWidth(null) * 2 / 3;
            int _x = x - (percent - rect_size) / 2;
            int _y = y - (percent - rect_size) / 2;
            Shape s = g.getClip();
            g.setClip(x, y, rect_size, rect_size);
            g.drawImage(im, _x, _y, percent, percent, Color.WHITE, null);
            g.setClip(s);
            g.setColor(Color.BLACK);
            g.drawRect(x, y, rect_size, rect_size);
            g.setColor(Color.WHITE);
            StringFilter.drawEnchant(g, x, y += 20);
            g.setFont(NormalFont.NORMALFONT.deriveFont(10.0f));
            if (this.timer > 0) {
                --this.timer;
                BeautifulView.setAlphaOnImg(g, new Float((double)this.timer / (double)this.INTERVAL));
                HoldEnemy.draw(g, "\u4f7f\u7528\uff1a\u3000", this.E.getExplanHoldAction(), x, y);
                BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
            }
            return rect_size + 2;
        }
        return 0;
    }

    public Base_Enemy get() {
        return this.E;
    }

    private int getThrowMax() {
        return this.throw_max;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hold() {
        if (this.E != null) {
            Message.set("\u88c5\u5099\u3067\u304d\u308b\u30a8\u30cd\u30df\u30fc\u306f1\u4f53\u307e\u3067\u3060\u305e");
            return false;
        }
        final Base_Enemy em = MapInSelect.getFrontEnemyFromCreature(Player.me);
        if (em == null) {
            SE.SYSTEM_MENU.play();
            Message.set("\u76ee\u306e\u524d\u306b\u6575\u306f\u3044\u306a\u3044\u305e");
            return false;
        }
        if (em instanceof \u8cfd\u92ad\u7bb1) {
            SE.SYSTEM_MENU.play();
            Message.set("\u76ee\u306e\u524d\u306b\u6575\u306f\u3044\u306a\u3044\u305e");
            return false;
        }
        this.timer = this.INTERVAL;
        SE.WARP_INSTANT.play();
        TurnSystemController.callMeToStartEnemyTurn();
        em.setMassPoint_ParabolaJump_Smalling(Player.me.getMassPoint(), new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                SE.SYSTEM_ENCHANT.play();
                Message.set(em.getColoredName(), "\u3092\u88c5\u5099\u3057\u305f");
                em.setMassPoint(new Point(0, 0));
                MapList.removeEnemy(em);
                HoldEnemy.this.E = em;
            }
        });
        return true;
    }

    public boolean isHold() {
        return this.E != null;
    }

    public void reset() {
        this.E = null;
    }

    public boolean specialAction() {
        if (this.E == null) {
            Message.set("\u6575\u3092\u88c5\u5099\u3057\u3066\u3044\u306a\u3044\u306e\u3067\u80fd\u529b\u306f\u4f7f\u3048\u306a\u3044");
            return false;
        }
        if (!this.E.enchantEnemySpecialAction()) {
            Player.me.normalAttack();
        }
        TurnSystemController.callMeToStartEnemyTurn();
        return true;
    }

    public boolean throwEnemy() {
        if (this.E == null) {
            return false;
        }
        Point p = Player.me.getMassPoint();
        DIRECTION d = Player.me.getDirection();
        int _x = d.X;
        int _y = d.Y;
        ArrayList<Point> list = new ArrayList<Point>();
        int i = 1;
        while (i <= this.getThrowMax()) {
            if (i != 1) {
                _x += d.X;
                _y += d.Y;
            }
            Point _p = new Point(p.x + _x, p.y + _y);
            if (!MassCreater.getMass((Point)_p).WALKABLE) break;
            if (!MassCreater.getMass((Point)_p).WATER) {
                list.add(_p);
            }
            ++i;
        }
        if (list.isEmpty()) {
            SE.SYSTEM_MENU.play();
            Message.set("\u76ee\u6a19\u70b9\u304c\u57cb\u307e\u3063\u3066\u3044\u3066\u6295\u3052\u3089\u308c\u306a\u3044");
            return false;
        }
        SE.THROW_HEAVY.play();
        this.throwing((Point)list.get(list.size() - 1));
        TurnSystemController.callMeToStartEnemyTurn();
        return true;
    }

    private void throwing(Point goal) {
        MapList.addEnemy(this.E);
        this.E.setMassPoint(Player.me.getMassPoint());
        this.E.setMassPoint_ParabolaJump_Undo(EnemyFall.getPoint(goal), new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
            }
        });
        this.E = null;
    }
}

