/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.player.class_job;

import dangeon.controller.task.Task;
import dangeon.model.condition.CONDITION;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.class_job.bonus.BaseBonus;
import dangeon.model.object.creature.player.class_job.bonus.BonusSpecialAction;
import dangeon.view.detail.View_Sider;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import main.res.BGM;
import main.res.CHARA_IMAGE;
import main.res.Image_LargeCharacter;
import main.util.Show;

public abstract class BaseClassJob
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final SpellCard s;
    private ArrayList<ENCHANT_SIMBOL> list_enchant_simbol = new ArrayList();
    private final HashMap<Integer, Boolean> swich_map = new HashMap(5);
    private BonusSpecialAction sp_action = null;
    protected int lv = 0;
    public final HashMap<CONDITION, Integer> condition_map = new HashMap();
    public final ArrayList<Task> end_task_map = new ArrayList();

    public BaseClassJob() {
        this.s = this.getRep();
    }

    public void addCondition(CONDITION condition, int time) {
        this.condition_map.put(condition, time);
    }

    public void addEndTask(Task task) {
        this.end_task_map.add(task);
    }

    public int addLv(ArrayList<Base_Artifact> list) {
        this.setSaisenListLv(++this.lv, list);
        return this.lv;
    }

    protected abstract void bonusLv1(ArrayList<BaseBonus> var1, Point var2);

    protected abstract void bonusLv2(ArrayList<BaseBonus> var1, Point var2);

    protected abstract void bonusLv3(ArrayList<BaseBonus> var1, Point var2);

    public boolean checkSimbol(ENCHANT_SIMBOL e) {
        return this.list_enchant_simbol.contains((Object)e);
    }

    public boolean checkSpec() {
        return this.sp_action != null;
    }

    public boolean checkSwicth(int child) {
        Boolean b = this.swich_map.get(child);
        return b != null && b != false;
    }

    public String className() {
        return this.getClass().getSimpleName().substring(5);
    }

    protected abstract void firstDemerite(ArrayList<BaseBonus> var1, Point var2);

    protected abstract void firstMerite(ArrayList<BaseBonus> var1, Point var2);

    public BGM getBGM() {
        if (this.s == null) {
            return BGM.kanpyo_ch2_fff;
        }
        return BGM.get(this.s.getClass());
    }

    public CHARA_IMAGE getCharaImage() {
        try {
            Constructor<? extends Base_Enemy> con = this.s.getStand().getConstructor(Point.class, Integer.TYPE);
            Base_Enemy obj = con.newInstance(this.s.getMassPoint(), 0);
            return obj.getCharacterImage();
        }
        catch (Exception e) {
            e.printStackTrace();
            Show.showErrorMessageDialog(e);
            return null;
        }
    }

    public String getExn() {
        return "";
    }

    public Image_LargeCharacter getIMLC() {
        if (this.s != null) {
            return this.s.IMLC;
        }
        return null;
    }

    public int getLv() {
        return this.lv;
    }

    protected abstract SpellCard getRep();

    public String[] getSelectingExn() {
        ArrayList<String> list = new ArrayList<String>();
        Color[] cs = new Color[]{Color.ORANGE, Color.RED, StringFilter.NUMBERS, Color.WHITE, Color.WHITE, Color.WHITE};
        list.add("\u30af\u30e9\u30b9\u3000" + cs[0] + "\u3010" + this.className() + "\u3011");
        Point p = Player.me.getMassPoint();
        int i = 1;
        while (i < cs.length) {
            String intend;
            ArrayList<BaseBonus> l = new ArrayList<BaseBonus>();
            if (i == 1) {
                intend = "\u4ee3\u511f\u3000\u3000";
                this.firstDemerite(l, p);
            } else if (i == 2) {
                intend = "\u30dc\u30fc\u30ca\u30b9";
                this.firstMerite(l, p);
            } else if (i == 3) {
                intend = "\uff2c\uff36\uff11\u3000";
                this.bonusLv1(l, p);
            } else if (i == 4) {
                intend = "\uff2c\uff36\uff12\u3000";
                this.bonusLv2(l, p);
            } else if (i == 5) {
                intend = "\uff2c\uff36\uff13\u3000";
                this.bonusLv3(l, p);
            } else {
                intend = "";
            }
            if (l.isEmpty()) {
                list.add(cs[i] + intend + "\uff08\u306a\u3057\uff09");
            } else {
                for (BaseBonus baseBonus : l) {
                    list.add(cs[i] + intend + "\u3010" + baseBonus.getEffectExn() + cs[i] + "\u3011");
                    intend = "\u3000\u3000\u3000\u3000";
                }
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public ArrayList<ENCHANT_SIMBOL> getSimbols() {
        return this.list_enchant_simbol;
    }

    public abstract String getSwitchExp();

    public void newMapAction() {
        for (CONDITION c : this.condition_map.keySet()) {
            Player.me.setConditionNeglectResist(c, this.condition_map.get((Object)c));
        }
    }

    public int setLv(int lv) {
        this.lv = lv;
        return this.lv;
    }

    public void setSaisenListLv(int lv, ArrayList<Base_Artifact> list) {
        Point p = Player.me.getMassPoint();
        ArrayList<BaseBonus> l = new ArrayList<BaseBonus>();
        if (lv == 0) {
            this.firstDemerite(l, p);
            this.firstMerite(l, p);
        } else if (lv == 1) {
            this.bonusLv1(l, p);
        } else if (lv == 2) {
            this.bonusLv2(l, p);
        } else if (lv == 3) {
            this.bonusLv3(l, p);
        }
        if (!l.isEmpty()) {
            View_Sider.setInformation("\u4ee5\u4e0b\u306e\u52b9\u679c\u3092\u5f97\u307e\u3057\u305f");
            for (BaseBonus baseBonus : l) {
                baseBonus.excute(list, this.list_enchant_simbol);
                View_Sider.setInformation("\u3010" + baseBonus.getEffectExn() + "\u3011");
            }
        }
    }

    public void setSwichON(BonusSpecialAction bonusSpecialAction) {
        this.sp_action = bonusSpecialAction;
    }

    public void setSwichON(int child) {
        this.swich_map.put(child, true);
    }

    public void specExcute() {
        if (this.sp_action != null) {
            this.sp_action.excute();
        }
    }

    public void turnEndAction() {
        for (Task task : this.end_task_map) {
            task.work();
        }
    }
}

