/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.player;

import dangeon.model.condition.CONDITION;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.enemy.CardAttackEffect;
import dangeon.model.object.creature.enemy.Ex\u30eb\u30fc\u30df\u30a2;
import dangeon.model.object.creature.player.Player;
import dangeon.util.ObjectPoint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import main.util.BeautifulView;
import main.util.DIRECTION;

public class Stand {
    public final Base_Enemy E;
    private int dx = 0;
    private int dy = 0;
    final DIRECTION D;
    private int attacking_frame = 0;
    private int attack_No = 0;
    private float alpha = 1.1f;
    public final int SCREEN_X;
    public final int SCREEN_Y;
    private boolean end = false;
    private final boolean FLAG_FARTHER;
    private final boolean FLAG_NO_MOVE;
    private final int LV;
    private boolean lastAttackNoChange = false;

    Stand(Class<? extends Base_Enemy> clazz, DIRECTION d, boolean isStandAttacking2MassFurther, int lv) {
        this(clazz, d, isStandAttacking2MassFurther, lv, Player.me.getMassPoint());
    }

    Stand(Class<? extends Base_Enemy> clazz, DIRECTION d, boolean isStandAttacking2MassFurther, int lv, Point p) {
        this.LV = lv;
        Base_Enemy obj = null;
        try {
            Constructor<? extends Base_Enemy> con = clazz.getConstructor(Point.class, Integer.TYPE);
            obj = con.newInstance(p, 1);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.E = obj;
        this.E.setPlayerSide(true);
        this.D = d;
        this.E.setDirection(this.D);
        this.E.startAttack(null);
        this.SCREEN_X = this.E.getScreenPoint().x;
        this.SCREEN_Y = this.E.getScreenPoint().y;
        this.FLAG_FARTHER = isStandAttacking2MassFurther;
        if (this.E instanceof CardAttackEffect) {
            this.dx += this.D.X * 10;
            this.dy += this.D.Y * 10;
        }
        this.FLAG_NO_MOVE = this.E instanceof Ex\u30eb\u30fc\u30df\u30a2;
    }

    private void back() {
        int sig;
        Point p = ObjectPoint.getDifferenceBetweenPlayer(this.SCREEN_X + this.dx, this.SCREEN_Y + this.dy);
        if (Math.abs(p.x) < this.Speed() && Math.abs(p.y) < this.Speed()) {
            this.end = true;
            return;
        }
        if (p.x != 0) {
            sig = p.x > 0 ? 1 : -1;
            this.dx -= this.Speed() * sig;
        }
        if (p.y != 0) {
            sig = p.y > 0 ? 1 : -1;
            this.dy -= this.Speed() * sig;
        }
        Point _p = ObjectPoint.getDifferenceBetweenPlayer(this.SCREEN_X + this.dx, this.SCREEN_Y + this.dy);
        if (p.x * _p.x < 0) {
            this.dx -= _p.x;
        }
        if (p.y * _p.y < 0) {
            this.dy -= _p.y;
        }
    }

    public boolean end() {
        return this.end;
    }

    public int getFootX() {
        return this.E.getFootX() + this.dx;
    }

    public int getFootY() {
        return this.E.getFootY() + this.dy;
    }

    public Image getImage(Graphics2D g) {
        float a = this.alpha;
        if (a < 0.0f) {
            a = 0.0f;
        } else if (a > 1.0f) {
            a = 1.0f;
        }
        BeautifulView.setAlphaOnImg(g, Float.valueOf(a));
        return this.E.getATKImage(this.LV, this.D, this.attack_No);
    }

    private void move() {
        if (this.FLAG_NO_MOVE) {
            return;
        }
        int range = 16;
        if (this.FLAG_FARTHER) {
            range = 50;
        }
        if (this.E instanceof CardAttackEffect) {
            range += 33;
        }
        if (Math.abs(this.dx) <= range && Math.abs(this.dy) <= range) {
            this.dx += this.D.X * 10;
            this.dy += this.D.Y * 10;
            if (this.FLAG_FARTHER) {
                this.dx += this.D.X * 10;
                this.dy += this.D.Y * 10;
            }
        }
    }

    private int Speed() {
        int speed = Player.me.isDushing() && Player.me.isMoving() ? 51 : 11;
        if (this.FLAG_FARTHER) {
            speed *= 2;
        }
        return speed;
    }

    void upDate() {
        this.alpha -= 0.03f;
        ++this.attacking_frame;
        if (!this.lastAttackNoChange) {
            Player.me.conditionCheck(CONDITION.\u920d\u8db3);
            this.E.upDate();
            this.attack_No = this.E.getAttackNo();
            boolean bl = this.lastAttackNoChange = this.attacking_frame > 9;
        }
        if (this.attacking_frame < 3) {
            return;
        }
        if (this.attacking_frame < 20) {
            this.move();
        } else if (this.E instanceof CardAttackEffect) {
            this.end = true;
        } else {
            this.back();
        }
    }
}

