/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.player;

import dangeon.controller.listener.menu.ENCHANT;
import dangeon.latest.scene.action.menu.first.adventure.medal.Medal;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.config.Config;
import dangeon.model.map.PresentField;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.artifact.item.spellcard.set.BSE;
import dangeon.model.object.artifact.item.spellcard.set.SetEnchantCard;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.class_job.bonus.bonus_switch.BonusConductor;
import dangeon.view.detail.View_Sider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import main.res.BGM;
import main.res.SE;

public enum Enchant {
    ATK(0),
    DEF(1),
    ANY1(2),
    ANY2(3),
    ANY3(4);

    public final int y;
    public static final int LENGTH;
    public static final int NON_ANY_LENGTH = 2;
    public static final int ANY_LENGTH;
    private Base_Artifact enchanted_now = null;
    public static final Color CL_ATK;
    public static final Color CL_DEF;
    public static final Color CL_ANY1;
    public static final Color CL_ANY2;
    public static final Color CL_ANY3;

    static {
        LENGTH = Enchant.values().length;
        ANY_LENGTH = Enchant.values().length - 2;
        CL_ATK = new Color(255, 10, 50);
        CL_DEF = Color.ORANGE;
        CL_ANY1 = Color.MAGENTA;
        CL_ANY2 = new Color(0, 220, 255);
        CL_ANY3 = new Color(150, 255, 80);
    }

    public static void forceToRemove(Base_Artifact a) {
        Enchant[] enchantArray = Enchant.values();
        int n = enchantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant e = enchantArray[n2];
            if (a.equals(e.enchanted_now)) {
                e.enchanted_now = null;
            }
            ++n2;
        }
    }

    public static Enchant get(int y) {
        Enchant[] enchantArray = Enchant.values();
        int n = enchantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant c = enchantArray[n2];
            if (c.y == y) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static Enchant[] getALL() {
        return new Enchant[]{ATK, DEF, ANY1, ANY2, ANY3};
    }

    public static Enchant[] getANYS() {
        return Player.me.getAnys();
    }

    public static Enchant getEnchantedPlace(Base_Artifact a) {
        Enchant[] enchantArray = Enchant.values();
        int n = enchantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant e = enchantArray[n2];
            if (a.equals(e.enchanted_now)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static List<Base_Artifact> getEnchantList() {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>();
        Enchant[] enchantArray = Enchant.values();
        int n = enchantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant e = enchantArray[n2];
            if (e.enchanted_now != null) {
                list.add(e.enchanted_now);
            }
            ++n2;
        }
        System.out.println(list);
        return list;
    }

    public static List<Base_Artifact> getEnchantListOfAny() {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>();
        if (Enchant.ANY1.enchanted_now != null) {
            list.add(Enchant.ANY1.enchanted_now);
        }
        if (Enchant.ANY2.enchanted_now != null) {
            list.add(Enchant.ANY2.enchanted_now);
        }
        if (Enchant.ANY3.enchanted_now != null) {
            list.add(Enchant.ANY3.enchanted_now);
        }
        return list;
    }

    public static ArrayList<Enchant> getListANY() {
        ArrayList<Enchant> list = new ArrayList<Enchant>();
        if (ANY1.isEnchant()) {
            list.add(ANY1);
        }
        if (ANY2.isEnchant()) {
            list.add(ANY2);
        }
        return list;
    }

    private static int getSum(Base_Artifact.STATUS s) {
        int status_value = 0;
        status_value += EnchantSpecial.staffPlusStatus(s);
        if (s == Base_Artifact.STATUS.STR) {
            status_value += EnchantSpecial.attackValue();
            if (Enchant.ATK.enchanted_now != null) {
                status_value += BSE.STR.isCheck() ? BSE.STR.getValue() : 0;
                status_value += Enchant.ATK.enchanted_now.itemEnchantPower(s);
                status_value += Enchant.ATK.enchanted_now.getForgeValue();
            }
            Medal.\u653b\u6483\u529b.save_the_more(status_value);
        } else {
            status_value += EnchantSpecial.deffeceValue();
            if (Enchant.DEF.enchanted_now != null) {
                status_value += BSE.DEF.isCheck() ? BSE.DEF.getValue() : 0;
                status_value += Enchant.DEF.enchanted_now.itemEnchantPower(s);
                status_value += Enchant.DEF.enchanted_now.getForgeValue();
            }
            Medal.\u9632\u5fa1\u529b.save_the_more(status_value);
        }
        if (status_value < 0) {
            status_value = 0;
        }
        return status_value;
    }

    public static int getSumDEF() {
        return Enchant.getSum(Base_Artifact.STATUS.DEF);
    }

    public static int getSumSTR() {
        return Enchant.getSum(Base_Artifact.STATUS.STR);
    }

    public static boolean isAnyANYEnchant() {
        int y = 0;
        while (y < ANY_LENGTH) {
            if (Enchant.get(2 + y).isEnchant()) {
                return true;
            }
            ++y;
        }
        return false;
    }

    public static boolean isEnchanted(Base_Artifact a) {
        Enchant[] enchantArray = Enchant.values();
        int n = enchantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant e = enchantArray[n2];
            if (a.equals(e.enchanted_now)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isEnchantSpace() {
        return Enchant.getEnchantList().size() <= 4;
    }

    public static void itemFreeze(Base_Artifact a) {
        Enchant[] ens;
        Enchant[] enchantArray = ens = BonusConductor.\u3072\u306d\u304f\u308c\u8005_\u6c37\u88c5\u5099\u7981\u6b62() ? Enchant.getALL() : Enchant.getANYS();
        int n = ens.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant en = enchantArray[n2];
            if (en.isEquals(a)) {
                Message.set(a.getColoredName(), "\u306f\u51cd\u3063\u3066\u3057\u307e\u3044", en.toString(), "\u304b\u3089\u5916\u308c\u305f");
                View_Sider.setInformation(a.getColoredName(), "\u304c\u51cd\u3063\u3066", en.toString(), "\u304b\u3089\u5916\u308c\u307e\u3057\u305f");
                Enchant.forceToRemove(a);
                break;
            }
            ++n2;
        }
        Player.me.updateStatus();
    }

    public static void loadPresentEnchant(Base_Artifact[] as) {
        int i = 0;
        while (i < as.length) {
            Enchant.values()[i].enchanted_now = as[i];
            ++i;
        }
    }

    public static Base_Artifact[] savePresentEnchant() {
        Base_Artifact[] as = new Base_Artifact[Enchant.values().length];
        int i = 0;
        while (i < as.length) {
            as[i] = Enchant.values()[i].enchanted_now;
            ++i;
        }
        return as;
    }

    public static void allRemove() {
        Enchant[] enchantArray = Enchant.values();
        int n = enchantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant e = enchantArray[n2];
            e.enchanted_now = null;
            ++n2;
        }
    }

    public static void check(ENCHANT_SIMBOL es, boolean no_tokidoki_check) {
        Enchant[] enchantArray = Enchant.values();
        int n = enchantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant e = enchantArray[n2];
            Base_Artifact a = e.getEnchant();
            if (a != null && a.sim == es) {
                a.enchantCheck(no_tokidoki_check);
            }
            ++n2;
        }
    }

    public static boolean tryToRemove(Base_Artifact a) {
        boolean flag = false;
        Enchant[] enchantArray = Enchant.values();
        int n = enchantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant e = enchantArray[n2];
            if (a.equals(e.enchanted_now)) {
                flag = e.tryToRemove() || flag;
            }
            ++n2;
        }
        if (flag) {
            SE.SYSTEM_ENCHANT_OFF.play();
        }
        return flag;
    }

    private Enchant(int y) {
        this.y = y;
    }

    public void forceToRemove() {
        this.enchanted_now = null;
    }

    public Color getColor() {
        switch (this) {
            case ATK: {
                return CL_ATK;
            }
            case DEF: {
                return CL_DEF;
            }
            case ANY1: {
                return CL_ANY1;
            }
            case ANY2: {
                return CL_ANY2;
            }
            case ANY3: {
                return CL_ANY3;
            }
        }
        return Color.BLACK;
    }

    public Color getColorWithForbitten() {
        if (this.enchanted_now != null && this.enchanted_now.isCurse()) {
            return Color.BLUE;
        }
        if (ENCHANT.isSelectedArtifactSpellCard()) {
            return this.getColor();
        }
        if (this.isMeANY()) {
            return this.getColor();
        }
        return Color.BLUE;
    }

    public Base_Artifact getEnchant() {
        return this.enchanted_now;
    }

    public SpellCard getEnchant_Casted_SpellCard() {
        return (SpellCard)this.enchanted_now;
    }

    public boolean isAbleToExchange(Base_Artifact old, Enchant old_place) {
        if (old_place == null || old == null) {
            return false;
        }
        if (this == old_place) {
            return false;
        }
        if (this.enchanted_now instanceof SpellCard && old instanceof SpellCard) {
            return true;
        }
        return this.isMeANY() && old_place.isMeANY();
    }

    public boolean isEnchant() {
        return this.enchanted_now != null;
    }

    public boolean isEnchantEmpty() {
        return this.enchanted_now == null;
    }

    public boolean isEquals(Base_Artifact a) {
        return a.equals(this.enchanted_now);
    }

    public boolean isMeANY() {
        int y = 0;
        while (y < ANY_LENGTH) {
            if (this == Enchant.get(2 + y)) {
                return true;
            }
            ++y;
        }
        return false;
    }

    public boolean isMeNONANY() {
        int y = 0;
        while (y < 2) {
            if (this == Enchant.get(y)) {
                return true;
            }
            ++y;
        }
        return false;
    }

    private boolean isSetAnyPossition() {
        switch (this) {
            case ATK: {
                return false;
            }
            case DEF: {
                return false;
            }
        }
        return true;
    }

    public void setEnchant(Base_Artifact a) {
        if (a != null && a != this.enchanted_now) {
            Player.me.hash_restriction.put(this, false);
        }
        this.enchanted_now = a;
        if (this.enchanted_now != null) {
            ENCHANT_SIMBOL eNCHANT_SIMBOL = this.enchanted_now.sim;
        }
    }

    public String toColoredString() {
        return this.getColor().toString().concat(this.toString()).concat(Color.WHITE.toString());
    }

    public String toString() {
        switch (this) {
            case ATK: {
                return "\u653b\u6483";
            }
            case DEF: {
                return "\u9632\u5fa1";
            }
            case ANY1: {
                return "\u4f55\u3067\u3082(\uff11)";
            }
            case ANY2: {
                return "\u4f55\u3067\u3082(\uff12)";
            }
            case ANY3: {
                return "\u4f55\u3067\u3082(\uff13)";
            }
        }
        return "\u30a8\u30e9\u30fc";
    }

    public boolean tryToRemove() {
        if (this.enchanted_now == null) {
            return false;
        }
        if (this.enchanted_now.isCurse()) {
            Message.set(this.enchanted_now.getColoredName().concat("\u306f\u546a\u308f\u308c\u3066\u3044\u3066\u5916\u305b\u306a\u3044\uff01"));
            return false;
        }
        Message.set(this.enchanted_now.getColoredName().concat("\u3092").concat(this.toColoredString()).concat("\u304b\u3089\u5916\u3057\u305f"));
        this.enchanted_now = null;
        return true;
    }

    public boolean tryToSet(Base_Artifact selected_artifact) {
        SetEnchantCard sec;
        boolean flag_checked = selected_artifact.isCurse_And_isItViewed();
        if (selected_artifact.isFrozen()) {
            if (BonusConductor.\u3072\u306d\u304f\u308c\u8005_\u6c37\u88c5\u5099\u7981\u6b62()) {
                Message.set(selected_artifact.getColoredName(), "\u306f\u51cd\u3063\u3066\u3044\u308b\u70ba", "%", "\u88c5\u5099\u3059\u308b\u6c17\u306b\u306a\u308c\u306a\u3044");
                return false;
            }
            if (this.isSetAnyPossition()) {
                Message.set(selected_artifact.getColoredName(), "\u306f\u51cd\u3063\u3066\u3044\u308b\u70ba", "%", "\u4f55\u3067\u3082\u88c5\u5099\u3092\u3059\u308b\u4e8b\u304c\u51fa\u6765\u306a\u3044");
                return false;
            }
        }
        if (this.enchanted_now != null && this.enchanted_now.isCurse()) {
            SE.SYSTEM_CURSE.play();
            Message.set(this.enchanted_now.getColoredName(), "\u306f\u546a\u308f\u308c\u3066\u5916\u305b\u306a\u3044\uff01");
            return false;
        }
        if (this.isMeNONANY() && !(selected_artifact instanceof SpellCard)) {
            Message.set(this.toColoredString().concat("\u306b\u306f\u30ab\u30fc\u30c9\u3057\u304b\u9078\u629e\u3067\u304d\u306a\u3044\uff01"));
            return false;
        }
        if (selected_artifact instanceof SpellCard) {
            final SpellCard spell = (SpellCard)selected_artifact;
            if (this.equals((Object)ATK) || this.equals((Object)DEF)) {
                new Thread(){

                    @Override
                    public void run() {
                        spell.IMLC.init();
                    }
                }.start();
            }
            if (!(BGM.isSpecialBGMplaying() || PresentField.get().isEnchantedBGM_NoPlay() || Config.isFixBGM())) {
                spell.startBGM();
            }
        }
        Enchant old_place = null;
        Enchant[] enchantArray = Enchant.values();
        int n = enchantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant e = enchantArray[n2];
            if (e.isEquals(selected_artifact)) {
                old_place = e;
                e.forceToRemove();
            }
            ++n2;
        }
        Base_Artifact old = this.enchanted_now;
        this.setEnchant(selected_artifact);
        SE.SYSTEM_ENCHANT.play();
        if (selected_artifact instanceof SpellCard) {
            selected_artifact.check();
        }
        if (old == null) {
            Message.set(this.enchanted_now.getColoredName().concat("\u3092").concat(this.toColoredString()).concat("\u88c5\u5099\u3057\u305f"));
        } else if (this.isAbleToExchange(old, old_place)) {
            if (old_place.isMeANY() && old.isFrozen()) {
                SE.SYSTEM_ENCHANT_OFF.play();
                Message.set(old.getColoredName().concat("\u3068"), this.enchanted_now.getColoredName().concat("\u3092\u6301\u3061\u66ff\u3048\u305f"));
                Message.set("\u304c", old.getColoredName(), "\u306f\u51cd\u3063\u3066\u3044\u305f\u305f\u3081\u5916\u308c\u3066\u3057\u307e\u3063\u305f");
            } else {
                SE.SYSTEM_ENCHANT_OFF.play();
                old_place.setEnchant(old);
                Message.set(old.getColoredName().concat("\u3068"), this.enchanted_now.getColoredName().concat("\u3092\u6301\u3061\u66ff\u3048\u305f"));
            }
        } else {
            SE.SYSTEM_ENCHANT_OFF.play();
            Message.set(old.getColoredName().concat("\u3092").concat("\u5916\u3057\u3066$"), this.enchanted_now.getColoredName().concat("\u3092").concat(this.toColoredString()).concat("\u88c5\u5099\u3057\u305f"));
        }
        if (this.enchanted_now.isCurse()) {
            SE.SYSTEM_CURSE.play();
            Message.setConcatFlag(false);
            if (flag_checked) {
                Message.set(this.enchanted_now.getColoredName(), "\u306f\u546a\u308f\u308c\u3066\u3044\u308b\uff01");
            } else {
                Message.set(this.enchanted_now.getColoredName(), "\u306f\u546a\u308f\u308c\u3066\u3044\u305f\uff01");
            }
        }
        if ((this.equals((Object)ATK) || this.equals((Object)DEF)) && (sec = SetEnchantCard.allCheck()) != null) {
            Message.setConcatFlag(false);
            Message.set(sec.getExp(), "@");
            SE.FANFARE2.play();
            sec.quickEffect();
        }
        selected_artifact.enchant();
        return true;
    }
}

