/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.player;

import dangeon.controller.TaskOnMapObject;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.MapList;
import dangeon.model.map.PresentField;
import dangeon.model.map.field.Base_Map;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.Base_Device;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.arrow.Arrow;
import dangeon.model.object.artifact.item.disc.Base_Disc;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u90aa;
import dangeon.model.object.artifact.item.food.Food;
import dangeon.model.object.artifact.item.grass.Base_Grass;
import dangeon.model.object.artifact.item.pot.Base_Pot;
import dangeon.model.object.artifact.item.ring.Ring;
import dangeon.model.object.artifact.item.scrool.Scrool;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.artifact.item.staff.Staff;
import dangeon.model.object.artifact.trap.Base_Trap;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.EnchantArrow;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import main.res.SE;
import main.util.Show;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;
import test.FirstBelongings;

public class Belongings {
    public static final int MAX = 30;
    public static final int POCKET_MAX = 0;
    private static ArrayList<Base_Artifact> items = new ArrayList(Belongings.getMax() + 0);
    private static ArrayList<Base_Artifact> list_deposited;

    static {
        FirstBelongings.done(items);
        list_deposited = new ArrayList();
    }

    public static void allRemove() {
        items.clear();
    }

    public static void breaking(Base_Artifact ... as) {
        list_deposited.clear();
        boolean flag_curse_play = false;
        int count = 0;
        int i = 0;
        while (i < as.length) {
            Base_Artifact a = as[i];
            if (!a.isEnchantedAndCursed()) {
                ++count;
                list_deposited.add(a);
                Belongings.remove(a);
            } else {
                flag_curse_play = true;
                Message.set(a.getColoredName(), "\u306f\u546a\u308f\u308c\u3066\u3044\u3066\u5916\u305b\u306a\u304b\u3063\u305f");
            }
            ++i;
        }
        if (count > 0) {
            Message.set(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(count), "\u30b3\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u6368\u3066\u305f");
        } else if (flag_curse_play) {
            SE.SYSTEM_CURSE.play();
        }
    }

    public static synchronized Base_Artifact get(int index) {
        if (index == -1) {
            for (Base_Artifact a : MapList.getListArtifact()) {
                if (!a.isPlayerOn()) continue;
                if (!a.isHidden() && !(a instanceof Base_Device)) {
                    return a;
                }
                return null;
            }
            return null;
        }
        return items.get(index);
    }

    public static Arrow getArrow(Class<? extends Base_Artifact> clazz) {
        for (Base_Artifact a : Belongings.getListItems()) {
            if (!a.getClass().equals(clazz) || a.isMerchant()) continue;
            return (Arrow)a;
        }
        return null;
    }

    public static ArrayList<Arrow> getArrows(Class<? extends Base_Artifact> clazz) {
        ArrayList<Arrow> list = new ArrayList<Arrow>();
        for (Base_Artifact a : Belongings.getListItems()) {
            if (!a.getClass().equals(clazz)) continue;
            list.add((Arrow)a);
        }
        return list;
    }

    public static ArrayList<Base_Artifact> getDeepCopy(List<Base_Artifact> items2) {
        ArrayList<Base_Artifact> l = new ArrayList<Base_Artifact>();
        for (Base_Artifact object : items2) {
            l.add(object);
        }
        return l;
    }

    public static synchronized Base_Artifact getFoot() {
        for (Base_Artifact a : MapList.getListArtifact()) {
            if (!a.isPlayerOn()) continue;
            return a;
        }
        return null;
    }

    public static int getItemIndex(Base_Artifact a) {
        return items.indexOf(a);
    }

    public static ArrayList<Base_Artifact> getListFreezeItems() {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>();
        for (Base_Artifact a : items) {
            if (!a.isFrozen()) continue;
            list.add(a);
        }
        return list;
    }

    public static ArrayList<Base_Artifact> getListItemNoEnchant() {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>();
        for (Base_Artifact a : items) {
            if (Enchant.isEnchanted(a)) continue;
            list.add(a);
        }
        return list;
    }

    public static ArrayList<Base_Artifact> getListItems() {
        return items;
    }

    public static List<Base_Artifact> getListItems_except(Base_Artifact ... as) {
        Base_Artifact a;
        ArrayList<Base_Artifact> list = Belongings.getDeepCopy(items);
        Base_Artifact[] base_ArtifactArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            a = base_ArtifactArray[n2];
            list.remove(a);
            ++n2;
        }
        a = Belongings.get(-1);
        if (a != null) {
            list.add(a);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Base_Artifact _a = (Base_Artifact)iterator.next();
            if (_a instanceof Base_Item) continue;
            iterator.remove();
        }
        return list;
    }

    public static ArrayList<Base_Artifact> getListItems_exceptPocket() {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>(Belongings.getMax());
        int i = 0;
        while (i < items.size()) {
            if (i == Belongings.getMax()) break;
            list.add(items.get(i));
            ++i;
        }
        return list;
    }

    public static ArrayList<Base_Artifact> getListItems_includingFoot() {
        Base_Artifact a2;
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>();
        for (Base_Artifact a2 : Belongings.getListItems()) {
            list.add(a2);
        }
        a2 = Belongings.getFoot();
        if (a2 != null && !(a2 instanceof Base_Device)) {
            list.add(a2);
        }
        return list;
    }

    public static int getMax() {
        Base_Map bm = PresentField.get();
        if (bm == null) {
            return 30;
        }
        return bm.getBelongingsMax();
    }

    public static ArrayList<Base_Artifact> getPocket() {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>(0);
        int i = Belongings.getMax();
        while (i < Belongings.getMax() + 0 && i < items.size()) {
            list.add(items.get(i));
            ++i;
        }
        return list;
    }

    public static synchronized int getSize() {
        return items.size();
    }

    public static boolean isEmpty() {
        return items.isEmpty();
    }

    public static boolean isMax() {
        return items.size() >= Belongings.getMax() + 0;
    }

    public static boolean isOver30() {
        return items.size() > Belongings.getMax();
    }

    public static boolean isOverMax() {
        return items.size() > Belongings.getMax() + 0;
    }

    public static boolean isSearchItem(String nam) {
        for (Base_Artifact a : items) {
            if (!a.getClass().getSimpleName().matches(nam)) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean pickUpItem(Base_Artifact artifact) {
        if (items.size() < Belongings.getMax() + 0) {
            if (items.size() < Belongings.getMax()) {
                Message.set(artifact.getColoredName().concat("\u3092\u62fe\u3063\u305f"));
            } else {
                Message.set(artifact.getColoredName().concat("\u3092" + Color.ORANGE + "\u30dd\u30b1\u30c3\u30c8" + Color.WHITE + "\u306b\u3057\u307e\u3063\u305f"));
            }
            TaskOnMapObject.addTrapRemoveTask(artifact);
            SE.SYSTEM_PICKUP.play();
            if (artifact instanceof Base_Item) {
                ((Base_Item)artifact).flag_pick_checked = false;
            }
            artifact.endJump();
            items.add(artifact);
            \u5370\u90aa.setInfomation();
            if (EnchantSpecial.enchantSimbolAllCheck(ENCHANT_SIMBOL.\u8b58\u5225)) {
                artifact.check();
            }
            return true;
        }
        Message.set(artifact.getColoredName(), "\u306f\u6301\u3061\u7269\u304c\u4e00\u676f\u3067\u62fe\u3048\u306a\u304b\u3063\u305f", "");
        return false;
    }

    public static synchronized boolean pickUpItem(Base_Artifact artifact, int i) {
        if (artifact.exchange()) {
            return false;
        }
        items.add(i, artifact);
        return true;
    }

    public static synchronized void remove(Base_Artifact a) {
        if (items.contains(a)) {
            items.remove(a);
            if (a.isEnchantedNow()) {
                Enchant.forceToRemove(a);
            }
        } else if (MapList.getListArtifact().contains(a)) {
            MapList.removeArtifact(a);
        }
    }

    public static synchronized void remove(int i) {
        items.remove(i);
    }

    public static void removePockets() {
        int size = items.size();
        int i = 0;
        while (i < size - Belongings.getMax()) {
            items.remove(Belongings.getMax());
            ++i;
        }
    }

    public static void replace(Base_Artifact a1, Base_Artifact a2) {
        int i = Belongings.getItemIndex(a1);
        int j = Belongings.getItemIndex(a2);
        items.set(i, a2);
        items.set(j, a1);
        Message.set(a1.getColoredName(), "\u3068", a2.getColoredName(), "\u306e\u4f4d\u7f6e\u3092\u5165\u308c\u66ff\u3048\u305f");
    }

    public static synchronized void setItems(Base_Artifact a) {
        items.add(a);
    }

    public static void setItems(Base_Artifact a, int index) {
        try {
            items.add(index, a);
        }
        catch (Exception e) {
            items.add(a);
        }
    }

    public static void setListItems(List<Base_Artifact> list) {
        items = new ArrayList<Base_Artifact>(list);
    }

    public static ArrayList<Base_Artifact> sort() {
        items = Belongings.sort(items, 30);
        return items;
    }

    public static ArrayList<Base_Artifact> sort(List<Base_Artifact> items) {
        Class[] cs;
        Enchant[] es;
        ArrayList<Base_Artifact> sort = new ArrayList<Base_Artifact>(items.size());
        Enchant[] enchantArray = es = Enchant.values();
        int n = es.length;
        int n2 = 0;
        while (n2 < n) {
            Enchant e = enchantArray[n2];
            for (Base_Artifact a : items) {
                if (!e.isEquals(a)) continue;
                sort.add(a);
            }
            Belongings.sortReduceSortedItems(sort, items);
            ++n2;
        }
        for (Base_Artifact a : items) {
            if (!EnchantArrow.isEnchant(a)) continue;
            sort.add(a);
            break;
        }
        Class[] classArray = cs = new Class[]{Base_Device.class, SpellCard.class, Arrow.class, Ring.class, Food.class, Base_Grass.class, Scrool.class, Staff.class, Base_Pot.class, Base_Disc.class, Base_Artifact.class, Base_Trap.class};
        int n3 = cs.length;
        n = 0;
        while (n < n3) {
            Class c = classArray[n];
            int i = 0;
            while (i < 3) {
                for (Base_Artifact a : items) {
                    if (sort.contains(a) || !c.isInstance(a) || i == 0 && !a.isPerfectCheked() || i == 1 && !a.isStaticCheked()) continue;
                    ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>();
                    for (Base_Artifact _a : items) {
                        if (sort.contains(_a) || !a.getClass().equals(_a.getClass())) continue;
                        list.add(_a);
                    }
                    Collections.sort(list);
                    for (Base_Artifact _a : list) {
                        sort.add(_a);
                    }
                }
                Belongings.sortReduceSortedItems(sort, items);
                ++i;
            }
            ++n;
        }
        if (items.size() != 0) {
            System.out.println("list\u306b\u6b8b\u3063\u3066\u3057\u307e\u3063\u305f\u30a2\u30a4\u30c6\u30e0\u306e\u6570\uff1a" + items.size());
            System.out.println("list\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u540d\u524d\uff1a" + items.size());
            for (Base_Artifact a : items) {
                System.out.println(a);
            }
            Show.showErrorMessageDialog("Sort\u304c\u3046\u307e\u304f\u3044\u3063\u3066\u306a\u3044\u3067\u3059");
        }
        return sort;
    }

    public static ArrayList<Base_Artifact> sort(List<Base_Artifact> items, int MAX) {
        ArrayList<Base_Artifact> overs;
        if (Belongings.getSize() > MAX) {
            int size = items.size() - MAX;
            overs = new ArrayList<Base_Artifact>(size);
            int i = 0;
            while (i < size) {
                overs.add(items.get(MAX));
                items.remove(MAX);
                ++i;
            }
            overs = Belongings.sort(overs);
        } else {
            overs = null;
        }
        ArrayList<Base_Artifact> sort = Belongings.sort(items);
        if (overs != null) {
            for (Base_Artifact a : overs) {
                sort.add(a);
            }
        }
        return sort;
    }

    private static void sortReduceSortedItems(List<Base_Artifact> sort, List<Base_Artifact> items) {
        for (Base_Artifact a : sort) {
            items.remove(a);
        }
    }
}

