/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.config.table.ItemDetail;
import dangeon.model.config.table.ItemTable;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u9b54;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.util.Damage;
import dangeon.view.anime.MasterSpark;
import java.awt.Image;
import java.awt.Point;
import main.util.DIRECTION;

public class \u98a8\u898b\u5e7d\u9999
extends Base_Enemy {
    private static final long serialVersionUID = 1L;

    public \u98a8\u898b\u5e7d\u9999(Point p, int Lv) {
        super(p, Lv);
    }

    private boolean check() {
        if (this.LV == 1 && !this.player_is_in_sight) {
            return false;
        }
        Point player_point = Player.me.getMassPoint();
        if (this.getMassPoint().x == player_point.x) {
            return true;
        }
        if (this.getMassPoint().y == player_point.y) {
            return true;
        }
        return Math.abs(this.getMassPoint().x - player_point.x) == Math.abs(this.getMassPoint().y - player_point.y);
    }

    private String damageMessage() {
        return "\u30de\u30b9\u30bf\u30fc\u30b9\u30d1\u30fc\u30af\u306b\u3088\u3063\u3066\u6d88\u3057\u70ad\u306b\u306a\u3063\u305f";
    }

    private void effect() {
        this.direction = DIRECTION.getDirectionToPlayer(this);
        this.setAnimation(new MasterSpark(this, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                \u98a8\u898b\u5e7d\u9999.this.effect(\u98a8\u898b\u5e7d\u9999.this.getDam());
            }
        }));
    }

    private void effect(int effect_damage) {
        Message.set(this.getColoredName(), "\u306f\u30de\u30b9\u30bf\u30fc\u30b9\u30d1\u30fc\u30af\u3092\u653e\u3063\u305f");
        Point p = this.getMassPoint().getLocation();
        DIRECTION d = this.getDirection();
        while (MassCreater.getMass(p) != Mass.nullpo) {
            Base_Creature c;
            p.translate(d.X, d.Y);
            Mass mass = MassCreater.getMass(p);
            if (mass.DIGGABLE) {
                mass.setDigged(true);
            }
            if ((c = MapList.getCreature(p)) == null) continue;
            this.effectDamage(c, effect_damage);
        }
        MassCreater.retakeMassSet();
    }

    private void effectDamage(Base_Creature c, int effect_damage) {
        int damage = effect_damage;
        if (c == Player.me) {
            damage = \u5370\u9b54.effect(damage);
        }
        Damage.damage(this, null, this.damageMessage(), this, c, damage);
    }

    @Override
    public boolean enchantEnemySpecialAction() {
        Player.me.setSecondAnimation(new MasterSpark(Player.me, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                Point p = Player.me.getMassPoint().getLocation();
                DIRECTION d = Player.me.getDirection();
                while (true) {
                    p.x += d.X;
                    p.y += d.Y;
                    if (MassCreater.isPointOutOfDangeon(p)) break;
                    if (!MassCreater.getMass((Point)p).WALKABLE) {
                        MassCreater.dig(p);
                    }
                    if (MapList.getEnemy(p) == null) continue;
                    Damage.damage(null, null, null, Player.me, MapList.getEnemy(p), 50);
                }
                MassCreater.retakeMassSet();
            }
        }));
        return true;
    }

    private int getDam() {
        switch (this.LV) {
            case 1: {
                return 30;
            }
            case 2: {
                return 40;
            }
        }
        return 50;
    }

    @Override
    protected Base_Artifact getDropItem() {
        return ItemTable.itemReturn(this.mass_point, ItemDetail.GRASS);
    }

    @Override
    public Image getImage() {
        if (this.getAnimation() != null) {
            return this.IM.getSPImage(this.LV, this.direction, 0);
        }
        return super.getImage();
    }

    @Override
    public int getItemDropParcent() {
        return super.getItemDropParcent() * 2;
    }

    @Override
    public int isKamin() {
        return this.LV == 2 ? 100 : super.isKamin();
    }

    private boolean railgun() {
        if (this.check()) {
            this.effect();
            return true;
        }
        return false;
    }

    @Override
    protected boolean specialAttack() {
        return this.special_ok && this.railgun();
    }

    @Override
    protected boolean specialCheck() {
        if (!this.check()) {
            return false;
        }
        return this.isSpecialParcent();
    }
}

