/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.menu.first.adventure.medal.Medal;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.config.table.ItemTable;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.resistant.ResistWeakPoint;
import dangeon.util.Damage;
import dangeon.util.MapInSelect;
import dangeon.util.R;
import dangeon.view.anime.FireEffect;
import dangeon.view.detail.View_Sider;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import main.res.SE;
import main.util.FrameShaker;

public class \u85e4\u539f\u59b9\u7d05
extends Base_Enemy {
    private static final long serialVersionUID = 1L;

    public \u85e4\u539f\u59b9\u7d05(Point p, int Lv) {
        super(p, Lv);
    }

    @Override
    public int damagedWithFire(int damage) {
        this.addLV(1);
        return 0;
    }

    @Override
    protected Point getAttackPoint() {
        if (this.getAnimation() == null) {
            return super.getAttackPoint();
        }
        return new Point(this.screen_point.x + this.attack_delt_point.x / 2, this.screen_point.y + this.attack_delt_point.y / 2);
    }

    @Override
    public SE getAttackSE() {
        if (this.getAnimation() == null) {
            return SE.ATTACK_FIRE;
        }
        return null;
    }

    @Override
    public int getConvertedLV() {
        if (this.LV <= 6) {
            return 1;
        }
        if (this.LV <= 12) {
            return 2;
        }
        if (this.LV < 99) {
            return 3;
        }
        return 4;
    }

    @Override
    public int getDeConvertedLV(int lv) {
        if (lv == 1) {
            return 1;
        }
        if (lv == 2) {
            return 7;
        }
        if (lv == 3) {
            return 13;
        }
        return 99;
    }

    @Override
    public Image getImage() {
        int LV = this.getConvertedLV();
        if (this.isAttacking()) {
            return this.getATKImage(LV, this.attacking_direction, this.attack_No);
        }
        if (this.flag_damaging) {
            return this.IM.getDamImage(LV, this.direction);
        }
        return this.IM.getWalkImage(LV, this.direction, this.getMoveAnimationSpeed());
    }

    @Override
    protected CONDITION getInitCondition() {
        return CONDITION.\u708e\u4e0a;
    }

    @Override
    public int getMaxLV() {
        return 99;
    }

    @Override
    public boolean resistOrWeakAction(ResistWeakPoint res, int damage) {
        this.addLV(1);
        return true;
    }

    @Override
    public void setNameAndStatus() {
        int lv = this.LV;
        this.LV = 1;
        super.setNameAndStatus();
        int MAX_HP = this.getMAX_HP();
        int MAX_STR = this.MAX_STR;
        int MAX_DEF = this.MAX_DEF;
        int ENEMY_EXP = this.ENEMY_EXP;
        this.LV = 2;
        super.setNameAndStatus();
        int mlp = lv - 1;
        this.setFirstStatus(MAX_HP + this.getMAX_HP() * mlp, MAX_STR + this.MAX_STR * mlp, MAX_DEF + this.MAX_DEF * mlp);
        this.ENEMY_EXP = ENEMY_EXP * lv;
        this.LV = lv;
        this.name = this.name.replaceAll("[0-9]", "").concat(String.valueOf(this.LV));
    }

    @Override
    protected void setStateChengeByLevelUp() {
        this.setConditionList(CONDITION.\u708e\u4e0a, 0);
    }

    @Override
    protected boolean specialAttack() {
        if (this.attack_possible()) {
            this.direction = this.converDirection(Player.me.getMassPoint());
            final \u85e4\u539f\u59b9\u7d05 c = this;
            FrameShaker.doneSoftly();
            this.startAttack(new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    int str = \u85e4\u539f\u59b9\u7d05.this.getSTR();
                    \u85e4\u539f\u59b9\u7d05.this.setSTR(str * 125 / 100);
                    if (Damage.normalAttack(c, Player.me) > 0) {
                        \u85e4\u539f\u59b9\u7d05.this.setAnimation(new FireEffect(Player.me, new Task(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public void work() {
                                ArrayList<Base_Artifact> list = Belongings.getListFreezeItems();
                                if (list.isEmpty()) {
                                    Base_Artifact a;
                                    list = Belongings.getListItemNoEnchant();
                                    Iterator<Base_Artifact> iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        a = iterator.next();
                                        if (!a.getListComposition().contains((Object)ENCHANT_SIMBOL.\u91d1)) continue;
                                        iterator.remove();
                                    }
                                    if (list.isEmpty()) {
                                        return;
                                    }
                                    int select = new R().nextInt(list.size());
                                    a = list.get(select);
                                    if (EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u8b77)) {
                                        Message.set(a.getColoredName(), "\u3092\u71c3\u3084\u3055\u308c\u305d\u3046\u306b\u306a\u3063\u305f\u304c\u795e\u306e\u52a0\u8b77\u304c\u3042\u3063\u3066\u5927\u4e08\u592b\u3060\u3063\u305f");
                                    } else {
                                        Belongings.remove(a);
                                        Message.set(a.getColoredName(), "\u3092\u71c3\u3084\u3055\u308c\u305f");
                                        View_Sider.setInformation(a.getColoredName(), "\u304c\u71c3\u3084\u3055\u308c\u307e\u3057\u305f");
                                        if (ItemTable.getRank(a) >= 4) {
                                            Medal.\u6575\u306b\u73cd\u3057\u3044\u30a2\u30a4\u30c6\u30e0\u3092\u58ca\u3055\u308c\u305f.addCount();
                                        }
                                    }
                                    return;
                                }
                                int select = new R().nextInt(list.size());
                                Base_Artifact a = list.get(select);
                                Message.set("\u51cd\u3063\u3066\u3044\u305f", a.getColoredName(), "\u304c\u71b1\u3067\u6eb6\u3051\u305f");
                                View_Sider.setInformation("\u51cd\u3063\u3066\u3044\u305f", a.getColoredName(), "\u304c\u6eb6\u3051\u307e\u3057\u305f");
                                a.freezeCountReset();
                            }
                        }));
                    }
                    \u85e4\u539f\u59b9\u7d05.this.setSTR(str);
                }
            });
        }
        return true;
    }

    @Override
    protected boolean specialCheck() {
        if (this.conditionCheck(CONDITION.\u708e\u4e0a)) {
            if (this.getConvertedLV() >= 3) {
                for (Base_Creature c : MapInSelect.getListAroundInCreature(this.getMassPoint())) {
                    if (!(c instanceof Base_Enemy) || c.conditionCheck(CONDITION.\u708e\u4e0a)) continue;
                    Message.set(c.getColoredName(), "\u306f\u708e\u306b\u5305\u307e\u308c\u305f");
                    SE.ATTACK_FIRE.play();
                    c.setCondition(CONDITION.\u708e\u4e0a, this.LV);
                }
            }
            if (this.attack_possible() && this.isSpecialParcent()) {
                return true;
            }
        }
        return false;
    }
}

