/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.util.Damage;
import dangeon.util.MapInSelect;
import dangeon.util.R;
import dangeon.view.util.WithinOutofScreen;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import main.res.SE;
import main.util.DIRECTION;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public class \u30d5\u30e9\u30f3\u30c9\u30fc\u30eb
extends Base_Enemy {
    private static final long serialVersionUID = 1L;
    private boolean flag_digg;
    private int spec = -1;

    public \u30d5\u30e9\u30f3\u30c9\u30fc\u30eb(Point p, int Lv) {
        super(p, Lv);
    }

    private boolean check() {
        int length = this.LV == 4 ? -1 : this.LV;
        return this.range(length, true);
    }

    protected void ddn(final Point p, int speed, DIRECTION dir, final boolean critical) {
        Message.set("\u30c7\u30c7\u30fc\u30f3\uff01");
        Player.me.startDamaging();
        Player.me.setMassPoint_WalkLike(p, speed);
        Point _p = new Point(p.x - dir.X, p.y - dir.Y);
        final \u30d5\u30e9\u30f3\u30c9\u30fc\u30eb e = this;
        this.setMassPoint_WalkLike(_p, speed, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                \u30d5\u30e9\u30f3\u30c9\u30fc\u30eb.this.spec = -1;
                Mass mass = MassCreater.getMass(p);
                if (mass.DIGGABLE) {
                    SE.DIGG.play();
                    MassCreater.dig(p);
                    MassCreater.retakeMassSet();
                }
                if (critical) {
                    \u30d5\u30e9\u30f3\u30c9\u30fc\u30eb.this.startAttack(new Task(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void work() {
                            Damage.enemyCriticalAttack(e);
                        }
                    });
                } else {
                    \u30d5\u30e9\u30f3\u30c9\u30fc\u30eb.this.attack();
                }
            }
        });
    }

    private void digg() {
        this.flag_digg = false;
        ArrayList<DIRECTION> list = this.diggable();
        if (list.isEmpty()) {
            return;
        }
        DIRECTION d = list.get(new R().nextInt(list.size()));
        final ArrayList<Mass> mass_list = new ArrayList<Mass>(this.LV);
        Point p = this.getMassPoint().getLocation();
        int i = 0;
        while (i < this.LV) {
            p.translate(d.X, d.Y);
            if (!this.diggable(p)) break;
            mass_list.add(MassCreater.getMass(p));
            ++i;
        }
        if (mass_list.isEmpty()) {
            return;
        }
        this.direction = d;
        if (WithinOutofScreen.isOutside(this)) {
            this.digg(mass_list, i);
        } else {
            final int I = i;
            this.startAttack(new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    \u30d5\u30e9\u30f3\u30c9\u30fc\u30eb.this.digg(mass_list, I);
                }
            });
        }
    }

    private void digg(ArrayList<Mass> mass_list, int i) {
        Message.set(this.getColoredName(), "\u306f\u58c1\u3092", \u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(i), "\u30de\u30b9\u6398\u3063\u305f");
        SE.DIGG.play();
        for (Mass mass : mass_list) {
            mass.setDigged(true);
        }
        MassCreater.retakeMassSet();
    }

    private ArrayList<DIRECTION> diggable() {
        ArrayList<DIRECTION> list = new ArrayList<DIRECTION>(4);
        DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyBasic4();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            Point p = d.getFrontPoint(this.getMassPoint().getLocation());
            if (this.diggable(p)) {
                list.add(d);
            }
            ++n2;
        }
        return list;
    }

    private boolean diggable(Point p) {
        Mass mass = MassCreater.getMass(p);
        return !mass.WALKABLE && mass.isDiggable() && MapList.getCreature(p) == null;
    }

    private void effect(final Point p, final DIRECTION dir) {
        if (EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.DEF, ENCHANT_SIMBOL.\u30a4\u30ab\u30ea)) {
            Message.set(Player.me.getColoredName(), "\u306f\u91cd\u304f\u3066\u52d5\u304b\u305b\u306a\u304b\u3063\u305f");
            this.attack();
            return;
        }
        int speed = 3;
        this.spec = 0;
        if (super.attack_possible()) {
            this.ddn(p, 3, dir, true);
        } else {
            Point _point_ = Player.me.getMassPoint().getLocation();
            _point_.translate(-dir.X, -dir.Y);
            this.setMassPoint_WalkLike(_point_, 3, new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    \u30d5\u30e9\u30f3\u30c9\u30fc\u30eb.this.ddn(p, 3, dir, true);
                }
            });
        }
    }

    @Override
    public boolean enchantEnemySpecialAction() {
        Base_Enemy c = MapInSelect.getFrontEnemyFromCreature(Player.me);
        if (c == null) {
            return false;
        }
        MapInSelect.\u5439\u304d\u98db\u3070\u3057(Player.me, "\u30d5\u30e9\u30f3\u306b\u5439\u304d\u98db\u3070\u3055\u308c\u3066\u5012\u308c\u305f", c, Player.me.direction, 10, Damage.getAttackDamage(true, c));
        return true;
    }

    @Override
    public Image getImage() {
        if (this.spec != -1) {
            ++this.spec;
            int i = this.spec < 4 ? 0 : 1;
            return this.IM.getSPImage(this.LV, this.direction, i);
        }
        return super.getImage();
    }

    @Override
    public boolean isAbleToAttackWhileNeglectingWall() {
        if (this.isSkillActive() && this.LV > 1) {
            return true;
        }
        return super.isAbleToAttackWhileNeglectingWall();
    }

    @Override
    protected boolean specialAttack() {
        if (this.flag_digg) {
            this.digg();
            return true;
        }
        if (this.check()) {
            this.direction = this.converDirection(Player.me.getMassPoint());
            if (this.walkableBreak(false)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean specialCheck() {
        if (this.flag_digg) {
            return true;
        }
        this.flag_digg = false;
        if (this.isSpecialParcent() && this.check() && this.walkableBreak(true)) {
            return true;
        }
        if (this.isSpecialParcent() && MassCreater.getRoom(this.getMassPoint()) != null && !this.diggable().isEmpty()) {
            this.flag_digg = true;
            return true;
        }
        return false;
    }

    private boolean walkableBreak(boolean check) {
        Point p = Player.me.getMassPoint().getLocation();
        DIRECTION dir = this.converDirection(p);
        Base_Creature c = MapInSelect.getStraightHitCreature(dir, p, 0);
        if (c != null) {
            Point goal = c.getMassPoint().getLocation();
            goal.translate(-dir.X, -dir.Y);
            if (goal.x == p.x && goal.y == p.y) {
                return false;
            }
            if (!check) {
                this.effect(goal, dir);
            }
            return true;
        }
        Point goal = MapInSelect.getStraightHitPoint(dir, p, 0);
        if (this.diggable(goal)) {
            DIRECTION[] ds;
            DIRECTION[] dIRECTIONArray = ds = DIRECTION.values_onlyBasic4();
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                DIRECTION d = dIRECTIONArray[n2];
                Mass m = MassCreater.getMass(goal.x + d.X, goal.y + d.Y);
                if (m.WALKABLE && !m.WATER) {
                    if (!check) {
                        this.effect(goal, dir);
                    }
                    return true;
                }
                ++n2;
            }
        }
        goal.translate(-dir.X, -dir.Y);
        if (goal.x == p.x && goal.y == p.y) {
            return false;
        }
        if (!check) {
            this.effect(goal, dir);
        }
        return true;
    }
}

