/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.controller.ThrowingItem;
import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.map.MapList;
import dangeon.model.map.PresentField;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.HiddenDevice;
import dangeon.model.object.artifact.item.arrow.\u5927\u7832\u306e\u5f3e;
import dangeon.model.object.artifact.item.bullet.\u30c9\u30e9\u30b4\u30f3\u30d6\u30ec\u30b9;
import dangeon.model.object.artifact.item.bullet.\u76ee\u304b\u3089\u30d3\u30fc\u30e0;
import dangeon.model.object.artifact.item.staff.MagicBullet;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.util.Damage;
import dangeon.util.MapInSelect;
import dangeon.util.ObjectPoint;
import dangeon.util.R;
import dangeon.util.ThunderDamage;
import dangeon.view.anime.Special_Wait;
import dangeon.view.anime.ThunderEffect;
import dangeon.view.detail.MainMap;
import dangeon.view.util.WithinOutofScreen;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import main.constant.FR;
import main.res.BulletImage;
import main.res.CHARA_IMAGE;
import main.res.SE;
import main.util.BeautifulView;
import main.util.DIRECTION;
import main.util.FileReadSupporter;
import main.util.FrameShaker;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public class \u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af
extends Base_Enemy {
    private static final long serialVersionUID = 1L;
    private transient BufferedImage arm;
    private transient BufferedImage atk;
    private transient BufferedImage breaking;
    private transient BufferedImage dam;
    private transient BufferedImage walk;
    private transient HiddenDevice hidden;
    private int flag_dying = -1;
    private int max_coma;
    private int each_frame;
    private boolean flag_arm;
    private int frame_count = -1;
    private int count = 0;

    @Override
    public void load() {
        this.arm = this.loadImage("arm");
        this.atk = this.loadImage("atk");
        this.breaking = this.loadImage("breaking");
        this.dam = this.loadImage("dam");
        this.walk = this.loadImage("walk");
        this.name = "\u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af";
        this.hidden = new HiddenDevice(this.mass_point);
        MapList.addArtifact(this.hidden);
    }

    public \u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af(Point p, int Lv) {
        super(p, Lv);
        this.load();
    }

    @Override
    protected void setBeatedAway() {
        MapList.removeArtifact(this.hidden);
        this.flag_dying = 0;
        SE.GOGOGO.play();
        this.max_coma = 25;
        this.each_frame = 4;
        FrameShaker.setShake_time(this.max_coma * this.each_frame * FR.THREAD_SLEEP / 2);
        this.setAnimation(new Special_Wait((Base_Creature)this, this.max_coma, this.each_frame, SE.GOGOGO, 2, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                Message.set(\u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af.this.getColoredName(), "\u3092\u3084\u3063\u3064\u3051\u305f");
                Player.me.setExpCash(\u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af.this.getENEMY_EXP());
                \u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af.this.setSuperBeatedAway();
            }
        }));
    }

    private void setSuperBeatedAway() {
        super.setBeatedAway();
    }

    @Override
    public boolean enemyLifeCheck() {
        if (this.getHP() <= 0) {
            if (this.getConditionList().contains((Object)CONDITION.\u5fa9\u6d3b)) {
                CONDITION.conditionRecovery(this, CONDITION.\u5fa9\u6d3b);
                Message.set(this.getColoredName(), "\u306f\u4e0d\u6b7b\u9ce5\u306e\u3054\u3068\u304f\u5fa9\u6d3b\u3057\u305f");
                this.chengeHP(null, null, this.getMAX_HP());
                return false;
            }
            if (this.recoveryGhost()) {
                return false;
            }
            this.setBeatedAway();
            return false;
        }
        return false;
    }

    @Override
    public void setNameAndStatus() {
        int lv = this.LV;
        this.LV = 1;
        super.setNameAndStatus();
        int MAX_HP = this.getMAX_HP();
        int MAX_STR = this.MAX_STR;
        int MAX_DEF = this.MAX_DEF;
        int ENEMY_EXP = this.ENEMY_EXP;
        this.LV = lv;
        this.setFirstStatus(MAX_HP + this.LV * 2, MAX_STR + this.LV, MAX_DEF + this.LV);
        this.ENEMY_EXP = ENEMY_EXP + lv * 100;
        if (this.LV > 1) {
            this.name = "\u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af".concat("ver").concat(String.valueOf(this.LV));
            new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    \u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af.this.tellHp();
                }
            }.work_appointment();
        }
    }

    private void tellHp() {
        if (!WithinOutofScreen.isOutside(this)) {
            this.setAnimation(new Special_Wait(this, 9, 4));
        }
        Message.set("\u300c\u6b8b\u308a\u6d3b\u52d5\u5024", this.getHP(), "\u30c7\u30b9\u3000\u6226\u95d8\u3092\u7d9a\u884c\u3057\u307e\u3059\u300d");
    }

    @Override
    public int getMaxLV() {
        return 99;
    }

    @Override
    protected Point getAttackPoint() {
        return this.screen_point;
    }

    @Override
    protected void drawCreature(Graphics2D g, int x, int y) {
        Image[] ims = MainMap.getPlainWall(PresentField.get().getMapTip());
        MainMap.drawWall(g, ims, x, y);
        this.flag_arm = false;
        if (this.flag_dying != -1) {
            ++this.flag_dying;
            if (this.getAnimation() != null) {
                BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f - (float)this.getAnimation().getComa() / (float)this.max_coma));
            } else {
                BeautifulView.setAlphaOnImg(g, Float.valueOf(0.0f));
            }
            super.drawCreature(g, x, y);
            BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
        } else {
            super.drawCreature(g, x, y);
            if (this.isAttacking()) {
                this.flag_arm = true;
                super.drawCreature(g, x, y);
            }
        }
    }

    @Override
    protected int getFootDeltY() {
        return -5;
    }

    @Override
    public String getOriginalName() {
        return this.name;
    }

    @Override
    protected void upDate_NormalAttack() {
        super.upDate_NormalAttack();
        if (this.frame_count < 6) {
            ++this.frame_count;
            --this.attaking_frame;
        } else if (this.frame_count == 6) {
            ++this.frame_count;
            FrameShaker.doneSoftly();
            SE.DAMAGED_CRITICAL.play();
        }
        if (this.normal_attack_phase == Base_Creature.AttackPhase.GO) {
            this.attack_No += this.frame_count / 2;
        } else if (this.attaking_frame == -1) {
            this.frame_count = -1;
        }
    }

    @Override
    public int getShadowSize() {
        return super.getShadowSize();
    }

    private BufferedImage getSubImage(BufferedImage im, int index) {
        int length = im == this.arm ? 6 : (im == this.atk ? 6 : (im == this.breaking ? 3 : (im == this.walk ? 3 : 1)));
        int w = im.getWidth();
        int h = im.getHeight() / length;
        int x = 0;
        int y = h * index;
        return im.getSubimage(x, y, w, h);
    }

    @Override
    protected boolean itemHitEffect(Base_Artifact a, boolean ento) {
        String s = a instanceof MagicBullet ? "\u9b54\u6cd5" : (a instanceof \u76ee\u304b\u3089\u30d3\u30fc\u30e0 ? "\u30d3\u30fc\u30e0" : "\u30a2\u30a4\u30c6\u30e0");
        this.resist(this.getColoredName(), "\u306f\u30d5\u30eb\u30e1\u30bf\u30eb\u30b3\u30fc\u30c6\u30a3\u30f3\u30b0\u3060\u304b\u3089", s, "\u3092\u53d7\u3051\u4ed8\u3051\u306a\u3044\uff01");
        return false;
    }

    private void resist(String ... msg) {
        SE.YOUMU_SP2.play();
        SE.REIMU_BARRIER.play();
        this.setAnimation(new Special_Wait(this, 3, 4));
        this.chengeHP(null, null, -1);
        Message.set(msg);
    }

    @Override
    protected boolean resistCondition(CONDITION c) {
        this.resist(this.getColoredName(), "\u306f\u30d5\u30eb\u30e1\u30bf\u30eb\u30b3\u30fc\u30c6\u30a3\u30f3\u30b0\u3060\u304b\u3089\u72b6\u614b\u7570\u5e38\u306b\u306a\u3089\u306a\u3044\uff01");
        return true;
    }

    private BufferedImage loadImage(String filename) {
        return FileReadSupporter.readImage("res/image/character_dot/\u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af/".concat(filename).concat(".png"));
    }

    @Override
    public Image getImage() {
        if (this.flag_dying != -1) {
            if (this.getAnimation() != null) {
                return this.getSubImage(this.breaking, this.getAnimation().getComa() % 3);
            }
            return this.getSubImage(this.breaking, 0);
        }
        if (this.isAttacking()) {
            if (this.flag_arm) {
                return this.getSubImage(this.arm, this.attack_No);
            }
            return this.getSubImage(this.atk, this.attack_No);
        }
        if (this.getAnimation() != null) {
            return this.getSubImage(this.breaking, this.getAnimation().getComa() % 2);
        }
        if (this.flag_damaging) {
            return this.dam;
        }
        return this.getSubImage(this.walk, CHARA_IMAGE.getKoma_StaticMethod(this.getMoveAnimationSpeed()));
    }

    @Override
    public void action() {
        if (!this.isSkillActive() || Player.me.getConditionList().contains((Object)CONDITION.\u3084\u308a\u3059\u3054\u3057) || Player.me.getConditionList().contains((Object)CONDITION.\u6697\u95c7) || Player.me.getConditionList().contains((Object)CONDITION.\u900f\u660e)) {
            this.enemy_actioned = true;
        } else {
            super.action();
        }
    }

    @Override
    protected boolean specialAttack() {
        if (!this.player_is_in_sight) {
            return true;
        }
        if (++this.count > 50) {
            this.count = 0;
            this.tellHp();
            return true;
        }
        if (this.count == 20) {
            String at = "";
            if (!WithinOutofScreen.isOutside(this)) {
                this.setAnimation(new Special_Wait(this, 9, 4));
            } else {
                at = "@";
            }
            Message.set("\u300c\u653e\u96fb\u6e96\u5099\u958b\u59cb\u300d", at);
            return true;
        }
        if (this.count > 20 && this.count < 25) {
            String at = "";
            if (!WithinOutofScreen.isOutside(this)) {
                this.setAnimation(new Special_Wait(this, 3, 4));
            } else {
                at = "@";
            }
            Message.set("\u300c", \u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(25 - this.count), "\u300d", at);
            return true;
        }
        if (this.count == 25) {
            this.setAnimation(new Special_Wait(this, 9, 4));
            Message.set(this.getColoredName(), "\u306e\u4f53\u304b\u3089\u96f7\u304c\u307b\u3068\u3070\u3057\u308b\uff01");
            Message.set("\u90e8\u5c4b\u5168\u4f53\u306b\u96f7\u30c0\u30e1\u30fc\u30b8\uff01");
            SE.LIGHTNING.play();
            MainMap.addEffect(new ThunderEffect(true, ObjectPoint.getDifferenceBetweenPlayer(this.screen_point.x, this.screen_point.y)));
            int damage = 50;
            for (Base_Enemy c : MapInSelect.getListRoomOrRoadInEnemy()) {
                this.thunder(c, damage);
            }
            this.thunder(Player.me, damage);
            return true;
        }
        if (this.attack_possible()) {
            if (new R().is(15)) {
                this.startAttack(new Task(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void work() {
                        if (Damage.normalAttack(\u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af.this, Player.me) > 0) {
                            FrameShaker.doneNormaly();
                            MapInSelect.\u5439\u304d\u98db\u3070\u3057(\u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af.this, null, Player.me, \u30d2\u30bd\u30a6\u30c6\u30f3\u30bd\u30af.this.direction, 10, 0);
                        }
                    }
                });
                return true;
            }
            return false;
        }
        if (!MapInSelect.isCreatureOnTheStraightAllDirection(this, Player.me, Math.max(30, 40))) {
            return true;
        }
        this.direction = this.converDirection(Player.me.getMassPoint());
        this.setAnimation(new Special_Wait(this, 3, 4));
        SE.PITFALL_OPEN.play();
        int r = new R().nextInt(2);
        Base_Artifact a = r == 0 ? this.beam() : this.mera();
        a.itemThrow((Base_Creature)this, ThrowingItem.HowToThrow.MAGIC, Math.max(30, 40));
        return true;
    }

    private void thunder(Base_Creature c, int dmg) {
        ThunderDamage.thunderDamage((Object)this, (Base_Creature)this, c, dmg);
    }

    @Override
    public int getConvertedLV() {
        if (this.LV <= 2) {
            return 1;
        }
        if (this.LV <= 4) {
            return 2;
        }
        if (this.LV < 10) {
            return 3;
        }
        return 4;
    }

    @Override
    public boolean chengeHP(Object obj, String str, int delt) {
        if (delt <= -999) {
            this.resist(this.getColoredName(), "\u306f\u30d5\u30eb\u30e1\u30bf\u30eb\u30b3\u30fc\u30c6\u30a3\u30f3\u30b0\u3060\u304b\u3089999\u4ee5\u4e0a\u306e\u30c0\u30e1\u30fc\u30b8\u3092\u53d7\u3051\u4ed8\u3051\u306a\u3044\uff01");
            return false;
        }
        return super.chengeHP(obj, str, delt);
    }

    private Base_Artifact mera() {
        Message.set(this.getColoredName(), "\u306f\u708e\u3092\u653e\u3063\u305f");
        return new \u30c9\u30e9\u30b4\u30f3\u30d6\u30ec\u30b9((Base_Creature)this, 20);
    }

    private Base_Artifact beam() {
        SE.ATTACK_SHOOT_ICY.play();
        Message.set(this.getColoredName(), "\u306f\u30d3\u30fc\u30e0\u3092\u653e\u3063\u305f");
        return new \u5927\u7832\u306e\u5f3e(this.getMassPoint().getLocation(), false){
            private static final long serialVersionUID = 1L;

            @Override
            public int getShadow() {
                return 0;
            }

            @Override
            public Image getImage(DIRECTION direction) {
                return BulletImage.eye_beam.getImage(direction);
            }

            @Override
            public void itemHit(Base_Creature target, Base_Creature source) {
                this.explode(target.getMassPoint(), source);
            }
        };
    }

    @Override
    protected boolean specialCheck() {
        return true;
    }
}

