/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.menu.Book;
import dangeon.latest.scene.action.message.ConvEvent;
import dangeon.latest.scene.action.message.Conversation;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.shop.Shop;
import java.awt.Point;
import java.util.ArrayList;
import main.res.BGM;
import main.res.Image_LargeCharacter;
import main.res.SE;
import main.util.DIRECTION;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public abstract class CopyOf__\u5e97\u4e3b
extends Base_Enemy {
    public final Shop shop;
    private boolean flag_first_in = true;
    protected boolean flag_buyed;
    protected Image_LargeCharacter IMLC;
    private static final long serialVersionUID = 1L;
    private BGM pre_bgm;
    protected Point pre_warning_point = new Point(-1, -1);

    public CopyOf__\u5e97\u4e3b(Point p, int lv) {
        super(p, lv);
        this.shop = null;
    }

    public CopyOf__\u5e97\u4e3b(Point p, int lv, Shop shop, Image_LargeCharacter imlc) {
        super(p, lv);
        this.shop = shop;
        this.IMLC = imlc;
    }

    @Override
    public void action() {
        if (this.isPlayerSide()) {
            this.setDirection(DIRECTION.getDirection(this, Player.me));
            this.enemy_actioned = true;
        } else {
            super.action();
        }
    }

    private void bgmPlay() {
        BGM bg = BGM.get();
        if (this.pre_bgm == null && bg != BGM.yukkurishiteittene) {
            this.pre_bgm = bg;
            BGM.yukkurishiteittene.play();
        }
    }

    private boolean checkSell() {
        for (Base_Artifact a : MapList.getListArtifact()) {
            if (!this.checkSell(a)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSell(Base_Artifact a) {
        return MassCreater.getMass(a.getMassPoint()).isShop() && !a.isMerchant() && a instanceof Base_Item;
    }

    private boolean checkWarning(Base_Item merchants) {
        return !MapList.getListArtifact().contains(merchants) || !MassCreater.getMass(merchants.getMassPoint()).isShop();
    }

    public void gather() {
        if (this.warning()) {
            this.judgement();
        }
    }

    protected abstract String getHello();

    protected abstract String getHelloRoughly();

    public void goOutMessage() {
        if (this.warning()) {
            new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    CopyOf__\u5e97\u4e3b.this.judgement();
                }
            }.work_appointment();
        } else {
            if (this.pre_bgm != null) {
                this.pre_bgm.play();
            }
            this.pre_bgm = null;
            if (this.isPlayerSide()) {
                Message.set("\u300c\u307e\u305f\u304d\u3066\u306d\uff01\u300d");
            } else {
                Message.set("\u304a\u5e97\u3092\u3042\u3068\u306b\u3057\u305f");
            }
        }
    }

    @Override
    public boolean hasMessage() {
        return this.isPlayerSide();
    }

    @Override
    public boolean isPlayerSide() {
        return this.shop != null && this.HP == this.getMAX_HP() && MapList.getListEnemy().contains(this) && Player.me.shop != null;
    }

    protected void judgement() {
        MapList.judgement();
        this.shop.release();
    }

    @Override
    public void message() {
        if (this.warning()) {
            this.pleasePages();
        } else if (this.checkSell()) {
            this.playerSell(null);
        } else {
            this.wasshoi();
        }
    }

    private void playerSell(String s) {
        final ArrayList<Base_Item> list = new ArrayList<Base_Item>();
        ConvEvent CnE = new ConvEvent(){

            @Override
            protected Book getContent1() {
                return new Book("\u3044\u3044\u3088"){

                    @Override
                    protected void work() {
                        CopyOf__\u5e97\u4e3b.this.say("\u307e\u3044\u3069\u30fc\uff01");
                        for (Base_Item base_Item : list) {
                            Player.me.addBooks(base_Item.getMerchantSoldValue());
                            base_Item.setMerchant(true);
                            (this).CopyOf__\u5e97\u4e3b.this.shop.getItemList().add(base_Item);
                        }
                    }
                };
            }

            @Override
            protected Book getContent2() {
                return new Book("\u3060\u3081"){

                    @Override
                    protected void work() {
                        CopyOf__\u5e97\u4e3b.this.say("\u305d\u3063\u304b\u30fc");
                    }
                };
            }

            @Override
            protected int pushCancelAction() {
                return 2;
            }
        };
        int sum = 0;
        for (Base_Artifact a : MapList.getListArtifact()) {
            if (!this.checkSell(a)) continue;
            list.add((Base_Item)a);
            sum += a.getMerchantSoldValue();
        }
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
        }
        sb.append("\u5e8a\u306b\u7f6e\u3044\u305f\u30a2\u30a4\u30c6\u30e0\u3092$\u3000");
        sb.append(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(sum));
        sb.append("\u30da\u30fc\u30b8\u3000$\u3068\u4ea4\u63db\u3057\u305f\u3044\u3093\u3060\u3051\u3069\u3044\u3044\u304b\u306a\uff1f");
        new Conversation(this.IMLC, sb.toString(), CnE);
    }

    private void pleasePages() {
        final ArrayList<Base_Item> list = new ArrayList<Base_Item>();
        int sum = 0;
        for (Base_Item a : this.shop.getItemList()) {
            if (!this.checkWarning(a)) continue;
            list.add(a);
            sum += a.getMerchantBuyValue();
        }
        final int SUM = sum;
        ConvEvent CnE = new ConvEvent(){

            @Override
            protected Book getContent1() {
                return new Book("\u3044\u3044\u3088"){

                    @Override
                    protected void work() {
                        if (Player.me.getBooks() >= SUM) {
                            SE.SYSTEM_ENCHANT.play();
                            CopyOf__\u5e97\u4e3b.this.say("\u3084\u3063\u305f\u30fc\uff01\u3000\u3042\u308a\u304c\u3068\u306d\uff01");
                            Player.me.addBooks(-SUM);
                            for (Base_Item base_Item : list) {
                                base_Item.setMerchant(false);
                                (this).CopyOf__\u5e97\u4e3b.this.shop.getItemList().remove(base_Item);
                            }
                            (this).CopyOf__\u5e97\u4e3b.this.flag_buyed = true;
                        } else {
                            CopyOf__\u5e97\u4e3b.this.say("\u30da\u30fc\u30b8\u304c\u8db3\u308a\u306a\u3044\u3088");
                        }
                        this.thenNext();
                    }
                };
            }

            @Override
            protected Book getContent2() {
                return new Book("\u3060\u3081"){

                    @Override
                    protected void work() {
                        CopyOf__\u5e97\u4e3b.this.say("\u3061\u3047\u30fc");
                        this.thenNext();
                    }
                };
            }

            @Override
            protected int pushCancelAction() {
                return 2;
            }

            private void thenNext() {
                if (CopyOf__\u5e97\u4e3b.this.checkSell()) {
                    CopyOf__\u5e97\u4e3b.this.playerSell("\u305d\u308c\u306f\u305d\u3046\u3068");
                }
            }
        };
        StringBuilder sb = new StringBuilder();
        sb.append("\u6301\u3063\u3066\u3044\u3063\u305f\u30a2\u30a4\u30c6\u30e0\u306e\u4ee3\u308f\u308a\u306b$\u3000");
        sb.append(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(sum));
        sb.append("\u30da\u30fc\u30b8\u3000$\u6b32\u3057\u3044\u3093\u3060\u3051\u3069\u3044\u3044\u304b\u306a\uff1f");
        new Conversation(this.IMLC, sb.toString(), CnE);
    }

    public void preGoOut() {
        Point p;
        if (this.warning() && this.isPlayerSide() && !this.pre_warning_point.equals(p = Player.me.getMassPoint())) {
            this.pre_warning_point = p;
            this.setDirection(DIRECTION.getDirection(this, Player.me));
            if (this.isSkillActive()) {
                Player.me.setDirection(DIRECTION.getDirection(Player.me, this));
                this.say("\u4ea4\u63db\u304c\u6e08\u3093\u3067\u306a\u3044\u3088\uff1f");
            } else {
                Message.set(this.getColoredName(), "\u306f\u4f55\u304b\u8a00\u3044\u305f\u3052\u306a\u76ee\u3067\u3053\u3061\u3089\u3092\u898b\u3066\u3044\u308b");
            }
        }
    }

    protected void say(String ... strings) {
        new Conversation(this.IMLC, strings);
    }

    public final void shopInMessage() {
        this.bgmPlay();
        if (this.isPlayerSide() && !Player.me.conditionCheck(CONDITION.\u900f\u660e)) {
            if (!this.flag_first_in || Belongings.get(-1) != null) {
                Message.set(this.getHelloRoughly());
            } else {
                this.say(this.getHello());
            }
            this.flag_first_in = false;
        } else {
            Message.set("\u304a\u5e97\u306b\u8db3\u3092\u8e0f\u307f\u5165\u308c\u305f");
        }
    }

    public boolean warning() {
        if (Player.me.shop == null) {
            return false;
        }
        for (Base_Item merchants : this.shop.getItemList()) {
            if (!this.checkWarning(merchants)) continue;
            return true;
        }
        return false;
    }

    protected abstract void wasshoi();
}

