/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.TurnSystemController;
import dangeon.latest.scene.action.menu.first.adventure.medal.Medal;
import dangeon.model.condition.CONDITION;
import dangeon.model.condition.Confusion;
import dangeon.model.config.Config;
import dangeon.model.map.InitialPlacement;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import dangeon.util.STAGE;
import dangeon.view.anime.OuraEffect;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import main.res.Image_LargeCharacter;
import main.res.SE;
import main.util.CSVLoadSupporter;
import main.util.DIRECTION;

public abstract class Base_Enemy
extends Base_Creature {
    private static final long serialVersionUID = 1L;
    private int largement;
    protected List<Point> list_room_in_root = new ArrayList<Point>();
    public static boolean enemy_move_wait = false;
    public boolean enemy_actioned = false;
    public boolean enemy_condition_actioned = false;
    public boolean player_is_in_sight = false;
    Mass[][] mass;
    protected int count_sight = 0;
    private Point player_back_point;
    protected boolean special_possible_check;
    public boolean special_ok;
    public boolean flag_move;
    public boolean flag_2nd_move;
    public boolean flag_3rd_move;
    private Point back_point;
    private Point root;
    Point kaguya;
    private int move_limit;
    private List<Point> list_road;
    public int turn_count;
    private int count_max;
    private boolean random;
    private boolean flag_skill_checking_now;
    private static String[] color_name = new String[]{Color.PINK.toString(), Color.PINK.toString(), new Color(255, 100, 100).toString(), Color.RED.toString()};
    private static String color_white = Color.WHITE.toString();
    private String explain_hold_action;
    private SE attack_se;
    private String tati_e;
    private int SIZE_HP;
    private int SIZE_STR;

    public Base_Enemy(Point p, int LV) {
        super(p, "_NO_DATA_", LV);
        this.player_back_point = Mass.nullpo.null_point;
        this.special_possible_check = false;
        this.special_ok = false;
        this.flag_move = false;
        this.back_point = new Point(0, 0);
        this.root = new Point();
        this.kaguya = new Point(-10, -10);
        this.move_limit = 0;
        this.list_road = new ArrayList<Point>();
        this.turn_count = 0;
        this.count_max = 3;
        this.massCheck();
    }

    public Base_Enemy(Point p, String name, int LV) {
        super(p, name, LV);
        this.player_back_point = Mass.nullpo.null_point;
        this.special_possible_check = false;
        this.special_ok = false;
        this.flag_move = false;
        this.back_point = new Point(0, 0);
        this.root = new Point();
        this.kaguya = new Point(-10, -10);
        this.move_limit = 0;
        this.list_road = new ArrayList<Point>();
        this.turn_count = 0;
        this.count_max = 3;
        this.massCheck();
    }

    public void action() {
        if (this.special_ok) {
            return;
        }
        this.playerSearch();
        if (!(this.special_possible_check || !this.isSkillActive() || Player.me.getConditionList().contains((Object)CONDITION.\u3084\u308a\u3059\u3054\u3057) || Player.me.getConditionList().contains((Object)CONDITION.\u6697\u95c7) || Player.me.getConditionList().contains((Object)CONDITION.\u900f\u660e))) {
            this.special_possible_check = true;
            if (this.specialCheck()) {
                this.special_ok = true;
                return;
            }
        }
        this.enemyMovePossible();
    }

    public final void attack() {
        this.normalAttack(false);
    }

    protected final boolean attack_possible() {
        if (CONDITION.enemyDontMove(this)) {
            return false;
        }
        if (this.isPlayerSide()) {
            return false;
        }
        if (this.isAbleToAttackWhileNeglectingWall()) {
            return this.playerIsInNeiver();
        }
        return this.attack_possible_Normally();
    }

    private boolean attack_possible_Normally() {
        Point p = Player.me.getMassPoint();
        if (this.playerIsInNeiver()) {
            if (!MassCreater.getMass((Point)p).WALKABLE) {
                return false;
            }
            return !(this.getMassPoint().x < p.x && this.getMassPoint().y < p.y ? !this.mass[this.getMassPoint().x + 1][this.getMassPoint().y].WALKABLE || !this.mass[this.getMassPoint().x][this.getMassPoint().y + 1].WALKABLE : (this.getMassPoint().x < p.x && this.getMassPoint().y > p.y ? !this.mass[this.getMassPoint().x + 1][this.getMassPoint().y].WALKABLE || !this.mass[this.getMassPoint().x][this.getMassPoint().y - 1].WALKABLE : (this.getMassPoint().x > p.x && this.getMassPoint().y < p.y ? !this.mass[this.getMassPoint().x - 1][this.getMassPoint().y].WALKABLE || !this.mass[this.getMassPoint().x][this.getMassPoint().y + 1].WALKABLE : this.getMassPoint().x > p.x && this.getMassPoint().y > p.y && (!this.mass[this.getMassPoint().x - 1][this.getMassPoint().y].WALKABLE || !this.mass[this.getMassPoint().x][this.getMassPoint().y - 1].WALKABLE))));
        }
        return false;
    }

    public void attackOrSpecial() {
        if (!CONDITION.isMovable(this)) {
            this.enemy_actioned = true;
            return;
        }
        if (this.conditionChecker()) {
            this.enemy_actioned = true;
            return;
        }
        if (this.enemy_condition_actioned) {
            this.enemy_actioned = true;
            return;
        }
        if (this.special_ok && this.isSkillActive()) {
            boolean flag_ok = false;
            this.flag_skill_checking_now = true;
            this.playerSearch();
            if (this.specialCheck()) {
                flag_ok = true;
            }
            this.flag_skill_checking_now = false;
            if (flag_ok && this.specialAttack()) {
                this.enemy_actioned = true;
                return;
            }
        }
        if (this.attack_possible()) {
            this.attack();
        }
        this.enemy_actioned = true;
    }

    public boolean attackPossibleFromEnemy(Base_Creature base_Creature) {
        Point p = base_Creature.getMassPoint();
        if (this.getMassPoint().x < p.x && this.getMassPoint().y < p.y) {
            if (!this.mass[this.getMassPoint().x + 1][this.getMassPoint().y].WALKABLE || !this.mass[this.getMassPoint().x][this.getMassPoint().y + 1].WALKABLE) {
                return false;
            }
        } else if (this.getMassPoint().x < p.x && this.getMassPoint().y > p.y) {
            if (!this.mass[this.getMassPoint().x + 1][this.getMassPoint().y].WALKABLE || !this.mass[this.getMassPoint().x][this.getMassPoint().y - 1].WALKABLE) {
                return false;
            }
        } else if (this.getMassPoint().x > p.x && this.getMassPoint().y < p.y) {
            if (!this.mass[this.getMassPoint().x - 1][this.getMassPoint().y].WALKABLE || !this.mass[this.getMassPoint().x][this.getMassPoint().y + 1].WALKABLE) {
                return false;
            }
        } else if (this.getMassPoint().x > p.x && this.getMassPoint().y > p.y) {
            if (!this.mass[this.getMassPoint().x - 1][this.getMassPoint().y].WALKABLE || !this.mass[this.getMassPoint().x][this.getMassPoint().y - 1].WALKABLE) {
                return false;
            }
        } else {
            return true;
        }
        return false;
    }

    public void battleCounterAction() {
    }

    private void branch() {
        Point point = this.getMassPoint();
        ArrayList<Point> list = new ArrayList<Point>();
        if (this.rootIsAround()) {
            if (this.movePoint(this.player_back_point, false, false)) {
                if (point.equals(this.player_back_point)) {
                    this.setPlayerBackPoint(Mass.nullpo.null_point);
                }
                return;
            }
            this.moveStopCount();
            return;
        }
        for (Point p : this.list_road) {
            if (p.x == this.back_point.x && p.y == this.back_point.y) continue;
            list.add(p);
        }
        int select = new R().nextInt(list.size());
        System.out.println(list);
        Point p = (Point)list.get(select);
        if (MapList.getCreature(p) == null && this.movable_water_check(p)) {
            this.enemy_move(p.x - point.x, p.y - point.y, this.converDirection(p));
            return;
        }
        list.remove(p);
        int select_second = new R().nextInt(list.size());
        p = (Point)list.get(select_second);
        if (MapList.getCreature(p) == null && !MassCreater.getMass((Point)p).WATER) {
            this.enemy_move(p.x - point.x, p.y - point.y, this.converDirection(p));
            return;
        }
        list.remove(p);
        if (list.isEmpty()) {
            this.moveStopCount();
            return;
        }
        Point fp = (Point)list.get(0);
        if (MapList.getCreature(fp) == null && !MassCreater.getMass((Point)fp).WATER) {
            this.enemy_move(fp.x - point.x, fp.y - point.y, this.converDirection(fp));
            return;
        }
        if (!enemy_move_wait) {
            return;
        }
        this.moveStopCount();
    }

    public void changeSize(int delt) {
        if ((delt += this.largement) > 1) {
            this.setHuge();
        } else if (delt == 1) {
            this.setBig();
        } else if (delt == 0) {
            this.setNeutral();
        } else {
            this.setSmall();
        }
        if (this.MAX_STR <= 0) {
            this.MAX_STR = 1;
        }
        if (this.getMAX_HP() <= 0) {
            this.setMAX_HP(1);
        }
        if (this.HP <= 0) {
            this.HP = 1;
        }
        if (this.STR <= 0) {
            this.STR = 1;
        }
    }

    private boolean conditionChecker() {
        if (this.getConditionList().contains((Object)CONDITION.\u6df7\u4e71)) {
            if (this.attack_possible()) {
                Confusion.randomAttack(this);
            }
            return true;
        }
        return false;
    }

    public Base_Enemy createEnemySet\u4eee\u7720(boolean b) {
        if (b) {
            this.setConditionList(CONDITION.\u7279\u6b8a\u4eee\u7720, 0);
        } else {
            CONDITION.conditionRecovery(this, CONDITION.\u7279\u6b8a\u4eee\u7720);
        }
        return this;
    }

    public void directionPointRoomInRoot(DIRECTION d) {
        Point p = this.getMassPoint();
        int x = d.X;
        int y = d.Y;
        while (MassCreater.getMass((int)(p.x + (x += d.X)), (int)(p.y + (y += d.Y))).WALKABLE) {
            if (!MassCreater.getMass((int)(p.x + x), (int)(p.y + y)).ROOM) continue;
            this.setRoot(new Point(p.x + x, p.y + y));
            break;
        }
    }

    public boolean enchantEnemySpecialAction() {
        return false;
    }

    public final void enemy_move(int x, int y, DIRECTION dir) {
        if (this.getMassPoint().x == this.player_back_point.x && this.getMassPoint().y == this.player_back_point.y) {
            this.setPlayerBackPoint(Mass.nullpo.null_point);
        }
        this.back_point = this.getMassPoint().getLocation();
        this.delt.x = -x * 50;
        this.delt.y = -y * 50;
        this.mass_point.x += x;
        this.mass_point.y += y;
        this.direction = dir;
        this.turn_count = 0;
        this.enemy_actioned = true;
        this.flag_move = true;
        if (TurnSystemController.isAbleToMoveAdditionally(this)) {
            this.enemy_actioned = false;
            this.action();
            if (TaskOnMapObject.getEnemyMoveTask().remove(this)) {
                this.moving();
            } else if (this.flag_3rd_move) {
                this.flag_3rd_move = false;
            } else {
                this.flag_2nd_move = false;
            }
            this.enemy_actioned = true;
        }
        boolean cfr_ignored_0 = MassCreater.getMass((Point)this.getMassPoint()).WALKABLE;
    }

    public void enemyMovePossible() {
        boolean move_possible = false;
        if (this.getConditionList().contains((Object)CONDITION.\u6df7\u4e71) && !Confusion.movePossible(this)) {
            return;
        }
        if (this.isWall_walk()) {
            if (this.specialMoveCheck()) {
                move_possible = true;
            }
        } else if (this.isRandom_walk()) {
            if (this.specialMoveCheck()) {
                move_possible = true;
            }
        } else if (!this.player_is_in_sight) {
            move_possible = true;
        } else if (!this.attack_possible()) {
            move_possible = true;
        }
        if (move_possible) {
            TaskOnMapObject.addEnemyMoveTask(this);
            return;
        }
    }

    protected boolean enemyOrWalkable(boolean Walkable_through, Point p) {
        if (MassCreater.isPointOutOfDangeon(p)) {
            return false;
        }
        return this.movePoint(p, MassCreater.getMass((Point)this.getMassPoint()).ROOM, Walkable_through);
    }

    @Override
    public SE getAttackSE() {
        return this.attack_se;
    }

    @Override
    public String getColoredName() {
        return color_name[this.largement + 1].concat(super.getColoredName()).concat(color_white);
    }

    public int getDeConvertedLV(int lv) {
        return lv;
    }

    @Override
    public int getDEF() {
        if (this.getConditionList().contains((Object)CONDITION.\u30d1\u30ef\u30fc\u30a2\u30c3\u30d7)) {
            return super.getDEF() * 15 / 10;
        }
        return super.getDEF();
    }

    @Override
    public DIRECTION getDirection() {
        return this.direction;
    }

    protected DIRECTION getDirectionRandomMove(boolean walkable) {
        ArrayList<Point> list = new ArrayList<Point>();
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                Point p;
                if (!(i == 0 && j == 0 || MassCreater.isPointOutOfDangeon(p = new Point(this.getMassPoint().x + i, this.getMassPoint().y + j)))) {
                    if (walkable) {
                        if (MapList.getCreature(p) == null && MassCreater.getMass((Point)p).WALKABLE && !MassCreater.getMass((Point)p).WATER) {
                            list.add(p);
                        }
                    } else if (this.movePointDirection(p, walkable)) {
                        list.add(p);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (list.isEmpty()) {
            return DIRECTION.DOWN;
        }
        int select = new R().nextInt(list.size());
        Point p = (Point)list.get(select);
        DIRECTION dir = this.converDirection(p);
        return dir;
    }

    public String getExplanHoldAction() {
        return this.explain_hold_action;
    }

    public final String getExplanHoldEffect() {
        return "\u7279\u306b\u7121\u3057";
    }

    protected CONDITION getInitCondition() {
        return null;
    }

    public int getLargement() {
        return this.largement;
    }

    public String getOriginalName() {
        return this.tati_e;
    }

    public Point getPlayerBackPoint() {
        return this.player_back_point;
    }

    public boolean getPlayerIsInSight() {
        return this.player_is_in_sight;
    }

    public Point getRoot() {
        return this.root;
    }

    public int getSize() {
        return this.size;
    }

    public ArrayList<String> getSpecialActionExplain() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("\u7279\u306b\u306a\u3057");
        return list;
    }

    public int getSpecialParcent() {
        return this.special_attack_parcent;
    }

    @Override
    public int getSTR() {
        if (this.getConditionList().contains((Object)CONDITION.\u30d1\u30ef\u30fc\u30a2\u30c3\u30d7)) {
            return this.STR * 15 / 10;
        }
        return this.STR;
    }

    public Image_LargeCharacter getTatiE() {
        return Image_LargeCharacter.get(this.tati_e);
    }

    public boolean hasMessage() {
        return false;
    }

    private void init() {
        CONDITION c = this.getInitCondition();
        if (c != null) {
            this.setCondition(c, 0);
        }
    }

    protected void init1() {
    }

    protected void init2() {
    }

    protected void init3() {
    }

    protected void init4() {
    }

    public int isKamin() {
        return 30;
    }

    protected boolean isRange() {
        return this.attack_possible();
    }

    protected boolean isSpecialParcent() {
        if (!this.isSkillActive()) {
            return false;
        }
        if (this.flag_skill_checking_now) {
            return true;
        }
        int parcent = this.getSpecialParcent();
        if (parcent != 0) {
            if (this.getConditionList().contains((Object)CONDITION.\u30a4\u30ab\u30ea)) {
                return true;
            }
            if (parcent >= new R().nextInt(100) + 1) {
                return true;
            }
        }
        return false;
    }

    public boolean itemHit() {
        return true;
    }

    private void loop() {
        if (Player.me.getConditionList().contains((Object)CONDITION.\u3084\u308a\u3059\u3054\u3057)) {
            return;
        }
        if (Player.me.getConditionList().contains((Object)CONDITION.\u900f\u660e)) {
            return;
        }
        if (MassCreater.isPlayerInTheSightFromThePoint(this.getMassPoint(), 1)) {
            this.player_is_in_sight = true;
            this.RoomInRootClear();
            if (MassCreater.getMass((Point)Player.me.getMassPoint()).ROAD) {
                Point p = Player.me.getMassPoint().getLocation();
                this.setRoot(p);
            }
        }
    }

    public void massCheck() {
        if (this.mass == null) {
            this.mass = MassCreater.getMass();
        }
    }

    public boolean massChecker(Point p) {
        return MassCreater.getMass(p) != null;
    }

    public void message() {
    }

    public boolean moveCheck(DIRECTION dir, boolean through) {
        Point p = this.getMassPoint().getLocation();
        if (!this.isWall_walk() && (dir.NUM % 2 != 0 ? !this.moveToWalkableCheck(dir) : !MassCreater.getMass((Point)new Point((int)(p.x + dir.X), (int)(p.y + dir.Y))).WALKABLE)) {
            return false;
        }
        p = new Point(p.x + dir.X, p.y + dir.Y);
        return MapList.getCreature(p) == null && this.movable_water_check(p);
    }

    protected boolean moveConditionChecker() {
        if (this.getConditionList().contains((Object)CONDITION.\u5f71\u7e2b\u3044)) {
            return true;
        }
        if (this.getConditionList().contains((Object)CONDITION.\u6df7\u4e71)) {
            Confusion.enemyRandomMove(this);
            return true;
        }
        return false;
    }

    private void moveLimit() {
        Point p = this.getMassPoint();
        int x = Math.abs(this.root.x - p.x);
        int y = Math.abs(this.root.y - p.y);
        this.move_limit = x + y + 1;
    }

    public boolean movePoint(Point p, boolean room, boolean through) {
        int abs_y;
        DIRECTION d = this.converDirection(p);
        List<DIRECTION> list = DIRECTION.neiberDirection(d);
        if (this.movePoint1(list.get(0), through)) {
            return true;
        }
        DIRECTION d3 = list.get(3);
        DIRECTION d4 = list.get(4);
        int abs_x = Math.abs(p.x - this.getMassPoint().x);
        if (abs_x != (abs_y = Math.abs(p.y - this.getMassPoint().y)) && abs_x != 0 && abs_y != 0) {
            list.clear();
            if (abs_x > abs_y) {
                list.add(p.x - this.getMassPoint().x > 0 ? DIRECTION.RIGHT : DIRECTION.LEFT);
                list.add(p.y - this.getMassPoint().y > 0 ? DIRECTION.DOWN : DIRECTION.UP);
            } else {
                list.add(p.y - this.getMassPoint().y > 0 ? DIRECTION.DOWN : DIRECTION.UP);
                list.add(p.x - this.getMassPoint().x > 0 ? DIRECTION.RIGHT : DIRECTION.LEFT);
            }
            list.add(d3);
            list.add(d4);
        }
        int i = 0;
        while (i < list.size()) {
            if (i >= 3 && !room) {
                return false;
            }
            DIRECTION dir = list.get(i);
            if (this.movePoint1(dir, through)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean movePoint1(DIRECTION dir, boolean through) {
        if (this.moveCheck(dir, through)) {
            this.enemy_move(dir.X, dir.Y, dir);
            return true;
        }
        return false;
    }

    public boolean movePointDirection(Point p, boolean walkable) {
        boolean room = MassCreater.getMass((Point)p).ROOM;
        List<DIRECTION> list = DIRECTION.neiberDirection(this.converDirection(p));
        int i = 0;
        while (i < list.size()) {
            if (i >= 3 && !room) {
                return false;
            }
            DIRECTION dir = list.get(i);
            if (!this.moveCheck(dir, walkable)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void moveStopCount() {
        if (this.count_max <= this.turn_count) {
            this.turn_count = 0;
            if (this.movePoint(new Point(this.mass_point.x - this.direction.X, this.mass_point.y - this.direction.Y), false, false)) {
                return;
            }
            if (enemy_move_wait) {
                this.enemy_actioned = true;
            }
        } else {
            ++this.turn_count;
            this.enemy_actioned = true;
        }
    }

    protected boolean moveToWalkableCheck(DIRECTION d) {
        List<DIRECTION> list = DIRECTION.neiberDirection(d);
        if (!MassCreater.getMass((Point)new Point((int)(this.getMassPoint().x + list.get((int)0).X), (int)(this.getMassPoint().y + list.get((int)0).Y))).WALKABLE) {
            return false;
        }
        Point first = this.getMassPoint();
        Point second = this.getMassPoint();
        first = new Point(first.x + list.get((int)1).X, first.y + list.get((int)1).Y);
        second = new Point(second.x + list.get((int)2).X, second.y + list.get((int)2).Y);
        return MassCreater.getMass((Point)first).WALKABLE && MassCreater.getMass((Point)second).WALKABLE;
    }

    public void moving() {
        if (this.moveConditionChecker()) {
            this.enemy_actioned = true;
            return;
        }
        if (this.specialMove()) {
            this.playerIsInNeiver();
            return;
        }
        if (this.player_is_in_sight && !Player.me.getConditionList().contains((Object)CONDITION.\u3084\u308a\u3059\u3054\u3057) && !Player.me.getConditionList().contains((Object)CONDITION.\u900f\u660e)) {
            this.testAproach();
        } else {
            this.testTroop();
        }
        this.playerIsInNeiver();
    }

    @Override
    protected final String nameLevel() {
        return this.name;
    }

    public boolean playerChecked() {
        if (this.playerIsInNeiver()) {
            this.player_is_in_sight = true;
            return true;
        }
        this.player_is_in_sight = false;
        return false;
    }

    @Override
    public boolean playerIsInNeiver() {
        if (Player.me.getConditionList().contains((Object)CONDITION.\u3084\u308a\u3059\u3054\u3057)) {
            return false;
        }
        if (Player.me.getConditionList().contains((Object)CONDITION.\u900f\u660e)) {
            return false;
        }
        Point p = Player.me.getMassPoint();
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                if (this.getMassPoint().x + i == p.x && this.getMassPoint().y + j == p.y) {
                    this.player_is_in_sight = true;
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void playerPointIsEntrancePoint() {
    }

    private void playerSearch() {
        this.player_is_in_sight = false;
        this.whereIsPlayer();
    }

    protected void powerUP() {
        if (++this.power_up_count >= 2) {
            this.setFlagWarning();
        }
        this.setSecondAnimation(new OuraEffect((Base_Creature)this, true));
        SE.STATUS_POWER_UP.play();
        this.changeMAX_STR(this.getSTR() * 15 / 10);
        this.setSTR(this.getMAX_STR());
    }

    private void preChangeSize() {
        if (this.SIZE_HP == 0 && this.SIZE_STR == 0) {
            this.SIZE_HP = this.getMAX_HP();
            this.SIZE_STR = this.MAX_STR;
        }
        if (this.largement != 0) {
            if (this.largement == -1) {
                this.HP *= 2;
                this.STR *= 2;
            } else if (this.largement == 2) {
                this.HP /= 2;
                this.STR = this.STR * 2 / 3;
            } else if (this.largement == 3) {
                this.HP /= 3;
                this.STR /= 2;
            }
        }
    }

    protected DIRECTION randomMoveDirection(boolean walkable) {
        ArrayList<Point> list = new ArrayList<Point>();
        DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (this.moveCheck(d, walkable)) {
                Point p = new Point(this.getMassPoint().x + d.X, this.getMassPoint().y + d.Y);
                list.add(p);
            }
            ++n2;
        }
        if (list.isEmpty()) {
            return DIRECTION.DOWN;
        }
        int select = new R().nextInt(list.size());
        Point p = (Point)list.get(select);
        DIRECTION dir = this.converDirection(p);
        this.enemy_move(dir.X, dir.Y, dir);
        return dir;
    }

    private void randomRoot(List<Point> list) {
        ArrayList<Point> l = new ArrayList<Point>();
        Point em = this.getMassPoint().getLocation();
        if (list.isEmpty()) {
            DIRECTION dir = this.getDirectionRandomMove(false);
            this.root = new Point(this.getMassPoint().x + dir.X, this.getMassPoint().y + dir.Y);
            return;
        }
        if (list.size() == 1) {
            this.root = list.get(0);
            return;
        }
        for (Point p : list) {
            Point ep = new Point(em.x - this.direction.X, em.y - this.direction.Y);
            if (p.x == ep.x && p.y == ep.y) continue;
            l.add(p);
        }
        int select = new R().nextInt(l.size());
        this.root = (Point)l.get(select);
    }

    private boolean randomWalk() {
        if (!this.specialMoveCheck()) {
            return false;
        }
        this.randomMoveDirection(false);
        return true;
    }

    protected boolean range(int length, boolean only_effective_when_player_is_in_sight) {
        if (only_effective_when_player_is_in_sight && !this.player_is_in_sight) {
            return false;
        }
        if (length == -1) {
            length = Math.max(30, 40);
        }
        DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            Point p = this.getMassPoint().getLocation();
            int i = 0;
            while (i < length) {
                p.translate(d.X, d.Y);
                if (MapList.getCreature(p) instanceof Player) {
                    return true;
                }
                ++i;
            }
            ++n2;
        }
        return false;
    }

    private void roomInRoadCheck(Point p) {
        this.list_road.clear();
        InitialPlacement.Room r = MassCreater.getRoom(this.getMassPoint().x, this.getMassPoint().y);
        for (Point point : r.getListEntrance()) {
            this.list_road.add(point);
        }
    }

    private boolean roomInRoot() {
        return this.list_road.isEmpty() || this.root.x == this.getMassPoint().x && this.root.y == this.getMassPoint().y;
    }

    public void RoomInRootClear() {
        this.list_road.clear();
        this.move_limit = 0;
    }

    private void rootInRoad() {
        Point p = this.mass_point.getLocation();
        int i = -1;
        while (i <= 1) {
            if (i != 0) {
                if (MassCreater.getMass((Point)new Point((int)(p.x + i), (int)p.y)).ROAD) {
                    this.list_road.add(new Point(p.x + i, p.y));
                }
                if (MassCreater.getMass((Point)new Point((int)p.x, (int)(p.y + i))).ROAD) {
                    this.list_road.add(new Point(p.x, p.y + i));
                }
            }
            ++i;
        }
        if (this.list_road.size() == 1 || this.list_road.isEmpty()) {
            if (this.movePoint(new Point(p.x + this.direction.X, p.y + this.direction.Y), true, false)) {
                return;
            }
            if (this.count_max <= this.turn_count) {
                Point dir = new Point(this.getMassPoint().x - this.direction.X, this.getMassPoint().y - this.direction.Y);
                this.direction = this.converDirection(dir);
                this.turn_count = 0;
                this.enemy_actioned = true;
            } else {
                ++this.turn_count;
            }
        } else if (this.list_road.size() == 2) {
            Point p2 = new Point(p.x + this.direction.X, p.y + this.direction.Y);
            if (!this.movePoint(p2, true, false)) {
                if (this.count_max <= this.turn_count) {
                    this.turn_count = 0;
                    Point direct = new Point(this.getMassPoint().x - this.direction.X, this.getMassPoint().y - this.direction.Y);
                    this.direction = this.converDirection(direct);
                    this.enemy_actioned = true;
                } else {
                    ++this.turn_count;
                }
            }
        } else {
            this.branch();
        }
    }

    public boolean rootIsAround() {
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                if ((i != 0 || j != 0) && this.getMassPoint().x + i == this.player_back_point.x && this.getMassPoint().y + j == this.player_back_point.y) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    protected void saveKO() {
        Config.save(this, this.getConvertedLV(), true);
        Medal.\u4eca\u307e\u3067\u3067\u5408\u8a08XX\u4f53\u306e\u6575\u3092\u3084\u3063\u3064\u3051\u305f.addCount();
    }

    protected void set2timesWalk() {
        this.setCondition(CONDITION.\u500d\u901f, 0);
    }

    protected void set3timesWalk() {
        this.setCondition(CONDITION.\u4e09\u500d\u901f, 0);
    }

    @Override
    protected void setBeatedAway() {
        this.saveKO();
        super.setBeatedAway();
    }

    private void setBig() {
        this.preChangeSize();
        this.SIZE_MAX = 150;
        this.size = 150;
        this.setMAX_HP(this.SIZE_HP * 2);
        this.MAX_STR = this.SIZE_STR * 3 / 2;
        this.HP *= 2;
        this.STR = this.STR * 3 / 2;
        this.largement = 1;
    }

    public Base_Enemy setConditionList(CONDITION condition, int timer) {
        super.setCondition(condition, timer);
        return this;
    }

    public Base_Enemy setDirection(DIRECTION d) {
        this.attacking_direction = d;
        this.direction = d;
        return this;
    }

    public Base_Enemy setFlagWarning() {
        this.flag_warning = true;
        return this;
    }

    protected void setHalfWalk() {
        this.setCondition(CONDITION.\u920d\u8db3, 0);
    }

    private void setHuge() {
        this.preChangeSize();
        this.SIZE_MAX = 200;
        this.size = 200;
        this.setMAX_HP(this.SIZE_HP * 3);
        this.MAX_STR = this.SIZE_STR * 2;
        this.HP *= 3;
        this.STR *= 2;
        this.largement = 2;
    }

    @Override
    public void setNameAndStatus() {
        STAGE[] stages;
        this.largement = 0;
        this.SIZE_MAX = 100;
        this.size = 100;
        this.setStateChengeByLevelUp();
        this.nameLevel();
        this.statusLevel();
        if (this.LV < 1) {
            super.setNameAndStatus();
            return;
        }
        CSVLoadSupporter<String> list = CSVLoadSupporter.loadCSV(String.valueOf(this.LV) + "_" + this.getClass().getSimpleName(), this.getClass(), "\t");
        if (list == null) {
            super.setNameAndStatus();
            return;
        }
        this.name = list.get();
        this.HP = list.toI();
        this.setMAX_HP(this.HP);
        this.MAX_STR = this.STR = list.toI();
        this.MAX_DEF = this.DEF = list.toI();
        this.setENEMY_EXP(list.toI());
        this.setSpecialAttackParcent(list.toI());
        this.explain_hold_action = list.get();
        this.tati_e = list.get();
        if (this.tati_e.isEmpty()) {
            this.tati_e = this.getClass().getSimpleName();
        }
        this.floating = list.isTrue();
        this.boating = list.isTrue();
        String g = list.get();
        this.Ghost = g.matches("true") || g.matches("TRUE") ? -1 : (g.matches("half") ? 0 : 1);
        this.Fire = list.isTrue();
        this.Ice = list.isTrue();
        this.Thunder = list.isTrue();
        this.Magic = list.isTrue();
        this.setRandom_walk(list.isTrue());
        this.setWall_walk(list.isTrue());
        this.list_category.clear();
        STAGE[] sTAGEArray = stages = new STAGE[]{STAGE.\u7d05\u9b54\u90f7, STAGE.\u5996\u3005\u5922, STAGE.\u6c38\u591c\u6284, STAGE.\u82b1\u6620\u585a, STAGE.\u98a8\u795e\u9332, STAGE.\u5730\u970a\u6bbf, STAGE.\u661f\u84ee\u8239, STAGE.\u795e\u970a\u5edf, STAGE.\u8f1d\u91dd\u57ce, STAGE.\u5916\u4f1d};
        int n = stages.length;
        int n2 = 0;
        while (n2 < n) {
            STAGE stage = sTAGEArray[n2];
            if (list.isTrue()) {
                this.list_category.add(stage);
            }
            ++n2;
        }
        this.attack_se = SE.get(list.get());
        this.init();
        if (this.LV == 1) {
            this.init1();
        } else if (this.LV == 2) {
            this.init2();
        } else if (this.LV == 3) {
            this.init3();
        } else if (this.LV == 4) {
            this.init4();
        }
    }

    private void setNeutral() {
        this.preChangeSize();
        this.SIZE_MAX = 100;
        this.size = 100;
        this.setMAX_HP(this.SIZE_HP);
        this.MAX_STR = this.SIZE_STR;
        this.largement = 0;
    }

    public void setPlayerBackPoint(Point p) {
        this.player_back_point = p;
    }

    public void setRoot(Point p) {
        if (p == null) {
            this.list_road.clear();
            this.root = this.getMassPoint().getLocation();
            return;
        }
        this.list_road.clear();
        this.list_road.add(p);
        this.root = p;
        this.moveLimit();
    }

    public void setSize() {
        int size = PresentField.get().getEnemySize();
        if (PresentField.get().isWarningEnemy()) {
            int r = R.ran(1000);
            this.flag_warning = true;
            if (PresentField.get().isLvUpedEnemy() && this.LV != 1 && this.LV != 4 && new R().is(75) && !this.isPlayerSide() && this.getMaxLV() < 5) {
                if (r < 30) {
                    int lv = this.LV;
                    CONDITION.conditionAllClear(this);
                    this.chengeLv(lv + 1);
                    if (this.getName().startsWith("*")) {
                        CONDITION.conditionAllClear(this);
                        this.chengeLv(lv);
                        this.flag_warning = false;
                    }
                } else {
                    this.flag_warning = false;
                }
            } else if (r < 5) {
                --size;
            } else if (r < 30) {
                ++size;
            } else {
                this.flag_warning = false;
            }
        } else if (size == 0) {
            return;
        }
        this.changeSize(size);
    }

    private void setSmall() {
        this.preChangeSize();
        this.SIZE_MAX = 50;
        this.size = 50;
        this.setMAX_HP(this.SIZE_HP / 2);
        this.MAX_STR = this.SIZE_STR / 2;
        this.HP /= 2;
        this.STR /= 2;
        this.largement = -1;
    }

    protected void setSpecialAttackParcent(int parcent) {
        this.special_attack_parcent = parcent;
    }

    protected void setSpecialHuge() {
        this.preChangeSize();
        this.SIZE_MAX = 250;
        this.size = 250;
        this.setMAX_HP(this.SIZE_HP * 3);
        this.MAX_STR = this.SIZE_STR * 2;
        this.HP *= 3;
        this.STR *= 2;
        this.largement = 2;
    }

    protected void setStateChengeByLevelUp() {
    }

    protected void special() {
    }

    protected boolean specialAttack() {
        return false;
    }

    protected abstract boolean specialCheck();

    protected boolean specialMove() {
        if (this.isWall_walk()) {
            return this.wallWalk();
        }
        if (this.isRandom_walk()) {
            return this.randomWalk();
        }
        return false;
    }

    protected final boolean specialMoveCheck() {
        if (this.isWall_walk()) {
            return this.wallWalkMoveCheck();
        }
        if (this.isRandom_walk()) {
            return this.specialMoveParcent();
        }
        return false;
    }

    protected boolean specialMoveParcent() {
        int parcent;
        int n = parcent = this.attack_possible() ? 15 : 50;
        return new R().is(parcent);
    }

    public void startTurn() {
        this.special_possible_check = false;
        this.special_ok = false;
    }

    @Override
    protected final List<Integer> statusLevel() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2);
        list.add(8);
        list.add(3);
        list.add(2);
        return list;
    }

    private void testAproach() {
        if (this.movePoint(Player.me.getMassPoint(), true, false)) {
            return;
        }
        if (enemy_move_wait) {
            this.enemy_actioned = true;
        }
    }

    protected void testTroop() {
        if (MassCreater.getMass((Point)this.mass_point).ROOM) {
            if (this.roomInRoot() || this.move_limit == 1) {
                this.roomInRoadCheck(this.getMassPoint());
                this.randomRoot(this.list_road);
                this.moveLimit();
            }
            this.troopInRoom();
            return;
        }
        if (MassCreater.getMass((Point)this.mass_point).ROAD) {
            this.RoomInRootClear();
            this.troopInRoad();
            this.RoomInRootClear();
            return;
        }
    }

    private void troopInRoad() {
        this.rootInRoad();
    }

    private void troopInRoom() {
        --this.move_limit;
        this.movePoint(this.root, true, false);
    }

    @Override
    public void upDate(int MOVE_SPEED) {
        if (this.flag_2nd_move && this.flag_3rd_move) {
            MOVE_SPEED *= 3;
        } else if (this.flag_2nd_move || this.flag_3rd_move) {
            MOVE_SPEED *= 2;
        }
        super.upDate(MOVE_SPEED);
    }

    protected void walkableThrough() {
        DIRECTION dir = this.converDirection(Player.me.getMassPoint());
        this.movePoint(new Point(this.getMassPoint().x + dir.X, this.getMassPoint().y + dir.Y), false, true);
    }

    protected boolean walkableThroughCheck() {
        return false;
    }

    private boolean wallWalk() {
        if (Player.me.getConditionList().contains((Object)CONDITION.\u3084\u308a\u3059\u3054\u3057) || Player.me.getConditionList().contains((Object)CONDITION.\u900f\u660e)) {
            this.randomMoveDirection(true);
            return true;
        }
        if (this.random) {
            this.randomMoveDirection(true);
            return true;
        }
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                if (Player.me.getMassPoint().x == this.getMassPoint().x + i && Player.me.getMassPoint().y == this.getMassPoint().y + j) {
                    this.randomMoveDirection(true);
                }
                ++j;
            }
            ++i;
        }
        this.walkableThrough();
        return true;
    }

    private boolean wallWalkMoveCheck() {
        if (Player.me.getConditionList().contains((Object)CONDITION.\u3084\u308a\u3059\u3054\u3057) || Player.me.getConditionList().contains((Object)CONDITION.\u900f\u660e)) {
            this.random = true;
            return true;
        }
        if (this.isSkillActive() && this.isRandom_walk() && this.specialMoveParcent()) {
            this.random = true;
            return true;
        }
        if (this.attack_possible()) {
            return false;
        }
        this.random = false;
        return true;
    }

    public void whereIsPlayer() {
        this.whereIsPlayer(true);
    }

    public void whereIsPlayer(boolean directing) {
        this.massCheck();
        try {
            if (this.mass[this.getMassPoint().x][this.getMassPoint().y].ROOM) {
                this.loop();
            } else if (this.mass[this.getMassPoint().x][this.getMassPoint().y].ROAD) {
                this.RoomInRootClear();
                if (!this.playerIsInNeiver()) {
                    int i = -1;
                    while (i <= 1) {
                        int j = -1;
                        while (j <= 1) {
                            if (MassCreater.getMass((Point)new Point((int)(this.mass_point.x + i), (int)(this.mass_point.y + j))).ROOM) {
                                this.loop();
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("" + this + this.getMassPoint() + this.mass[1][1].WALKABLE);
        }
        if (this.player_is_in_sight && directing) {
            this.direction = this.converDirection(Player.me.getMassPoint());
        }
    }
}

