/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.ThrowingItem;
import dangeon.controller.TurnSystemController;
import dangeon.controller.task.Task;
import dangeon.latest.scene.action.menu.first.adventure.medal.Medal;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.condition.\u5fa9\u6d3b;
import dangeon.model.config.table.ItemTable;
import dangeon.model.map.EnemyFall;
import dangeon.model.map.ItemFall;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.Base_Device;
import dangeon.model.object.artifact.item.bullet.\u30c9\u30e9\u30b4\u30f3\u30d6\u30ec\u30b9;
import dangeon.model.object.artifact.item.bullet.\u76ee\u304b\u3089\u30d3\u30fc\u30e0;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u5384;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u5ac9\u59ac;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u5b9d;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u75c5;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u90aa;
import dangeon.model.object.artifact.item.food.\u30df\u30b7\u30e3\u30b0\u30b8\u304a\u306b\u304e\u308a;
import dangeon.model.object.artifact.item.food.\u5947\u8de1\u306e\u304a\u306b\u304e\u308a;
import dangeon.model.object.artifact.item.staff.MagicBullet;
import dangeon.model.object.creature.action.SpecialAction;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.enemy.\u308f\u304b\u3055\u304e\u59eb;
import dangeon.model.object.creature.enemy.\u5c01\u7363\u306c\u3048;
import dangeon.model.object.creature.enemy.\u6d29\u77e2\u8acf\u8a2a\u5b50;
import dangeon.model.object.creature.enemy.\u98a8\u898b\u5e7d\u9999;
import dangeon.model.object.creature.npc.Base_NPC;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.resistant.ResistWeakPoint;
import dangeon.util.Damage;
import dangeon.util.MapInSelect;
import dangeon.util.ObjectPoint;
import dangeon.util.R;
import dangeon.util.STAGE;
import dangeon.util.Switch;
import dangeon.view.anime.Base_Anime;
import dangeon.view.anime.FireEffect;
import dangeon.view.anime.HealEffect;
import dangeon.view.anime.HitEffect;
import dangeon.view.detail.MainMap;
import dangeon.view.detail.SecondAnime;
import dangeon.view.detail.View_Sider;
import dangeon.view.util.WithinOutofScreen;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import main.res.CHARA_IMAGE;
import main.res.Image_Artifact;
import main.res.SE;
import main.util.BeautifulView;
import main.util.DIRECTION;

public abstract class Base_Creature
extends Base_MapObject {
    public boolean player_side = false;
    protected boolean floating;
    protected boolean boating;
    protected boolean Fire;
    protected boolean Ice;
    protected boolean Thunder;
    protected boolean Magic;
    private boolean random_walk;
    private boolean wall_walk;
    protected int Ghost = 1;
    protected boolean flag_warning = false;
    private static final long serialVersionUID = 1L;
    protected List<STAGE> list_category = new ArrayList<STAGE>();
    protected CHARA_IMAGE IM;
    protected int ENEMY_EXP;
    protected int HP;
    protected int STR;
    protected int DEF;
    private int MAX_HP;
    protected int MAX_STR;
    protected int MAX_DEF;
    public boolean quick_one_attack = false;
    private boolean item_drop = true;
    public HashMap<CONDITION, Integer> condition_map = new HashMap();
    private ArrayList<CONDITION> list_condition = new ArrayList();
    private ArrayList<CONDITION> condition_remove_task = new ArrayList();
    protected DIRECTION attacking_direction = null;
    protected final Point attack_delt_point = new Point(0, 0);
    protected AttackPhase normal_attack_phase = null;
    protected final Point beated_away_point = new Point(0, 0);
    protected int beated_away_angle = 0;
    protected int attaking_frame = 0;
    protected int special_attack_parcent = 0;
    protected boolean flag_damaging = false;
    protected int attack_No = 0;
    private transient ArrayList<Task> attack_task = new ArrayList(8);
    private Base_Anime effect;
    private Base_Anime second_effect;
    private int telepo = -1;
    private Task telepo_task;
    protected int SIZE_MAX = 100;
    protected int size = 100;
    private byte flag_changing_size = 0;
    protected boolean flag_mute;
    protected int power_up_count = 0;

    public Base_Creature(Point p, String name, int level) {
        super(name, p, level);
        this.setNameAndStatus();
        this.IM = CHARA_IMAGE.get(this.getClass());
    }

    public Base_Creature(Point p, String name, int level, CONDITION c) {
        super(name, p, level);
        CONDITION.setConditionTime(this, c, 0);
        this.list_condition.add(c);
    }

    public void addAttackTask(Base_Creature active, Base_Creature passive) {
        this.attack_task.add(this.getAttackTask(active, passive));
    }

    public void addAttackTask(Task t) {
        this.attack_task.add(t);
    }

    public void addLV(int delt) {
        if (this instanceof Base_NPC) {
            return;
        }
        if (this.getConvertedLV() == 4) {
            Message.set("ANOTHER\u306e\u30ec\u30d9\u30eb\u306f\u5909\u5316\u3057\u306a\u304b\u3063\u305f");
            return;
        }
        int lv = delt + this.getLV();
        lv = this.getLV(lv);
        if (this.equals(Player.me)) {
            this.LV = lv;
        } else if (this.LV > lv) {
            if (this.LV > this.getMaxLV()) {
                Message.set(this.getColoredName(), "\u306e\u30ec\u30d9\u30eb\u306f\u4e0b\u304c\u3089\u306a\u304b\u3063\u305f");
                return;
            }
            SE.LEVEL_DOWN.play();
            Message.set(this.getColoredName(), "\u306f\u30ec\u30d9\u30eb\u304c\u4e0b\u304c\u3063\u3066");
            this.LV = lv;
            this.setNameAndStatus();
            Message.set(this.getColoredName(), "\u306b\u306a\u3063\u305f");
            View_Sider.setInformation("\u30ec\u30d9\u30eb\u304c\u4e0b\u304c\u3063\u3066", this.getColoredName(), "\u306b\u306a\u308a\u307e\u3057\u305f");
        } else if (this.LV < lv) {
            SE.LEVEL_UP.play();
            Message.set(this.getColoredName(), "\u306f\u30ec\u30d9\u30eb\u304c\u4e0a\u304c\u3063\u3066");
            this.LV = lv;
            this.setNameAndStatus();
            Message.set(this.getColoredName(), "\u306b\u306a\u3063\u305f");
            View_Sider.setInformation("\u30ec\u30d9\u30eb\u304c\u4e0a\u304c\u3063\u3066", this.getColoredName(), "\u306b\u306a\u308a\u307e\u3057\u305f");
        } else if (delt < 0) {
            Message.set("\u3053\u308c\u4ee5\u4e0a", this.getColoredName(), "\u306e\u30ec\u30d9\u30eb\u306f\u4e0b\u304c\u3089\u306a\u304b\u3063\u305f");
        } else if (delt > 0) {
            Message.set("\u3053\u308c\u4ee5\u4e0a", this.getColoredName(), "\u306e\u30ec\u30d9\u30eb\u306f\u4e0a\u304c\u3089\u306a\u304b\u3063\u305f");
        }
    }

    public void addMAX_HP(int delt) {
        if (this.MAX_HP + delt > 999) {
            this.MAX_HP = 999;
            return;
        }
        if (this.MAX_HP + delt < 1) {
            this.MAX_HP = 1;
            return;
        }
        this.MAX_HP += delt;
    }

    public void addStr(int value) {
        this.STR = this.STR + value <= 1 ? 1 : (this.STR + value >= this.MAX_STR ? this.MAX_STR : (this.STR += value));
    }

    public void arrowDamage(Object obj, String str, int damage) {
        damage = 1;
        this.chengeHP(obj, str, damage);
        Damage.damageArrowMessage(this, str, damage);
        if (this.enemyLifeCheck()) {
            Player.me.setExpCash(this.getENEMY_EXP());
        }
    }

    public void changeConditoinTurn(CONDITION condition, int diff) {
        if (this.condition_map.containsKey((Object)condition)) {
            int timer = this.condition_map.get((Object)condition) + diff;
            if (timer <= 0) {
                CONDITION.quickRemoveCondition(condition, this);
            } else {
                this.condition_map.put(condition, timer);
            }
        } else if (diff > 0) {
            this.setCondition(condition, diff);
        }
    }

    public void changeMAX_STR(int value) {
        int max_str = this.MAX_STR + value;
        if (max_str >= 999) {
            max_str = 999;
            value = max_str - this.MAX_STR;
        }
        this.MAX_STR = value;
        this.STR += value;
        if (this.MAX_STR < 1) {
            this.MAX_STR = 1;
        }
        if (this.STR < 1) {
            this.STR = 1;
        }
    }

    public DIRECTION chengeDirection(Base_Creature creature, Point p) {
        if (creature.getMassPoint().x == p.x) {
            if (creature.getMassPoint().y < p.y) {
                return DIRECTION.DOWN;
            }
            return DIRECTION.UP;
        }
        if (creature.getMassPoint().y == p.y) {
            if (creature.getMassPoint().x < p.x) {
                return DIRECTION.RIGHT;
            }
            return DIRECTION.LEFT;
        }
        return null;
    }

    public boolean chengeHP(Object obj, String str, int delt) {
        Integer I;
        if (delt < 0 && !EnchantSpecial.isFlagNeglectHeal() && (I = Damage.convert_2geki(this, -delt)) != null) {
            delt = -I.intValue();
            EnchantSpecial.setFlagNeglectHeal(true);
        }
        this.HP = this.HP + delt <= 0 ? 0 : (this.HP + delt > this.getMAX_HP() ? this.getMAX_HP() : (this.HP += delt));
        if (delt < 0) {
            if (this.equals(Player.me) && \u5c01\u7363\u306c\u3048.isNue(3) && !(obj instanceof \u5c01\u7363\u306c\u3048)) {
                MainMap.addEffect(new HitEffect(this, "\u306c\u3048\u3093"));
            } else {
                MainMap.addEffect(new HitEffect(this, -delt));
            }
        } else if (delt > 0) {
            MainMap.addEffect(new HealEffect(this, delt));
        }
        if (delt <= 0) {
            CONDITION.conditionEffectCase(this, CONDITION.\u9ebb\u75fa);
            CONDITION.conditionEffectCase(this, CONDITION.\u5b89\u5fc3);
            CONDITION.conditionEffectCase(this, CONDITION.\u3084\u308a\u3059\u3054\u3057);
        }
        CONDITION.conditionEffectCase(this, CONDITION.\u4eee\u7720);
        CONDITION.conditionEffectCase(this, CONDITION.\u7279\u6b8a\u4eee\u7720);
        if (this instanceof Player) {
            return false;
        }
        boolean flag = this.enemyLifeCheck();
        EnchantSpecial.setFlagNeglectHeal(false);
        return flag;
    }

    public void chengeHP_NoEffect(int delt) {
        if (this.HP + delt <= 0) {
            this.HP = 0;
            if (this instanceof Player) {
                Player.me.death(null, "\u304a\u8179\u304c\u6e1b\u3063\u3066\u5012\u308c\u305f");
            } else {
                this.enemyLifeCheck();
            }
        } else {
            this.HP = this.HP + delt > this.getMAX_HP() ? this.getMAX_HP() : (this.HP += delt);
        }
    }

    public void chengeHpGetExp(int delt) {
        this.HP = this.HP + delt <= 0 ? 0 : (this.HP + delt > this.getMAX_HP() ? this.getMAX_HP() : (this.HP += delt));
        if (delt < 0) {
            MainMap.addEffect(new HitEffect(this, -delt));
        } else if (delt > 0) {
            MainMap.addEffect(new HealEffect(this, delt));
        }
        CONDITION.conditionEffectCase(this, CONDITION.\u3084\u308a\u3059\u3054\u3057);
        CONDITION.conditionEffectCase(this, CONDITION.\u9ebb\u75fa);
        CONDITION.conditionEffectCase(this, CONDITION.\u5b89\u5fc3);
        CONDITION.conditionEffectCase(this, CONDITION.\u4eee\u7720);
        CONDITION.conditionEffectCase(this, CONDITION.\u7279\u6b8a\u4eee\u7720);
        this.enemyLifeCheck();
    }

    public void chengeLevelHp(int delt) {
        this.HP = this.HP + delt < 1 ? 0 : (this.HP + delt > 999 ? 999 : (this.HP += delt));
    }

    public void chengeLv(int lv) {
        this.LV = lv;
        this.setNameAndStatus();
    }

    public boolean conditionCheck(CONDITION condition) {
        return this.list_condition.contains((Object)condition);
    }

    public DIRECTION converDirection(Point p) {
        DIRECTION d = DIRECTION.getDirection(this.getMassPoint(), p);
        if (d == DIRECTION.NEUTRAL) {
            Player.me.setMassPoint_ParabolaJumpAttack(EnemyFall.getPoint(Player.me.getMassPoint()));
            d = this.getDirection();
            if (d == null || d == DIRECTION.NEUTRAL) {
                d = DIRECTION.DOWN;
            }
        }
        return d;
    }

    public Base_Enemy convertEnemyFromCreature(Base_Creature creature) {
        return MapList.getEnemy(creature.getMassPoint());
    }

    public boolean counterAttackEnemy() {
        return false;
    }

    public int damagedWithFire(int damage) {
        if (this.isFire()) {
            Message.set(this.getColoredName(), "\u306b\u306f\u52b9\u304b\u306a\u304b\u3063\u305f");
            return 0;
        }
        return damage;
    }

    private Point directionValue(boolean plus, Point p) {
        if (plus) {
            return new Point(this.getMassPoint().x + p.x, this.getMassPoint().y + p.y);
        }
        return new Point(this.getMassPoint().x - p.x, this.getMassPoint().y - p.y);
    }

    protected void drain(int dam) {
    }

    public void drawCreature(Graphics2D g) {
        this.drawCreature(g, ObjectPoint.getScreenPointRelPlayer(this));
    }

    protected void drawCreature(Graphics2D g, int x, int y) {
        BufferedImage bi = (BufferedImage)this.getImage();
        if (this.telepo == -1 && this.size == 100) {
            g.drawImage((Image)bi, x + this.getFootX(), y + this.getFootY(), null);
        } else {
            int TELEPO = 16;
            if (this.telepo > -1) {
                ++this.telepo;
            }
            if (this.telepo >= TELEPO) {
                this.telepo = -1;
                this.drawCreature(g, x, y);
                return;
            }
            x += this.getFootX();
            y += this.getFootY();
            int w = bi.getWidth(null);
            int h = bi.getHeight(null);
            if (this.size != 100) {
                w = w * this.size / 100;
                h = h * this.size / 100;
            }
            if (this.telepo == -2) {
                this.telepo = TELEPO / 2;
            } else if (this.telepo > 0) {
                if (this.telepo == TELEPO / 2 && this.telepo_task != null) {
                    this.telepo_task.work();
                    this.telepo_task = null;
                }
                double rate = Math.sin(Math.PI * (double)this.telepo / (double)TELEPO);
                double dw = (double)w * rate;
                double dh = (double)h * rate;
                w = (int)((double)w - dw);
                h = (int)((double)h + dh);
                x = (int)((double)x + dw / 2.0);
                y = (int)((double)y - dh);
            }
            g.drawImage(bi, x, y, w, h, null);
        }
    }

    public void drawCreature(Graphics2D g, Point p) {
        int x = p.x;
        int y = p.y;
        if (!this.conditionCheck(CONDITION.\u3084\u308a\u3059\u3054\u3057)) {
            if (this.conditionCheck(CONDITION.\u900f\u660e)) {
                BeautifulView.setAlphaOnImg(g, Float.valueOf(0.5f));
                this.drawCreature(g, x, y);
                BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
            } else {
                this.drawCreature(g, x, y);
            }
        }
        for (CONDITION cnd : this.getConditionList()) {
            if (cnd.IMA == null || this instanceof Player && this.conditionCheck(CONDITION.\u7761\u7720) && !this.conditionCheck(CONDITION.\u304a\u306b\u304e\u308a)) continue;
            cnd.IMA.draw(g, x + this.getHeadX(), y, this);
        }
    }

    public void endDamaging() {
        this.flag_damaging = false;
    }

    @Override
    protected void endParabonalJump() {
        if (this.flag_changing_size != 0) {
            this.flag_changing_size = 0;
            if (this.at_movement_end_task != null) {
                this.at_movement_end_task.work();
                this.at_movement_end_task = null;
            }
        } else {
            super.endParabonalJump();
        }
    }

    private void enemyBreak() {
        this.itemDrop();
        if (this.isSkillActive(true)) {
            this.enemyBreakAction();
        }
    }

    protected void enemyBreakAction() {
    }

    public boolean enemyLifeCheck() {
        if (this.getHP() <= 0) {
            if (this.getConditionList().contains((Object)CONDITION.\u5fa9\u6d3b)) {
                CONDITION.conditionRecovery(this, CONDITION.\u5fa9\u6d3b);
                Message.set(this.getColoredName(), "\u306f\u4e0d\u6b7b\u9ce5\u306e\u3054\u3068\u304f\u5fa9\u6d3b\u3057\u305f");
                this.chengeHP(null, null, this.getMAX_HP());
                return false;
            }
            if (this.recoveryGhost()) {
                return false;
            }
            this.setBeatedAway();
            Message.set(this.getColoredName(), "\u3092\u3084\u3063\u3064\u3051\u305f");
            this.enemyBreak();
            return true;
        }
        return false;
    }

    public void finshAnimation() {
        this.effect = null;
    }

    public void finshSecondAnimation() {
        this.second_effect = null;
    }

    public Point frontOrBackPoint(boolean plus) {
        switch (this.direction) {
            case UP: {
                return this.directionValue(plus, new Point(0, -1));
            }
            case DOWN: {
                return this.directionValue(plus, new Point(0, 1));
            }
            case LEFT: {
                return this.directionValue(plus, new Point(-1, 0));
            }
            case RIGHT: {
                return this.directionValue(plus, new Point(1, 0));
            }
            case UP_LEFT: {
                return this.directionValue(plus, new Point(-1, -1));
            }
            case UP_RIGHT: {
                return this.directionValue(plus, new Point(1, -1));
            }
            case DOWN_LEFT: {
                return this.directionValue(plus, new Point(-1, 1));
            }
            case DOWN_RIGHT: {
                return this.directionValue(plus, new Point(1, 1));
            }
        }
        return null;
    }

    public Base_Anime getAnimation() {
        return this.effect;
    }

    public Image getATKImage(int LV, DIRECTION attacking_direction, int attack_No) {
        int max = this.IM.ATK[0][0].length;
        if (attack_No >= max) {
            attack_No = max - 1;
        }
        return this.IM.getATKImage(LV, attacking_direction, attack_No);
    }

    public Point getAttackDeltPoint() {
        return this.attack_delt_point;
    }

    public int getAttackingFrame() {
        return this.attaking_frame;
    }

    public int getAttackNo() {
        return this.attack_No;
    }

    protected Point getAttackPoint() {
        return new Point(this.screen_point.x + this.attack_delt_point.x, this.screen_point.y + this.attack_delt_point.y);
    }

    public SE getAttackSE() {
        return SE.ATTACK_HANDS;
    }

    protected Task getAttackTask(final Base_Creature active, final Base_Creature passive) {
        return new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                if (active != null && passive != null && !passive.isInValidOnAttack()) {
                    Damage.normalAttack(active, passive);
                }
            }
        };
    }

    public Point getBackPoint() {
        Point p = this.getMassPoint();
        DIRECTION d = this.getDirection();
        return new Point(p.x - d.X, p.y - d.Y);
    }

    public ArrayList<CONDITION> getBadConditionList() {
        ArrayList<CONDITION> list = new ArrayList<CONDITION>();
        for (CONDITION con : CONDITION.values_bad()) {
            if (!this.list_condition.contains((Object)con)) continue;
            list.add(con);
        }
        return list;
    }

    public List<STAGE> getCategory() {
        return this.list_category;
    }

    public CHARA_IMAGE getCharacterImage() {
        return this.IM;
    }

    @Override
    public String getColoredName() {
        return super.getColoredName();
    }

    public List<CONDITION> getConditionList() {
        return this.list_condition;
    }

    public List<CONDITION> getConditionListNow() {
        ArrayList<CONDITION> list = new ArrayList<CONDITION>();
        for (CONDITION c : this.getConditionList()) {
            if (this.getConditionRemoveTask().contains((Object)c)) continue;
            list.add(c);
        }
        return list;
    }

    public List<CONDITION> getConditionRemoveTask() {
        return this.condition_remove_task;
    }

    public int getConditionTurn(CONDITION con) {
        Integer i = this.condition_map.get((Object)con);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int getConvertedLV() {
        return this.getLV();
    }

    public int getDEF() {
        return this.DEF / 2;
    }

    protected Base_Artifact getDropItem() {
        return ItemTable.itemReturn(this.getMassPoint().getLocation(), null);
    }

    public int getENEMY_EXP() {
        System.out.println(this.ENEMY_EXP);
        return this.ENEMY_EXP;
    }

    protected int getFootDeltY() {
        return 0;
    }

    public final int getFootX() {
        return (50 - this.getImage().getWidth(null) * this.size / 100) / 2;
    }

    public final int getFootY() {
        return (-(this.getImage().getHeight(null) + 50) / 2 + this.getFootDeltY()) * this.size / 100 + 30;
    }

    public int getGhost() {
        return this.Ghost;
    }

    public int getHeadX() {
        return 0;
    }

    public int getHeadY() {
        return -30 * this.size / 100;
    }

    public final int getHP() {
        return this.HP;
    }

    @Override
    public Image getImage() {
        if (this.conditionCheck(CONDITION.\u304a\u306b\u304e\u308a)) {
            return Image_Artifact.FOOD.getImage(0);
        }
        if (this.isAttacking()) {
            return this.getATKImage(this.LV, this.attacking_direction, this.attack_No);
        }
        if (this.getAnimation() != null) {
            return this.IM.getSPImage(this.LV, this.direction, this.getAnimation().getComa());
        }
        if (this.flag_damaging) {
            return this.IM.getDamImage(this.LV, this.direction);
        }
        return this.IM.getWalkImage(this.LV, this.direction, this.getMoveAnimationSpeed());
    }

    public int getItemDropParcent() {
        return this.itemDropParcent();
    }

    public final int getLV(int goal) {
        boolean minus;
        boolean plus = goal > this.getLV();
        boolean bl = minus = goal < this.getLV();
        if (!plus && !minus) {
            return goal;
        }
        if (this.getConvertedLV() == 4) {
            return 4;
        }
        if (goal < 1) {
            goal = 1;
        } else if (goal > this.getMaxLV()) {
            goal = this.getMaxLV();
        }
        return goal;
    }

    public final int getMAX_DEF() {
        return this.MAX_DEF;
    }

    public int getMAX_HP() {
        return this.MAX_HP;
    }

    public int getMAX_STR() {
        return this.MAX_STR;
    }

    protected float getMoveAnimationSpeed() {
        if (TurnSystemController.time_stop_count != 0) {
            if (this.equals(Player.me)) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (this.list_condition.contains((Object)CONDITION.\u4eee\u7720)) {
            return 0.0f;
        }
        if (this.list_condition.contains((Object)CONDITION.\u7761\u7720)) {
            return 0.0f;
        }
        if (this.list_condition.contains((Object)CONDITION.\u6697\u95c7)) {
            return 0.0f;
        }
        if (this.list_condition.contains((Object)CONDITION.\u7279\u6b8a\u4eee\u7720)) {
            return 0.0f;
        }
        if (this.list_condition.contains((Object)CONDITION.\u9ebb\u75fa)) {
            return 0.0f;
        }
        if (this.list_condition.contains((Object)CONDITION.\u920d\u8db3)) {
            return 0.5f;
        }
        if (this.list_condition.contains((Object)CONDITION.\u500d\u901f)) {
            return 2.0f;
        }
        if (this.list_condition.contains((Object)CONDITION.\u4e09\u500d\u901f)) {
            return 3.0f;
        }
        return 1.0f;
    }

    public int getPowerUp() {
        return this.power_up_count;
    }

    @Override
    public final Point getScreenPoint() {
        if (this.beated_away_angle > 0) {
            return new Point(this.screen_point.x + this.beated_away_point.x, this.screen_point.y + this.beated_away_point.y);
        }
        if (this.normal_attack_phase != null) {
            return this.getAttackPoint();
        }
        return super.getScreenPoint();
    }

    public Base_Anime getSecondAnimation() {
        return this.second_effect;
    }

    public int getShadowSize() {
        if (!MassCreater.getMass((Point)this.getMassPoint()).WALKABLE) {
            return 0;
        }
        if (this.conditionCheck(CONDITION.\u3084\u308a\u3059\u3054\u3057)) {
            return this.getShadowSize100();
        }
        return this.getShadowSize100() * this.size / 100;
    }

    protected int getShadowSize100() {
        return 25;
    }

    public int getShadowY() {
        return 3;
    }

    public int getSTR() {
        return this.STR;
    }

    public BufferedImage getWalkDot() {
        return this.IM.getWalkDot(this.LV - 1);
    }

    public void heal(Base_Creature source, int value) {
        if (this.chengeHP(null, null, value *= this.getGhost()) && source != null) {
            source.setExpCash(this.getENEMY_EXP());
        }
    }

    protected boolean isAbleToAttack_NowDirecting() {
        if (this.isAbleToAttackWhileNeglectingWall()) {
            return true;
        }
        Point p = this.mass_point.getLocation();
        if (this.direction.isBias()) {
            DIRECTION[] dIRECTIONArray = this.direction.getNeiboringDirections3();
            int n = dIRECTIONArray.length;
            int n2 = 0;
            while (n2 < n) {
                DIRECTION d = dIRECTIONArray[n2];
                if (!MassCreater.getMass((Point)d.getFrontPoint((Point)p.getLocation())).WALKABLE) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return MassCreater.getMass((Point)this.direction.getFrontPoint((Point)p)).WALKABLE;
    }

    public boolean isAbleToAttackWhileNeglectingWall() {
        return this.isWall_walk();
    }

    public boolean isAbleToFeel() {
        if (EnchantSpecial.toushi()) {
            return true;
        }
        if (!MassCreater.isSpotValid()) {
            Point p = Player.me.getMassPoint();
            for (Mass m : MassCreater.getMasses_NotSpotValid(p.x, p.y)) {
                if (m.X != this.getMassPoint().x || m.Y != this.getMassPoint().y) continue;
                return true;
            }
        }
        return MassCreater.isThePointInThePlayerSight(this.getMassPoint(), 1, 1);
    }

    public final boolean isAbleToIgnoreWalls() {
        return this.isWall_walk();
    }

    @Override
    public boolean isAnimating() {
        if (super.isAnimating()) {
            return true;
        }
        if (this.telepo != -1) {
            return true;
        }
        if (this.getAnimation() != null) {
            return true;
        }
        if (this.getSecondAnimation() != null) {
            return true;
        }
        if (this.isBeatedAway()) {
            return true;
        }
        return this.normal_attack_phase != null;
    }

    protected boolean isAttacking() {
        return this.normal_attack_phase != null;
    }

    public boolean isAttackPhaseEnd() {
        return this.normal_attack_phase == null;
    }

    public boolean isBadCondition() {
        for (CONDITION con : CONDITION.values_bad()) {
            if (!this.list_condition.contains((Object)con)) continue;
            return true;
        }
        return false;
    }

    public boolean isBeatedAway() {
        return this.beated_away_angle > 0;
    }

    public boolean isBoating() {
        return !this.conditionCheck(CONDITION.\u5c01\u5370) && this.boating;
    }

    public boolean isCHARA_IMAGE_ARROW() {
        return this.IM == CHARA_IMAGE.arrow;
    }

    public boolean isFire() {
        return !this.conditionCheck(CONDITION.\u5c01\u5370) && (this.Fire || this.conditionCheck(CONDITION.\u708e\u4e0a));
    }

    public boolean isFlagWarning() {
        return this.flag_warning;
    }

    public boolean isFlying() {
        return this.floating;
    }

    public boolean isIce() {
        return !this.conditionCheck(CONDITION.\u5c01\u5370) && this.Ice;
    }

    public boolean isInValidOnAttack() {
        return false;
    }

    public boolean isItemDrop() {
        return this.item_drop;
    }

    public boolean isMagicAttack() {
        return !this.conditionCheck(CONDITION.\u5c01\u5370) && this.Magic;
    }

    public boolean isMaxHp() {
        return this.getMAX_HP() <= this.HP;
    }

    public boolean isPassiveSkillActive() {
        return this.HP > 0 && !this.conditionCheck(CONDITION.\u5c01\u5370) && !this.conditionCheck(CONDITION.\u3048\u3048\u3093\u3058\u3083\u306a\u3044\u304b) && !TurnSystemController.time_stop;
    }

    public boolean isPlayerSide() {
        return this.player_side;
    }

    protected boolean isRandom_walk() {
        return this.isPassiveSkillActive() && this.random_walk;
    }

    public boolean isResistantToGrassWave() {
        return false;
    }

    public boolean isShownOnMiniMap() {
        if (EnchantSpecial.toushi()) {
            return true;
        }
        if (this.conditionCheck(CONDITION.\u900f\u660e) && !Player.me.conditionCheck(CONDITION.\u76ee\u85ac) && !EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.ALL, ENCHANT_SIMBOL.\u8b58)) {
            return false;
        }
        return MassCreater.isThePointInThePlayerSight(this.getMassPoint(), 1, 1);
    }

    public boolean isSkillActive() {
        return this.isSkillActive(false);
    }

    public boolean isSkillActive(boolean active_in_dying) {
        CONDITION[] cs;
        CONDITION[] cs1 = new CONDITION[]{CONDITION.\u4eee\u7720, CONDITION.\u3048\u3048\u3093\u3058\u3083\u306a\u3044\u304b, CONDITION.\u5c01\u5370, CONDITION.\u7279\u6b8a\u4eee\u7720, CONDITION.\u9ebb\u75fa, CONDITION.\u6df7\u4e71, CONDITION.\u7761\u7720, CONDITION.\u6697\u95c7, CONDITION.\u5929\u90aa\u9b3c};
        CONDITION[] cs2 = new CONDITION[]{CONDITION.\u3048\u3048\u3093\u3058\u3083\u306a\u3044\u304b, CONDITION.\u5c01\u5370};
        CONDITION[] cONDITIONArray = cs = this.isSkillActiveAnytimeButSealed() ? cs2 : cs1;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            CONDITION condition = cONDITIONArray[n2];
            if (this.conditionCheck(condition)) {
                return false;
            }
            ++n2;
        }
        if (active_in_dying) {
            return true;
        }
        return this.HP > 0 && !TurnSystemController.time_stop;
    }

    protected boolean isSkillActiveAnytimeButSealed() {
        return false;
    }

    public boolean isThroughItem(Base_Artifact a) {
        return false;
    }

    public boolean isThunder() {
        return !this.conditionCheck(CONDITION.\u5c01\u5370) && this.Thunder;
    }

    public boolean isVisible() {
        return this.conditionCheck(CONDITION.\u900f\u660e);
    }

    protected boolean isWall_walk() {
        return this.isPassiveSkillActive() && this.wall_walk;
    }

    public boolean isWatering() {
        return this.isFlying() || this.isBoating() || this.isIce();
    }

    private void itemDrop() {
        if (!PresentField.get().isItemDrop()) {
            return;
        }
        if (!this.item_drop) {
            return;
        }
        if ((int)(new R().nextDouble() * 10000.0) < \u5370\u5b9d.effect(this.itemDropParcent())) {
            this.setOnDropItem();
        }
    }

    protected int itemDropParcent() {
        return 250;
    }

    public final boolean itemHit(Base_Artifact a, boolean ento, Base_Creature source, Base_Creature target) {
        CONDITION.conditionEffectCase(this, CONDITION.\u4eee\u7720);
        CONDITION.conditionEffectCase(this, CONDITION.\u7279\u6b8a\u4eee\u7720);
        CONDITION.conditionEffectCase(this, CONDITION.\u5b89\u5fc3);
        CONDITION.conditionEffectCase(this, CONDITION.\u3084\u308a\u3059\u3054\u3057);
        if (!this.isSkillActive()) {
            return true;
        }
        if (a instanceof Base_Device) {
            return true;
        }
        return this.itemHitEffect(a, ento);
    }

    protected boolean itemHitEffect(Base_Artifact a, boolean ento) {
        if (a instanceof MagicBullet || a instanceof \u76ee\u304b\u3089\u30d3\u30fc\u30e0 || a instanceof \u30c9\u30e9\u30b4\u30f3\u30d6\u30ec\u30b9) {
            return true;
        }
        if (!ento && this.conditionCheck(CONDITION.\u708e\u4e0a)) {
            MainMap.addEffect(new FireEffect(this.mass_point, null), true);
            if (a.isCold()) {
                this.setConditionRemoveTask(CONDITION.\u708e\u4e0a);
            }
            Message.set(a.getColoredName(), "\u306f\u71c3\u3048\u5c3d\u304d\u305f");
            return false;
        }
        return true;
    }

    public void load() {
        this.attack_task = new ArrayList(8);
    }

    protected boolean movable_water_check(Point p) {
        Mass m = MassCreater.getMass(p);
        if (!m.WATER) {
            return true;
        }
        return this.isWatering();
    }

    protected abstract String nameLevel();

    public void nodamageGetExp() {
        Player.me.setExpCash(this.getENEMY_EXP());
    }

    public void normalAttack(boolean p_or_e) {
        final Base_Creature c = this;
        if (this.conditionCheck(CONDITION.\u6df7\u4e71)) {
            this.direction = DIRECTION.values_exceptNeatral()[new R().nextInt(8)];
        } else {
            this.direction = this.converDirection(Player.me.getMassPoint());
            if (this.getConditionList().contains((Object)CONDITION.\u5929\u90aa\u9b3c)) {
                this.direction = DIRECTION.backDirection(this.direction);
            }
        }
        this.startAttack(new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                if (!Base_Creature.this.isAbleToAttack_NowDirecting()) {
                    return;
                }
                Base_Creature target = null;
                Base_Creature.this.isAbleToAttackWhileNeglectingWall();
                target = Player.me.getMassPoint().equals(c.getDirection().getFrontPoint(c.getMassPoint().getLocation())) ? Player.me : MapInSelect.getFrontEnemyFromCreature(c);
                if (target != null) {
                    if (c.conditionCheck(CONDITION.\u3048\u3048\u3093\u3058\u3083\u306a\u3044\u304b)) {
                        Damage.enemyCriticalAttack(c, target);
                    } else {
                        int dam = Damage.normalAttack(c, target);
                        if (Base_Creature.this.isSkillActive()) {
                            Base_Creature.this.drain(dam);
                        }
                    }
                }
            }
        });
    }

    public boolean playerIsInNeiver() {
        return false;
    }

    public boolean playerLifeCheck(Object obj) {
        if (Player.me.getHP() <= 0) {
            if (\u5fa9\u6d3b.recovery()) {
                Medal.\u5fa9\u6d3b\u56de\u6570.addCount();
                return false;
            }
            return !Switch.test || !Switch.switch_player_no_death;
        }
        return false;
    }

    public void playerTrapDamage(Object obj, String str, int damage) {
        Player.me.chengeHP(obj, str, -damage);
    }

    private CONDITION quickCondition(CONDITION c) {
        if (c == CONDITION.\u920d\u8db3) {
            if (this.list_condition.contains((Object)CONDITION.\u500d\u901f)) {
                CONDITION.setEnemyNormalSpeed(this);
                return null;
            }
            if (this.list_condition.contains((Object)CONDITION.\u4e09\u500d\u901f)) {
                CONDITION.setEnemyNormalSpeed(this);
                return CONDITION.\u500d\u901f;
            }
            return c;
        }
        if (c == CONDITION.\u500d\u901f) {
            if (this.list_condition.contains((Object)CONDITION.\u920d\u8db3)) {
                CONDITION.setEnemyNormalSpeed(this);
                return null;
            }
            if (this.list_condition.contains((Object)CONDITION.\u500d\u901f)) {
                CONDITION.setEnemyNormalSpeed(this);
                return CONDITION.\u4e09\u500d\u901f;
            }
            if (this.list_condition.contains((Object)CONDITION.\u4e09\u500d\u901f)) {
                return null;
            }
            return c;
        }
        if (c == CONDITION.\u4e09\u500d\u901f) {
            if (this.list_condition.contains((Object)CONDITION.\u920d\u8db3)) {
                CONDITION.setEnemyNormalSpeed(this);
                return CONDITION.\u500d\u901f;
            }
            return c;
        }
        return c;
    }

    public boolean recoveryGhost() {
        if (this.getGhost() != 1 && this.conditionCheck(CONDITION.\u90aa\u6cd5)) {
            SE.SYSTEM_CURSE.play();
            this.setTelepoteAnimation(true, null);
            CONDITION.conditionRecovery(this, CONDITION.\u90aa\u6cd5);
            Message.set(this.getColoredName(), "\u306f\u90aa\u6cd5\u306e\u529b\u3067\u3088\u307f\u304c\u3048\u3063\u305f");
            this.chengeHP(null, null, this.getGhost() == 0 ? 1 : this.getMAX_HP() / 2);
            return true;
        }
        return false;
    }

    public boolean reflection(ThrowingItem ti) {
        return this.conditionCheck(CONDITION.\u53cd\u5c04);
    }

    protected boolean resistCondition(CONDITION c) {
        return false;
    }

    public boolean resistOrWeakAction(ResistWeakPoint res, int damage) {
        return false;
    }

    protected void setAnimation(Base_Anime a) {
        this.effect = a;
        MainMap.setAnimation(this);
    }

    protected void setBeatedAway() {
        this.beated_away_angle = new R().nextInt(30) - 15;
        this.beated_away_angle += (this.direction.ROTATE + 4) * 45;
    }

    public void setBombedAway() {
        this.setBeatedAway();
    }

    public boolean setCondition(CONDITION c, int timer) {
        if (this.resistCondition(c)) {
            return false;
        }
        this.setConditionList(c, timer);
        return true;
    }

    private Base_Creature setConditionList(CONDITION condition, int timer) {
        if (this instanceof Player) {
            \u5370\u5384.effect(condition);
            \u5370\u5ac9\u59ac.effect(condition);
            if (\u5370\u75c5.effect(condition)) {
                return this;
            }
        } else if (this instanceof Base_Enemy && condition == CONDITION.\u304a\u306b\u304e\u308a) {
            TaskOnMapObject.addEnemyRemoveTask(this);
            ItemFall.itemFall(new R().nextInt(2) == 0 ? new \u30df\u30b7\u30e3\u30b0\u30b8\u304a\u306b\u304e\u308a(this.mass_point) : new \u5947\u8de1\u306e\u304a\u306b\u304e\u308a(this.mass_point));
            return this;
        }
        if (condition == CONDITION.\u500d\u901f || condition == CONDITION.\u4e09\u500d\u901f || condition == CONDITION.\u920d\u8db3) {
            condition = this.quickCondition(condition);
        }
        if (this.list_condition.contains((Object)condition)) {
            if (condition == CONDITION.\u6b7b) {
                this.condition_map.put(condition, (this.condition_map.get((Object)condition) + 1) / 2);
            }
            return this;
        }
        if (condition == CONDITION.\u5c01\u5370) {
            CONDITION.conditionAllClear(this);
            if (this instanceof Base_Enemy && !MassCreater.getMass((Point)this.mass_point).WALKABLE) {
                Medal.\u58c1\u306e\u4e2d\u306e\u6575\u3092\u5c01\u5370\u3057\u305f.addCount();
            }
        }
        if (condition == null) {
            return this;
        }
        CONDITION.setConditionTime(this, condition, timer);
        this.list_condition.add(condition);
        return this;
    }

    public boolean setConditionNeglectResist(CONDITION c, Integer timer) {
        this.setConditionList(c, timer);
        return true;
    }

    public void setConditionRemoveTask(CONDITION condition) {
        this.condition_remove_task.add(condition);
    }

    public void setDamaging(boolean flag) {
        this.flag_damaging = flag;
    }

    public final void setDEF(int dEF) {
        this.DEF = dEF;
    }

    public void setENEMY_EXP(int eNEMY_EXP) {
        this.ENEMY_EXP = eNEMY_EXP;
    }

    protected void setExpCash(int enemy_EXP2) {
        this.addLV(1);
    }

    public final void setFirstStatus(int hp, int str, int def) {
        this.HP = hp;
        this.setMAX_HP(this.HP);
        this.MAX_STR = this.STR = str;
        this.MAX_DEF = this.DEF = def;
    }

    public final void setHP(int hP) {
        if (this.HP + hP >= this.getMAX_HP()) {
            this.HP = this.getMAX_HP();
        }
        this.HP = hP;
    }

    public void setItemDrop(boolean b) {
        this.item_drop = b;
    }

    public void setLV_NoMessage(int goal) {
        if (this instanceof Base_NPC) {
            return;
        }
        int lv = this.LV;
        this.LV = this.getLV(goal);
        if (this.LV != lv) {
            this.setNameAndStatus();
        }
    }

    @Override
    public void setMassPoint_Jump(Point p, Task task) {
        super.setMassPoint_Jump(p, task);
        this.setTelepoteAnimation(false, null);
    }

    public void setMassPoint_ParabolaJump_Smalling(Point p, Task task) {
        this.flag_changing_size = (byte)-1;
        super.setMassPoint_ParabolaJumpAttack(p, task);
    }

    public void setMassPoint_ParabolaJump_Undo(Point p, Task task) {
        this.flag_changing_size = 1;
        super.setMassPoint_ParabolaJumpAttack(p, task);
    }

    public final void setMAX_DEF(int mAX_DEF) {
        this.MAX_DEF = mAX_DEF;
    }

    public final void setMAX_HP(int value) {
        this.MAX_HP = value;
    }

    public void setMute(boolean b) {
        this.flag_mute = b;
    }

    public void setNameAndStatus() {
        List<Integer> list = this.statusLevel();
        this.name = this.nameLevel();
        try {
            this.HP = list.get(0);
            this.setMAX_HP(this.HP);
            this.MAX_STR = this.STR = list.get(1).intValue();
            this.MAX_DEF = this.DEF = list.get(2).intValue();
            this.setENEMY_EXP(list.get(3));
        }
        catch (IndexOutOfBoundsException e) {
            this.HP = 1;
            this.setMAX_HP(1);
            this.STR = 1;
            this.MAX_STR = 1;
            this.DEF = 1;
            this.MAX_DEF = 1;
            this.setENEMY_EXP(1);
        }
    }

    public void setOnDropItem() {
        Base_Artifact item = this.getDropItem();
        if (item == null) {
            return;
        }
        ItemFall.itemFall(this.getMassPoint(), item);
        this.setItemDrop(false);
    }

    public void setPlayerSide(boolean b) {
        this.player_side = b;
    }

    protected void setRandom_walk(boolean random_walk) {
        this.random_walk = random_walk;
    }

    public void setSecondAnimation(Base_Anime a) {
        this.second_effect = a;
        SecondAnime.setAnimation(this);
    }

    public void setSTR(int sTR) {
        this.STR = sTR <= 1 ? 1 : sTR;
    }

    public void setTelepoteAnimation(boolean half, Task task) {
        this.telepo = half ? -2 : 0;
        this.telepo_task = task;
    }

    protected void setWall_walk(boolean wall_walk) {
        this.wall_walk = wall_walk;
    }

    public void skipDrawFrame() {
        this.telepo = -1;
    }

    public boolean staffHitCheck(Base_Artifact a) {
        CONDITION.conditionEffectCase(this, CONDITION.\u4eee\u7720);
        CONDITION.conditionEffectCase(this, CONDITION.\u7279\u6b8a\u4eee\u7720);
        CONDITION.conditionEffectCase(this, CONDITION.\u5b89\u5fc3);
        return this.staffHitEffect(a);
    }

    protected boolean staffHitEffect(Base_Artifact a) {
        return true;
    }

    public void startAttack(Task t) {
        SE se = this.getAttackSE();
        if (!this.flag_mute && se != null) {
            se.play();
        }
        this.attacking_direction = this.direction;
        this.normal_attack_phase = AttackPhase.GO;
        this.attack_task.add(t);
    }

    public void startDamaging() {
        TaskOnMapObject.setDamaging(this);
        this.flag_damaging = true;
    }

    protected abstract List<Integer> statusLevel();

    @Override
    public void upDate() {
        if (this.beated_away_angle > 0) {
            this.upDate_BeatedAway();
        } else if (this.normal_attack_phase != null) {
            this.upDate_NormalAttack();
        } else {
            super.upDate();
        }
    }

    private void upDate_BeatedAway() {
        int dx = (int)Math.round(Math.cos(Math.PI * 2 * (double)this.beated_away_angle / 360.0) * 10.0 * 4.0);
        int dy = (int)Math.round(Math.sin(Math.PI * 2 * (double)this.beated_away_angle / 360.0) * 10.0 * 4.0);
        this.beated_away_point.translate(dx, dy);
        if (WithinOutofScreen.isOutside(this)) {
            TaskOnMapObject.addEnemyRemoveTask(this);
        }
    }

    @Override
    protected void upDate_Jump() {
        if (this.flag_changing_size != 0) {
            this.size += this.flag_changing_size * 5 * this.SIZE_MAX / 100;
            if (this.size > this.SIZE_MAX) {
                this.size = this.SIZE_MAX;
            }
            if (this.size < 0) {
                this.size = 0;
            }
        }
        super.upDate_Jump();
    }

    protected void upDate_NormalAttack() {
        ++this.attaking_frame;
        if (!(this instanceof Player)) {
            if (this.conditionCheck(CONDITION.\u4e09\u500d\u901f)) {
                ++this.attaking_frame;
                ++this.attaking_frame;
            }
            if (this.conditionCheck(CONDITION.\u500d\u901f) || Player.me.conditionCheck(CONDITION.\u920d\u8db3) && !this.isPlayerSide()) {
                ++this.attaking_frame;
            }
        }
        switch (this.normal_attack_phase) {
            case GO: {
                int FR2 = 3;
                if (this.attaking_frame < FR2) {
                    this.attack_No = 0;
                    return;
                }
                if (this.attaking_frame < FR2 * 2) {
                    this.attack_No = 1;
                } else if (this.attaking_frame < FR2 * 3) {
                    this.attack_No = 2;
                } else {
                    this.normal_attack_phase = AttackPhase.BACK;
                }
                if (Math.abs(this.attack_delt_point.x) > 16 || Math.abs(this.attack_delt_point.y) > 16) break;
                this.attack_delt_point.translate(this.direction.X * 10, this.direction.Y * 10);
                break;
            }
            case BACK: {
                this.attack_delt_point.translate(-this.direction.X * 10, -this.direction.Y * 10);
                if (this.attack_delt_point.x * this.direction.X > 0 || this.attack_delt_point.y * this.direction.Y > 0) break;
                this.attack_delt_point.setLocation(0, 0);
                this.normal_attack_phase = null;
                this.attack_No = 0;
                this.attaking_frame = -1;
            }
        }
        while (!this.attack_task.isEmpty()) {
            Task t = this.attack_task.get(0);
            if (t != null) {
                t.work();
            }
            this.attack_task.remove(0);
        }
    }

    public void waterAction(Mass m) {
        if (this.isWatering() && !this.isIce()) {
            if (this instanceof \u6d29\u77e2\u8acf\u8a2a\u5b50) {
                m.setWaterLeefOn(false);
            } else if (this instanceof \u98a8\u898b\u5e7d\u9999) {
                m.setWaterLeefOn(false);
                m.FLOWER = true;
            } else if (this instanceof \u308f\u304b\u3055\u304e\u59eb) {
                m.WATER_LEEF = false;
            }
            return;
        }
        if (this instanceof Player) {
            if (!PresentField.get().isHaraheru() || this.isIce()) {
                Message.set(this.getColoredName(), "\u306f\u6c34\u8def\u3092\u51cd\u3089\u305b\u305f");
                SE.ICE.play();
                m.setFrozen_includingNeibors();
                MassCreater.retakeMassSet();
            } else if (!\u5370\u90aa.isWallWalk()) {
                SpecialAction.\u9ad8\u98db\u3073(this);
                Medal.\u6c34\u8def\u306e\u4e0a\u306b\u4e57\u3063\u3066\u30ef\u30fc\u30d7\u3057\u305f.addCount();
            }
        } else if (this instanceof Base_Enemy) {
            if (this.isIce()) {
                Message.set(this.getColoredName(), "\u306f\u6c34\u8def\u3092\u51cd\u3089\u305b\u305f");
                SE.ICE.play();
                m.setFrozen_includingNeibors();
                MassCreater.retakeMassSet();
            } else if (!(this instanceof Base_NPC)) {
                SE.ATTACK_WATER.play();
                Message.set(this.getColoredName(), "\u306f\u304a\u307c\u308c\u3066\u3057\u307e\u3063\u305f");
                this.chengeHP_NoEffect(-999);
            }
        }
    }

    protected static enum AttackPhase {
        GO,
        BACK;

    }
}

