/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.staff;

import dangeon.controller.ThrowingItem;
import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.staff.Staff;
import dangeon.model.object.creature.Base_Creature;
import dangeon.util.MapInSelect;
import java.awt.Point;
import main.util.DIRECTION;

public class \u5f15\u304d\u5bc4\u305b\u306e\u6756
extends Staff {
    private static final long serialVersionUID = 1L;
    public static final Base_Artifact.ITEM_CASE item_case = Base_Artifact.ITEM_CASE.STAFF;
    public static final String item_name = "\u5f15\u304d\u5bc4\u305b\u306e\u6756";
    public static final String item_name_sound = "\u3072\u304d\u3088\u305b\u306e\u3064\u3048";

    public \u5f15\u304d\u5bc4\u305b\u306e\u6756(Point p) {
        super(p, item_name, 1);
    }

    @Override
    protected void effect(Base_Creature c) {
        DIRECTION direction = DIRECTION.getDirection(this.used_creature.getMassPoint(), c.getMassPoint()).getReverse();
        if (direction == DIRECTION.NEUTRAL) {
            return;
        }
        MapInSelect.\u5439\u304d\u98db\u3070\u3057(this.used_creature, "\u5439\u304d\u98db\u3070\u3057", c, direction, 10, 0);
        Message.set(this.used_creature.getColoredName(), "\u306f", c.getColoredName(), "\u3092\u5f15\u304d\u5bc4\u305b\u305f");
    }

    @Override
    protected String getSecondExplain_ByEach() {
        return "\u4f55\u3067\u3082\u5f15\u304d\u5bc4\u305b\u308b\u306e\u3067\u6ce8\u610f\u3057\u3088\u3046";
    }

    @Override
    public boolean hitWall(final Base_Creature used_creature) {
        this.staticCheck();
        used_creature.startDamaging();
        Point p = used_creature.getMassPoint().getLocation();
        DIRECTION d = used_creature.getDirection();
        while (MassCreater.getMass((Point)p).WALKABLE) {
            p.translate(d.X, d.Y);
        }
        do {
            p.translate(-d.X, -d.Y);
        } while (MapList.isCreature(p) && !p.equals(used_creature.getMassPoint()));
        Message.set(used_creature.getColoredName(), "\u306f\u58c1\u306b\u5f15\u304d\u5bc4\u305b\u3089\u308c\u305f");
        used_creature.setMassPoint_WalkLike(p, 3, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                used_creature.endDamaging();
            }
        });
        return true;
    }

    @Override
    public boolean isMagicHitToItem() {
        return true;
    }

    @Override
    public void itemHitCheck(boolean ento, final Base_Creature c, final Base_Artifact a) {
        this.staticCheck();
        Message.set(c.getColoredName(), "\u306f", a.getColoredName(), "\u3092\u5f15\u304d\u5bc4\u305b\u305f");
        new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                DIRECTION direction = DIRECTION.getDirection(c.getMassPoint(), a.getMassPoint());
                a.direction = direction.getReverse();
                int dx = c.getMassPoint().x - a.getMassPoint().x;
                int dy = c.getMassPoint().y - a.getMassPoint().y;
                int range = Math.max(Math.abs(dx), Math.abs(dy)) - 1;
                if (range > 10) {
                    range = 10;
                }
                a.itemThrow(c, ThrowingItem.HowToThrow.NORMAL, false, range, true);
            }
        }.work_appointment();
    }
}

