/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.staff;

import dangeon.controller.ThrowingItem;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.config.Config;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.staff.MagicBullet;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.util.MapInSelect;
import dangeon.util.R;
import java.awt.Point;
import java.util.Random;
import main.res.Image_Artifact;
import main.util.DIRECTION;

public abstract class Staff
extends Base_Item {
    private static final long serialVersionUID = 1L;
    private boolean checked_perfect = false;
    protected Base_Creature used_creature;

    protected Staff(Point p, String item_name, int level) {
        super(p, item_name, 0, Base_Artifact.ITEM_CASE.STAFF);
        R ran = new R();
        this.addStaffRest(((Random)ran).nextInt(5) + 2);
        this.IM = Image_Artifact.STAFF;
        this.sim = ENCHANT_SIMBOL.\u6756;
    }

    @Override
    protected void action() {
    }

    @Override
    public void check() {
        this.checked_perfect = true;
        super.check();
    }

    protected abstract void effect(Base_Creature var1);

    protected boolean effect_checker() {
        return true;
    }

    protected void effectHitCheck(Base_Creature c, Base_Creature sorce) {
        if (c.staffHitCheck(this)) {
            this.pre_effect(c, sorce);
        }
    }

    protected int enchantAttack(boolean normal, Base_Creature c, int damage) {
        return damage;
    }

    @Override
    protected int enchantDefence(boolean normal, Base_Creature c, int damage) {
        return damage;
    }

    public void enemyStaffUse(Base_Creature c) {
        this.direction = c.getDirection();
        this.A = new MagicBullet(this, c);
        this.A.itemThrow(c);
    }

    @Override
    public void firstMsgAtUsingThis() {
    }

    @Override
    public String getClassName() {
        return "\u6756\uff1a";
    }

    @Override
    public String getLastPackage() {
        return "staff";
    }

    @Override
    public StringBuilder getName(StringBuilder sb) {
        sb.append(this.getName());
        if (this.isPerfectCheked() || this.flag_open_numbers) {
            sb.append("[");
            sb.append(this.staff_rest);
            sb.append("]");
        } else if (this.staff_use_count != 0) {
            sb.append("[");
            sb.append(this.staff_use_count);
            sb.append("]");
        } else {
            sb.append("[");
            sb.append("?");
            sb.append("]");
        }
        return sb;
    }

    @Override
    protected String getSecondExplain_ByCategory() {
        return "\u4f7f\u7528\u3059\u308b\u3068\u98db\u8ddd\u96e2\u7121\u9650\u306e\u5fc5\u4e2d\u306e\u9b54\u6cd5\u5f3e\u3092\u98db\u3070\u3057\u5f53\u305f\u3063\u305f\u3082\u306e\u306b\u52b9\u679c\u3092\u4e0e\u3048\u308b\u3002\u6295\u3052\u3066\u5f53\u3066\u3066\u3082\u540c\u3058\u52b9\u679c\u304c\u767a\u751f\u3059\u308b\u3002\u6b8b\u308a\u56de\u6570\u304c\u30bc\u30ed\u306b\u306a\u308b\u307e\u3067\u8907\u6570\u56de\u4f7f\u3046\u3053\u3068\u304c\u3067\u304d\u308b\u3002";
    }

    @Override
    public int getShadow() {
        return 5;
    }

    protected boolean hitWall(Base_Creature c) {
        return false;
    }

    public boolean hitWall(ThrowingItem throwingItem) {
        if (this.hitWall(throwingItem.C) && !(throwingItem.C instanceof Base_Enemy) && this.effect_checker()) {
            this.staticCheck();
            Config.saveItemData(this);
        }
        return false;
    }

    public boolean isMagicHitToItem() {
        return false;
    }

    public boolean isNeglectiveForWall_Magic() {
        return false;
    }

    @Override
    public boolean isPerfectCheked() {
        return this.checked_perfect;
    }

    public void itemEffect(Base_Creature c) {
        this.effect(c);
    }

    @Override
    public int itemEnchantPower(Base_Artifact.STATUS status) {
        return 0;
    }

    @Override
    public void itemHit(Base_Creature c, Base_Creature c2) {
        this.pre_effect(c, c2);
    }

    @Override
    public boolean itemUse() {
        if (this.getStaffRest() <= 0) {
            Player.me.setNoMagic();
            Message.set(this.getColoredName().concat("\u306e\u56de\u6570\u304c\uff10\u306e\u70ba"), "\u4f7f\u3048\u306a\u304b\u3063\u305f");
            if (this.isStaticCheked()) {
                this.check();
            } else {
                this.flag_open_numbers = true;
            }
            return true;
        }
        Message.set(this.getColoredName(), "\u3092\u632f\u3063\u305f");
        --this.staff_use_count;
        this.addStaffRest(-1);
        this.direction = Player.me.getDirection();
        this.A = new MagicBullet(this);
        this.A.itemThrow(Player.me, ThrowingItem.HowToThrow.MAGIC);
        return true;
    }

    private void pre_effect(Base_Creature c, Base_Creature sorce) {
        if (!(sorce instanceof Base_Enemy) && this.effect_checker()) {
            this.staticCheck();
            Config.saveItemData(this);
        }
        this.used_creature = sorce;
        this.effect(c);
    }

    public void staffUse() {
        this.direction = Player.me.getDirection();
        new MagicBullet(this).itemThrow(Player.me, ThrowingItem.HowToThrow.MAGIC);
    }

    protected Base_Creature way(Base_Creature c) {
        DIRECTION d = c.getDirection();
        return this.wayCheck(c.getMassPoint().getLocation(), d.X, d.Y);
    }

    private Base_Enemy wayCheck(Point p, int i, int j) {
        do {
            p.x += i;
            p.y += j;
            if (MapInSelect.MapMaxPoint(p)) {
                return null;
            }
            if (MapList.getEnemy(p) == null) continue;
            return MapList.getEnemy(p);
        } while (MassCreater.getMass((Point)p).WALKABLE);
        return null;
    }
}

