/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.spellcard.double_card;

import dangeon.controller.task.Task;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.Player;
import dangeon.util.Damage;
import dangeon.view.anime.MarisaSpark;
import java.awt.Point;
import main.util.DIRECTION;

public class DoubleCard
extends Base_Item {
    private static final long serialVersionUID = -97526840866347523L;
    private SpellCard first;
    private SpellCard second;

    private static String doubleSpell(SpellCard s1, SpellCard s2) {
        return s1.getCharacterShortName().concat("\u3068").concat(s2.getCharacterShortName()).concat("\u306e\u30ab\u30fc\u30c9");
    }

    public DoubleCard(Point p, SpellCard sc, SpellCard sc2) {
        super(p, DoubleCard.doubleSpell(sc, sc2), 0, Base_Artifact.ITEM_CASE.SPELLCARD);
        this.first = sc;
        this.second = sc2;
        this.setForgeValue();
    }

    @Override
    protected int enchantDefence(boolean b, Base_Creature creature, int damage) {
        return 0;
    }

    @Override
    protected String[] getExplan() {
        String[] str = new String[]{this.first.getDoubleExplainToUse(), this.second.getDoubleExplainToUse()};
        return str;
    }

    @Override
    protected String getSecondExplain_ByEach() {
        return "second";
    }

    @Override
    public int itemEnchantPower(Base_Artifact.STATUS status) {
        return 0;
    }

    @Override
    public boolean itemUse() {
        if (this.set()) {
            return true;
        }
        this.first.itemUse();
        this.second.itemUse();
        this.setForgeValue(-1);
        if (this.getForgeValue() < 0) {
            this.spellUsed();
        }
        return true;
    }

    private boolean set() {
        if ((this.first.getCharacterShortName().matches("\u9b54\u7406\u6c99") || this.second.getCharacterShortName().matches("\u9b54\u7406\u6c99")) && (this.first.getCharacterShortName().matches("\u5e7d\u9999") || this.second.getCharacterShortName().matches("\u5e7d\u9999"))) {
            Player.me.setSecondAnimation(new MarisaSpark(Player.me, new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    Point p = Player.me.getMassPoint().getLocation();
                    DIRECTION d = Player.me.getDirection();
                    while (true) {
                        p.x += d.X;
                        p.y += d.Y;
                        if (MassCreater.isPointOutOfDangeon(p)) break;
                        if (!MassCreater.getMass((Point)p).WALKABLE) {
                            MassCreater.dig(p);
                        }
                        if (MapList.getEnemy(p) == null) continue;
                        Damage.damage(null, null, null, Player.me, MapList.getEnemy(p), 120);
                    }
                    MassCreater.retakeMassSet();
                }
            }));
            return true;
        }
        return false;
    }

    private void setForgeValue() {
        this.forge_value = this.first.getForgeValue() + this.second.getForgeValue();
    }

    private void spellUsed() {
        if (this.isEnchantedNow()) {
            Enchant.forceToRemove(this);
        }
        Belongings.remove(this);
    }
}

