/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.spellcard;

import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.config.table.ItemTable;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.class_job.bonus.bonus_switch.BonusConductor;
import dangeon.util.R;
import dangeon.util.STAGE;
import java.awt.Color;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import main.res.BGM;
import main.res.Image_Artifact;
import main.res.Image_LargeCharacter;
import main.res.SE;
import main.util.CSVLoadSupporter;
import main.util.Show;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public abstract class SpellCard
extends Base_Item {
    private String fu_name;
    private String range;
    public final int stand_lv;
    private int BOMB_MAX = 4;
    private int BOMB;
    public final int BOMB_USE;
    public final LinkedHashSet<BGM> BGM_LIST = new LinkedHashSet();
    protected ArrayList<STAGE> list_stage;
    private static final long serialVersionUID = 1L;
    public final Image_LargeCharacter IMLC;
    private boolean checked_perfect = false;

    protected SpellCard(Point p, String item_name, int level, int composition_number) {
        super(p, item_name, composition_number, Base_Artifact.ITEM_CASE.SPELLCARD);
        this.BOMB_USE = this.getPassingOfSpellCard() ? 2 : 1;
        this.addBomb(this.BOMB_USE);
        this.defaultForge();
        this.stand_lv = 0;
        this.IM = Image_Artifact.CARD;
        this.IMLC = Image_LargeCharacter.get(this);
        this.BGM_LIST.add(BGM.get(this.getClass()));
        this.list_stage = new ArrayList();
        try {
            Constructor<? extends Base_Enemy> con = this.getStand().getConstructor(Point.class, Integer.TYPE);
            Base_Enemy obj = con.newInstance(p, level);
            for (STAGE s : obj.getCategory()) {
                this.list_stage.add(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Show.showErrorMessageDialog(e);
        }
    }

    protected SpellCard(Point p, String item_name, int level, int composition_number, Class<? extends Base_Enemy> c) {
        this(p, item_name, level, composition_number);
    }

    @Override
    protected void action() {
    }

    public void addBomb(int delt) {
        this.BOMB += delt;
        if (this.BOMB >= this.BOMB_MAX) {
            this.BOMB = this.BOMB_MAX;
        } else if (this.BOMB < 0) {
            this.BOMB = 0;
        }
    }

    @Override
    public void check() {
        this.checked_perfect = true;
        this.flag_open_cursed = true;
        ENCHANT_SIMBOL e = ENCHANT_SIMBOL.\u8b0e;
        if (this.sim == e || this.getListComposition().contains((Object)e)) {
            EnchantSpecial.setInfoBake(0);
        }
        if (this.sim == (e = ENCHANT_SIMBOL.\u72f8) || this.getListComposition().contains((Object)e)) {
            EnchantSpecial.setInfoBake(1);
        }
        super.check();
    }

    @Override
    public void check(String s) {
        if (s.matches("forge")) {
            if (this.isStaticCheked()) {
                this.check();
            }
            this.flag_open_numbers = true;
        }
    }

    private void defaultForge() {
        R ran = new R();
        int value = ((Random)ran).nextInt(64) + 1;
        switch (value) {
            case 1: {
                this.forge_value = 3;
                break;
            }
            case 2: 
            case 3: {
                this.forge_value = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.forge_value = 1;
                break;
            }
        }
    }

    protected int enchantAttack(boolean normal, Base_Creature c, int damage) {
        return damage;
    }

    @Override
    public void enchantCheck(boolean tokidoki_check) {
    }

    @Override
    protected int enchantDefence(boolean normal, Base_Creature c, int damage) {
        return damage;
    }

    public int getBombs() {
        return this.BOMB;
    }

    public int getBomCount() {
        int i = this.getForgeValue() + this.BOMB;
        if ((i /= this.BOMB_USE) < 0) {
            i = 0;
        }
        return i;
    }

    public String getCharacterName() {
        String s = this.getName();
        return s.substring(0, s.length() - 4);
    }

    public abstract String getCharacterShortName();

    @Override
    public String getClassName() {
        return "\u30ab\u30fc\u30c9\uff1a";
    }

    public String getComboMsg() {
        return "-\u5171\u9cf4\u52b9\u679c-FIXME";
    }

    public abstract String getDoter();

    public abstract String getDoterURL();

    public String getDoubleExplainToUse() {
        String s = "";
        String[] stringArray = this.getExplanToUse();
        if (stringArray.length != 0) {
            String str = stringArray[0];
            return str;
        }
        return s;
    }

    @Override
    protected String[] getExplan() {
        StringBuilder sb = new StringBuilder();
        sb.append(Color.CYAN);
        sb.append("\u3010\u4f7f\u7528\u3011");
        sb.append(Color.LIGHT_GRAY);
        sb.append("\u30dc\u30e0:");
        sb.append(this.BOMB_USE);
        sb.append(" ");
        sb.append(Color.PINK);
        sb.append("\u5bfe\u8c61:");
        sb.append(this.range.isEmpty() ? "\uff1f" : this.range);
        sb.append(" ");
        if (!this.flag_pass_turn) {
            sb.append(Color.MAGENTA);
            sb.append("\u30bf\u30fc\u30f3\u7d4c\u904e:\u306a\u3057");
        }
        sb.append(Color.WHITE);
        String[] arr = new String[]{sb.toString(), this.exn[0]};
        return arr;
    }

    public String getExplan__() {
        return this.getExplanToUse()[0];
    }

    abstract String getExplanToEnchant();

    abstract String[] getExplanToUse();

    @Override
    protected abstract String getFlavor();

    public String getFuName() {
        return this.fu_name;
    }

    public abstract String getIllustlator();

    public abstract String getIllustlatorURL();

    @Override
    public String getLastPackage() {
        return "spellcard";
    }

    @Override
    public ArrayList<String> getListItemExplan(ArrayList<String> list) {
        list.add(this.getName());
        if (this.sim != null) {
            list.add("\u5370: ".concat(this.sim.getSimbolName()));
        }
        list.add(this.getSpellStatusQuestion());
        String use = new String();
        String[] stringArray = this.getExplanToUse();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            use = use.concat(str);
            ++n2;
        }
        list.add(use);
        if (this.getExplanToEnchant().length() != 0) {
            list.add(this.getExplanToEnchant());
        }
        return list;
    }

    public final List<STAGE> getListStage() {
        return this.list_stage;
    }

    public int getMaxBombs() {
        return this.BOMB_MAX;
    }

    @Override
    public StringBuilder getName(StringBuilder sb) {
        sb.append(this.getName());
        if (this.stand_lv != 0) {
            sb.append("\u2606");
        }
        if (this.isPerfectCheked()) {
            if (this.forge_value != 0) {
                if (this.forge_value > 0) {
                    sb.append("+");
                }
                sb.append(this.forge_value);
            }
        } else if (this.flag_open_numbers) {
            if (this.forge_value >= 0) {
                sb.append("+");
            }
            sb.append(this.forge_value);
        } else {
            sb.append("+?");
        }
        return sb;
    }

    public String getOneLineUseExplan() {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = this.getExplanToUse();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            sb.append(str);
            ++n2;
        }
        return sb.toString();
    }

    abstract boolean getPassingOfSpellCard();

    @Override
    protected String getSecondExplain_ByCategory() {
        return "\u305d\u306e\u4eba\u7269\u306e\u3061\u304b\u3089\u3092\u501f\u308a\u308b\u3053\u3068\u304c\u51fa\u6765\u308b\u4e0d\u601d\u8b70\u306a\u30a2\u30a4\u30c6\u30e0\u3002\u4f7f\u7528\u3059\u308b\u3068\u4fee\u6b63\u5024\u304c\u4e0b\u304c\u308a\u305d\u306e\u7d50\u679c\u30de\u30a4\u30ca\u30b9\u306b\u306a\u308b\u3068\u6d88\u3048\u3066\u3057\u307e\u3046\u3002";
    }

    @Override
    protected String getSecondExplain_ByEach() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u3010\u5bfe\u5fdcDISC\u3011");
        sb.append("@");
        if (this.getListStage().isEmpty()) {
            sb.append("\uff08\u306a\u3057\uff09");
            sb.append("@");
        } else {
            for (STAGE s : this.getListStage()) {
                sb.append("\u25c6");
                sb.append((Object)s);
                sb.append("\u3000");
            }
        }
        sb.append("@");
        sb.append("@");
        sb.append("\u3010\u7acb\u3061\u7d75\u5e2b\uff0f\u30c9\u30c3\u30bf\u30fc\u3011");
        sb.append("@");
        sb.append("\u25c6");
        sb.append(this.getIllustlator());
        sb.append("\u3000");
        sb.append("\u25c6");
        sb.append(this.getDoter());
        sb.append("@");
        sb.append("@");
        String str = this.getSecondExplain_ByEach_Annotation();
        if (str != null) {
            sb.append("\u3010\u4e00\u8a00\u6ce8\u91c8\u3011");
            sb.append("@");
            sb.append(str);
            sb.append("@");
        }
        return sb.toString();
    }

    protected String getSecondExplain_ByEach_Annotation() {
        return null;
    }

    protected abstract String[] getSecondExplan();

    @Override
    public int getShadow() {
        return 4;
    }

    public String getSpellStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append(Enchant.CL_ANY3);
        sb.append("\u3010\u88c5\u5099\u3011");
        sb.append(Enchant.CL_ATK);
        sb.append("\u653b\u6483\u529b+");
        sb.append(Color.WHITE);
        if (this.itemEnchantPower(Base_Artifact.STATUS.STR) < 10) {
            sb.append(" ");
        }
        sb.append(this.itemEnchantPower(Base_Artifact.STATUS.STR));
        sb.append(" ");
        sb.append(Enchant.CL_DEF);
        sb.append("\u9632\u5fa1\u529b+");
        sb.append(Color.WHITE);
        if (this.itemEnchantPower(Base_Artifact.STATUS.DEF) < 10) {
            sb.append(" ");
        }
        sb.append(this.itemEnchantPower(Base_Artifact.STATUS.DEF));
        sb.append(Color.PINK);
        sb.append("\u3000\u5668:");
        sb.append(Enchant.CL_ANY3);
        sb.append(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.toMaruMoji(this.composition_number));
        sb.append(Color.GRAY);
        sb.append("\u3000\u51fa\u73fe\u5ea6:");
        sb.append(Enchant.CL_ANY3.darker());
        sb.append(ItemTable.getRank_String(this));
        return sb.toString();
    }

    public String getSpellStatusQuestion() {
        return this.getSpellStatus();
    }

    public abstract Class<? extends Base_Enemy> getStand();

    @Override
    protected void init() {
        CSVLoadSupporter<String> list = CSVLoadSupporter.loadCSV(this.getClass().getSimpleName(), Base_Artifact.class, "\t");
        if (list != null) {
            this.name = list.get();
            this.flag_pass_turn = list.isTrue();
            this.exn = list.get().split("\\$");
            this.fu_name = list.get();
            this.range = list.get();
        } else {
            System.out.println("[@Base_artifact.init()]NosuchArtifact Exception :" + this.name);
        }
    }

    public boolean isAbleToUse() {
        this.getBombs();
        int i = this.getBombs() - this.BOMB_USE;
        return i >= 0 || this.getForgeValue() >= -i;
    }

    @Override
    public boolean isCurse_And_isItViewed() {
        return this.flag_open_cursed && this.isCurse();
    }

    @Override
    protected boolean isForgedMax() {
        return this.forge_value >= 99 && this.getBombs() >= this.getMaxBombs();
    }

    public boolean isPassing() {
        return this.getPassingOfSpellCard();
    }

    @Override
    public boolean isPerfectCheked() {
        return this.checked_perfect;
    }

    public boolean isUdongeSelective() {
        return true;
    }

    @Override
    public int itemEnchantPower(Base_Artifact.STATUS status) {
        return 0;
    }

    @Override
    public boolean itemUse() {
        if (this.isUsingMouse() && BonusConductor.\u5b88\u77e2\u795e_\u53e3\u5c01\u3058()) {
            SE.MIRACLE_ONIGIRI.play();
            Player.me.setCondition(CONDITION.\u304a\u306b\u304e\u308a, 5);
        }
        if (this.BOMB >= this.BOMB_USE) {
            if (!this.spellUse()) {
                return true;
            }
            System.out.println(String.valueOf(this.BOMB) + "\u304b" + this.BOMB_USE);
            this.addBomb(-this.BOMB_USE);
            System.out.println(String.valueOf(this.BOMB) + "\u3068" + this.BOMB_USE);
        } else if (this.getForgeValue() + this.BOMB - this.BOMB_USE >= 0) {
            if (!this.spellUse()) {
                return true;
            }
            this.setForgeValue(-this.BOMB_USE + this.BOMB);
            this.BOMB = 0;
        } else {
            Message.set("\u4fee\u6b63\u5024\u304c\u8db3\u308a\u306a\u304f\u3066\u4f7f\u7528\u3067\u304d\u306a\u3044");
            return false;
        }
        return true;
    }

    @Override
    public void setCurse(boolean curse) {
        if (curse) {
            this.flag_open_cursed = true;
        }
        super.setCurse(curse);
    }

    protected abstract boolean spellUse();

    private void spellUsed() {
        if (this.isEnchantedNow()) {
            Enchant.forceToRemove(this);
        }
        Belongings.remove(this);
    }

    public void startBGM() {
        BGM.play(this);
    }

    @Override
    public boolean waterAction() {
        if (!this.getListComposition().contains((Object)ENCHANT_SIMBOL.\u91d1) && !this.isFrozen()) {
            Message.set(this.getColoredName(), "\u306f\u6fe1\u308c\u3066\u4fee\u6b63\u5024\u304c\u4e0b\u304c\u3063\u305f");
            this.setForgeValue(-1);
        }
        return true;
    }
}

