/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.pot;

import dangeon.latest.scene.Base_View;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.latest.scene.action.itemlist.Book_Item;
import dangeon.latest.scene.action.itemlist.Item_List;
import dangeon.latest.scene.action.menu.Book;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.SelectItem;
import dangeon.model.object.artifact.item.check.Checker;
import dangeon.model.object.artifact.item.pot.Base_Pot;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.util.STAGE;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Base_Pot_Selective
extends Base_Pot
implements SelectItem {
    private static final long serialVersionUID = 1L;

    public Base_Pot_Selective(Point p, String item_name, int max, STAGE ... stages) {
        super(p, item_name, max, stages);
    }

    @Override
    public ArrayList<Base_Artifact> getEscape(ArrayList<Base_Artifact> list) {
        Iterator<Base_Artifact> iterator = list.iterator();
        while (iterator.hasNext()) {
            Base_Artifact a = iterator.next();
            if (this.isUnableToPutIn(a)) continue;
            iterator.remove();
        }
        return list;
    }

    @Override
    public StringBuilder getName(StringBuilder sb) {
        sb.append(this.getName());
        sb.append("[");
        sb.append(this.MAX - this.LIST.size());
        sb.append("]");
        return sb;
    }

    @Override
    protected boolean isItemUseThisAvailable() {
        if (!super.isItemUseThisAvailable()) {
            return false;
        }
        if (this.isMax()) {
            Message.set(this.getColoredName(), "\u306f\u65e2\u306b\u3044\u3063\u3071\u3044\u3060");
            return false;
        }
        return true;
    }

    @Override
    protected boolean isUnableToPutIn(Base_Artifact a) {
        if (Enchant.isEnchanted(a) && a.isCurse()) {
            return true;
        }
        if (!a.isMobile()) {
            return true;
        }
        return a instanceof Base_Pot;
    }

    @Override
    public final boolean itemUse() {
        if (this.isUnableToPutIn(this.A)) {
            Message.set(this.A.getColoredName(), "\u306f\u5165\u308c\u3089\u308c\u306a\u3044");
            return false;
        }
        Message.set(this.getColoredName(), "\u306b", this.A.getColoredName(), "\u3092\u5165\u308c\u305f");
        this.LIST.add(this.A);
        this.A.remove();
        this.potUse();
        return true;
    }

    protected abstract void potUse();

    @Override
    protected void selectItem(Base_View view) {
        Base_Pot_Selective ME = this;
        ArrayList<Base_Artifact> list = null;
        if (this.isStaticCheked()) {
            list = Belongings.getDeepCopy(Belongings.getListItems());
            list = ME.getEscape(list);
        }
        if (list == null) {
            list = new ArrayList();
        }
        list.add(this);
        final Base_Pot_Selective me = this;
        new Item_List(new Book_Item(){

            @Override
            public void work(Base_Artifact a) {
                Base_Pot_Selective.this.A = a;
                Base_Pot_Selective.this.itemUseThis();
            }
        }, list, true){

            @Override
            protected void action_cancel() {
                super.action_cancel();
                Checker.select(me);
            }

            @Override
            protected Book getMultiBook(final Base_Artifact ... selected_artifacts) {
                return new Book(){

                    @Override
                    protected void work() {
                        Base_Artifact[] base_ArtifactArray = selected_artifacts;
                        int n = selected_artifacts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Base_Artifact a = base_ArtifactArray[n2];
                            Base_Pot_Selective.this.A = a;
                            Base_Pot_Selective.this.itemUseThis();
                            ++n2;
                        }
                        this.setNextScene(Scene_Action.getMe());
                    }
                };
            }
        };
    }
}

